#
## <SHAREFILE=linalg/sffge/sffge.mpl >
## <DESCRIBE>
##                Performs Bareiss' fraction free Gaussian elimination algorithm
##                on a rectangular matrix of polynomial entries and returns the
##                reduces matrix (in upper triangular form) and optionally the
##                rank and determinant.  This routine has the same functionality
##                as the library routine linalg[ffgausselim] but is using
##                a variation of Nguyen and Saunders algorithm which is suited
##                to sparse matrices.
##                AUTHORS: Igor Berchtold, Michael Monagan, monagan@inf.ethz.ch
## </DESCRIBE>

#################################################
# sffge(A) 
#
# Input:        sffge(A, 'rank', 'det');
#                 sffge(A, rmar);
# Output:      reduced matrix
#                 'rank' (optional)  rank of A
#                 'det'  (optional)  determinant of A
#
#
# Author: Igor Berchtold, ETHZ, SS93
# Date:  2.8.93
#
# Change(s): Michael Monagan, October 1993
#
# ################################################
sffge := proc(A,rank,det)
   local  B,H,n,m,sign,r,k,i,j,temp,q,l,piv,rmarg,lim;
   option `Copyright 1993 by I. Berchtold and M.B. Monagan, ETH Zuerich`;
   # Compute dimensions of A
   n:= linalg[rowdim](A);
   m:= linalg[coldim](A);

   if nargs>1 and type(args[2],'integer') then
       rmarg := args[2];
       if rmarg<0 or nargs>2 then ERROR(`invalid arguments`) fi;
   else
       rmarg := m
   fi;

   # Initialization
   r:= 1; sign:=1;
   B:= array(1..n,1..m);
   for i to n do
       H[i]:= 1;
       for j to m do
         if not type(A[i,j],polynom(rational)) then
            ERROR(`matrix entries must be polynomials over the rationals`);
         else
            B[i,j]:= expand(A[i,j]);
         fi;
       od;
   od;

   piv:= 1;
   # Eliminate below row r, with pivot in column k
   for k to min(m,rmarg) while r <= n do

    # Find a nonzero and smallest pivot
    for i from r to n  while B[i,k]=0 do od;
    if i <= n then
        lim := length(B[i,k]);
        for j from i+1 to n do
            l:= length(B[j,k]); 
            if l=0 then next fi;
            if l<lim then lim:= l; i:= j; fi;
        od;
        if r<>i then 
            # Pivot is in row i, so switch rows i and r
            for j from k to m do
                  temp:= B[i,j]; B[i,j]:= B[r,j]; B[r,j]:= temp;
            od;
            temp:= H[i]; H[i]:= H[r]; H[r]:= temp;
            sign:= -sign;
        fi;
        if H[r]<>piv then   # B[k,k]  not up to date
	     if divide(piv,H[r],'q') then
	         for i from k to m do
                       B[r,i]:= B[r,i]*q;
                    od;
                else
                   for i from k to m do
                       if B[r,i]<>0 then
                          divide(B[r,i]*piv,H[r],evaln(B[r,i]));
	            fi;
                   od;
                fi;
        fi;
        for i from r+1 to n do
               if B[i,k] <> 0 then
                   if piv<>H[i] then           # B[i,k] not up to date
	          if divide(piv,H[i],'q') then
                         for l from k to m do
                            B[i,l]:= B[i,l]*q;
                         od;
                     else
                         for l from k to m do
  		     if B[i,l]<>0 then
                              divide(B[i,l]*piv,H[i],evaln(B[i,l]));
		     fi;
                        od;
                     fi;
                   fi;
                   for j from k+1 to m do
 		divide(B[r,k]*B[i,j]-B[r,j]*B[i,k],piv,evaln(B[i,j]));
                   od;
                   H[i]:= B[r,k]; 
                   B[i,k]:= 0; 
               fi;
        od;
        piv:= B[r,k];
        r:=r+1;
    fi;
   od;
   if nargs>1 and not type(args[2],'integer') then rank:= r-1 fi;
   if nargs>2 then
        if n+1 = r then
           det:= sign*piv;
        else
           det:= 0;
        fi;
   fi;
   RETURN(eval(B));
end:


#save `sffge.m`;
#quit
