#======================================================================
#
#             Test file for the Maple package TRANS
# Computed results are compared with the results that should come out
#
#======================================================================
#read `trans.m`:
with(share):readshare(trans,numerics):
with(trans):
f := x -> - ln (1 - x) / x:
# Shanks transformation
a3:= ratser(f(x), x, sh, 4):
if normal(a3-(1-1/4*x-1/24*x^2)/(1-3/4*x)=0)
then print (okay) else print (a3) fi;
# u transformation
a4:= ratser (f(x), x, u, 4):
if normal(a4-(1-19/16*x+23/96*x^2)/(1-27/16*x+3/4*x^2-1/16*x^3)=0)
then print (okay) else print (a4) fi;
# t transformation
a5:= ratser (f(x), x, t, 4):
if normal(a5-(1-49/64*x+29/384*x^2)/(1-81/64*x+3/8*x^2-1/64*x^3)=0)
then print (okay) else print (a5) fi;
# d transformation
a6:=ratser (f(x), x, d, 4):
if normal(a6-(1-1/2*x)/(1-x+1/6*x^2)=0) then
print (okay) else print (a6) fi;
# v transformation
a7:=ratser (f(x), x, v, 4):
if normal(a7-(1-5/4*x+7/24*x^2)/(1-7/4*x+5/6*x^2-1/12*x^3)=0)
then print (okay) else print (a7) fi;
# su transforamtion
a8:=ratser (f(x), x, su, 4):
if normal(a8-(1-13/10*x+1/3*x^2)/(1-9/5*x+9/10*x^2-1/10*x^3)=0)
then print (okay) else print (a8) fi;
# st transformation
a9:= ratser (f(x), x, st, 4):
if normal(a9-(1-17/20*x+13/120*x^2)/(1-27/20*x+9/20*x^2-1/40*x^3)=0)
then print (okay) else print (a9) fi;
# sd transformation
a10:=ratser (f(x), x, sd, 4):
if normal(a10-(1-1/2*x)/(1-x+1/6*x^2)=0) then
print (okay) else print (a10) fi;
# sv transformation
a11:= ratser (f(x), x, sv, 4):
if normal(a11-(1-8/5*x+19/30*x^2-1/20*x^3)/(1-21/10*x+27/20*x^2-1/4*x^3)=0)
then print (okay) else print (a11) fi;
# rho transformation using x_n = n+1 (default)
a12:= ratser (f(x), x, rh, 4):
if normal(a12-(1-1/4*x-1/24*x^2+1/4*x^3)/(1-3/4*x)=0) then
print (okay) else print (a12) fi;
# iterated rho_2 transformation using x_n = n+1 (default)
a13:= ratser (f(x), x, rhit, 4):
if normal(a13-(1-1/4*x-1/24*x^2+1/4*x^3)/(1-3/4*x)=0)
then print (okay) else print (a13) fi;
# rho transformation using x_n = (n+1) ** 2
a14 := ratser (f(x), x, [rh, 1, 4, 9, 16, 25], 4):
if normal(a14-(1-1/28*x+11/168*x^2+1/4*x^3)/(1-15/28*x)=0) then
print (okay) else print (a14) fi;
# Germain-Bonne transformation
a15 := ratser (f(x), x, gb, 4):
if normal(a15-(1-11/12*x-3/8*x^2+35/72*x^3-1/16*x^4)/(1-17/12*x+17/24*x^3-1/4*x^4)=0)
then print (okay) else print (a15) fi;
# Richardson extrapolation using x_n = 1 / (n+1) (default)
a16 := ratser (f(x), x, r, 4):
if normal(a16-(1+7/12*x-17/18*x^2+8/3*x^3)=0) then
print (okay) else print (a16) fi:
# theta algorithm
a17 := ratser (f(x), x, th, 4):
if normal(a17-(1-x+1/12*x^2)/(1-3/2*x+1/2*x^2)=0) then
print (okay) else print (a17) fi:
# iterated theta_2 algorithm
a18 := ratser (f(x), x, thit, 4):
if normal(a18-(1-x+1/12*x^2)/(1-3/2*x+1/2*x^2)=0) then
print (okay) else print (a18) fi:
# iterated aitken transformation
a19 := ratser (f(x), x, at, 4):
if normal(a19-(1-1/4*x-1/24*x^2)/(1-3/4*x)=0) then
print (okay) else print (a19) fi:
# Shanks transformation
a20 := ratser (GAMMA(x), x, sh, 3):
if normal(a20-(1440*gamma^4-5760*Zeta(3)*gamma+120*Pi^4+(-108*Pi^4*gamma-720*gamma^5+
2880*gamma^2*Zeta(3)+480*Pi^2*Zeta(3)+240*Pi^2*gamma^3)*x+(-960*gamma^3*Zeta(3)+
Pi^6+1920*Zeta(3)^2+54*Pi^4*gamma^2-480*gamma*Zeta(3)*Pi^2+120*gamma^6-60*gamma^
4*Pi^2)*x^2)/((1440*gamma^4-5760*Zeta(3)*gamma+120*Pi^4)*x+(12*Pi^4*gamma+720*
gamma^5-2880*gamma^2*Zeta(3)+480*Pi^2*Zeta(3)+240*Pi^2*gamma^3)*x^2+(60*gamma^4*
Pi^2+6*Pi^4*gamma^2+1920*Zeta(3)^2-9*Pi^6+480*gamma*Zeta(3)*Pi^2+120*gamma^6-960
*gamma^3*Zeta(3))*x^3)=0)
then print (okay) else print (a20) fi;
# theta algorithm
a21 := ratser (GAMMA(x), x, th, 3):
if normal(a21-(960*Pi^2*Zeta(3)+5760*gamma^2*Zeta(3)+240*Pi^4*gamma+1920*Pi^2*gamma^3+
2880*gamma^5+(-240*gamma^4*Pi^2+960*gamma*Zeta(3)*Pi^2+36*Pi^6+5760*gamma^3*Zeta
(3)+216*Pi^4*gamma^2-1440*gamma^6)*x+(-6240*Zeta(3)*gamma^4+152*Zeta(3)*Pi^4+
3840*Zeta(3)^2*gamma+240*gamma^7+480*Zeta(3)*Pi^2*gamma^2-20*Pi^4*gamma^3-120*
gamma^5*Pi^2+2*Pi^6*gamma)*x^2+(-72*gamma*Zeta(3)*Pi^4-320*Zeta(3)^2*Pi^2+12*
gamma^4*Pi^4-800*gamma^3*Zeta(3)*Pi^2+3*Pi^8-5760*gamma^2*Zeta(3)^2+18*gamma^2*
Pi^6+1440*gamma^5*Zeta(3)+40*gamma^6*Pi^2)*x^3)/((960*Pi^2*Zeta(3)+5760*gamma^2*
Zeta(3)+240*Pi^4*gamma+1920*Pi^2*gamma^3+2880*gamma^5)*x+(36*Pi^6+456*Pi^4*gamma
^2+1920*gamma*Zeta(3)*Pi^2+11520*gamma^3*Zeta(3)+1680*gamma^4*Pi^2+1440*gamma^6)
*x^2+(72*Zeta(3)*Pi^4+18*Pi^6*gamma+156*Pi^4*gamma^3+3840*Zeta(3)^2*gamma+1440*
Zeta(3)*Pi^2*gamma^2+2400*Zeta(3)*gamma^4+360*gamma^5*Pi^2+240*gamma^7)*x^3)=0)
then print (okay) else print (a21) fi;
# segmented approximation using the iterated Aitken transformation
a22:=[ratser (exp(x), x = x0, at, 4, [1, 5, 10], horner)]:
if map(normal, a22-[(53/72*exp(1)+(19/72*exp(1)+(1/72*exp(1)-1/72*exp(1)*x)*x)*x)/
(2+(-23/18+(11/36-1/36*x)*x)*x), (19/24*exp(5)+(-37/72*exp(5)+(13/72*exp(5)-1/72*
exp(5)*x)*x)*x)/(124/9+(-91/18+(23/36-1/36*x)*x)*x), (173/18*exp(10)+(-121/36*
exp(10)+(7/18*exp(10)-1/72*exp(10)*x)*x)*x)/(117/2+(-487/36+(19/18-1/36*x)*x)*x)])=[0,0,0]
then print (okay) else print (a22) fi;
kfun := proc (nu, x, n)
   local sum1, term, j;
   term  := 1;
   sum1  := 1;
   if n = 0 then
      RETURN (sum1)
   fi;
   for j from 1 to n
   do
      term := -term * (1 / 2 + nu + j - 1) *
	      (1 / 2 - nu + j - 1) / (j * 2 * x);
      sum1 := sum1 + term
   od
end:
# a divergent series 2F0
a23 := kfun(nu,x,5):
if normal(a23-(1-1/2*(1/2+nu)*(1/2-nu)/x+1/8*(1/2+nu)*(1/2-nu)/x^2*(3/2+nu)*(3/2-nu)-
1/48*(1/2+nu)*(1/2-nu)/x^3*(3/2+nu)*(3/2-nu)*(5/2+nu)*(5/2-nu)+1/384*(1/2+nu)*(1/2-nu)/
x^4*(3/2+nu)*(3/2-nu)*(5/2+nu)*(5/2-nu)*(7/2+nu)*(7/2-nu)-1/3840*(1/2+nu)*(1/2-nu)/x^5*
(3/2+nu)*(3/2-nu)*(5/2+nu)*(5/2-nu)*(7/2+nu)*(7/2-nu)*(9/2+nu)*(9/2-nu))=0)
then print (okay) else print (a23) fi;
# sd transformation
a24 := ratgen (a23,sd,horner):
if normal(a24-(244980+(1648768+(1248896+(131072+1024*nu^2)*nu^2)*nu^2)*nu^2+(18309600+
(20470144+(2644480+34816*nu^2)*nu^2)*nu^2+(82702080+(22947840+552960*nu^2)*nu^2+(
77475840+4669440*nu^2+17203200*x)*x)*x)*x)/(893025+(-656784+(137824+(-10496+256*
nu^2)*nu^2)*nu^2)*nu^2+(25401600+(-7392256+(634880-16384*nu^2)*nu^2)*nu^2+(
91445760+(-11980800+368640*nu^2)*nu^2+(-3932160*nu^2+79626240+17203200*x)*x)*x)*x)=0)
then print (okay) else print (a24) fi;
# iterated Aitken transformation
a25 := ratgen (a23,at,horner):
if normal(a25-(-6646407+(23699052+(11470240+(304512+(-768-1024*nu^2)*nu^2)*nu^2)*nu^2)*
nu^2+(172275552+(156551168+(14638080+(540672-8192*nu^2)*nu^2)*nu^2)*nu^2+(
601269120+(140834304+(8497152+73728*nu^2)*nu^2)*nu^2+(459767808+(47972352+
1572864*nu^2)*nu^2+(7864320*nu^2+92405760)*x)*x)*x)*x)/(227614800+(-62055168+(
3737088+(135168-12288*nu^2)*nu^2)*nu^2)*nu^2+(653686656+(-66157056+(-2267136+
270336*nu^2)*nu^2)*nu^2+(471318528+(2752512-2359296*nu^2)*nu^2+(7864320*nu^2+
92405760)*x)*x)*x)/x=0)
then print (okay) else print (a25) fi;
# The following command should produce this Fortran code
#      function shtr (x)
#      double precision shtr, x
#      if (x .le. 150.D-2) then 
#      shtr = (-0.1328275388190142D2+(0.6867129421285136D1-0.545304748331
#     #9388D1*x)*x)/(-0.9789230309650352D0-0.1088974891297064D2*x)
#      elseif (x .gt. 150.D-2 .and. x .le. 250.D-2) then
#      shtr = (-0.9206963342381458D1+(0.5375392029492051D1-0.162147617042
#     #998D1*x)*x)/(-0.6899930027047347D1+0.9789230309650352D0*x)
#      elseif (x .gt. 250.D-2) then 
#      shtr = (-0.20843631793123D2+(0.1082672500424027D2-0.29549025745571
#     #08D1*x)*x)/(-0.178286850162791D2+0.3449965013523673D1*x)
#      end if
#      end
ratser (GAMMA(x), x=x0, sh, 3, fort, horner, double, [1,2,3]);
#quit
