with(share):
readshare(MatPade,algebra): # read `MatPade.m`;
#
# testing PHPA
#
F := [2*x^6 + (1+x)/(1-x), 1 + x^8*cos(x) , (1 + x)/(1-2*x)]:
n := [1,2,3]:
N := convert(n,`+`) + nops(n):
P := PHPA(F,x,n,2,N):
P := subs(x=x^2,P):
s := sum( P[i]*F[i],i=1..nops(n) ):
Ans[1]:= series( s , x , N):
P := PHPA(F,x,n, 2, N, all):
P := subs(x=x^2,P):
s := sum( P[i]*F[i],i=1..nops(n) ):
Ans[2] := series( s , x , N):
#
# testing Hermite Pade
#
F := [2*x^6 + (1+x)/(1-x), 1 + x^8*cos(x) , (1 + x)/(1-2*x)]:
n := [1,2,3]:
P := HermitePade(F,x,n):
s := sum( P[i]*F[i],i=1..nops(n) ):
N := convert(n,`+`) + nops(n):
Ans[3] := series( s , x , N):
P := HermitePade(F,x,n,all):
s := sum( P[i]*F[i],i=1..nops(n) ):
N := convert(n,`+`) + nops(n):
Ans[4] := series( s , x , N):
#
# testing Simultaneous Pade
#
F := [2*x^6*cos(x) + (1+x)/(1-x), (1 + x)/(1-2*x)]:
n := [2,3,3]:
P := SimultaneousPade(F,x,n):
N := convert(n,`+`):
for i from 1 to nops(F) do
    Ans[4 + i ] := series(  P[1] * F[i] - P[i+1] , x, N + 2):
od:
P := SimultaneousPade(F,x,n,all):
N := convert(n,`+`):
for i from 1 to nops(F) do
    Ans[6 + i] := series(  P[1] * F[i] - P[i+1] , x, N + 2):
od:
#
# testing RightMatrixPade
#
A := linalg[matrix](2,2,[ 1 + z^2 + 2*z^4 - z^5 + z^6 + O(z^8),
                          z^7 + O(z^8), -z^5 + O(z^8),
                          1 + z^2 + z^4 + z^7 + O(z^8) ]):

A := map(series,eval(A),z,8):
n := [2,3]:
ans := RightMatrixPade(A,z,n,all):
s := evalm(A &* ans[2] - ans[1]):
Ans[9] := ans[1]: Ans[10] := ans[2]:
Ans[11] := map(series, eval(s), z, convert(n,`+`) + 1):
ans := RightMatrixPade(A,z,n):
s := evalm(A &* ans[2] - ans[1]):
map(series, eval(s), z, convert(n,`+`) + 1):
n := [3,4]:
ans := RightMatrixPade(A,z,n,all):
s := evalm(A &* ans[2] - ans[1]):
Ans[12] := map(series, eval(s), z, convert(n,`+`) + 1):
ans := RightMatrixPade(A,z,n):
s := evalm(A &* ans[2] - ans[1]):
Ans[13] := map(series, eval(s), z, convert(n,`+`) + 1):
#
# testing LeftMatrixPade
#
n := [2,3]:
ans := LeftMatrixPade(A,z,n):
s := evalm( ans[2] &* A  - ans[1]):
Ans[14] := map(series, eval(s), z, convert(n,`+`) + 1):
n := [3,4]:
ans := LeftMatrixPade(A,z,n):
s := evalm(ans[2]&*A  - ans[1]):
Ans[15] := map(series, eval(s), z, convert(n,`+`) + 1):
#
# testing SigmaBases
#
F := linalg[matrix](4,1,[1,z,z/(1-z^4) + z^10,z/(1+z^4) + z^12]):
n := [2,2,2,2]:
Ans[16] := SigmaBases(F,z,n,2,10):
F := [2*z^6 + (1+z)/(1-z), 1 + z^8*cos(z) , (1 + z)/(1-2*z)]:
n := [1,2,3]:
N := convert(n,`+`) + nops(n):
Ans[17] := SigmaBases(F,z,n,2,N):
a[1] := series(O(x^9),x,9):
a[2] := series(O(x^9),x,9):
a[3] := series(1*x^8+O(x^9),x,9):
a[4] := series(_c(2,0)*x^8+O(x^9),x,9):
a[5] := series(25*x^9+O(x^10),x,10):
a[6] := 0:
a[7] := series((27*_c(2,0)-2*_c(3,0))*x^9+O(x^10),x,10):
a[8] := 0:
a[9] := array(1 .. 2, 1 .. 2,[(1, 1)=0,(2, 1)=-_c(4,1,1)*z-_c(4,0,1),
(2, 2)=-_c(4,1,2)*z-_c(4,0,2),(1, 2)=0]):
a[10]:= array(1 .. 2, 1 .. 2,[(1, 1)=0,(2, 1)=_c(4,1,1)*z^3+_c(4,0,1)*z^2-_c(4,1,1)*z-_c(4,0,1),(2, 2)=_c(4,1,2)*z^3+_c(4,0,2)*z^2-_c(4,1,2)*z-_c(4,0,2),(1, 2)=0]):
a[11]:= map(series,array(1 .. 2, 1 .. 2,[(1, 1)=O(z^7),(2, 1)=O(z^6),(2, 2)=O(z^6),(1, 2)=O(z^7)]),z,6):
a[12]:= map(series,array(1 .. 2, 1 .. 2,[(1, 1)=O(z^8),(2, 1)=O(z^8),(2, 2)=O(z^8),(1, 2)=O(z^8)]),z,8):
a[13] := map(series,array(1 .. 2, 1 .. 2,[(1, 1)=O(z^8),(2, 1)=O(z^8),(2, 2)=O(z^8),(1, 2)=O(z^9)]),z,8):
a[14] := map(series,array(1 .. 2, 1 .. 2,[(1, 1)=O(z^6),(2, 1)=O(z^6),(2, 2)=O(z^6),(1, 2)=O(z^6)]),z,6):
a[15]:= map(series,array(1 .. 2, 1 .. 2,[(1, 1)=O(z^8),(2, 1)=O(z^8),(2, 2)=O(z^8),(1, 2)=O(z^8)]),z,8):
a[16]:= array(1 .. 4, 1 .. 4,[(1, 3)=0,(2, 4)=1/2,(4, 2)=-2*z,(3, 4)=-1/2,(1, 4)=0,(3,2)=-z^2+1,(1, 1)=z^5,(4, 3)=z,(2, 1)=0,(3, 1)=0,(4, 1)=0,(2, 2)=z^2,(3, 3)=-1/2 +z^2,(4, 4)=z,(2, 3)=-1/2,(1, 2)=0]):
a[17]:=array(1 .. 3, 1 .. 3,[(1, 3)=2*z^4-2/3*z^3,(3, 2)=-1/6*z,(1, 1)=z^3,(2, 1)=7/12*z^2-1/2,(3, 1)=1/2*z,(2, 2)=-7/36*z^2+1/6+z^3,(3, 3)=z^3+z^2-1/3*z,(2, 3)=1/6*z^3-25/18*z^2-z+1/3,(1, 2)=-1/3*z^3]):
for i from 1 to 8 do
  if simplify(a[i] - Ans[i]) = 0 then  print(okay) 
  else print(false,a[i] - Ans[i]); fi;
od;
for i from 9 to 17 do
  if linalg[iszero](map(expand,evalm(a[i] - Ans[i]))) then  print(okay) 
  else print(false,evalm(a[i] - Ans[i])); fi;
od;
#quit
