#with(share):readshare(polya,algebra):
with(group):

DisjCyc := proc(per)
local i,  j,  n,  v,  val;
   n := nops(per);
   val := { };
   for i to n do
      if per[i]<>i and not has(val,i)  then
          v := i; 
          j := i;
          while not per[j]=i do
              v := v,  per[j];
              j := per[j]
          od;
          val := val union { [v] };\

      fi
   od;
   convert(val, list);
end:
# 
# 
GpSet := proc(G)    
local n,perm, g, tg, gpset;
    n := op(1,G);
    gpset := {[]}; 
    perm := combinat[permute](n);
    for g in perm do
          tg := DisjCyc(g);
          if groupmember(tg, G) then gpset := gpset union {tg} 
          fi;
    od; 
RETURN(gpset)
end:
# 
#     The procedure typ has two arguments. The second argument is a member of a permutation 
# group, and the first argument is the degree of the permutation. The procedure returns the cycle 
# type of the permutation.
typ := proc(n,g)
      local i, result, ind;
            result := x[1]^n;
            for i from 1 to nops(g) do
                        ind := nops(op(i,g));
                        result :=result* x[ind]*x[1]^(-ind);
           od;
result;
end:
# 
#     The cycle index of a group G is calculated by the procedure Cyc.
Cyc := proc(G)
     local g, no, result;
          result := 0;
          no := op(1,G);
          for g in GpSet(G) do
                result := result+typ(no,g)
          od;
          result := result/grouporder(G);
     end:
#     The procedure Polya solves the combinatorial problem. Adhering to the notation in the 
# introduction, the first argument of Polya is the group G, the second argument is a list, clist, 
# whose components are cont(x), with x running over the elements of the set F.          
Polya := proc(G,clist) 
                 local i, j, no, result;
                     no := op(1,G);
                     result := Cyc(G);
                     for i to no do
                          result := subs(x[i]=sum(clist[j]^i, j=1..nops(clist)), result);
                     od;
          result := expand(result);
end:
#
# Test file.
# 
Di(6) := permgroup(6,{[[1,2,3,4,5,6]],[[2,6],[3,5]]}):
r := typ(6,[[1,2],[3,4,5]]):
if r=x[1]*x[2]*x[3] then print(`okay`) else r fi;
r := Cyc(Di(6)):
if r=1/12*x[1]^6+1/6*x[6]+1/4*x[1]^2*x[2]^2+1/3*x[2]^3+1/6*x[3]^2
then print(`okay`) else r fi;
r := Polya(Di(6),[H,Cl]):
if r=H^6+H^5*Cl+3*H^4*Cl^2+3*H^3*Cl^3+3*H^2*Cl^4+H*Cl^5+Cl^6 
then print(`okay`) else r fi; 
r := Polya(Di(6),[2*s,3*p]):
if r=64*s^6+96*s^5*p+432*s^4*p^2+648*s^3*p^3+972*s^2*p^4+486*s*p^5+729*p^6
then print(`okay`) else r fi;
#quit
