with(share):readshare(tzsolve,analysis):
#################### Release 3 test file ########################


##########################
# standard input
###
# Convert from 5.2 to Release 3
# PDE solver version 1.0 test file

interface(quiet=true):

# reading the file with solver

#read `tzsolve.m`:


# setting the TestPDESolver global variable to true

TestPDESolver:=true:

# setting the print_and_plot_PDE global variable to 
# false to avoid printing the results and displaying 
# the 3D plot 

print_and_plot_PDE:=false:


test1:=proc(n1::integer,n2::integer,n3::integer,theta::numeric)

local sol1, Nlist, eq1, ci1, d1 , d2, d3, a, b, Nelem, FinalTime: 

# seting the FinalTime

FinalTime:=0.7:

# the analytical solution

(N,l,alpha)-> sum(200*sin('n'*Pi*x/l)*exp(-'n'^2*Pi^2*alpha^2*t/l)*100,
               'n'=1..N):

sol1:=unapply("(25,1,1),x,t): 

# declaring the differential equation

eq1:={diff(u(x,t),t)-diff(u(x,t),x$2)=0,u(0,t)=0,u(1,t)=0}:

# the initial condition 

ci1:=100*sin(Pi*x):

# running the solver with M=n1 

# Nelem elements

Nelem:=5:

tzsolve(eq1 union {u(x,0)=eval(ci1)},u(x,t),Nelem,n1,FinalTime,1,theta);

# assigning the result to d1

d1:=":

# running the solver with M=n2 

tzsolve(eq1 union {u(x,0)=eval(ci1)},u(x,t),Nelem,n2,FinalTime,1,theta);

# assigning the result to d2

d2:=":

# running the solver with M=n3 

tzsolve(eq1 union {u(x,0)=eval(ci1)},u(x,t),Nelem,n3,FinalTime,1,theta);

# assigning the result to d3

d3:=":

# Computing the convergence data

# for M=n1

GetConvData(eval(d1),evalhf(1/Nelem),evalhf(FinalTime/n1),0,sol1):

# for M=n2

GetConvData(eval(d2),evalhf(1/Nelem),evalhf(FinalTime/n2),0,sol1):

# for M=n30

GetConvData(eval(d3),evalhf(1/Nelem),evalhf(FinalTime/n3),0,sol1):


# computing the slope of the line using the linregress function


stats[fit,[leastsquare[[x,y],y=a*x+b]]]([[""","","],[log(FinalTime/n1),
                              log(FinalTime/n2),
                              log(FinalTime/n3)]]):

# returning the slope as result

RETURN(coeff(rhs("),x)):

end:

# test1


# test number 2

test2:=proc(n1::integer,n2::integer,n3::integer,theta::numeric)

global  print_and_plot_PDE;
local sol1, Nlist, eq1, ci1, d1 , d2, d3, a, b, Nelem, FinalTime: 

# seting the FinalTime

FinalTime:=0.7:

# the analytical solution

(N,l,alpha) -> sum(800*sin((2*'n'-1)*Pi*x/l)*exp(-(2*'n'-1)^2*Pi^2*alpha^2*t/l)/
               ((2*'n'-1)*Pi)^3,'n'=1..N):

sol1:=unapply("(25,1,1),x,t): 

# declaring the differential equation

eq1:={diff(u(x,t),t)-diff(u(x,t),x$2)=0,u(0,t)=0,u(1,t)=0}:

# the initial condition 

ci1:=100*x*(1-x):

# setting the print_and_plot_PDE global variable to 
# false to avoid printing the results and displaying 
# the 3D plot 

print_and_plot_PDE:=false:

# running the solver with M=n1 

# Nelem elements

Nelem:=5:

tzsolve(eq1 union {u(x,0)=eval(ci1)},u(x,t),Nelem,n1,FinalTime,1,theta);

# assigning the result to d1

d1:=":

# running the solver with M=n2 

tzsolve(eq1 union {u(x,0)=eval(ci1)},u(x,t),Nelem,n2,FinalTime,1,theta);

# assigning the result to d2

d2:=":

# running the solver with M=n3 

tzsolve(eq1 union {u(x,0)=eval(ci1)},u(x,t),Nelem,n3,FinalTime,1,theta);

# assigning the result to d3

d3:=":

# Computing the convergence data

# for M=n1

GetConvData(eval(d1),evalhf(1/Nelem),evalhf(FinalTime/n1),0,sol1):


# for M=n2

GetConvData(eval(d2),evalhf(1/Nelem),evalhf(FinalTime/n2),0,sol1):

# for M=n30

GetConvData(eval(d3),evalhf(1/Nelem),evalhf(FinalTime/n3),0,sol1):


# computing the slope of the line using the linregress function

stats[fit,[leastsquare[[x,y],y=a*x+b]]]([[""","","],[log(FinalTime/n1),
                              log(FinalTime/n2),
                              log(FinalTime/n3)]]):

# returning the slope as result

RETURN(coeff(rhs("),x)):

end:

# test2

# checking test 1 result


if ceil(abs(test1(2,4,16,0.5))) >= 1 then 
 print(`Ok - test #1 !`) 
else 
 print(`error - test #1`)
fi:

# checking test2 result

if abs(test2(2,4,16,0.7))>= 0.1 then 
 print(`Ok - test #2 !`) 
else 
 print(`error - test #2`)
fi: 


#quit
