#
## <SHAREFILE=convert/arctanh/arctanh.mpl >
## <DESCRIBE>
##                Rewrite all logarithms and inverse hyperbolic trig functions
##                in an expression in terms of arctanh.
##                AUTHOR: Vincent Broman, broman@nosc.mil
## </DESCRIBE>

`convert/arctanh` := proc( form)
# 
# this function modifies the expression FORM
# by replacing all occurences of ln or inverse hyperbolic trig functions
# by equivalent expressions in arctanh.
# e.g.  convert( ln( x+a), arctanh) => 2*arctanh( (x+a-1)/(x+a+1)).
# 
# Vincent Broman, broman@nosc.mil
#
   local newform, fn, ar;

   if type( form, {string, numeric}) then
      form
   else
      newform := map( procname, form);
      if type( newform, function) and
	 member( op( 0, newform), {ln, arcsinh, arccosh,
	       	     	      	   arccoth, arccsch, arcsech}) and
	 type( [op( newform)], [algebraic])
      then
      	 fn := op( 0, newform);
	 ar := op( 1, newform);
	 if fn = 'arcsinh' then
	    2*arctanh( (ar - 1 + sqrt( ar**2 + 1))/(ar + 1 + sqrt( ar**2 + 1)));
	 elif fn = 'arccosh' then
	    2*arctanh( (ar - 1 + sqrt( ar**2 - 1))/(ar + 1 + sqrt( ar**2 - 1)));
	 elif fn = 'arccoth' then
	    arctanh( 1/ar);
	 elif fn = 'arccsch' then
	    2*arctanh( (1/ar - 1 + sqrt( 1/ar**2 + 1))
	       	      /(1/ar + 1 + sqrt( 1/ar**2 + 1)));
	 elif fn = 'arcsech' then
	    2*arctanh( (1/ar - 1 + sqrt( 1/ar**2 - 1))
	       	      /(1/ar + 1 + sqrt( 1/ar**2 - 1)));
      	 else # 'ln'
	    2*arctanh( (ar - 1)/(ar + 1));
	 fi;
      else
      	 newform;
      fi;
   fi;
end:


#save `arctanh.m`;
#quit
