# % FILE anton1011.mpl
interface(echo=2);

A:=array([[2,1+I],[1-I,3]]);

# Maple V has a function innerprod which is more general than the
# dotprod function, though most useful with real vectors and matrices.
with(linalg,dotprod,innerprod):
u:=array([I,1+I]): v:=array([-2*I,1+I]):
simplify(dotprod(u,v));
innerprod(u,v);
simplify(dotprod(u,v,'orthogonal'));
#########################################################################
# Example 2 Section10.6 - AR6 p517; AR7 p560
# Show that the matrix A defined below is unitary.
# Maple 5.0.1 does not have a unitary test like orthog
# orthog(A) is false as it should be.
# htranspose and be said to people, not Maple, 'hermitian_transpose'.
with(linalg,htranspose,multiply):
A:=array([[(1+I)/2,(1+I)/2],[(1-I)/2,(-1+I)/2]]):
multiply(htranspose(A),A);
# This verifies that A is unitary.
##########################################################################

interface(echo=1);
