#
## <SHAREFILE=engineer/TDTools/TDTools.mpl >
## <DESCRIBE>
##	SEE ALSO: engineer/TDTools/thermo1.mws
##        Tools for manipulating derivatives and differentials.
##        These tools were written for thermodynamics but are useful
##        in other contexts.
##                AUTHOR: Ross Taylor, taylor@sun.soe.clarkson.edu
## </DESCRIBE>
## <UPDATE=R4 >

# TDTools - Maple Tools for Thermodynamics
#
#   TD - an extended D that operates on undefined functions like X(Y,Z)
#   TDiff - returns indexed partial derivatives (Inert version)
#   Tdiff - returns an indexed partial derivative (active)
#   DiffFlip - replaces a partial derivative with its reciprocal
#   D2Diff - replaces differentials with partial derivatives
#   Diff2D - the inverse of D2Diff
#   D2I - makes an integral equation from one in terms of D
#   TInt - applies limits to Inert integrals. Used in D2I
#   Tint - evaluation of a thermodynamic integral equation
#   simplify/Diff - knows how to make indexed second derivatives commute
#   solveqn - returns an expression in the form var = something
#   Flipeqn - interchanges the left and right hand sides of an equation
#   Compare_Eqn - takes two equations of the form a=b and a=c and returns b=c
#

TDTools:=`TDTools `:
TD := 'TD':

`type/Dtest` := proc(x)
  if traperror(op(0,x)) = `D` then
     true
  elif traperror(op(0,op(0,x))) = `@@` and traperror(op(1,op(0,x))) = `D` then
     true
  else
     false
   fi
end:


`type/Difftest` := proc()
   local le;
   le := traperror(op(0,args));
   if le <>`Diff` then false else true fi;
end:


`type/difftest` := proc()
    local le;
    le := traperror(op(0,args));
    if le <>`diff` then false else true fi;
end:

# CF 95-11-06:  I needed to add these two types since the syntax of forall
# conflicts with the fact that `+` and `*` are now defined as functions.
# The real trouble is that `+` and `*` are overloaded (both functions and type
# names).

`type/TD_plus` := proc(a)
    type(a,`+`);
end:

`type/TD_mult` := proc(a)
    type(a,`*`);
end:


Diff_function := proc(X::function, t::name)
local indexset, fname, t1;
  indexset := {op(X)} minus{t};
  fname := op(0,X);
  if type (fname, mathfunc) then
    t1 := diff (X,t)
  else
    t1 := Diff (fname,t)
  fi;
  if indexset <> {} then
    RETURN (t1[op(convert(indexset,list))])
  else
    RETURN (t1)
  fi;
end:

# Rule 0: Operate on existing D's
rule0 := forall(Dtest(x), TD(x) = D(x)):
# Rule 1: The basic operation
rule1 := forall(function(x), TD(x) = ''convert(map((t,X) ->Diff_function(X,t)*D(t),[op(x)],x),`+`)''):
# Rule 2: Chain rule for products
rule2 := forall(TD_plus(x), TD(x) = ''TD(op(1,x))
                                        *convert([op(2..nops(x),x)],`*`)''
       + ''TD(convert([op(2..nops(x),x)],`*`)) *op(1,x)''):
# Rule 3: Handle strings and numbers
rule3 := forall(string(y), TD(y) = D(y)):
rule3a := forall(numeric(y), TD(y) = 0):
# Rule 4: Deal with sums
rule4 := forall(TD_mult(x), TD(x) = ''convert(map(TD,[op(x)]),`+`)''):
# Rule 5: Deal with Diff and diff
rule5 := forall(Difftest(x),TD(x) = ''convert(map((t,X) ->Diff(X,t)*D(t),indets(indets(x,`Difftest`),algfun),
         x),`+`)''):
rule5a := forall(difftest(x),TD(x) = ''convert(map((t,X) ->diff(X,t)*D(t),indets(indets(x,`difftest`),algfun
          ),x),`+`)''):
# Rule 6: Make sure TD works with equations
rule6 := forall(`=`(x), TD(x) = ''map''(TD,x)):
# Rule 7: and powers
rule7 := forall([x,y], TD(x^y) = y*x^(y-1)*TD(x)):
# Rule 8: Above all, be able to handle indexed variables when applying TD.

index_proc := proc(a)
local t;
if op(0,op(0,a)) = `Diff` then # is head Diff ?
  TD(op(0,a)); # yes
  t:= map((x,y)->map((x,y) -> x[y],x,y),TD(op(0,a)),op(a)); # diff wrt vars
  subs(map(x -> x = D(op(op(0,x))), select(has,indets(t),`D`)),t); # deal with indeces
elif op(0,op(0,a)) <> string then
  subs(op(0,op(0,a)) = op(0,op(0,a))[op(a)],TD(op(0,a)))
else
  subs(op(0,a) = op(0,a)[op(a)],TD(op(0,a)))
fi
end:

rule8 := forall(indexed(a), TD(a) = ''index_proc(a)''):
# The TD operator is created with the define command.
TD:='TD':
define(TD,rule8,rule7,rule6,rule5,rule5a,rule4,rule3,rule3a,rule2,rule1,rule0):

Dsolve := proc(expr,dterm)
local xxx,expr2;
expr2:=subs(dterm=xxx,expr);
expr2:=xxx=solve(expr2,xxx);
RETURN(subs(xxx=dterm,expr2));
end:

TDiff := proc(f1::{algebraic,equation},x::name)
local i,y,g,index,f,constpar,L,L1;
if type(f1,equation) then
   RETURN(map(TDiff,f1,x,args[3..nargs]));
fi;
if type(f1,`+`) then
   RETURN(convert(map(TDiff,[op(f1)],x,args[3..nargs]),`+`))
fi;
if type(f1,`*`) then
   RETURN(
   convert([seq(convert([op({op(f1)} minus {op(i,f1)})],`*`)*TDiff(op(i,f1),x,args[3..nargs]) ,i=1..nops(f1
))]         ,`+`));
fi;
if type(f1,numeric) then
   RETURN(0);
fi;
# See if TDiff was called with constant parameters (args[ 3..])
if nargs > 2 then
  constpar:=[args[3..nargs]];
  if member(x, constpar) then
    ERROR(`variable cannot be a constant parameter`);
  fi;
else
  constpar:=[];
fi;
# Check if argument is already indexed
if type(f1,indexed) then
   f :=op(0,f1);
   index := [op(f1)];
   if not type(f,Difftest) then f:=f1; index:=[]; fi;
else
   f := f1;
   index := [];
fi;
# Evaluate derivative
if index <> [] or constpar <> [] then
  L:=[op(index),op(constpar)];  #this will become the new index
  L1:= NULL;                            # after eliminating duplicate entries
  for i in L do
    if not member(i, [L1]) then
      L1 := L1,i;
    fi;
  od;
  if f <> x and f <> L1 then 'Diff'(f,x)[L1]; elif f <> x and f = L1 then 0; elif f = x then 1; fi;
else
  if f <> x then 'Diff'(f,x); else 1; fi;
fi;
end:

DiffFlip := proc(eqn,dervs)
local term1, term2,diffterm,index,derv,dervlist,expr;
dervlist:=[args[2..nargs]];
expr:=eqn;
for derv in dervlist do
   if type(derv,indexed) then
      index := op(derv);
      diffterm:=op(0,derv);
      term1:= op(1,diffterm);
      term2:= op(2, diffterm);
      if type(term1,function) then
        term1:=op(0,term1);
        expr:=subs(derv=1/(Diff(term2,term1)[index]),expr);
      else
        expr:=subs(derv=1/(Diff(term2,term1)[index]),expr);
      fi;
    else
      diffterm:=derv;
      term1:= op(1,diffterm);
      term2:= op(2, diffterm);
      if type(term1,function) then
        term1:=op(0,term1);
        expr:=subs(derv=1/(Diff(term2,term1)),expr);
      else
        expr:=subs(derv=1/(Diff(term2,term1)),expr);
      fi;
    fi;
od;
RETURN(expr);
end:

macro(SimpDiff=`simplify/Diff`);
SimpDiff:=proc(a)
local e,f,g,x,y,index;
if type(a,indexed) then
   e := op(0,a);
   index := op(a);
   if not type(e,Difftest) then e:=a; index:=[]; fi;
else
   e := a;
   index := [];
fi;
if type(e,numeric) or type(e,name) or type(e,procedure) then e
elif type(e, function) and op(0,e)=Diff then
  f:=op(1,e); x:=op(2,e);
  if nops(e) > 2 then
    if index <> [] then
      RETURN(SimpDiff(Diff(Diff(f,x),op(3..nops(e),e)))[op(sort({index}))])
    else
      RETURN(SimpDiff(Diff(Diff(f,x),op(3..nops(e),e))))
    fi;
  fi;
  f:=SimpDiff(f);
  if type(f,'Diff(algebraic,name)') then
    g:=op(1,f); y:=op(2,f);
    if [y,x] <> sort([y,x]) then
      if index <> [] then
       RETURN(Diff(SimpDiff(Diff(g,x)),y)[op(sort({index}))])
      else
       RETURN(Diff(SimpDiff(Diff(g,x)),y))
      fi;
    fi;
  fi;
 if index <> [] then
   'Diff'(f,x)[op(sort({index}))];
 else
   'Diff'(f,x);
 fi;
else
  map(SimpDiff,a)
fi;
end:

D2Diff:=proc(expr,var)
local x,expr2,set2,constpar,i;
set2:=indets(expr) minus indets(expr,function);
if nargs > 2 then
  constpar:=[seq(args[i],i=3..nargs)];
  if member(var, constpar) then
    ERROR(`variable cannot be the same as a constant parameter`);
  fi;
  expr2:=subs({seq(D(x)=Diff(x,var)[op(constpar)],x=set2)},expr);
  expr2:=subs({seq(Diff(x,x)[op(constpar)]=1,x=set2)},expr2);
   subs({seq(seq(Diff(i,x)[op(constpar)]=0,x=[op(set2),var]),i=constpar)},expr2);
 else
  expr2:=subs({seq(D(x)=Diff(x,var),x=set2)},expr);
  expr2:=subs({seq(Diff(x,x)=1,x=set2)},expr2);
  subs({seq(seq(Diff(i,x)=0,x=[op(set2),var]),i=constpar)},expr2);
 fi;
end:

Diff2D := proc(eqn,derv)
local term1,term2,diffterm,expr;
expr:=eqn;
if type(derv,indexed) then
    diffterm:=op(0,derv);
else
    diffterm:=derv;
fi;
if type(diffterm,Difftest) then
   term1:= op(1,diffterm);
   term2:= op(2, diffterm);
   expr:=subs(derv=D(term1)/D(term2),expr);
   if type(expr,`=`) then
     RETURN(expr*D(term2));
   else
     RETURN(expr);
   fi;
fi;
end:

Tdiff := proc(f,x,y,z)
local t,a,p;
t:=TD(f);
if  nargs > 4 then a:=subs(seq(D(p)=0,p=args[5]),t); else a:=t; fi;
a:=D2Diff(",y,z);
RETURN(TDiff(x,y,z)=solve(a,TDiff(x,y,z)));
end:

`type/Itest`:=proc(x)
    if traperror(op(0,x)) = Int then true
    elif traperror(op(0,op(0,x))) = `@@` and traperror(op(1,op(0,x))) = Int
         then
        true
    else false
    fi
end:

`type/itest`:=proc(x)
    if traperror(op(0,x)) = int then true
    elif traperror(op(0,op(0,x))) = `@@` and traperror(op(1,op(0,x))) = int
         then
        true
    else false
    fi
end:

TInt:=proc(expr)
local expr2,set2,v,limits,lower,upper,z,temp,v1,llimits,ulimits,i;

    expr2:=expr;
    set2 := [op(indets(expr,Itest))];

    if nargs = 2 then
       limits:=args[2];
       llimits := op(1,limits); ulimits:=op(2,limits);
       if type(llimits,set) and type(ulimits,set) then
         llimits:=convert(llimits,list);
         ulimits:=convert(ulimits,list);
         for i from 1 to nops(llimits) do
           temp:=lhs(op(i,llimits))[lowlim]=rhs(op(i,llimits));
           llimits:=subsop(i=temp,llimits);
         od;
         for i from 1 to nops(ulimits) do
           temp:=lhs(op(i,ulimits))[upplim]=rhs(op(i,ulimits));
           ulimits:=subsop(i=temp,ulimits);
         od;
       elif type (llimits, algebraic) and type(ulimits, algebraic) then
           llimits:=[seq(op(2,v)[lowlim]=op(2,v)[llimits],v=set2)];
           ulimits:=[seq(op(2,v)[upplim]=op(2,v)[ulimits],v=set2)];
       else
          ERROR (`Integration limits not in correct format`);
       fi;
    fi;
       for v in set2 do
         z := op(2,v);
         if nargs > 1 then
            temp:=z=z[lowlim]..z[upplim];
            temp:=subs(llimits,ulimits,temp);
            if op(1,rhs(temp)) = op(2,rhs(temp)) then
               v1 := 0;
             else
               v1:=subsop(2=temp,v);
            fi;
         else
            v1 := v;
         fi;
            expr2:=subs(v=v1,expr2);
       od;
      # expr2:=subs(llimits,ulimits,expr2);
       expr2:=subs(V[ZeroPressure]=infinity,P[ZeroPressure]=0,expr2);
       RETURN(expr2);
end:

Tint:=proc(expr)
local expr2,set2,v,lower,upper,z,temp,v1,numv,i,z1,zleft,zright;
    expr2:= expr;
    set2 := [op(indets(expr,Itest))];
    numv := nops(set2);
      for i from 1 to numv do
        v := set2[i];
        z := op(2,v);
        zleft := lhs(z): zright := rhs(z);
        lower.i := op(1,zright);
        upper.i := op(2,zright);
        if not type(lower.i,constant) then
          z1:=subsop(1=xx.i,zright);
        else z1 := zright; fi;
        if not type(upper.i,constant) then
          z1:=subs(upper.i=yy.i,z1);
        fi;
        temp:=zleft=z1;
        v1:=subsop(2=temp,v);
        expr2:=subs(v=v1,expr2);
    od;
    subs(Int=int,expr2);
    expr2:=eval(");
    for i from 1 to numv do
      expr2:=subs(xx.i=lower.i,yy.i=upper.i,expr2);
    od;
end:


D2I:=proc(expr)
local expr2,set2,v,c,range;
    range:='range';
    if nargs > 1 then range := args[2]; fi;
    if type(expr,`=`) and assigned(range) then
        RETURN(D2I(lhs(expr),range) = D2I(rhs(expr),range))
    elif type(expr,`=`) and not assigned(range) then
        RETURN(D2I(lhs(expr)) = D2I(rhs(expr)))
    else
        set2 := [op(indets(indets(expr,Dtest),algfun))];
        expr2 := collect(expr,[seq(D(v),v = set2)]);
        for v in set2 do
            c := coeff(expr2,D(v));
            if type(c,`+`) then
                expr2 := subs(c*D(v) = map(Int,c,v),expr2)
            else expr2 := subs(c*D(v) = Int(c,v),expr2)
            fi;
            expr2 := subs(Int(1,v) = Int(``,v),expr2)
        od;
    fi;
    expr2:=combine(expr2,Int);
    if assigned(range) then RETURN(TInt(expr2,range))
    else RETURN(expr2)
    fi;
end:

solveqn:=proc(eqn::equation,var)  var=solve(eqn,var); end:

Compare_Eqn:=proc(eqn1::equation,eqn2::equation)
local set1,set2,set3;
# make derivative terms commute
set1:=SimpDiff({lhs(eqn1),rhs(eqn1)});
set2:=SimpDiff({lhs(eqn2),rhs(eqn2)});
set3:=(set1 minus set2) union (set2 minus set1);
if nops(set3) = 2 then
  RETURN(op(1,set3)/sign(op(1,set3))=op(2,set3)/sign(op(1,set3)));
fi;
end:

Flipeqn := proc(eqn::equation)
  RETURN(rhs(eqn)=lhs(eqn));
end:

