#
## <SHAREFILE=numerics/pade2/pade2.mpl >
## <DESCRIBE>
##                The call pade2([f1,f2,...,fn],x=p,[d1,d2,...,dn]) computes a
##                generalized Pade approximation of the functions f1,f2,...,fn
##                at x=p where the output polynomials [g1,g2,...,gn] in x
##                (not all 0) satisfy
##                (i)  degree(g.i,x) <= d.i for all i
##                (i)  f1*g1+f2*g2+...+fn*gn has a zero of multiplicity
##                     d1+d2+...+dn+n-1 at x=p
##                AUTHOR: Harm Derksen, hderksen@sci.kun.nl
## </DESCRIBE>


# author: Harm Derksen, university of nijmegen, hderksen@sci.kun.nl
# Generalised pade approximations

`pade2/valuation`:=proc(f,z,x,acc)
local c;
c:=coeff(f,z,1);
if c=0 then acc else ldegree(coeff(f,z,1),x) fi;
end:

`pade2/smaller`:=proc(f,g,z,vars)
local ff,gg;
ff:=grobner[leadmon](coeff(f,z,0),vars)[2];
gg:=grobner[leadmon](coeff(g,z,0),vars)[2];
grobner[leadmon](ff+gg,vars)[2]=gg and f<>0;
end:

`pade2/wipe`:=proc(f,g,z,x,i)
local ff,gg;
ff:=coeff(coeff(f,z,1),x,i);
gg:=coeff(coeff(g,z,1),x,i);
expand(f-ff/gg*g);
end:

pade2:=proc(functionlist,point,accuracy)
local n,x,y,z,i,j,k,l,vars,appr,acc,degrees,maxdegree,smallest,ops,result;
    if not (type(functionlist,list(algebraic)) or type(functionlist,algebraic))
        then ERROR(`first argument must be a function or a list of functions`) fi;
    if not (type(point,name=algebraic) or type(point,name))
        then ERROR(`second argument is wrong`) fi;
    if not (type(accuracy,nonnegint) or type(accuracy,list(nonnegint)))
        then ERROR(`third argument must be a nonnegative integer or a list of nonnegative integers`) fi;
    if not type(functionlist,list) then 
        result:=pade2([1,functionlist],point,accuracy);
        RETURN(normal(-result[1]/result[2])) fi;
    if type(point,name) then 
        RETURN(pade2(functionlist,point=0,accuracy)) fi;
    ops:=[op(point)];x:=ops[1];
    if ops[2]<>0 then RETURN(expand(subs(x=x-ops[2],
        pade2(subs(x=x+ops[2],functionlist),x=0,accuracy))))
    fi;
    appr:=functionlist;
    n:=nops(appr);
    vars:=[seq(y[i],i=1..n),x];
    if type(accuracy,list) then 
        acc:=convert(accuracy,`+`)+n-1;
        maxdegree:=max(op(accuracy));
        degrees:=[seq(maxdegree-accuracy[i],i=1..n)];
    else
        acc:=accuracy;
        degrees:=[seq(0,i=1..n)];
    fi;
    appr:=[seq(expand(x^degrees[i]*y[i]+convert(series(appr[i],x=0,acc),
        `polynom`)*z),i=1..n)];
    for i from 0 to acc-1 do
        k:=0;
        for j to n do
            if coeff(appr[j],z,1)=0 then 
                for l to n while `pade2/smaller`(appr[j],appr[l],z,vars) do od;
                if l=n+1 then
                    RETURN([seq(expand(coeff(appr[j],y[l],1)/x^degrees[l]),l=1..n)])
                fi;
            fi;    
            if `pade2/valuation`(appr[j],z,x,acc)=i then
                if k=0 or `pade2/smaller`(appr[j],appr[k],z,vars) then
                    k:=j;
                fi;
            fi;
        od;
        if k>0 then
            appr:=[seq(`pade2/wipe`(appr[j],appr[k],z,x,i),j=1..k-1),
                expand(x*appr[k]-coeff(appr[k],x,acc-1)*x^acc),
                seq(`pade2/wipe`(appr[j],appr[k],z,x,i),j=k+1..n)];
        fi;
    od;
    smallest:=1;
    for i from 2 to n do
        if `pade2/smaller`(appr[i],appr[smallest],z,vars) then
            smallest:=i;
        fi;
    od;
    [seq(expand(coeff(appr[smallest],y[l],1)/x^degrees[l]),l=1..n)];
end:

#save `pade2.m`;
#quit
