# Test : formal power series package - powerseries
with(share): readshare(PS,calculus): # read `PS.m`:
with(PS):

#test powcreate
v := powcreate(v(n)=v(n-1)+v(n-3),v(0)=0,v(1)=1,v(2)=-1):
if  powcoeff(v,0) <> 0 then 'FAIL', powcoeff(v,0) fi;
if  powcoeff(v,5) <> -1 then 'FAIL', powcoeff(v,5) fi;
if  powcoeff(v,8) <> -3 then 'FAIL', powcoeff(v,8) fi;
t := powcreate(t(n)=t(n-1)/5,t(0)=1):
if {seq(powcoeff(t,i), i=0..14)} <> {'1/(5^i)'$'i'=0..14} then 'FAIL', 4 fi;
# test powpoly & tpsform
if ( tpsform( t, x) <> taylor(1+1/5*x+1/25*x^2+1/125*x^3+1/625*x^4+1/3125*x^5+x^6,x) )
then 'FAIL', 5 fi;
s := powpoly( x, x):
if ( tpsform( s ) <> taylor(x+O(x^6),x) ) then 'FAIL', " else true fi;
r := powpoly( sum( 'i*x^i', 'i'=1..8), x):
if ( tpsform( r, 10) <> taylor(x+2*x^2+3*x^3+4*x^4+5*x^5+6*x^6+7*x^7+8*x^8+O(x^11),x,10) )
then 'FAIL', " else true fi;
# test powsolve
a:=ode ((x,y)->y, [1]):
b:=ode ((x,y,yp)->(yp-y*x-x^2+2)/(x^2+1), [alpha,beta]):
c:=ode ((x,y,yp,ypp)->y,[3/2,-1/2,-3/2,1/2]):
# test add, negative & subtract
d := add( a, c, s, t, v):
tpsform( d, x):
if ( " <> taylor(7/2+27/10*x-121/100*x^2-371/500*x^3+3173/30000*x^4
-149327/150000*x^5+x^6,x) ) then 'FAIL', " else true fi;
e := negative( a ):
tpsform( e, x):
if (" <> taylor(-1-x-1/2*x^2-1/6*x^3-1/24*x^4-1/120*x^5+x^6,x) )
then 'FAIL'," else true fi;
f := subtract( a, e ):
tpsform( f, x):
if ( " <> taylor(2+2*x+x^2+1/3*x^3+1/12*x^4+1/60*x^5+x^6,x) ) then
'FAIL'," else true fi;
#test multconst
g := multconst( a, 2):
tpsform( g, x):
if ( " <> taylor(2+2*x+x^2+1/3*x^3+1/12*x^4+1/60*x^5+x^6,x) ) then
'FAIL'," else true fi;
h := multiply ( a, c):
tpsform( h, x ):
if ( " <> taylor(3/2+x-1/2*x^2-2/3*x^3-1/4*x^4-1/30*x^5+x^6,x) ) then
'FAIL'," else true fi;
i := inverse ( c ):
tpsform( i, x):
if (" <> taylor(2/3+2/9*x+11/27*x^2+17/81*x^3+227/972*x^4+2227/14580*x^5
+x^6,x) ) then 'FAIL'," else true fi;
j := quotient( a, i):
tpsform( j, x):
if ( " <> taylor(3/2+x-1/2*x^2-2/3*x^3-1/4*x^4-1/30*x^5+x^6,x) ) then
'FAIL'," else true fi;
#test powexp, powlog, powdiff, powint
if traperror(powlog( s ))<>`singularity encountered` then
'FAIL',`powlog( s )` else true fi;
k := powlog ( c ):
if powcoeff(k,2) <> -5/9 then 'FAIL',powcoeff(k,2) fi;
if powcoeff(k,5) <> -14/243 then 'FAIL',powcoeff(k,5) fi;
l := powexp ( s ):
tpsform( l, x):
if ( " <> taylor(1+x+1/2*x^2+1/6*x^3+1/24*x^4+1/120*x^5+x^6,x) ) then
'FAIL'," else true fi;
m := powdiff( l ):
n := powint ( m ):
tpsform( m, x):
if ( " <> taylor(1+x+1/2*x^2+1/6*x^3+1/24*x^4+1/120*x^5+x^6,x) ) then
'FAIL'," else true fi;
tpsform( n, x):
if ( " <> taylor(x+1/2*x^2+1/6*x^3+1/24*x^4+1/120*x^5+x^6,x) ) then
'FAIL'," else true fi;
p := compose( v, v):
tpsform( p, 7):
if ( " <> taylor(x-2*x^2+4*x^4-4*x^5-3*x^6+8*x^7+x^8,x,8) ) then
'FAIL'," else true fi;
# q:=reversion(p, v):
# tpsform( q ):
# if ( " <> taylor(x+x^2+3*x^3+10*x^4+39*x^5+163*x^6+716*x^7+x^8,x) )
# then 'FAIL'," else true fi;
r:=reversion(v):
tpsform( r, x):
if ( " <> taylor(x+x^2+3*x^3+10*x^4+39*x^5+163*x^6+716*x^7+x^8,x) )
then 'FAIL'," else true fi;
# test evalpow
f:='f': g:='g': l:='l': m:='m':
F := exp(x): G := 1/(1-x/5): L := x/(1-x/2): M := 0:
f:=powcreate(F):
g:=powcreate(G):
l:=powcreate(L):
m:=powcreate(M, x):
if( tpsform(evalpow(f+g*f-g)) <> taylor(F+G*F-G, x) ) then 'FAIL',1 else true fi;
if( tpsform(evalpow(f^1)) <> taylor(F^1, x) ) then 'FAIL',2 else true fi;
if( tpsform(evalpow(f^2)) <> taylor(F^2, x) ) then 'FAIL',3 else true fi;
if( tpsform(evalpow(f^4)) <> taylor(F^4, x) ) then 'FAIL',4 else true fi;
if( tpsform(evalpow(f^6)) <> taylor(F^6, x) ) then 'FAIL',5 else true fi;
if( tpsform(evalpow(10, x)) <> taylor(10+O(x^6), x) ) then 'FAIL',6 else true fi;
if( tpsform(evalpow(aaa)) <> taylor(aaa+O(aaa^6), aaa) ) then 'FAIL',7 else true fi;
if( tpsform(evalpow(pexp(f)+pinv(g)*plog(f)-pneg(g)/pdiff(f))) <> 
    taylor(exp(F)+log(F)/G+G/diff(F,x), x) ) then 'FAIL',8 else true fi;
if( tpsform(evalpow(pint(f)+prev(l)*f(l))) <> 
    taylor(int(F,x)-1+2*x/(2+x)*subs(x=L,F), x) ) then 'FAIL',9 else true fi;
# if( tpsform(evalpow(prev(l,m)*pquo(f,g)+psub(f,g))) <> taylor(, x) ) then 'FAIL',10 else true fi;
if( tpsform(powsin(l)) <> taylor(sin(L),x)) then 'FAIL',11 else true fi;
if( tpsform(powsinh(l)) <> taylor(sinh(L),x)) then 'FAIL',12 else true fi;
if( tpsform(powcos(l)) <> taylor(cos(L),x)) then 'FAIL',13 else true fi;
if( tpsform(powcosh(l)) <> taylor(cosh(L),x)) then 'FAIL',14 else true fi;
if( tpsform(powtan(l)) <> taylor(tan(L),x)) then 'FAIL',15 else true fi;
if( tpsform(powtanh(l)) <> taylor(tanh(L),x)) then 'FAIL',16 else true fi;
if( tpsform(powlog(g)) <> taylor(log(G),x)) then 'FAIL',17 else true fi;
if( tpsform(powln(g)) <> taylor(ln(G),x)) then 'FAIL',18 else true fi;

e := powcreate(exp(x)):
if( tpsform(`^`(e,e)) <> taylor(exp(x)^exp(x),x)) then 'FAIL',19 else true fi;

#quit

