#
## <SHAREFILE=algebra/seralgfun/seralgfun.mpl >
## <DESCRIBE>
##       Returns an expansion of all the branches of an algebraic
##       function at the origin. Should work over finite extensions too.
##       The order should be relatively small, otherwise it is better
##       to use the differential equation.
##       AUTHOR: Bruno.Salvy@inria.fr
## </DESCRIBE>
## <UPDATE=R4 >

##    -*-Maple-*-
##
##    Title: 	series_algfun
##    Created:	July 1994
##    Author: 	Bruno Salvy
##		<Bruno.Salvy@inria.fr>
##
## Description: returns an expansion of all the branches of an algebraic
## function at the origin. Should work over finite extensions too.
##  The order should be relatively small, otherwise it is better to use
##  the differential equation.

seralgfun:=`_seralgfun`:

series_algfun:=proc (Pol::polynom,x::name,y::name,ord::nonnegint,optional_positive_slopes)
    map(`series_algfun/prettyprint`,`series_algfun/doit`(args),x)
end: # series_algfun

`series_algfun/doit`:=proc (Pol,x,y,ord,opt)
local pol, a, u, i, j, pts, alpha, mini, deg, theta, jmin, sl, lastpt, p, pu, nb2, res, r, nb, q, a0, normalizer;
option `Copyright Bruno Salvy, INRIA Rocquencourt, France`;
    _EnvExplicit:=false; # otherwise some RootOf's will be perturbed
    pol:=collect(Pol,[y,x],evala);
    # Newton polygon
    deg:=degree(pol,y);
    pts:=select(proc(x) x[2]<>0 end,[seq([i,coeff(pol,y,i)],i=0..deg)]);
    pts:=[seq([i[1],ldegree(i[2],x)],i=pts)];
    nb:=0;
    lastpt:=pts[1];
    for i from 2 to nops(pts) do
	mini:=infinity;
	for j from i to nops(pts) do
	    theta:=(pts[j][2]-lastpt[2])/(pts[j][1]-lastpt[1]);
	    if theta<mini then mini:=theta; jmin:=j fi
	od;
	nb:=nb+1; alpha[nb]:=-mini; i:=jmin; lastpt:=pts[i]
    od;
    # Treat each slope
    nb2:=0;
    alpha:={seq(alpha[i],i=1..nb)};
    if nargs=5 then alpha:=select(type,alpha,nonneg) fi;
    for sl in alpha do
	r:=denom(sl);
	p:=collect(subs(x=x^r,y=x^numer(sl)*y,pol),x);
	if ldegree(p,x)<>0 then p:=collect(p/x^ldegree(p,x),x) fi;
	q:=collect(coeff(p,x,0),y);
	if ldegree(q,y)<>0 then q:=collect(q/y^ldegree(q,y),y) fi;
	for u in sqrfree(q,y)[2] do
	    a0:=traperror(evala(RootOf(u[1],y)));#These 5 lines are not
	    if a0<>lasterror then a0:=[a0]	# strictly necessary but they
	    elif op(1,[a0])<>`reducible RootOf detected.  Substitutions are`
		then ERROR(a0)				# save much trouble in
	    else a0:=map(subs,a0[2],RootOf(u[1],y)) fi; # later computations.
	    for a0 in a0 do
		if u[2]=1 then	# regular case
		    if type(a0,RootOf) then normalizer:=evala
		    else normalizer:=normal fi;
		    a[0]:=a0; pu:=p;
		    for i to ord-1 do # ord relatively small
			pu:=collect(subs(y=a[i-1]+x*y,pu),x);
			a[i]:=normalizer(solve(coeff(pu,x,i),y))
		    od; # in this loop, normal saves memory
		    nb2:=nb2+1;
		    res[nb2]:=[seq([a[i],sl+i/r],i=0..ord-1),[O(1),sl+ord/r]]
		else		# several branches
		    for i in `series_algfun/doit`(
			    subs([x=x^u[2],y=a0+x*y],p),x,y,ord-1,1) do
			nb2:=nb2+1;
			res[nb2]:=[[a0,sl],seq([j[1],(j[2]+1)/u[2]/r],j=i)]
		    od
		fi
	    od
	od
    od;
    [seq(res[i],i=1..nb2)]
end: # series_algfun/doit

`series_algfun/prettyprint`:=proc (l, x)
local i;
    series(convert([seq(i[1]*x^i[2],i=l)],`+`),x,max(4,ceil(l[nops(l)][2])))
end: # `series_algfun/prettyprint`

#save `seralgfun.m`;
#quit
