#--------------------------------------------------------------------------
# test for GB: 
#--------------------------------------------------------------------------
with(share): readshare(`mod/GB`): # read `GB.m`: 

#--------------------------------------------------------------------------
# ex2  : example over Zp[x,y]
# from : Buchberger, "Grobner Bases: An algorithmic method ...",
#        Example 6.1 (p.188),   Solution: p.194
#
x:= 'x':   y:= 'y':
F := {3*x^2*y + 2*x*y + y + 9*x^2 + 5*x -3,
      2*x^3*y - x*y - y + 6*x^3 - 2*x^2 - 3*x + 3,
      x^3*y + x^2*y + 3*x^3 + 2*x^2}:
X := [y,x]:

g := GB(F,X,plex) mod 5: 
if convert(g,set) <> {y+x^2+x+2,x^3} then 'FAIL',g else ok fi;
g := GB(F,X,plex) mod 7:
if convert(g,set) <> {y+x^2+2*x+4,x^3+x^2+x} then 'FAIL',g else ok fi;

#--------------------------------------------------------------------------
# example over Zp(s)[x,y]
#
x := 'x': y := 'y': s := 's':
F := [s^2/(2*s+1)*x^2*y-(s+1)*y, (3*s-1)/3*x*y^2-1/(s-1)*x]:
X := [x,y]:

g := GB(F,X,tdeg) mod 3:
if convert(g,set) <> {s^2*x^2*y+y*s^2+2*y,y^2} then 'FAIL',g else ok fi;

#--------------------------------------------------------------------------
# ex7  : example for grobner bases
# from : Winkler, "A p-adic approach ...", Example 1 (b)
x:= 'x':   y:= 'y':
F := {7*x*y + y + 4*x, y + 2}:
X := [y,x]:                                      # x < y

g := GB(F,X,plex) mod 5:
if convert(g,set) <> {1} then 'FAIL',g else ok fi;
g := GB(F,X,plex) mod 7:
if convert(g,set) <> {y + 2, x + 3} then 'FAIL',g else ok fi;


#--------------------------------------------------------------------------
# example for Normalform computation
# 
F := [x^2 - 2*x*z + 5, x*y^2 + y*z^3, 3*y^2 - 8*z^3]:   X := [x,y,z]:
G := GB(F,X,tdeg) mod 5:
p := 4*y^4*x+4*z^2*y^4*x+2*y^5*x*z+3*x*z*y^3:
n := Normalform(p,G,X,tdeg) mod 5:
if n <> 0 then 'FAIL',n else ok fi;
q := 3*x^3*y*z^2 + 4*x*z^2 + y^3 + y*z:
n := Normalform(q,G,X,tdeg) mod 5:
if n <> z^2*x+4*y^3+4*z*y+z^2*y^3 then 'FAIL',n else ok fi;

#--------------------------------------------------------------------------
# example for Normalform computation 
#
F := [s^2/(2*s+1)*x^2*y-(s+1)*y, (2*s-1)/2*x*y^2-1/(s-1)*x]:
G := GB(F,[x,y]) mod 3:
p := F[1]*(Randpoly(3,x) mod 3) + F[2]*(Randpoly(2,y) mod 3):
n := Normalform(p, G, [x,y]) mod 3:
if n <> 0 then 'FAIL',n else ok fi;

#done:
