#################################################################
#
#                    CAPOLSINI Patrick
#               INRIA - Universite de Nice
#                         1992
#
#                   Test file for macroC
#             to compare with reference file test.c
#################################################################
with(share): readshare(macroC,numerics): # read `macroC.m`;
optimized := true:
autodeclare := `double`:
precision := `double`:

test := proc()
local l1, l2, l3, l4, l5, mat, mat2, mat3;

# Preprocessor functions
l1 := 
[includeC, `<math.h>`],
[includeC, `<stdio.h>`],
[includeC, `<simul.h>`],
[includeC, string(`toto.h`)],

[commentC, ``],
[defineC, PI, Pi],
[defineC, SQUARE(num), (num) * (num)],
[undefC, TOTO],

[commentC, ``],
[ifdefm, TOTO, [[defineC, ROWS, 100], [defineC, LINES, 100]],
               [[defineC, ROWS, 10], [undefC, TOTO]]],

[commentC, ``],
[ifndefm, TOTO, [defineC, ROWS, 1]],

[commentC, ``],
[ifm, defined(TOTO), [[defineC, WELCOME, toto],
                      [elifm, defined(TITI), [defineC, WELCOME, titi]],
		      [elifm, defined(TUTU), [defineC, WELCOME, tutu]]],
                     [defineC, WELCOME, tata]],

[commentC, ``],
[lineC, 56, `toto.c`],
[errorC, `This an ERROR message`],
[pragmaC, inline]:

# functions with loops, iterations, affectations and declarem
l2 := 
[commentC, ``],
[commentC, 
`                                                                  `],
[commentC, 
`      Inversion de matrice symmetrique definie positive           `],
[commentC,
`                                                                  `],
[commentC, ``],
[commentC, ` Decomposition de cholesky `],
[commentC, ``],
[functionm, void, cholesky, [[double, [`**M`, `**res`]],
                             [int, n]],
  [ [form, &=(j,0), j<=n-1,&=(j,j+1),
         [[equalC, tmp, 0.0],
          [form, &=(k,0), k<=j-1,&=(k,k+1),
               [&=(tmp, tmp+(res[j+1,k+1]^2))]
          ],
          [equalC, res[j+1,j+1], sqrt(M[j+1,j+1]-tmp)],
          [form, &=(i,j+1), i<=n-1, &=(i,i+1),
               [[equalC, tmp, 0.0],
                [form, &=(k,0), k<=j-1, &=(k,k+1),
                     [&=(tmp, tmp+(res[j+1,k+1]*res[i+1,k+1]))]
                ],
                [equalC, res[i+1,j+1], (M[j+1,i+1]-tmp)/res[j+1,j+1]],
                [equalC, res[j+1,i+1], res[i+1,j+1]]
               ]
          ]]
    ],
    [declarem, int, [i,j,k]],
    [declarem, double, [tmp]]  
  ]],

[commentC, ``],
[commentC, ` Resoluton du systeme lineaire (MMt) X = b  `],
[functionm, void, resolution, [[double, [`**M`, `*X`, `*b`]],
                               [int, [n]]],
[ [equalC, w, dvector(0, n-1)],
  [declarem, int, [i,j]],
  [declarem, double, [tmp, `*w`, `*dvector()`]],
  [declarem, void, [free_dvector()]],
  [commentC, ` resolution de Mw = b `],
  [equalC, w[1], b[1]/M[1,1]],
  [form, &=(i,1), i<=n-1, &=(i,i+1),
       [[&=(tmp, 0)],
        [form, &=(j,0), j<=i-1, &=(j,j+1),
             [equalC, tmp, tmp+M[i+1,j+1]*w[j+1]]
        ],
        [equalC, w[i+1], (1/M[i+1,i+1])*(b[i+1]-tmp)]
       ]
  ],
  [commentC, ` resolution de (Mt) X = w `],
  [equalC, X[n], w[n]/M[n,n]],
  [form, &=(i,n-2), i>=0, &=(i,i-1),
       [[equalC, tmp, 0],
        [`&=`(j, i+1)],
	[dowhilem, j<=n-1,
                 [[&=(tmp, M[j+1,i+1]*X[j+1]+tmp)],
		  [&=(j,j+1)]]
        ],
        [equalC, X[i+1], (1/M[i+1,i+1])*(w[i+1]-tmp)]
       ]
   ],
   [callC, free_dvector, [w, 0, n-1]]
]],

[commentC, ``],
[commentC, ` Inversion de la matrice M apres decomposition `],
[functionm, void, inversion, [[double, [`**M`, `**res`]],
                              [int, [n]]],
[ [equalC, chol, dmatrix(0, n-1, 0, n-1)],
  [equalC, X, dvector(0, n-1)],
  [equalC, base_vect, dvector(0, n-1)],
  [callC, cholesky, [M, chol, n]],
  [declarem, double, [`**chol`, `*X`, `*base_vect`, 
                      `*dvector()`, `**dmatrix()`]],
  [declarem, int, [i, j]],
  [declarem, void, [free_dvector(), free_dmatrix()]],
  [form, &=(j, 0), j<=n-1, &=(j,j+1),
       [[form, &=(i, 0), i<=n-1, &=(i,i+1),
             [equalC, base_vect[i+1], 0]
        ],
       [equalC, base_vect[j+1], 1],
       [resolution(chol, X, base_vect, n)],
       [`&=`(i, 0)],
       [whilem, i<=n-1,
              [[equalC, res[i+1,j+1], X[i+1]],
	       [`&=`(i, i+1)]]
       ]]
   ],
   [free_dmatrix(chol, 0, n-1, 0, n-1)],
   [free_dvector(X, 0, n-1)],
   [free_dvector(base_vect, 0, n-1)]
]]:

# Declarations
l3 :=
[commentC, ``], 
[typedefC, int, integer],

[commentC, ``],
[typedefC, [structC, personnel_record,
               [[char, [firt_name[21]]],
                [char, [last_name[26]]],
                [int, [age]],
                [char, [hobby[21]]],
                [float, [income]]
               ]], PERSON],

[commentC, ``],
[typedefC, [unionC, numbers,
                [[char, [letter]],
                 [int, [number]],
                 [float, [dec_number]],
		 [double, [precise_number]]
                ]], NUMBER],

[commentC, ``],
[enumC, digits, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [dig1, dig2, dig3]] :

# Exits and labels
l4 := 
[commentC, ``],
[labelm, toto,
       [[returnC, exp(-I*Pi/4)],
        [breakC],
        [continueC]
       ]],

[commentC, ``],
[gotoC, toto]:
 
# Conditionnal structures and Input - Output
l5 := 
[commentC, ``],
[fopenm, pointer, file, rw,
[
  [if_then_elsem, 'scanf'(string(`%c`), string(`&c`)) <> `EOF`, 
                [callC, `printf `, [string(`not end of file`)]],
                [[callC, `printf `, [string(`end of file`)]],
                 [returnC, `EOF`]]
  ],
  [commentC, ``],
  [switchm, letter, [[caseC, `a`, [callC, `printf `, [string(`a`)]]],
                     [caseC, `A`, [[callC, `printf `, [string(`A`)]],
                                  [callC, `printf `, [string(`Uppercase`)]]]],
                     [defaultC, [callC, `printf `, [string(`Other letter`)]]]]
  ]
]]:

# optimized option and matrixm (matrices with options)
mat := array(1..2, 1..2, [[x^3, x+a^4],[a^2, x^2+a*x]]):
mat2 := array(1..3,1..3, sparse, [(1,1)=x^4, (2,2)=x^2,(2,1)=x]):
mat3 := array(1..3,1..3,identity):
l6 := 
[commentC, ``],
[functionm, void, `matrices`, [],
[ [matrixm, toto, op(mat)],
  [commentC, ``],
  [matrixm, toto, op(mat2)],
  [commentC, ``],
  [matrixm, toto, mat3],
  [callC, matrices, []]
]]
:

genC(4, [l1, l2, l3, l4, l5, l6], filename=`macroC.c`);
end:

test():
init_genC():

!cat macroC.c
#quit
