#
## <SHAREFILE=linalg/class/class.mpl >
## <DESCRIBE>
##                Rational canonical form for a matrix of rational numbers.
##                Includes a utility routine HyperCompanion for constructing
##                the hyper companion matrix of a univariate polynomial
##                AUTHOR: Eugene Johnson, ejohnson@umaxc.weeg.uiowa.edu
## </DESCRIBE>

# HyperCompanion-generates hyper-companion
# matrix of a power of a polynomial or companion matrix of a polynomial 
# 9/1/91  EWJ
# Used in classical to compute rational/classical canonical
# form of a rational matrix
#
HyperCompanion:=proc(p,e,x) local d,i,H;
if not type(e,posint) then ERROR(`2nd argument must be a positive integer`) fi;
if not type(x,name) then ERROR(`3rd argument must be a name`) fi;
if not type(p,polynom(anything,x)) then ERROR(`1st argument must be a polynomial in `,x) fi;
d:=degree(p,x);
H:=linalg[companion](p,x);
if e>1 then H:=linalg[diag](H$e) fi;
for i from d+1 by d to e*d do H[i,i-1]:=1 od;
op(H)
end:  


macro(factors=readlib(factors)):
# classical(A);
# E. Johnson  9/1/91
# Requires access to HyperCompanion
#
classical:=proc(M,PP) local i,C,S,L,P,Q,x,MM;
options  `copyright EWJ`;
if not type(M,'matrix') then MM:=evalm(M) else MM:=M fi;
if not type(MM,'matrix(rational,square)') then 
ERROR(`classical is implemented only for square rational matrices at this time`) fi;
L:=NULL;
S:=linalg[smith](x-MM,x);
#compute the elementary divisors
for i to linalg[rowdim](MM) do if S[i,i]<>1 then L:=L,op(factors(S[i,i])[2]) fi od;
#compute the classical form
C:=linalg[diag](seq(HyperCompanion(op(i),x),i=[L]));
#Use frobenius to compute the transition matrix if indicated
if nargs>1 then linalg[frobenius](C,P); linalg[frobenius](MM,Q); PP:=evalm(Q&*(1/P)) fi;
op(C);
end:


class := `See ?classical and ?HyperCompanion`:
#save `class.m`;
#quit
