## <SHAREFILE=science/pof/pof.mpl >
## <DESCRIBE>
##               (physical chemistry - nuclear magnetic resonance)
##               This package of procedures implements the product operator
##               formalism approach for calculation and vizualization of the
##               effect of an NMR pulse sequence. The implementation is written
##               for weakly-coupled systems with nuclear spin of 1/2.
## SEE ALSO: science/pof/COSY.mws, science/pof/JRes.mws, science/pof/nQF.mws,
##           science/oneD.mws
## </DESCRIBE>

pof:=`pof `:
#
# This package of procedures implements the product operator
# formalism approach for calculation and vizualization of the
# effect of an NMR pulse sequence. The implementation is written
# for weakly-coupled systems with nuclear spin of 1/2.
# Copyright (1994) Rene P.F. Kanters, KANTERS@urvax.urich.edu
#

macro(monopoly=`pof/monopoly`):
macro(t_evo=`pof/t_evo`):
macro(pof_norm=`pof/pof_norm`):
macro(SQjump=`pof/SQjump`):
macro(preQF=`pof/preQF`):
macro(doQF=`pof/doQF`):
macro(CFT=`pof/CFT`):
macro(MonCFT=`pof/MonCFT`):
macro(Cos_FT=`pof/Cos_FT`):
macro(MonCosFT=`pof/MonCosFT`):
macro(combi=`pof/combi`):
macro(MonoPreFT=`pof/MonoPreFT`):
macro(do_ph_cor=`pof/do_ph_cor`):
macro(getW=`pof/getW`):
macro(plotsub=`pof/plotsub`):
macro(monosuper=`pof/monosuper`):

monopoly:=proc() local i; 
if type(args[2],`+`) then map(args[1],seq(args[i],i=2..nargs));
else args[1](seq(args[i],i=2..nargs)); fi;
end:

nmrsubs:=proc() local i; cleanup(subs(seq(args[i],i=1..nargs))) end:

spinsystem:=proc(s) local i,j,k,l,m,n;
global J,T,W;
if not type(s,list) then ERROR(`argument should be a list`); fi;
J:=table(symmetric); W:='W';
T:=map(proc(s) if type(s,list) then op(s);else s;fi;end,s);
for i in s do
  if type(i,list) then
    for j to nops(i) do for k to j-1 do J[i[k],i[j]]:=0; od; od;
    m:=i[1]; l:=subsop(1=NULL,i); member(m,T,'n');
    for j in l do W[j]:=W[m]; od;
    for j in l do
      for k to n-1 do J[T[k],j]:=J[T[k],m]; od;
      for k from n+nops(l)+1 to nops(T) do J[j,T[k]]:=J[m,T[k]]; od;
    od;
  fi;
od;
convert(map(proc(s) Iz[s];end,T),`+`);
end:
 
xpulse:=proc(s,k,b) local i;
seq(Iy[k[i]]=Iy[k[i]]*cos(b)+Iz[k[i]]*sin(b),i=1..nops(k));
seq(Iz[k[i]]=Iz[k[i]]*cos(b)-Iy[k[i]]*sin(b),i=1..nops(k));
subs({",""},s);
end:
 
ypulse:=proc(s,k,b) local i;
seq(Ix[k[i]]=Ix[k[i]]*cos(b)-Iz[k[i]]*sin(b),i=1..nops(k));
seq(Iz[k[i]]=Iz[k[i]]*cos(b)+Ix[k[i]]*sin(b),i=1..nops(k));
subs({",""},s);
end:
 
zpulse:=proc(s,k,b) local i;
seq(Ix[k[i]]=Ix[k[i]]*cos(b)+Iy[k[i]]*sin(b),i=1..nops(k));
seq(Iy[k[i]]=Iy[k[i]]*cos(b)-Ix[k[i]]*sin(b),i=1..nops(k));
subs({",""},s);
end:
 
pulse:=proc(s,p,a,b) local k;
if nops(p)=0 then k:=T; else k:=p; fi;
if type(a,list) then
  if nops(a)<>2 then ERROR(`tilted rf pulse needs [theta,phi]`); fi;
  zpulse(s,k,-a[2]);
  ypulse(",k,Pi/2-a[1]);
  xpulse(",k,b);
  ypulse(",k,a[1]-Pi/2);
  zpulse(",k,a[2]);
else
  zpulse(s,k,-a);
  xpulse(",k,b);
  zpulse(",k,a);
fi;
cleanup(");
end:
  
shift:=proc(s,p,t) local i,n,C,S,a;
if nops(p)=0 then n:=s;
  for i in T do a:=2*Pi*W[i]*t; S:=Sin(a); C:=Cos(a);
    n:=subs({Ix[i]=Ix[i]*C+Iy[i]*S,Iy[i]=Iy[i]*C-Ix[i]*S},n);
  od;
else n:=0;
  for i in p do a:=2*Pi*W[i]*t; S:=Sin(a); C:=Cos(a);
    n:=n+coeff(s,Ix[i])*(Ix[i]*C+Iy[i]*S)+coeff(s,Iy[i])*(Iy[i]*C-Ix[i]*S);
  od;
fi;
cleanup(n);
end:
 
couple:=proc(s,t) local i,j,n,a,C,S,k,l;
n:=s;
for i to nops(T) do l:=T[i];
  for j to i-1 do k:=T[j];
    if J[k,l]<>0 then a:=Pi*J[k,l]*t; S:=Sin(a); C:=Cos(a);
      Ix[k]=Ix[k]*C+2*Iy[k]*Iz[l]*S, Iy[k]=Iy[k]*C-2*Ix[k]*Iz[l]*S;
      Ix[l]=Ix[l]*C+2*Iy[l]*Iz[k]*S, Iy[l]=Iy[l]*C-2*Ix[l]*Iz[k]*S;
      n:=subs({",""},n);
    fi;
  od;
od;
cleanup(n);
end:
 
evolve:=proc(s,p,t) couple(shift(s,p,t),t); end:
 
t_evo:=proc(s) local i,t;
t:=false;
if not type(s,`*`) then RETURN(t_evo(2*s)/2); fi;
for i in s do
  if type(i,`^`) then i:=op(1,i);
    if type(i,indexed) and (op(0,i)=`Ix` or op(0,i)=`Iy`) then RETURN(0); fi; 
  elif type(i,indexed) then
    if op(0,i)<>`Iz` then
      if t and (op(0,i)=`Ix` or op(0,i)=`Iy`) then RETURN(0); else t:=true; fi;
    fi;
  fi;
od;
if t then s; else 0; fi;
end:

#observe by quadrature detection
observe:=proc(s,k,t,p) local i,s1,s2,s3;
s1:=seq(Ix[T[i]]=cos(p)-I*sin(p),i=1..nops(T));
s2:=seq(Iy[T[i]]=sin(p)+I*cos(p),i=1..nops(T));
s3:=seq(Iz[T[i]]=0,i=1..nops(T));
subs(s1,s2,s3,evolve(monopoly(t_evo,s),k,t))/2;
end:

cleanup:=proc(s) monopoly(pof_norm,expand(s)); end:

pof_norm:=proc(s) local n,i,j,r,c,p,f,a,b;
  c:=false; r:=1;
  if type(s,`*`) then n:=convert(s,list); else n:=[s]; fi;
  for i to nops(n) do
    if type(n[i],function) then
      a:=op(n[i]);
      if op(0,n[i])=`Sin` then
        if type(a,constant) then r:=r*sin(a);
        else f:=false; j:=i+1;
          while not f and j<=nops(n) do
            if type(n[j],function) and indets(a)=indets(op(n[j])) then
	      b:=op(n[j]);
              if op(0,n[j])=`Sin` then f:=true; n:=subsop(j=1,n);
                if sign(evalf(a-b))=1 then r:=r*(Cos(a-b)-Cos(a+b))/2;
                else r:=r*(Cos(b-a)-Cos(a+b))/2; fi;
              elif op(0,n[j])=`Cos` then f:=true; n:=subsop(j=1,n);
                if sign(evalf(a-b))=1 then r:=r*(Sin(a+b)+Sin(a-b))/2;
                else r:=r*(Sin(a+b)-Sin(b-a))/2; fi;
              fi;
            fi; j:=j+1;
          od;
          if f then c:=true; else r:=r*n[i]; fi;
        fi;
      elif op(0,n[i])=`Cos` then
        if type(a,constant) then r:=r*cos(a);
        else f:=false; j:=i+1;
          while not f and j<=nops(n) do
            if type(n[j],function) and indets(a)=indets(op(n[j])) then
	      b:=op(n[j]);
              if op(0,n[j])=`Cos` then f:=true; n:=subsop(j=1,n);
                if sign(evalf(a-b))=1 then r:=r*(Cos(a+b)+Cos(a-b))/2;
                else r:=r*(Cos(a+b)+Cos(b-a))/2; fi;
              elif op(0,n[j])=`Sin` then f:=true; n:=subsop(j=1,n);
                if sign(evalf(a-b))=1 then r:=r*(Sin(a+b)-Sin(a-b))/2;
                else r:=r*(Sin(b+a)+Sin(b-a))/2; fi;
              fi;
            fi; j:=j+1;
          od;
          if f then c:=true; else r:=r*n[i]; fi;
        fi;
      else r:=r*n[i]; fi;	# added else because of exp(...)  
    elif type(n[i],`^`) then
      a:=op(1,n[i]); p:=op(2,n[i]);
      if type(a,function) then
        if op(0,a)=`Sin` then
          r:=r*((1-Cos(2*op(a)))/2)^iquo(p,2)*a^irem(p,2); c:=true;
        elif op(0,a)=`Cos` then
          r:=r*((1+Cos(2*op(a)))/2)^iquo(p,2)*a^irem(p,2); c:=true;
        else r:=r*n[i]; fi;
      elif type(a,indexed) and op(0,a)=`Iz` then
	r:=r*(1/4)^iquo(p,2)*a^irem(p,2);
      else r:=r*n[i]; fi;
    else r:=r*n[i]; fi;
  od;
  if c then RETURN(monopoly(pof_norm,expand(r))); else RETURN(r); fi;
end:

pm_xy:=proc(s) local i;
seq(Ip[T[i]]=Ix[T[i]]+I*Iy[T[i]],i=1..nops(T));
seq(Im[T[i]]=Ix[T[i]]-I*Iy[T[i]],i=1..nops(T));
expand(subs(","",s));
end:
 
xy_pm:=proc(s) local i;
seq(Ix[T[i]]=(Ip[T[i]]+Im[T[i]])/2,i=1..nops(T));
seq(Iy[T[i]]=I*(Im[T[i]]-Ip[T[i]])/2,i=1..nops(T));
expand(subs(","",s));
end:
 
QC:=proc(s) local qc,i,p;
if(s=0) then RETURN(0); fi;qc:=0;
if not type(s,`*`) then RETURN(QC(2*s)); fi;
for i in s do
  if type(i,`^`) then p:=op(2,i); i:=op(1,i); else p:=1; fi;
  if type(i,indexed) then
    if op(0,i)=`Ip` then qc:=qc+p;
    elif op(0,i)=`Im` then qc:=qc-p;
    fi;
  fi;
od;
RETURN(qc);
end:
 
QCset:=proc(s) map(QC,convert(xy_pm(s),set)); end:
 
SQjump:=proc(s,k,a,b,p,n) local new,i,qc,ns;
qc:=QC(s); new:=0;
ns:=xy_pm(pulse(pm_xy(s),k,a,b));
for i in ns do if modp(QC(i)-qc,n)=p then new:=new+i; fi; od;
expand(evalc(pm_xy(new)));
end:
 
QFpulse:=proc(s,k,a,b,p,n) monopoly(SQjump,xy_pm(s),k,a,b,p,n); end:
 
preQF:=proc(s,q) local i,t,p;
t:=0;
if not type(s,`*`) then RETURN(preQF(2*s,q)/2); fi;
for i in s do
  if type(i,`^`) then p:=op(2,i); i:=op(1,i); else p:=1; fi;
  if type(i,indexed) and (op(0,i)=`Ix` or op(0,i)=`Iy`) then t:=t+p; fi;
od;
p:=abs(q);
if t>=p and irem(p,2)=irem(t,2) then s; else 0; fi;
end:

doQF:=proc(s,q) local r;
if iquo(QC(s),q,`r`)<>0 and r=0 then s; else 0; fi;
end:
 
QF:=proc(s,q)
xy_pm(monopoly(preQF,s,q));
monopoly(doQF,",q);
expand(evalc(pm_xy(")));
end:

CFT:=proc(s,t) local c;
if type(s,function) and has(op(1,s),t) then c:=expand(coeff(op(s),t)/(2*Pi));
  if op(0,s)=`Cos` then 
    if has(c,`W`) then (Ab(c,t)+I*Di(c,t))/2; 
    else (Ab(c,t)+Ab(-c,t)+I*Di(c,t)+I*Di(-c,t))/2; fi;
  elif op(0,s)=`Sin` then
    if has(c,`W`) then (Di(c,t)-I*Ab(c,t))/2;
    else (Di(c,t)-Di(-c,t)-I*Ab(c,t)+I*Ab(-c,t))/2; fi;
  fi;
else s; fi;
end:
 
MonCFT:=proc(s,t) local i,n;
if not has(s,t) then RETURN(s*Ab(0,t)); fi;
if type(s,`*`) then map(CFT,s,t); else CFT(s,t); fi;
end:

# real or cosine transform, only positive chemical shifts, for TPPI
Cos_FT:=proc(s,t) local c;
if type(s,function) and has(op(1,s),t) then c:=expand(coeff(op(s),t)/(2*Pi));
  if op(0,s)=`Cos` then 
    if has(c,`W`) then Ab(c,t)/2; 
    else (Ab(c,t)+Ab(-c,t))/2; fi;
  elif op(0,s)=`Sin` then
    if has(c,`W`) then Di(c,t)/2;
    else (Di(c,t)-Di(-c,t))/2; fi;
  fi;
else s; fi;
end:
 
MonCosFT:=proc(s,t) local i,n;
if not has(s,t) then RETURN(s*Ab(0,t)); fi;
if type(s,`*`) then map(Cos_FT,s,t); else Cos_FT(s,t); fi;
end:

combi:=proc(a,b,t) local c,v,i,s,d;
if type(a,`*`) then c:=1; v:=1;
  for i in a do if not has(i,t) then c:=c*i; else v:=v*i; fi; od;
  RETURN(c*combi(v,b,t));
fi;
if has(b,`W`) then RETURN(combi(b,a,t)); fi;
if not type(a,function) or not type(b,function) then RETURN(a*b); fi;
s:=op(a)+op(b); d:=op(a)-op(b);
if op(0,a)=`Sin` then
  if op(0,b)=`Sin` then Cos(d)/2-Cos(s)/2;
  elif op(0,b)=`Cos` then Sin(s)/2+Sin(d)/2; fi;
elif op(0,a)=`Cos` then
  if op(0,b)=`Sin` then Sin(s)/2-Sin(d)/2;
  elif op(0,b)=`Cos` then Cos(s)/2+Cos(d)/2; fi;
else a*b; fi;
end:
 
MonoPreFT:=proc(s,t) local i,combining,c,k;
if not type(s,`*`) then RETURN(s); fi;
k:=1;c:=1; combining:=false;
for i in s do
  if has(i,t) then
    if combining then c:=monopoly(combi,c,i,t);
    else c:=i; combining:=true; fi;
  else k:=k*i; fi;
od; expand(k*c);
end:
 
do_ph_cor:=proc(s,p,t) local n,i,k;
if type(s,`*`) then n:=convert(s,list); else n:=[s]; fi;
for i to nops(n) do k:=n[i];
  if type(k,function) and has(op(1,k),t) then
    if op(0,k)=`Sin` then n:=subsop(i=cos(p)*k+sin(p)*Cos(op(k)),n);
    elif op(0,k)=`Cos` then n:=subsop(i=cos(p)*k-sin(p)*Sin(op(k)),n); fi;
  fi;
od; convert(n,`*`);
end:
 
FT:=proc(s,p,t,v) 
monopoly(MonoPreFT,s,t);
expand(monopoly(do_ph_cor,",p,t));
expand(monopoly(MonCFT,",t));
subs(t=v,");
end:

CosFT:=proc(s,p,t,v) 
monopoly(MonoPreFT,s,t);
expand(monopoly(do_ph_cor,",p,t));
expand(monopoly(MonCosFT,",t));
subs(t=v,");
end:

getW:=proc(s) local i;
if type(s,indexed) and op(0,s)=`W` then RETURN(op(s)); fi;
for i in op(s) do if type(i,indexed) and op(0,i)=`W` then RETURN(op(i)); fi;
od;
RETURN(0);
end:
 
pA:=proc(v0,v,T2) 2*T2/(1+(2*Pi*T2*(v0-v))^2); end:
 
pD:=proc(v0,v,T2) 4*Pi*T2^2*(v0-v)/(1+(2*Pi*T2*(v0-v))^2); end:
 
plotsub:=proc(s) local n,i;
n:=evalc(Re(s));
if type(s,`*`) then n:=convert(n,list); else n:=[n]; fi;
for i in n do
  if type(i,function) and (op(0,i)=`Ab` or op(0,i)=`Di`) then
    n:=subs(i=op(0,i)(op(1,i),op(2,i),T2[getW(op(1,i))]),n);
  fi;
od;
convert(subs(Ab=pA,Di=pD,W=Wv,J=Jv,Cos=cos,Sin=sin,n),`*`);
end:
 
nmrplot:=proc() local n,i;
n:=args[1];
if type(n,`set`) then n:={seq(monopoly(plotsub,op(i,n)),i=1..nops(n))};
else n:=monopoly(plotsub,n); fi; 
plot(eval(n),seq(args[i],i=2..nargs));
end:
 
nmrplot2d:=proc() local n,i;
n:=args[1];
if type(n,`set`) then n:={seq(monopoly(plotsub,op(i,n)),i=1..nops(n))};
else n:=monopoly(plotsub,n); fi; 
# Must eval n here
plot3d(eval(n),args[2..nargs]);
end:

with(plots,display3d):
crit_A:=1:
crit_D:=10:

super2d:=proc() local i;
if type(args[1],`+`) then convert(args[1],set); else {args[1]}; fi;
display3d(map(monosuper,",seq(args[i],i=2..nargs)));
end:

monosuper:=proc() local i,s,r1,r2,w,t,v,d;
if type(args[1],`*`) then s:=convert(args[1],list); else s:=[args[1]]; fi;
for i in s do
  if type(i,function) and (op(0,i)=`Ab` or op(0,i)=`Di`) then
    w:=T2[getW(op(1,i))]; v:=op(1,i): t:=op(2,i);
	if op(0,i)=`Ab` then d:=crit_A/w; else d:=crit_D/w; fi;
    if t=args[2] then r1:=t=v-d..v+d;
    elif t=args[3] then r2:=t=v-d..v+d; fi;
    s:=subs(i=op(0,i)(v,t,w),s);
  fi;
od;
r1:=eval(subs(W=Wv,J=Jv,r1)); r2:=eval(subs(W=Wv,J=Jv,r2));
convert(subs(Ab=pA,Di=pD,W=Wv,J=Jv,Cos=cos,Sin=sin,s),`*`);
plot3d(",r1,r2,seq(args[i],i=4..nargs));
end:

# print(`POF-NMR procedures saved in file pof.m`);

#save `pof.m`:
#quit
