#
## <SHAREFILE=system/reorder/reorder.mpl >
## <DESCRIBE>
##              Utility routine to reorder the order in which two or more sums,
##              limits, or integrals appear in an expression.
##              Vincent Broman, broman@nosc.mil
## </DESCRIBE>

reorder := proc( form, ind1, ind2)
#
# restructures form by interchanging the order in which two
# sums, limits, or integrals are performed.
# the sums affected are those whose controlling variable is ind1 or ind2.
#
   local ind, innerind, summand, insum, rest;
   
   if nargs > 3 or nops( {ind1, ind2, FAIL}) < 3 then
      ERROR( `illegal arguments`)
   fi;
   if type( form, {numeric, string}) then
      RETURN( form)        # bottom of recursion
   fi;
   ind := `reorder/indexof`( form);
   if ind = ind1 or ind = ind2 then
      # form is the outermost sum of the sums of interest
      if ind = ind1 then
	 innerind := ind2
      else
	 innerind := ind1
      fi;
      if not has( op( 2, form), innerind) then
	 summand := op( 1, form);
	 # split up summand = insum * rest
	 if type( summand, `*`) then
	    insum := map( proc( x, var) if has( x, var) then x else 1 fi end,
		      	  summand,
		      	  innerind);
      	    rest := map( proc( x, var) if has( x, var) then 1 else x fi end,
		      	 summand,
		      	 innerind);
      	 else
	    insum := summand;
	    rest := 1;
	 fi;
	 # if exactly one factor of summand contains references to innerind
	 # then insum will be that factor.
	 # if insum is 1 or a product it will fail the following test.
	 if `reorder/indexof`( insum) = innerind and
	    not has( op( 2, insum), ind)
	 then
	    RETURN( subsop( 1=subsop( 1=rest*op( 1, insum), form), insum))
	 fi;
      fi;
   fi;
   map( procname, args)
end:

`reorder/indexof` := proc( form)
#
# returns the index variable of a sum,
# the variable of integration of an integral,
# or the controlling variable of a limit expression,
# IF  form  actually is a sum/integral/limit expression,
# otherwise returns  FAIL.
#
   local ind;
   
   if type( form, function) and
      member( op( 0, form), {sum, Sum, int, Int, limit, Limit})
   then
      ind := op( 2, form);
      if type( ind, `=`) then  ind := op( 1, ind)  fi;
      ind
   else
      `FAIL`
   fi
end:


#save `reorder.m`;
#quit
