#
## <SHAREFILE=analysis/pdetools/pdetools.mpl >
## <DESCRIBE>
##       A package for solving PDE's
##                REFERENCE: A Computational Strategy for the Analytical
##                Solving of Partial Differential Equations.
##                Computer Physics Communications (1994)
##                AUTHOR: E.S.Cheb-Terrab, terrab@cbpfsu1.cat.cbpf.br
##                AUTHOR: Katherina von Bulow, TERRAB@BRUERJ.BITNET
## </DESCRIBE>
## <UPDATE=R4 >

pdetools:=`pdetools `:
macro( TABLEREF = 6,
       FUNCTION = 13 );

#####################################################################
# Date: April/15/95. Version: 1.0
#
# Authors: E.S.Cheb-Terrab and Katherina von Bulow
#          Departamento de Fisica Teorica
#          Instituto de Fisica
#          Universidade do Estado do Rio de Janeiro, Brasil.
#          E-mail: TERRAB@BRUERJ.BITNET
#
# Title:   The PDEtools package
#
# ref.:    A Computational Strategy for the Analytical Solving of Partial
#          Differential Equations Comp.Phys.Comm (1994)
#
#####################################################################
# The package below can be loaded into a Maple session by giving
# the instruction:
#
# > read `pdetools.txt`;
#
# at the Maple prompt ">", assuming that the contents of the package
# are in an ASCII file named "`pdetools.txt`".
#
# If you want to save the package in a library please contact us at the e-mail
# mentioned above
#####################################################################
#                            INDEX
#####################################################################
#	PDEtools commands and subroutines
########################
# dchange
# `dchange/funcs`
# `dchange/known`
# `dchange/unknown`
# `dchange/special`
# `dchange/Diff_aux`
# `dchange/sort`
# `dchange/info`
# `dchange/SingleSolve`
# `dchange/derivate`
# `dchange/multint`
# `dchange/multint/jaco`
# `dchange/multint/newrange`
########################
# jaco
# newrange
########################
# pdsolve
# `pdsolve/resinco`
# `pdsolve/res`
# `pdsolve/fixedfunc`
# `pdsolve/args`
# `pdsolve/info`
# `pdsolve/vars`
# `pdsolve/fhint`
# `pdsolve/Incomplete`
# `pdsolve/1diff`
# `pdsolve/mixed`
# `pdsolve/strip`
# `pdsolve/strip/aux`
# `pdsolve/INTEGRATE`
# `pdsolve/INTEGRATE/_C`
# `pdsolve/first_order`
# `pdsolve/second_order`
# `pdsolve/second_order/hyperbolic`
# `pdsolve/second_order/parabolic`
# `pdsolve/second_order/elliptic`
# `pdsolve/sep`
# `pdsolve/re_enter`
# `pdsolve/solve_c`
# `pdsolve/choose_c`
# `pdsolve/trap`
# `pdsolve/LHS_of_ode`
# `pdsolve/den`
# `pdsolve/rearrange`
# `pdsolve/rearrange/sort`
########################
# build
# strip
# splitstrip
# pdtest
########################
# PDEtools/routines (not specifically related to any command)
########################
# `pdsolve/Assigned`
# `PDEtools/print`
# `pdsolve/select`
# `pdsolve/expand/Int`
# `type/known`
# `type/unknown`
# `type/De`
# `type/Int`
# `type/int`
# `type/diff`
# `type/Diff`
# `type/sum`
# `type/Sum`
# `type/limit`
# `type/Limit`
# `type/product`
# `type/Product`
# `type/Function`
# `type/Numeric`
# `type/HINT`
########################
# 	From the Partials package, Comp.Phys.Comm 79 (1994)
########################
# odiff
# parameters
# usediff
# `usediff/subD`
# useD
# `useD/subdiff`
# Value
# `value/define`
# `Value/Sum`
# `Value/Normal`
# `Value/Product`
# `Value/Diff`
# `Value/Int`
# `Value/Limit`
# Has
# `Has/definite`
########################
#	On-Line Help
########################
# `help/text/PDEtools`
# `help/text/pdsolve`
# `help/text/pdtest`
# `help/text/strip`
# `help/text/splitstrip`
# `help/text/build`
# `help/text/dchange`
# `help/text/newrange`
########################
#	For building the library
########################
# `MAKELIB/reassign`
# MAKELIB
#####################################################################
# Auxiliary procedures from the Maple library

readlib('freeze'):
readlib('isolate'):
#####################################################################
# Special strings used by the commands

unprotect('HINT'):
unprotect('INTEGRATE'):
unprotect('known'):
unprotect('unknown'):
unprotect(`00`):
unprotect(_c):
unprotect(_s):
unprotect(_p):
unprotect(_xi):
HINT:='HINT':
INTEGRATE:='INTEGRATE':
known:='known':
unknown:='unknown':
`00`:='`00`':
_c:='_c':
_s:='_s':
_p:='_p':
_xi:='_xi':
protect('HINT'):
protect('INTEGRATE'):
protect('known'):
protect('unknown'):
protect(`00`):
protect(_c):
protect(_s):
protect(_p):
protect(_xi):
interface(labelling='false'):
#####################################################################
#                         dchange command
#####################################################################
# Cases:
#
#   - explicit transformation.
#   - abstract1 transformations x=X(xi,eta), t=T(xi,eta)
#   - abstract2 transformations x=X(xi+eta), t=T(xi-eta)
#   - mix of explicit and any kind of abstract transformation
#
#   - known function Ex: sin(t) -> sin(x/y) # Exactly f(t(new))
#   - unknown function Ex: f(t) -> f(x,y)   # f(new contained in t)
#   - special rules for composite functions containing outer or inner unknown.
#      - by default, different behavior between known and unknown functions.
#      - user option defining a function as 'known' or 'unknown'
#
# ATTENTION:
#
#   * Special care with the transformation variable being an index of a
#		function-procedure
#   * dchange/userfunction to indicate any special transf rule (in
#		preparation)
#####################################################################
dchange := proc()
local a1,funcs,res,INFO;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    if not assigned(_Envworking) then
        INFO := `dchange/info`(args);
        a1 := INFO[1];
        _Env_tr := INFO[2];
        _Env_itr := INFO[3];
        _Env_newl := INFO[4];
        _Env_known := INFO[5];
        _Env_unknown := INFO[6];
        if nops(INFO) = 6 then _Env_simp := NULL
        else _Env_simp := INFO[7]
        fi;
        _Env_old := map(lhs,_Env_tr);
        _Env_new := {op(_Env_newl)};
        _Envworking := 1;
        proc(u)
            rhs(u) = lhs(u),1/rhs(u) = 1/lhs(u);
            if hastype(u,`^`) then
                ",rhs(u)^2 = lhs(u)^2,1/rhs(u)^2 = 1/lhs(u)^2
            fi
        end;
        _Env_subs := map(",_Env_itr),_Env_tr
    else _Envworking := _Envworking+1; a1 := args[1]
    fi;
    if not has(eval(a1),_Env_old) or _Env_tr = {} then RETURN(a1)
    elif type(a1,{set,`=`,`..`,list}) then RETURN(map(dchange,a1))
    elif type(a1,'procedure') then
        readlib('procbody');
        if has(indets(procbody(a1),'string') minus {op(1,eval(a1))},_Env_old)
             then
            indets(procbody(a1),indexed);
            if nops(") = 1 then op(op(op(`pdsolve/select`(",`&args`))))
            else
                max(
                   op(map(k -> op(op(op(`pdsolve/select`(k,`&args`,`+`)))),"))
                   )
            fi;
            if nops([op(1,eval(a1))]) < " then
                ERROR(`arguments of procedure`,a1,
                    `must have explicit names; not "args[`.".`]"`)
            elif has([op(1,eval(a1))],_Env_new) then
                ERROR(`: Procedure`,a1,`expect arguments named`,
                   [op(1,eval(a1))],
                   `and these names coincide with those of the new variables`,
                   _Env_newl,
                   `Try changing the name of the expected arguments of`,a1)
            fi;
            res := dchange(eval(a1(op(1,eval(a1))(op(_Env_old)))));
            [op(1,eval(a1))];
            zip((k,l) -> k = l,[op(")(op(_Env_old))],");
            subs(op(_Env_old) = op(_Env_newl),");
            res := unapply(subs(","",res),op(1,eval(a1)));
            RETURN(eval("))
        else RETURN(a1)
        fi
    fi;
    funcs := select(has,indets(a1,'function'),_Env_old);
    map(proc(f,funcs)
        options operator,arrow;
            if not has(funcs minus {f},f) then f = `dchange/funcs`(f) fi
        end                                                             ,
        funcs,funcs);
    a1 := subs(",a1);
    select(has,indets(a1,'function'),_Env_old);
    if " <> {} then map(f -> f = `dchange/funcs`(f),"); a1 := subs(",a1) fi;
    if has(a1,_Env_old) then a1 := subs(_Env_subs,a1) fi;
    if _Env_simp <> NULL then _Env_simp(a1) else a1 fi
end:
#####################################################################
`dchange/funcs` :=  # RETURNS dchange(f,..)
proc(f::function)
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    if member(op(0,f),{
     'Diff','diff','Int','int','Sum','sum','Limit','limit','product','Product'
     }) then
        `dchange/special`(f)
    elif type(f,'De') then
        if member('D',_Env_unknown) then
            subs(_Env_subs,op(0,f))(
                `dchange/unknown`([op(f)],_Env_tr,_Env_itr,_Env_newl))
        elif member('D',_Env_known) then
            subs(_Env_subs,op(0,f))(
                `dchange/known`([op(f)],_Env_tr,_Env_itr,_Env_newl))
        else
            usediff(f);
            if type(",'diff') then `dchange/special`(")
            else
                subs(_Env_subs,op(0,f))(
                    `dchange/known`([op(f)],_Env_tr,_Env_itr,_Env_newl))
            fi
        fi
    elif not member(op(0,f),_Env_known) and
        (type(f,'unknown') or member(op(0,f),_Env_unknown)) then
        subs(_Env_subs,op(0,f))(
            `dchange/unknown`([op(f)],_Env_tr,_Env_itr,_Env_newl))
    else
        subs(_Env_subs,op(0,f))(
            `dchange/known`([op(f)],_Env_tr,_Env_itr,_Env_newl))
    fi
end:
#####################################################################
`dchange/known` :=       # RETURNS a sequence
proc(L::list)
local res,i;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    res := NULL;
    for i in L do
        if type(i,'function') then res := res,`dchange/funcs`(i); next
        else
            indets(i,'function');
            if " <> {} and has(",_Env_old) then
                map(proc(f,sf)
                    options operator,arrow;
                        if not has(sf minus {f},f) then f fi
                    end                                     ,",");
                map(f -> f = `dchange/funcs`(f),");
                subs(",i)
            else i
            fi
        fi;
        res := res,subs(_Env_subs,")
    od;
    if not hastype(L,'function') then `dchange/known`(args) := res fi;
    res
end:
#####################################################################
`dchange/unknown` :=           # RETURNS a sequence
proc(L::list)
local L_f_unknown,L_other,L_params,k,res;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    L_f_unknown := [];
    L_params := map(
        proc(x,X) options operator,arrow; if not has(x,X) then x fi end,L,
        _Env_old union _Env_new);
    L_other := subs(map(u -> u = NULL,L_params),L);
    for k in L_other do
        if member(k,_Env_new) or hastype(k,'unknown') then
            L_f_unknown := [op(L_f_unknown),dchange(k)];
            L_other := subs(k = NULL,L_other)
        else L_other := subs(k = frontend(expand,[dchange(k)]),L_other)
        fi
    od;
    if L_other <> [] then
        [op(map(proc(x,A,B)
                options operator,arrow;
                    if Has(A,x) and not Has(B,x) then x fi
                end                                       ,
            indets(L_other,'name') minus (_Env_old union _Env_new),L_other,
            L_params))];
        L_params := [op(L_params),op(`dchange/sort`(",L))];
        L_other := indets(L_other) intersect _Env_new
    else L_other := {}
    fi;
    L_other minus {op(L_f_unknown)};
    `dchange/sort`([op(")],_Env_newl);
    res := op(L_params),op("),op(L_f_unknown);
    if not hastype(L,'function') then `dchange/unknown`(args) := res fi;
    res
end:
#####################################################################
`dchange/sort` :=  	# RETURNS a list with the elements of
proc(l1,l2)
local res,i;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    res := NULL;
    for i in l2 do  if member(i,l1) then res := res,i fi od;
    {op(l1)} minus {res};
    res := [res,op(")]
end:
#####################################################################
`dchange/special` :=   # RETURNS dchange(a)
proc(a)
local pr,f,var,res,i,new_var,new_idx,new_ratio,pole,lim,direc;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    if not assigned(_Envworking2) then
        _Envworking2 := 1;
        if has(a,'Diff') then
            res := (eval @ subs)('Diff' = `dchange/Diff_aux`,a)
        else res := a
        fi
    else res := a
    fi;
    pr := traperror(op(0,res));
    f := op(1,res);
    var := traperror(op(2,res));
    if type(",`=`) then lhs(") else " fi;
    if has(f,_Env_old) then
        if type(f,'function') then
            if member(pr,{'Int','int'}) then
                if has(f,{'Int','int'}) then f := combine(f) fi;
                if member(op(0,f),{'Int','int'}) and map(member,map(
                    proc(u)
                    options operator,arrow;
                        if type(u,`=`) then lhs(u) else u fi
                    end                                     ,{var,op(2,f)}),
                    _Env_old) = {'true'} then
                    map(proc(x,expr)
                        options operator,arrow;
                            if has(expr,x) then x fi
                        end                         ,map(lhs,_Env_tr),res);
                    map(q -> nops(
                       indets(select(has,_Env_tr,q),'name') intersect _Env_new
                       ),");
                    if " <> {1} then RETURN(`dchange/multint`(f,var,pr)) fi
                fi
            fi;
            `dchange/funcs`(f)
        else dchange(f)
        fi;
        if has(",_Env_old) then
            ERROR(`Unable to remove the old variables`,_Env_old,`from `,f)
        else f := "
        fi
    fi;
    if not has(var,_Env_old) then RETURN(pr(f,var))
    elif type(var,`=`) and not has(lhs(var),_Env_old) then
        if type(rhs(var),`..`) then
            lhs(var) = map(proc(u)
                           options operator,arrow;
                               if has(u,_Env_old) then dchange(u) else u fi
                           end                                             ,
                rhs(var))
        elif has(rhs(var),_Env_old) then lhs(var) = dchange(rhs(var))
        fi;
        if has(",_Env_old) then
            ERROR(`Unable to remove the old variables`,_Env_old,`from `,var)
        else var := "
        fi;
        RETURN(pr(f,var))
    fi;
    if member(pr,{'Diff','diff'}) then
        if _Env_itr <> {} then
            res := 0;
            for i in _Env_newl do
                res := res+pr(f,i)*diff(rhs(op(1,select(has,_Env_itr,i))),var)
            od;
            if has(res,a) then subs(_Env_subs,useD(a)) fi;
            if has(res,_Env_old) then
                if type(res,'function') then `dchange/funcs`(res)
                else dchange(res)
                fi
            fi;
            if has(",_Env_old) then
                ERROR(
                    `Unable to remove the old variables`,_Env_old,`from `,res)
            else res := "
            fi
        else `dchange/derivate`(var,pr,_Env_tr,_Env_newl)(f)
        fi;
        if has(",{'cos','sin','tan'}) then RETURN(simplify(",'trig'))
        else RETURN(")
        fi
    elif
      member(pr,{'Int','int','Sum','sum','Limit','limit','product','Product'})
       then
        if nops(_Env_newl) = 1 then new_idx := op(_Env_newl)
        else
            if type(var,`=`) then lhs(var) else var fi;
            map(proc(eq,ox)
                options operator,arrow;
                    if lhs(eq) = ox then eq fi
                end                           ,_Env_tr,");
            new_idx := indets(map(rhs,")) intersect _Env_new;
            if nops(new_idx) = 1 then new_idx := op(1,new_idx)
            elif member(pr,{'Int','int'}) then
                RETURN(`dchange/multint`(f,var,pr))
            else
                ERROR(`Coupled multivariate changes of variables are not`.
                    `implemented for sums, limits or products`)
            fi
        fi;
        new_var := op(map(
           proc(eq,nx) options operator,arrow; if lhs(eq) = nx then eq fi end,
           _Env_itr,new_idx));
        if type(var,'algebraic' = 'algebraic' .. 'algebraic') then
            rhs(new_var),lhs(var),[op(rhs(var))];
            [traperror(limit("[1],"[2] = "[3][1])),
                traperror(limit("[1],"[2] = "[3][2]))];
            if has(",{lasterror,'undefined'}) then
                ERROR(`Unable to determine new range for`,new_idx)
            elif
              member(pr,{'Sum','sum'}) and evalb(1 < abs("[1]-"[2])) = 'false'
               then
                ERROR(`Unable to change variables with step = 1 for`,new_idx)
            elif has(",lhs(var)) then
                ERROR(
                 `Unable to remove the old variables`,_Env_old,`from `,new_var
                 )
            else new_var := new_idx = "[1] .. "[2]
            fi;
            denom(f);
            if has(",new_idx) then
                lim['inf'] := op(1,op(2,""));
                lim['sup'] := op(2,op(2,"""));
                traperror(solve(""" = 0,new_idx));
                if " <> lasterror and " <> lim['sup'] then
                    for pole in " do
                        if type(pole-lim['inf'],{0,'posint'}) and
                            evalb(pole <= lim['sup']) = 'true' then
                            if member(pr,{'Int','int'}) then ''integrand''
                            else ''summand''
                            fi;
                            ERROR(
                                cat(`Singularities were found in the new `,"))
                        fi
                    od
                fi
            fi;
            evalf(rhs(new_var));
            if evalb(op(1,") < op(2,")) <> 'true' then
                if evalb(op(2,") < op(1,")) = 'true' or
                    op(1,") = 0 and traperror(sign(op(2,"))) = -1 or
                    op(2,") = 0 and traperror(sign(op(1,"))) = 1 then
                    f := -f;
                    new_var :=
                        new_idx = op(2,rhs(new_var)) .. op(1,rhs(new_var))
                fi
            fi
        elif type(var,`=`) then
            traperror(limit(rhs(new_var),var));
            if " = lasterror then
                ERROR(
                  `Unable to determine new limit for the new variable`,new_idx
                  )
            elif " = 'undefined' then
                ERROR(`Undefined new limit for the new variable`,new_idx)
            else new_var := new_idx = "
            fi
        else new_var := new_idx
        fi;
        if has(new_var,_Env_old) then
            if type(new_var,'anything' = 'algebraic' .. 'algebraic') then
                lhs(new_var) = map(dchange,rhs(new_var))
            else dchange(new_var)
            fi;
            if has(",_Env_old) then
                ERROR(
                 `Unable to remove the old variables`,_Env_old,`from `,new_var
                 )
            else new_var := "
            fi
        fi;
        if type(var,`=`) then lhs(var) else var fi;
        if member(pr,{'Int','int','Sum','sum'}) then
            map(proc(eq,ox)
                options operator,arrow;
                    if lhs(eq) = ox then eq fi
                end                           ,_Env_tr,");
            new_ratio := diff(rhs(op(")),new_idx);
            direc := NULL
        else
            if member(pr,{'Limit','limit'}) and nops(res) = 3 then
                direc := op(3,res);
                map(proc(eq,nx)
                    options operator,arrow;
                        if lhs(eq) = nx then rhs(eq) fi
                    end                                ,_Env_itr,new_idx);
                evalb(sign("") = -sign(op("))) = 'true';
                if " then
                    if direc = 'left' then direc := 'right'
                    elif direc = 'right' then direc := 'left'
                    fi
                fi
            else direc := NULL
            fi;
            new_ratio := 1
        fi;
        RETURN(pr(f*new_ratio,new_var,direc))
    else RETURN(pr(f,var))
    fi
end:
#####################################################################
`dchange/Diff_aux` :=
proc()
local i;
options remember,`Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    if nargs = 2 then Diff(args)
    else args[1]; for i from 2 to nargs do  Diff(",args[i]) od
    fi
end:
#####################################################################
`dchange/info` := 
proc(a1::{`=`,set(`=`)})
local A,ARGS,i;
    if type(a1,`=`) then ARGS := subs(a1 = {a1},[args])
    else ARGS := [args]
    fi;
    if nargs < 2 then ERROR(`Missing arguments`)
    else
        A[1] := ARGS[2];
        A[2] := ARGS[1];
        map(lhs,A[2]);
        if nops(") <> nops(A[2]) then
            ERROR(
          `Found more than one transformation equation for the same variable`)
        elif map(
         proc(u) options operator,arrow; if not type(u,'name') then u fi end,"
         ) <> {} then
            ERROR(
                `Found lhs of transformation equations not being of type name`
                )
        elif has(map(rhs,A[2]),") then
            ERROR(`Found same variables`.
            ` in both lhs and rhs of 1st. set of transformation equations`)
        elif not type(A[1],{set,`=`,`..`,list,algebraic,procedure}) then
            ERROR(`Invalid type:`,whattype(A[1]),` for the target`)
        fi;
        ARGS := subsop(1 = NULL,2 = NULL,ARGS)
    fi;
    select(type,ARGS,'set'(`=`));
    nops(");
    if 1 < " then
        ERROR(`More than 2 sets of transformation equations were found`)
    elif " = 1 then
        A[3] := op("");
        map(lhs,A[3]);
        if nops(") <> nops(A[3]) then
            ERROR(
         `Found more than one transformation equation for the same variable`
            )
        elif nops(") <> nops(A[2]) then
            ERROR(
     `The number of transformation equations and its inverses must be the same`
            )
        elif map(
         proc(u) options operator,arrow; if not type(u,'name') then u fi end,"
         ) <> {} then
            ERROR(
                `Found lhs of transformation equations not being of type name`
                )
        elif has(",map(lhs,A[2])) then
            ERROR(
`Found transformation equations for same variables in both transformation sets`
            )
        elif has(map(rhs,A[3]),") then
            ERROR(
`Found same variables in both lhs and rhs of 2nd. set of transformation equations`
            )
        fi;
        ARGS := subs(A[3] = NULL,ARGS)
    else A[3] := {}
    fi;
    select(type,ARGS,'list');
    nops(");
    if 1 < " then ERROR(`More than one list of new variables were found`)
    elif " = 1 then
        A[4] := op("");
        if nops(") <> nops({op(")}) then
            ERROR(`Found repeated variables in the list of new variables`)
        elif nops(") <> nops(A[2]) then
            ERROR(
`The number of new variables and transformation equations must be the same`
            )
        elif map(
         proc(u) options operator,arrow; if not type(u,'name') then u fi end,"
         ) <> [] then
            ERROR(`Found new variables that are not of type name`)
        elif A[3] <> {} and (has(",map(lhs,A[2])) or not has(map(rhs,A[2]),"))
             then
            A[2]; A[2] := A[3]; A[3] := ""
        fi;
        if not has(A[4],indets(map(rhs,A[2]),'name')) then
            ERROR(
`The new variables are not contained in the rhs of the transformation equations`
            )
        fi;
        if has(A[4],map(lhs,A[2])) then
            ERROR(`Found old variables in the indicated list of new variables`
                )
        fi;
        ARGS := subs(A[4] = NULL,ARGS)
    else
        if A[3] = {} then
            indets(map(rhs,A[2]),'name') minus parameters();
            if nops(") = nops(A[2]) then A[4] := sort([op(")])
            else ERROR(`Missing a list with the new variables`)
            fi
        else A[4] := sort([op(map(lhs,A[3]))])
        fi
    fi;
    if A[3] = {} then
        map(L -> lhs(op(2,L)),indets(A[1],{'Limit','limit'}));
        map(proc(L)
            options operator,arrow;
                if type(op(2,L),`=`) then lhs(op(2,L)) fi
            end                                          ,
            indets(A[1],{'Int','int','Sum','sum','product','Product'})) union
            ";
        if has(",map(lhs,A[2])) then
            A[3] := `dchange/SingleSolve`(A[2],{op(A[4])})
        fi
    fi;
    if ARGS = [] then RETURN([seq(A[i],i = 1 .. 4),{},{}]) fi;
    map(proc(u) options operator,arrow; if lhs(u) = 'known' then u fi end,
        select(type,ARGS,`=`));
    nops(");
    if 1 < " then ERROR(`Multiple statement of 'known' = ... `)
    elif " = 1 then
        ARGS := subs(op("") = NULL,ARGS);
        rhs(op("""));
        if whattype(") = 'exprseq' or not type(",'set') then {"} fi;
        A[5] := map(proc(f,tar)
                        if type(f,'function') then op(0,f)
                        elif type(f,'name') then f
                        else RETURN(NULL)
                        fi;
                        if has(tar,") then " else NULL fi
                    end                                   ,",A[1])
    else A[5] := {}
    fi;
    if ARGS = [] then RETURN([seq(A[i],i = 1 .. 5),{}]) fi;
    map(proc(u) options operator,arrow; if lhs(u) = 'unknown' then u fi end,
        select(type,ARGS,`=`));
    nops(");
    if 1 < " then ERROR(`Multiple statement of 'unknown' = ... `)
    elif " = 1 then
        ARGS := subs(op("") = NULL,ARGS);
        rhs(op("""));
        if whattype(") = 'exprseq' or not type(",'set') then {"} fi;
        A[6] := map(proc(f,tar)
                        if type(f,'function') then op(0,f)
                        elif type(f,'name') then f
                        else RETURN(NULL)
                        fi;
                        if has(tar,") then " else NULL fi
                    end                                   ,",A[1])
    else A[6] := {}
    fi;
    if ARGS = [] then RETURN([seq(A[i],i = 1 .. 6)]) fi;
    indets(ARGS,'procedure');
    nops(");
    if 1 < " then ERROR(`Multiple indication of a simplification procedure`)
    elif " = 1 then A[7] := op("")
    else A[7] := NULL
    fi;
    [seq(A[i],i = 1 .. 7)]
end:
#####################################################################
`dchange/SingleSolve`  := 
proc(f::set(`=`),x::set(name))
local s,S;
options system,remember;
    s := [traperror(solve(f,x))];
    if s = [] or s = [lasterror] then
        ERROR(`Unable to solve`,f,`for `,x,
            `try giving both the trasformation and its inverse`)
    elif nops(s) = 1 then s := op(1,s)
    elif nops(x) = 1 then
        traperror(isolate(op(f),op(x)));
        if " <> lasterror and lhs(") = op(x) then s := {"} fi
    fi;
    if type(s,'list') then
        map(s_eq -> [map(eq -> evalc(Im(rhs(eq))),s_eq),s_eq],s);
        for S in " do  if op(1,S) = {0} then s := op(2,s); break fi od
    fi;
    if type(s,'list') then s := op(1,s) fi;
    if has(s,'RootOf') then
        traperror(convert(s,radical)); if " <> lasterror then s := " fi
    fi;
    s
end:
#####################################################################
`dchange/derivate` := 
proc(var,pr,tr,newl)
local F,piff,n;
options remember;
    sort([op(tr)],(a,b) -> lexorder(lhs(a),lhs(b)));
    member(var,map(lhs,"),'n');
    linalg[jacobian](map(rhs,""),newl);
    evalm(1/");
    if has(",{'cos','sin','tan'}) then map(simplify,",trig) fi;
    convert(linalg[col](",n),'list');
    convert(
        zip((l1,l2) -> l1*l2,",map((nx,F,piff) -> piff(F,nx),newl,F,piff)),`+`
        );
    subs(piff = pr,unapply(",F))
end:
#####################################################################
`dchange/multint` := 
proc(f,var,pr)
local vars,integrand,struk,i,j,dx;
    integrand := f;
    struk := [pr,var];
    if type(var,`=`) then vars := lhs(var) else vars := var fi;
    while member(op(0,integrand),{'Int','int'}) do
        op(2,integrand);
        if type(",`=`) then lhs(") else " fi;
        if member(",_Env_old) then
            if has([vars],") then break
            else
                vars := ",vars;
                struk := [op(0,integrand),op(2,integrand)],struk;
                integrand := combine(op(1,integrand))
            fi
        else break
        fi
    od;
    map(u -> type(u[2],`=`),{struk});
    if not member(",{{'true'},{'false'}}) then
        ERROR(`Missing some integration limits for the old variables`)
    elif " = {'false'} then
        ERROR(`Multiple change of variables requires an integration Domain`)
    fi;
    if {vars} intersect _Env_old <> _Env_old then
        ERROR(
          `Invalid multiple change of variables involving more variables than`
          .` the multiplicity of the integral`)
    fi;
    integrand := dchange(integrand)*`dchange/multint/jaco`(_Env_tr,_Env_newl);
    if _Env_simp <> NULL then integrand := _Env_simp(") fi;
    dx := `dchange/multint/newrange`([struk]);
    for i to nops([struk]) do
        j := op(i,[struk]); integrand := j[1](integrand,dx[i])
    od;
    if has(integrand,{_alpha,_l}) then
        map(proc(u)
                rhs(u);
                op(1,");
                if type(",'function') and op(0,op(0,")) = _l then "" fi
            end                                                        ,dx);
        map(proc(a,dx) options operator,arrow; if has(dx,a) then a fi end,
            [_alpha,_beta],dx);
        print(
         `Warning: Computation of new ranges`,[op(""),op(")],`not implemented`
         );
        print('______________________________________________________');
        print(` `)
    fi;
    integrand
end:
#####################################################################
`dchange/multint/jaco` := proc(tr,newl)
options remember;
    map(rhs,sort([op(tr)],(a,b) -> lexorder(lhs(a),lhs(b))));
    linalg[jacobian](",newl);
    abs(linalg[det]("));
    if _Env_simp <> NULL then _Env_simp(") else " fi
end:
#####################################################################
`dchange/multint/newrange` := 
proc(struk::list)
local dx,i,newvars,L,var;
    dx := map((x,L) -> op(select(has,L,x)),_Env_newl,_Env_itr);
    newvars := _Env_new;
    indets(struk,`=`);
    L := map(eq -> [lhs(eq) = op(1,rhs(eq)),lhs(eq) = op(2,rhs(eq))],");
    for i in dx do
        var := lhs(i);
        indets(i,'name') intersect _Env_old;
        if nops(") = 1 then
            op(map(proc(l,v)
                   options operator,arrow;
                       if lhs(op(1,l)) = v then l fi
                   end                              ,L,op(")));
            map(proc(ox,ref)
                options operator,arrow;
                    if has(ref,ox) then ox fi
                end                          ,_Env_old,map(rhs,"));
            if " = {} then
                dx :=
                 subs(i = (var = subs(""[1],rhs(i)) .. subs(""[2],rhs(i))),dx)
                 ;
                next
            else "
            fi
        fi;
        if i = op(nops(dx),dx) then
            dx := [op(subs(i = NULL,dx)),var = _alpha .. _beta]
        else
            select(has,_Env_tr,");
            op((indets(",'name') intersect newvars) minus {var});
            dx := subs(i = (var = _l[var](") .. _u[var](")),dx);
            newvars := newvars minus {var}
        fi
    od;
    dx
end:
#####################################################################
pdsolve :=
proc(PDE::{equation,algebraic},f::{name,HINT},g::{string,HINT},h::{string})
local S0_extra,n_vars,F,a,a1,A1,diff_vars,not_diff_var,derivatives,
    mixed_derivatives,OO,Cic,k,`ODE's`,non_separated,S,i,Case_has_F,
    Case_mixed_deriv,Case_all_mix_derivs,oops,Sum_S0,Sum_mix,repeated,Sol,
    hint,Hint,Pde,resinco;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    if not assigned(_Env_check_info) then
        _Env_check_info := 'true';
        `pdsolve/args`(args);
        if has([args],'INTEGRATE') then _Env_INTEGRATE := 'INTEGRATE'
        else _Env_INTEGRATE := NULL
        fi
    fi;
    if not assigned(_Env_PDEtools_print) then _Env_PDEtools_print := 'true'
    else _Env_PDEtools_print := 'false'
    fi;
    if assigned(_Env_Lev) then _Env_Lev := _Env_Lev+1 else _Env_Lev := 1 fi;
    if has(map(type,[args],'HINT'),'true') then
        hint := usediff(rhs((eval @ select)(type,[args],'HINT')[1]));
        _Env_hint :=
            indets(hint,{'Function','name'}) minus indets(hint,'unknown');
        Hint := indets(hint,'Function');
        if assigned(_Env_fhint) then
            _Env_fhint := _Env_fhint union map(u -> op(0,u),Hint)
        else _Env_fhint := map(u -> op(0,u),Hint)
        fi
    fi;
    if _Env_check_info then
        _Env_check_info := 'false'; _Env_info := `pdsolve/info`(args)
    fi;
    [a1,A1,F,S,derivatives,mixed_derivatives,diff_vars,not_diff_var,n_vars,OO,
        Case_has_F,Case_mixed_deriv,Case_all_mix_derivs];
    zip(assign,",_Env_info);
    _Env_vars_F := [op(F)];
    if not assigned(_Env_vars) then
        _Env_vars := map(proc(u,param)
                         options operator,arrow;
                             if not has(param,u) then u fi
                         end                              ,[op(F)],
            parameters())
    else
        map(proc(x,a) options operator,arrow; if has(a,x) then x fi end,
            _Env_vars,a1);
        for i in op(F) do  if has(",i) then next else [op("),i] fi od;
        _Env_vars := "
    fi;
    if hint = 'strip' then
        `pdsolve/strip`(A1,F);
        if " = A1 then RETURN(PDE)
        else
            traperror(`pdsolve/strip/solve`(",F));
            if traperror(op(0,")) = `&Where` then
                RETURN(`pdsolve/res`(PDE,"))
            else RETURN("")
            fi
        fi
    fi;
    if not assigned(hint) then
        if Case_all_mix_derivs and
        traperror(frontend(expand,[subs(map(u -> u = 0,derivatives),a1)])) = 0
         then
            `pdsolve/mixed`(a1,F,mixed_derivatives)
        elif nops(derivatives) = 1 then
            `pdsolve/1diff`(A1,F,derivatives,diff_vars,Case_has_F)
        fi;
        if traperror(op(0,")) = `&Where` then RETURN(`pdsolve/res`(PDE,"))
        fi;
        if OO = 1 then
            `pdsolve/first_order`(A1,F,derivatives,diff_vars,not_diff_var[1],
                not_diff_var[2],Case_has_F)
        elif OO = 2 and n_vars = 2 then
            if not assigned(_Env_xi) then _Env_xi := 1 fi;
            map(proc(x)
                options operator,arrow;
                    if substring(x,1 .. 3) = '_xi' then x fi
                end                                         ,
                indets(a1,'string'));
            if " <> {} then
                map(proc(x)
                        parse(substring(x,4 .. length(x)));
                        if nops(["]) = 1 and type(",'numeric') then "
                        else NULL
                        fi
                    end                                              ,");
                i := max(0,op("))+1;
                if _Env_xi < i then _Env_xi := i fi
            fi;
            `pdsolve/second_order`(a1,F,derivatives,diff_vars,_Env_xi)
        fi;
        if traperror(op(0,")) = `&Where` then RETURN(`pdsolve/res`(PDE,"))
        fi;
        if type(a1,linear(derivatives)) then pdsolve(a1,S,'HINT' = `*`)
        elif type(`pdsolve/select`(a1,derivatives,`+`),`*`) then
            if traperror((eval @ subs)(map(u -> u = 0,derivatives),a1)) = 0
                 then
                pdsolve(a1,op(0,F),'HINT' = `+`)
            else pdsolve(a1,op(0,F),'HINT' = `*`)
            fi
        fi;
        if traperror(op(0,")) = `&Where` then
            resinco := ";
            `pdsolve/resinco`(",A1,F);
            if " = {} then RETURN(`pdsolve/res`(A1,resinco)) fi
        fi
    fi;
    if not assigned(hint) or member(hint,{`+`,`*`}) then
        Sol :=
        sum('cat'(''_'',S,'i')(_Env_vars_F['i']),'i' = 1 .. nops(_Env_vars_F))
        ;
        select(has,not_diff_var[1],_Env_vars_F);
        if " <> [] then cat(''_'',S,`00`)(op(")) else 0 fi;
        S0_extra[1] := ";
        select(has,not_diff_var[2],_Env_vars_F);
        if " <> [] then cat(''_'',S,0)(op(")) else 0 fi;
        S0_extra[2] := ";
        if hint = `+` then
            Sum_S0 :=
                `pdsolve/select`(Sol,{op(diff_vars)})+S0_extra[1]+S0_extra[2]
        elif hint = `*` then
            Sum_S0 := convert(
             `pdsolve/select`(Sol,{op(diff_vars)})+S0_extra[1]+S0_extra[2],`*`
             )
        else
            Sum_S0 := `pdsolve/select`(Sol,{op(diff_vars)})+S0_extra[2];
            if Case_mixed_deriv then
                _Env_S0 := indets(Sum_S0,'function');
                if nops(derivatives) = 1 and
                    frontend(expand,[(eval @ subs)(F = Sum_S0,A1)]) = 0 then
                    _Env_S0 := select(type,_Env_S0,'unknown');
                    RETURN(`pdsolve/res`(PDE,(F = Sum_S0) &Where {}))
                else
                    Sum_mix := 0;
                    for i in mixed_derivatives do
                        `pdsolve/select`(_Env_S0,i);
                        Sum_mix := Sum_mix+convert(",`*`)
                    od
                fi;
                Sum_S0 := Sum_S0+Sum_mix
            fi;
            if S0_extra[1] <> 0 then Sum_S0 := (1+Sum_S0)*S0_extra[1] fi
        fi
    else Sum_S0 := hint
    fi;
    _Env_S0 := indets(Sum_S0,'Function') minus indets(A1,'Function');
    Pde := A1;
    traperror(useD(frontend(expand,[subs(F = Sum_S0,A1)])));
    if " = lasterror then
        ERROR(`pdsolve has not been able to solve`,a1,
          `either because of derivatives in the denominator or something else`
          )
    elif has(",F) then a1 := useD(pdtest(A1,(F = Sum_S0) &Where [{}]))
    else a1 := "
    fi;
    if a1 <> 0 then
        derivatives :=
            `pdsolve/select`(indets(a1,'De'),map(u -> op(0,u),_Env_S0));
        `pdsolve/vars`(a1,derivatives,_Env_S0);
        diff_vars := "[1]
    fi;
    if a1 = 0 or derivatives = {} and
        (expand(a1) = 0 or expand(simplify(expand(usediff(a1)),'trig')) = 0)
         then
        RETURN(`pdsolve/res`(PDE,(F = Sum_S0) &Where {}))
    fi;
    if derivatives = {} and not has(a1,select(type,_Env_S0,'unknown')) then
        if assigned(resinco) then
            `PDEtools/print`(`Warning:  Incomplete separation.`);
            `PDEtools/print`(
                '______________________________________________________');
            `PDEtools/print`(` `);
            RETURN(`pdsolve/res`(PDE,resinco))
        elif assigned(hint) then
            `PDEtools/print`(`The proposed HINT=... is not so good.`);
            `PDEtools/print`(`No Solutions found and no ODE's at all.`)
        else `PDEtools/print`(`Warning:  No solutions found`)
        fi;
        `PDEtools/print`(
            '______________________________________________________');
        `PDEtools/print`(` `);
        RETURN(PDE)
    fi;
    if derivatives <> {} and assigned(Hint) and Hint <> {} then
        sort(map(
          proc(u,eq)
              if 1 < nops(u) then op(0,u); if has(eq,") then u else NULL fi fi
          end
          ,[op(_Env_S0)],a1));
        if 0 < nops(") then
            `pdsolve/fhint`(Pde,a1,hint,",F);
            if type(",'`&Where`'('anything','anything')) then
                RETURN(`pdsolve/res`(PDE,"))
            elif assigned(resinco) then
                `PDEtools/print`(`Warning:  Incomplete separation.`);
                `PDEtools/print`(
                    '______________________________________________________');
                `PDEtools/print`(` `);
                RETURN(`pdsolve/res`(PDE,resinco))
            else
                `PDEtools/print`(`Warning:  No solutions found`);
                `PDEtools/print`(
                    '______________________________________________________');
                `PDEtools/print`(` `);
                RETURN(PDE)
            fi
        fi
    fi;
    proc(u,v) if 1 < nops(`pdsolve/select`(v,u)) then u fi end;
    repeated := map(",diff_vars,derivatives);
    Cic := {};
    `ODE's` := {};
    non_separated := map(
        proc(x,pde) options operator,arrow; if has(pde,x) then x fi end,
        _Env_vars,a1);
    if not Case_has_F then
        for k in subs(map(u -> u = NULL,repeated),diff_vars) do
            `pdsolve/select`(derivatives,k);
            proc(deriv)
                indets({op(deriv)},'name') intersect {op(_Env_vars_F)};
                if nops(") = 1 then deriv else 0 fi
            end;
            map(","");
            if has(",0) then next fi;
            map(u -> u = freeze(u),");
            if diff(subs(",a1),k) = 0 then
                Cic := Cic union {k};
                non_separated := subs(k = NULL,non_separated)
            fi
        od;
        proc(deriv,cic)
        local n;
            if nops(deriv) = 1 and member(op(deriv),cic) then
                member(op(deriv),_Env_vars,'n'); deriv = _c[n]
            fi
        end;
        if subs(map(u -> u = NULL,not_diff_var[2]),non_separated) <> [] then
            `ODE's` := map(",derivatives,Cic)
        else
            map(
            ",derivatives minus `pdsolve/select`(derivatives,diff_vars[1]),Cic
            );
            `ODE's` := {op(")};
            `pdsolve/LHS_of_ode`(subs("",a1) = 0,diff_vars[1],derivatives);
            `pdsolve/trap`(lhs("),{diff_vars[1]},{diff_vars[1]});
            if not " then
                `ODE's` := usediff(`ODE's` union {""});
                RETURN(`pdsolve/res`(PDE,(F = Sum_S0) &Where `ODE's`))
            else non_separated := [diff_vars[1],op(non_separated)]
            fi
        fi;
        derivatives := derivatives minus map(lhs,`ODE's`);
        a1 := subs(`ODE's`,a1)
    fi;
    a := `pdsolve/sep`(
        a1,derivatives,non_separated,not_diff_var[1],not_diff_var[2]);
    if a[5] = 'true' then oops := 'true'
    else
        oops := 'false';
        `ODE's` := {op(`ODE's`),op(a[4])};
        if a[3] = [] then
            RETURN(`pdsolve/res`(PDE,(F = Sum_S0) &Where `ODE's`))
        fi;
        a1 := a[1];
        derivatives := a[2];
        non_separated := a[3]
    fi;
    if not oops and (has(a1,'D') or 1 < nops(non_separated)) then
        a1 := `pdsolve/den`(a1,non_separated);
        if a1 <> a[1] then
            a := `pdsolve/sep`(
                a1,derivatives,non_separated,not_diff_var[1],not_diff_var[2]);
            if a[5] = 'true' then oops := 'true'
            else
                oops := 'false';
                `ODE's` := {op(`ODE's`),op(a[4])};
                if a[3] = [] then
                    RETURN(`pdsolve/res`(PDE,(F = Sum_S0) &Where `ODE's`))
                fi;
                a1 := a[1];
                derivatives := a[2];
                non_separated := a[3]
            fi
        fi
    fi;
    if oops then
        if assigned(resinco) then
            `PDEtools/print`(`Warning:  Incomplete separation.`);
            `PDEtools/print`(
                '______________________________________________________');
            `PDEtools/print`(` `);
            RETURN(`pdsolve/res`(PDE,resinco))
        elif has([args],'HINT') then
            `PDEtools/print`(
            `Warning:  The proposed HINT leads to an inconsistency or to a co\
            nstraint.`
            );
            `PDEtools/print`(
                '______________________________________________________');
            `PDEtools/print`(` `)
        else
            `PDEtools/print`(`Warning:`);
            `PDEtools/print`(
            `The algorithm used by pdsolve cannot separate this PDE. Try opti\
            on HINT`
            );
            `PDEtools/print`(
                '______________________________________________________');
            `PDEtools/print`(` `)
        fi;
        RETURN(PDE)
    elif `ODE's` = {} or
      not has(a1,'D') and {op(non_separated)} minus {op(not_diff_var[1])} = {}
       then
        if Case_mixed_deriv and nops(not_diff_var[1]) = 0 and
            not has([args],'HINT') then
            Sum_S0 := Sum_S0-Sum_mix;
            if frontend(expand,[(eval @ subs)(F = Sum_S0,A1)]) = 0 then
                RETURN(`pdsolve/res`(PDE,(F = Sum_S0) &Where {}))
            elif assigned(resinco) then
                `PDEtools/print`(`Warning:  Incomplete separation.`);
                `PDEtools/print`(
                    '______________________________________________________');
                `PDEtools/print`(` `);
                RETURN(`pdsolve/res`(PDE,resinco))
            else
                `PDEtools/print`(`Warning:  No solutions found`);
                `PDEtools/print`(
                    '______________________________________________________');
                `PDEtools/print`(` `);
                RETURN(PDE)
            fi
        elif assigned(resinco) then
            `PDEtools/print`(`Warning:  Incomplete separation.`);
            `PDEtools/print`(
                '______________________________________________________');
            `PDEtools/print`(` `);
            RETURN(`pdsolve/res`(PDE,resinco))
        else
            `PDEtools/print`(`Warning:  No solutions found`);
            `PDEtools/print`(
                '______________________________________________________');
            `PDEtools/print`(` `);
            RETURN(PDE)
        fi
    fi;
    if a[3] = [] then RETURN(`pdsolve/res`(PDE,(F = Sum_S0) &Where `ODE's`))
    else
        `pdsolve/Incomplete`(A1,a[1],F,S,Sum_S0,usediff(`ODE's`));
        if type(",'function') and op(0,") = `&Where` then
            `pdsolve/res`(PDE,")
        else PDE
        fi
    fi
end:
#####################################################################
`pdsolve/resinco` := 
proc(resinco,A1,F)
local odes;
    odes := op(2,resinco);
    `pdsolve/select`(odes,`&and`);
    if " <> {} then odes := odes minus " fi;
    map(proc(d,f,x)
        options operator,arrow;
            if has(d,f) and has(d,x) then d fi
        end                                   ,indets(A1,{'diff','De'}),
        op(0,F),{op(F)});
    `pdsolve/vars`(A1,",{F});
    {op("[2])},{op("[3])};
    indets(odes,`=`),{op(_Env_vars)} minus ("[1] union "[2]),"[1],"[2];
    map(
    proc(eq,dv,dv1,dv2)
    options operator,arrow;
        if
        1 < nops(indets(eq,'name') intersect dv) or has(eq,dv) and has(eq,dv1)
         or has(eq,dv) and has(eq,dv2) or has(eq,dv1) and has(eq,dv2) then
            eq
        fi
    end
    ,")
end:
#####################################################################
`pdsolve/res` :=
proc(PDE,res)
local hint,odes,and_func,arb_funcs;
    if nargs = 2 and _Env_Lev <> 1 then RETURN(res) fi;
    hint := rhs(op(1,res));
    map(proc(f) options operator,arrow; if op(0,f) = `&and` then f fi end,
        indets(op(2,res),'function'));
    odes := usediff(subs(map(u -> u = NULL,"),op(2,res)));
    if "" <> {} then and_func := `&and`(map(op @ op,""))
    else and_func := NULL
    fi;
    if odes = {} then odes := NULL fi;
    if nargs = 3 then RETURN(op(1,res) &Where [odes,and_func]) fi;
    indets(hint,'unknown') minus indets(PDE,'unknown');
    if odes <> NULL then " minus map(`pdsolve/fixedfunc`,odes,") fi;
    if " = {} then
        if and_func = NULL and odes = NULL then
            arb_funcs := ``(`There are no arbitrary functions`)
        else arb_funcs := NULL
        fi
    else
        arb_funcs := ``(op(sort([op(")],(a,b) -> lexorder(op(0,a),op(0,b)))),
            ` are arbitrary functions.`)
    fi;
    if _Env_INTEGRATE = 'INTEGRATE' then
        _Env_S0 := (indets(hint,'unknown') minus indets(PDE,'unknown'))
            intersect indets(odes,'unknown');
        odes := `pdsolve/INTEGRATE`(odes)
    fi;
    op(1,res) &Where [odes,arb_funcs,and_func]
end:
#####################################################################
`pdsolve/fixedfunc` := 
proc(ode,arbfuncs)
local ff,x;
    ff := map(proc(f,ode) options operator,arrow; if has(ode,f) then f fi end,
        arbfuncs,ode);
    if " = {} then
        ff := map(proc(f,ode)
                  options operator,arrow;
                      if has(ode,op(0,f)) then f fi
                  end                              ,arbfuncs,ode);
        if " = {} then RETURN() fi
    fi;
    if nops(ff) = 1 then RETURN(op("))
    elif has(ode,{'diff','De'}) then
        map(proc(f,df) options operator,arrow; if has(df,f) then f fi end,ff,
            indets(ode,'diff'));
        if " = {} then
            map(proc(f,Df)
                options operator,arrow;
                    if has(Df,op(0,f)) then f fi
                end                             ,ff,indets(ode,'De'));
            if " = {} then ff fi
        fi
    fi;
    if nops(") = 1 then op(")
    else
        ff := ";
        map(f -> [op(f)],ff);
        if nops(") = nops(ff) then RETURN(op(ff))
        else
            for x in " do
                `pdsolve/select`(ff,x);
                ff := (ff minus ") union
                    {op(1,sort([op(")],(a,b) -> lexorder(op(0,a),op(0,b))))}
            od;
            op(ff)
        fi
    fi
end:
#####################################################################
`pdsolve/args` :=
proc()
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    if 4 < nargs or nargs < 1 then
        ERROR(`pdsolve takes between one and four arguments`)
    elif nargs = 4 then
        if not args[4] = 'INTEGRATE' then
            ERROR(`Expected fourth argument: INTEGRATE. Received:`,args[4])
        elif not type(args[3],'HINT') then
            ERROR(`Expected third argument: 'HINT = ...'. Received:`,args[3])
        elif not type(args[2],'name') then
            ERROR(
  `Expected type of second argument: 'string' or 'indexed'. Received:`
            ,whattype(args[2]))
        fi
    elif nargs = 3 then
        if not (args[3] = 'INTEGRATE' or type(args[3],'HINT')) then
            ERROR(
              `Expected third argument: 'HINT = ...' or INTEGRATE. Received:`,
              args[3])
        elif not (type(args[2],'name') or type(args[2],'HINT')) then
            ERROR(
              `Expected second argument: 'HINT = ...' or a 'name'. Received:`,
              args[2])
        elif type(args[2],'HINT') and type(args[3],'HINT') then
            ERROR(`Repeated arguments`)
        fi
    elif nargs = 2 then
        if not (
         args[2] = 'INTEGRATE' or type(args[2],'HINT') or type(args[2],'name')
         ) then
            ERROR(
 `Expected second argument: INTEGRATE or 'HINT = ...' or a 'name'. Received:`
            ,args[2])
        fi
    fi
end:
#####################################################################
`pdsolve/info` :=
proc(PDE,f,g,h)
local freeze_derivatives,a11,cop,v,divisor,a1,A1,F,S,derivatives,
    mixed_derivatives,diff_vars,not_diff_var,n_vars,OO,Case_has_F,
    Case_mixed_deriv,Case_all_mix_derivs;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    if type(PDE,`=`) then lhs(PDE)-rhs(PDE) else PDE fi;
    a1 := useD(frontend(expand,["]));
    derivatives := indets(a1,'De');
    if " = {} then ERROR(PDE,`is not a differential equation`) fi;
    proc(u)
        op(0,u);
        if type(",'function') then op(")(op(u))
        else ERROR(`Cannot handle derivatives such as`,u)
        fi
    end;
    F := map(",derivatives);
    if 1 < nargs and type(args[2],'name') and args[2] <> 'INTEGRATE' then
        if not member(args[2],map(u -> op(0,u),F)) then
            ERROR(`No derivatives of`,args[2],`were found`)
        else
            F := map(
               proc(u,S) options operator,arrow; if op(0,u) = S then u fi end,
               F,args[2]);
            if nops(") = 1 then S := args[2]
            else
                ERROR(`The indeterminate function`,args[2],
`is expected to depend on the same variables throughout the equation`
                ,`but came as `,`pdsolve/select`(F,args[2]))
            fi
        fi
    elif nops(F) = 1 then
        S := op(0,F[1]);
        if type(S,'function') and type(op(0,S),{name,string}) then
            S := op(0,S)
        fi
    else ERROR(`The name of the indeterminate function must be given`)
    fi;
    F := F[1];
    select(has,[args],'HINT');
    if " <> [] then
        map(f -> op(0,f),indets(usediff("),'unknown'));
        if has(",op(0,F)) then
            ERROR(`The indeterminate function name`,op(0,F),
                `cannot appear in the HINT`)
        fi
    fi;
    _Env_vars := subs(map(u -> u = NULL,parameters()),[op(F)]);
    if not map(type,{op(_Env_vars)},'name') = {'true'} then
        ERROR(
          `Variables of the indeterminate function`,F,` must be of type name.`
          )
    elif nops(F) = 1 then ERROR(`Not a PDE. Please use dsolve.`)
    fi;
    proc(derivative,S)
        op(0,derivative); if op(") = S then derivative fi
    end;
    derivatives := map(",derivatives,op(0,F));
    map(u -> u = freeze(u),derivatives);
    freeze_derivatives := map(rhs,");
    A1 := frontend(expand,[subs("",a1)]);
    map(proc(f,S,vars)
        options operator,arrow;
            if op(0,f) = S and [op(f)] <> vars then f fi
        end                                             ,
        indets(A1,'Function'),S,_Env_vars);
    if " <> {} then
        ERROR(`The indeterminate function`,S,
        `is expected to depend on the same variables throughout the equation`,
        `but came as `," union {F})
    elif has(denom(A1),freeze_derivatives) then
        A1 := frontend(expand,[numer(A1)]);
        a1 := thaw(");
        freeze_derivatives := indets(A1,'string') intersect freeze_derivatives
            ;
        derivatives := thaw(")
    fi;
    divisor := 1;
    if has(A1,F) then
        a11 := factor(A1);
        if type(a11,`*`) then
            cop := a11;
            `pdsolve/select`([op(a11)],S);
            for v in " do
                a11/v;
                if has(",freeze_derivatives) then
                    a11 := "; divisor := divisor*v
                fi
            od;
            if a11 = cop then Case_has_F := 'true'
            else
                frontend(expand,[a11]);
                if has(",F) then Case_has_F := 'true'
                else Case_has_F := 'false'
                fi;
                a1 := thaw(normal(frontend(expand,[A1/divisor])))
            fi
        else Case_has_F := 'true'
        fi
    else Case_has_F := 'false'
    fi;
    A1 := usediff(a1);
    `pdsolve/vars`(a1,derivatives,{F});
    diff_vars := "[1];
    not_diff_var[1] := ""[2];
    not_diff_var[2] := """[3];
    n_vars := nops(diff_vars);
    proc(mix_deriv)
        {op(op(0,op(0,mix_deriv)))};
        if 1 < nops(") then map(op,",mix_deriv) fi
    end;
    mixed_derivatives := map(",derivatives);
    Case_mixed_deriv := evalb(mixed_derivatives <> {});
    OO := odiff(convert(derivatives,`*`));
    if nops(derivatives) = nops(mixed_derivatives) then
        Case_all_mix_derivs := 'true'
    else Case_all_mix_derivs := 'false'
    fi;
    [a1,A1,F,S,derivatives,mixed_derivatives,diff_vars,eval(not_diff_var),
        n_vars,OO,Case_has_F,Case_mixed_deriv,Case_all_mix_derivs]
end:
#####################################################################
`pdsolve/vars` := 
proc(a1,derivatives,F)
local S,i;
    subs(map(u -> u = freeze(u),derivatives),a1);
    map(proc(u,v) if has(v,u) then u fi end,_Env_vars,subs(
       {diff = Diff,seq(op(i,F) = S[i],i = 1 .. nops(F))},usediff(derivatives)
       ));
    map(proc(u,expr) options operator,arrow; if has(expr,u) then u fi end,
        subs(map(u -> u = NULL,"),_Env_vars),"");
    "",",subs(map(u -> u = NULL,{op("),op("")}),_Env_vars)
end:
#####################################################################
`pdsolve/fhint` := 
proc()
local Pde,pde,hint,funcs,F,case,odes,res,f,Fail,N,i;
    Pde := args[1];
    pde := args[2];
    hint := args[3];
    if 1 < nops(args[4]) then
        map((f,other) -> op(0,f)(op(map(
          proc(x,oth) options operator,arrow; if not has(oth,x) then x fi end,
          [op(f)],subs(f = NULL,other)))),args[4],args[4]);
        sort(",proc(a,b)
               options operator,arrow;
                   if nops(b) < nops(a) then 'true'
                   elif nops(a) < nops(b) then 'false'
                   else lexorder(op(0,a),op(0,b))
                   fi
               end                                    )
    else args[4]
    fi;
    map(u -> op(0,u),");
    if not assigned(_Env_funcs) then _Env_funcs := "
    else
        map(proc(u,v) options operator,arrow; if has(v,u) then u fi end,",
            _Env_funcs)
    fi;
    funcs := map(op,[seq(",f = 1 .. nops("))]);
    F := args[5];
    _Env_check_info := 'true';
    case['rpde'] := 'true';
    case['incomplete'] := 'false';
    case['complete'] := 'false';
    Fail := 0;
    odes := {};
    if has(pde,'_c') then
        map(proc(u)
            options operator,arrow;
                if op(0,u) = '_c' and type(op(u),'numeric') then op(u) fi
            end                                                          ,
            indets(pde,indexed));
        N := max(0,op("));
        pde := subs(_c = _k,pde)
    else N := 0
    fi;
    for f in funcs do
        if case['rpde'] then
            if not has(pde,f) or select(has,indets(useD(pde),'De'),f) = {}
                 then
                funcs := subs(f = NULL,funcs);
                if 0 < nops(funcs) then next
                else
                    odes := usediff(odes union {pde});
                    case['complete'] := 'true';
                    break
                fi
            else res := pdsolve(pde,f)
            fi
        else res := pdsolve(Pde,op(0,F),'HINT' = hint)
        fi;
        if type(res,'`&Where`'('anything','anything')) then
            if has(op(2,res),_c) then
                map(proc(u)
                    options operator,arrow;
                        if op(0,u) = '_c' then op(u) fi
                    end                                ,
                    indets(op(2,res),'indexed'));
                max(0,op("));
                res := subs({seq(_c[i] = _k[i+N],i = 1 .. ")},res);
                N := N+""
            fi;
            if not assigned(_Env_xi) then _Env_xi := 1 fi;
            map(proc(x)
                options operator,arrow;
                    if substring(x,1 .. 3) = '_xi' then x fi
                end                                         ,
                indets(res,'string'));
            if " <> {} then
                map(proc(x)
                        parse(substring(x,4 .. length(x)));
                        if nops(["]) = 1 and type(",'numeric') then "
                        else NULL
                        fi
                    end                                              ,");
                i := max(0,op("))+1;
                if _Env_xi < i then _Env_xi := i fi
            fi;
            odes := odes union op(2,res);
            if case['rpde'] then hint := subs(Value(op(1,res)),hint)
            else hint := Value(rhs(op(1,res)))
            fi;
            _Env_S0 :=
            _Env_S0 union (indets(hint,'unknown') minus indets(Pde,'unknown'))
            ;
            funcs := subs(f = NULL,funcs);
            if nops(funcs) = 0 then case['complete'] := 'true'; break
            else
                Fail := 0;
                if has(op(1,res),funcs) then case['rpde'] := 'false'
                else
                    case['rpde'] := 'true';
                    case['incomplete'] := 'true';
                    `pdsolve/select`(indets(odes,`=`),{op(funcs)});
                    if " = {} then case['complete'] := 'true'; break
                    else pde := op(1,"); odes := odes minus {"}
                    fi
                fi
            fi
        else
            Fail := Fail+1;
            if Fail = nops({op(funcs)}) then
                odes := usediff(odes union {pde}); break
            fi
        fi
    od;
    if case['complete'] then
        `pdsolve/resinco`((F = hint) &Where odes,Pde,F);
        if " = {} then RETURN(subs(_k = _c,(F = hint) &Where odes))
        else case['incomplete'] := 'true'
        fi
    fi;
    if case['incomplete'] then
        `PDEtools/print`(`Warning:  Incomplete separation.`);
        `PDEtools/print`(
            '______________________________________________________');
        `PDEtools/print`(` `);
        RETURN(subs(_k = _c,(F = hint) &Where odes))
    else RETURN('FAIL')
    fi
end:
#####################################################################
`pdsolve/Incomplete` :=
proc(A1,a1,F::function,S::string,Sum_S0,Sol::set)
local hint,sep_vars,non_sep_vars,res,remain,FF,N,i;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    sep_vars := map(proc(u,v) if has(v,u) then u fi end,_Env_vars,Sol);
    non_sep_vars := subs(map(u -> u = NULL,sep_vars),_Env_vars_F);
    if non_sep_vars = [] then
        RETURN((F = Sum_S0) &Where (Sol union {a1 = 0}))
    elif assigned(_Env_fhint) and 1 < nops(non_sep_vars) then
        usediff(a1);
        select(has,indets(",'Function'),subs(S = NULL,_Env_fhint));
        if has(",non_sep_vars) then
            RETURN((F = Sum_S0) &Where (Sol union {"" = 0}))
        fi
    fi;
    hint := F = Sum_S0;
    if 1 < nops(non_sep_vars) then
        frontend(expand,[Sum_S0]);
        if type(",`*`) then
            "/`pdsolve/select`(",{op(non_sep_vars)});
            if not has(",non_sep_vars) then
                hint := F = "*cat(''_'',S,nops(_Env_vars)+1)(op(non_sep_vars))
            fi
        elif type(",`+`) then
            `pdsolve/select`(",{op(sep_vars)});
            hint := F = "+cat(''_'',S,nops(_Env_vars)+1)(op(non_sep_vars))
        fi
    fi;
    `pdsolve/res`(A1,hint &Where Sol,0);
    remain := factor(pdtest(A1,"));
    if " = 0 then RETURN(hint &Where Sol)
    elif type(remain,`*`) then
        `pdsolve/select`(remain,{op(non_sep_vars)});
        indets(",'Function') minus _Env_S0;
        _Env_S0 := _Env_S0 union ";
        if not `pdsolve/trap`(""",{op(non_sep_vars)},{op(non_sep_vars)}) then
            remain := """
        else ''bad_remain''
        fi;
        _Env_S0 := _Env_S0 minus """
    fi;
    if not has(remain,sep_vars) then
        res := hint &Where (Sol union {remain = 0});
        if pdtest(A1,`pdsolve/res`(A1,res,0)) = 0 and
            1 < nops(indets(rhs(hint)) intersect {op(non_sep_vars)}) then
            FF := `pdsolve/select`(indets(rhs(hint),'function'),non_sep_vars);
            if nops(FF) = 1 then
                if has(remain,'_c') then
                    map(proc(u)
                        options operator,arrow;
                            if op(0,u) = '_c' and type(op(u),'numeric') then
                                op(u)
                            fi
                        end                                                 ,
                        indets(remain,'indexed'));
                    N := max(0,op("));
                    remain := subs(_c = _k,remain)
                else N := 0
                fi;
                _Env_check_info := 'true';
                traperror(pdsolve(remain,op(0,op(FF))));
                if traperror(op(0,")) = `&Where` then
                    if N <> 0 and has(",_c) then
                        map(
                          proc(u)
                          options operator,arrow;
                              if op(0,u) = '_c' and type(op(u),'numeric') then
                                  op(u)
                              fi
                          end
                          ,indets(",'indexed'));
                        max(0,op("));
                        subs({seq(_c[i] = _k[i+N],i = 1 .. ")},_k = _c,""")
                    fi;
                    res := subs(_k = _c,subs(op(1,"),hint) &Where
                      ((Sol union op(2,")) minus `pdsolve/select`(op(2,"),``))
                      )
                elif N <> 0 then res := subs(_k = _c,res)
                else res
                fi
            else res
            fi
        else res
        fi
    else res := (F = Sum_S0) &Where (Sol union {usediff(a1) = 0})
    fi;
    if _Env_PDEtools_print then
        `pdsolve/resinco`(res,A1,F);
        if " <> {} then
            print(`Warning:  Incomplete separation.`);
            print('______________________________________________________');
            print(` `)
        fi
    fi;
    res
end:
#####################################################################
`pdsolve/1diff` :=
proc(A1,F,derivatives,diff_vars,Case_has_F)
local a1,deriv,hint,info,count,`dx's`,k,vars,pdInt,uu;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    `dx's` := diff_vars;
    deriv := op(1,usediff(derivatives));
    if has(A1,{op(_Env_vars)} minus {op(_Env_vars_F)}) then RETURN(FAIL)
    elif not Case_has_F then
        subs(uu = deriv,[solve(subs(deriv = uu,A1),uu)]);
        if " = [] then RETURN('FAIL')
        elif nops(") = 1 then a1 := op(1,")
        else
            select(proc(u)
                       if traperror(sign(u)) = 1 then 'true' else 'false' fi
                   end                                                      ,"
                );
            if " <> [] then a1 := op(1,") else a1 := op(1,"") fi
        fi;
        count := 1;
        hint := a1;
        vars := [op(F)];
        `dx's` := map((u,A1) -> u $ odiff(A1,u),diff_vars,A1);
        _Env_A1_func := indets(A1,'Function');
        pdInt := proc(f,dx)
                     indets(f,'Function');
                     if " = {} then Int(f,dx)
                     elif " intersect _Env_A1_func = {} then f
                     else Int(f,dx)
                     fi
                 end                                          ;
        for k in `dx's` do
            info := hint,subs(k = NULL,vars);
            if info[2] = [] then 0
            else cat(''_'',op(0,F),count)(op(info[2]))
            fi;
            hint := "+
                (eval @ subs)(Int = pdInt,`pdsolve/expand/Int`(info[1],k))+
                cat(_C,count);
            count := count+1
        od;
        traperror(collect(hint,[op(F)],'distributed'));
        if " <> lasterror then hint := " fi;
        deriv-a1;
        if " <> A1 then _Env_check_info := 'true' else 0 fi;
        pdsolve("",op(0,F),'HINT' = hint);
        if type(",'function') and op(0,") = `&Where` then RETURN(")
        else 'FAIL'
        fi
    fi;
    'FAIL'
end:
#####################################################################
`pdsolve/mixed` :=
proc(a1,F,mixed_derivatives)
local n,i,k,arb_f,res,permus,Res,names_list,vars_num,j;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    Res := {};
    for n from nops(F)-1 by -1 to 1 do
        permus := {op(map(u -> convert(u,set),combinat[permute]([op(F)],n)))};
        for i in mixed_derivatives do
            res[i] := {};
            for j in permus do
                'true';
                for k in Res do
                    if j minus k = {} then
                        permus := permus minus {j}; 'false'; break
                    else 'true'
                    fi
                od;
                if " and i minus j <> {} then res[i] := res[i] union {j} fi
            od;
            permus := permus intersect res[i]
        od;
        Res := Res union permus
    od;
    arb_f := cat(''_'',op(0,F));
    names_list := [seq(cat(arb_f,i),i = 1 .. nops(Res))];
    vars_num := seq(_Env_vars[i] = i,i = 1 .. nops(_Env_vars));
    Res := map(u -> sort([op(u)]),[op(subs(vars_num,Res))]);
    Res := sort(Res,
      proc(a,b)
      local j;
          nops(a),nops(b);
          if "[1] < "[2] then 'true'
          elif "[1] = "[2] then
              if "[1] = 1 then
                  if op(a) < op(b) then RETURN('true') else RETURN('false') fi
              else
                  for j to nops(a) do
                      if a[j] < b[j] then RETURN('true')
                      elif a[j] = b[j] then next
                      else RETURN('false')
                      fi
                  od
              fi
          else 'false'
          fi
      end
      );
    Res := subs(map(u -> rhs(u) = lhs(u),{vars_num}),Res);
    zip((f,vars) -> f(op(vars)),names_list,Res);
    convert(",`+`);
    pdsolve(a1,op(0,F),'HINT' = ")
end:
#####################################################################
`pdsolve/strip` :=
proc(a,F)
local ode_set,Sol,L_sets,s_strip,Case_Incomplete,funcs,add;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    splitstrip(a,F);
    if type(",'`&Where`'('anything','anything')) then
        s_strip := op(1,"); add := op(2,"")
    else s_strip := "
    fi;
    Sol := s_strip;
    L_sets := sort([op(s_strip)],
        proc(a,b) if nops(a) <= nops(b) then 'true' else 'false' fi end);
    Case_Incomplete := 'false';
    for ode_set in L_sets do
        funcs :=
           map(proc(u) if op(u) = _s then u fi end,indets(ode_set,'Function'))
           ;
        Sol := subs(ode_set = `pdsolve/strip/aux`(ode_set,funcs),Sol);
        indets(Sol,'diff');
        if " <> {} and has(",funcs) then Case_Incomplete := 'true' fi
    od;
    if Sol <> s_strip then Sol := `pdsolve/INTEGRATE/_C`(Sol)
    else
        `PDEtools/print`(`Warning:  No solutions found`);
        `PDEtools/print`(
            '______________________________________________________');
        `PDEtools/print`(
            `The system was unable to solve the associated strip.`);
        `PDEtools/print`(` `);
        RETURN(a)
    fi;
    if Case_Incomplete then
        `PDEtools/print`(`Warning:  Incomplete solution of the strip`)
    else `PDEtools/print`(`Complete solution of the strip:`)
    fi;
    `PDEtools/print`('______________________________________________________')
        ;
    `PDEtools/print`(` `);
    if assigned(add) then (a = 0) &Where [Sol,`&and`(add)]
    else (a = 0) &Where [Sol]
    fi;
    RETURN(")
end:
#####################################################################
`pdsolve/strip/aux` := 
proc(ode_set,funcs)
local Ode_set,Sol,de,ode,i,j,count,bubu,w,ode2,uu;
    Ode_set := ode_set;
    Sol := Ode_set;
    count := nops(ode_set);
    for i to nops(funcs) do
        ode := map(
            proc(u,funcs,n)
                if nops(indets(u,'Function') intersect funcs) <= n then u fi
            end                                                             ,
            Ode_set,funcs,i);
        if " <> {} then
            if i = 1 then
                if not nops(ode) = 1 then
                    map(proc(w)
                        options operator,arrow;
                            if has(w,_s) then op(0,w) else NULL fi
                        end                                       ,
                        [op(indets(ode,'Function'))]);
                    sort(`pdsolve/select`(",_p),
                        proc(a,b)
                            if op(a) < op(b) then 'true' else 'false' fi
                        end                                             );
                    subs(map(w -> w = NULL,"),"");
                    map(v -> v(_s),[op(sort(",lexorder)),op("")]);
                    ode2 := [];
                    for w in "" do
                        ode2 := [op(ode2),op(`pdsolve/select`(ode,w))]
                    od;
                    ode := ode2
                fi;
                for de in ode do
                    bubu := traperror(dsolve(op(
                      subs(_s = uu,[de,indets(de,'function') intersect funcs])
                      ),'explicit' = true));
                    if bubu <> NULL and bubu <> {de} and bubu <> lasterror
                         then
                        subs({uu = _s,_C1 = cat(''_C'',count)},[bubu]);
                        Sol := subs(",Sol minus {de}) union {op(1,")};
                        Ode_set := subs("",Ode_set minus {de});
                        i := 0;
                        count := count-1
                    fi
                od
            else
                [ode,indets(ode,'function') intersect funcs];
                if nops("[1]) <> nops("[2]) then next fi;
                bubu :=
                    traperror(dsolve(op(subs(_s = uu,")),'explicit' = true));
                if bubu <> NULL and bubu <> lasterror then
                    subs({uu = _s,seq(
                      cat(''_C'',j) = cat(''_C'',count+1-j),j = 1 .. nops(ode)
                      )},bubu);
                    Sol := subs(",Sol minus ode) union ";
                    Ode_set := subs("",Ode_set minus ode);
                    i := 0;
                    count := count-nops(ode)
                fi
            fi;
            if Ode_set = {} then break fi
        fi
    od;
    Sol
end:
#####################################################################
`pdsolve/strip/solve` := 
proc(w::function,f::function)
local j,eq,eq_list,vars,s_eq,F,F_eq,Cs,_C_eqs;
    op(2,w);
    if has(",_p) then
        ERROR(`The case when there are _p's is not yet implemented`)
    else
        eq_list :=
        sort([op(indets(",`=`))],(a,b) -> lexorder(op(0,lhs(a)),op(0,lhs(b))))
    fi;
    vars := sort([op(f)]);
    F := op(0,f);
    map(u -> diff(u(_s),_s),{op(vars)} union {F});
    if has(eq_list,") then RETURN(fail_1)
    else
        map(u -> u(_s) = u,{op(vars)} union {F}); eq_list := subs(",eq_list)
    fi;
    [op(indets(eq_list,'string') minus {_s})];
    Cs := sort(map(proc(c)
                   options operator,arrow;
                       if substring(c,1 .. 2) = _C then c fi
                   end                                      ,"));
    F_eq := op(select(has,eq_list,F));
    s_eq := [];
    for eq in subs(F_eq = NULL,eq_list) do
        map(proc(C,eq)
            options operator,arrow;
                if has(eq,_s) and has(eq,C) then C fi
            end                                      ,Cs,eq);
        s_eq := [op(s_eq),[eq,"]]
    od;
    sort(s_eq,proc(a,b)
                  [op(2,a),op(2,b)];
                  if nops("[1]) < nops("[2]) then 'true'
                  elif nops("[1]) = nops("[2]) then
                      lexorder(op(0,lhs(op(1,a))),op(0,lhs(op(1,b))))
                  else 'false'
                  fi
              end                                                    );
    s_eq := map(u -> op(1,u),");
    for eq in s_eq do
        traperror(convert(isolate(eq,_s),'radical'));
        if " = lasterror or not lhs(") = _s or has(rhs("),_s) then next
        else
            s_eq := ";
            eq_list := subs({F_eq = NULL,eq = NULL},eq_list);
            break
        fi
    od;
    if has(eq_list,F_eq) then RETURN(fail_2) fi;
    _C_eqs := [];
    for j to nops(eq_list) do
        [op(indets(rhs(eq_list[j]),'string') minus {_s})];
        sort(map(proc(c)
                 options operator,arrow;
                     if substring(c,1 .. 2) = _C then c fi
                 end                                      ,"));
        if nops(") = 1 then op(")
        else
            map(
              proc(c,L) options operator,arrow; if not has(L,c) then c fi end,
              ",subsop(j = NULL,eq_list));
            if " <> [] then op(1,sort(")) else op(1,"") fi
        fi;
        traperror(convert(isolate(eq_list[j],"),'radical'));
        if " = lasterror or not lhs(") = "" or has(rhs("),"") then
            RETURN(fail_3)
        else _C_eqs := [op(_C_eqs),"]; eq_list := subs("",eq_list)
        fi
    od;
    _C_eqs :=
        map((eq,C_eqs) -> lhs(eq) = subs(op(C_eqs),rhs(eq)),_C_eqs,_C_eqs);
    s_eq := traperror(simplify(isolate(subs(op(_C_eqs),s_eq),_s)));
    if " = lasterror or not lhs(") = _s or has(rhs("),_s) then
        RETURN(fail_6)
    fi;
    F_eq := subs(op(_C_eqs),s_eq,F_eq);
    [op(indets(F_eq,'string'))];
    map(proc(c,_C_eqs)
        options operator,arrow;
            if substring(c,1 .. 2) = _C and not has(_C_eqs,c) then c fi
        end                                                            ,",
        _C_eqs);
    if " = [] then RETURN(fail_4) fi;
    sort(map(proc(c)
             options operator,arrow;
                 if substring(c,1 .. 2) = _C then c fi
             end                                      ,"));
    sort(map(
        proc(c,s_eq) options operator,arrow; if not has(s_eq,c) then c fi end,
        ",s_eq));
    if " <> [] then Cs := " else Cs := "" fi;
    if nops(Cs) = 1 then op(1,Cs)
    elif type(rhs(F_eq),{`+`,`*`}) then
        map(
           proc(C,ops) options operator,arrow; if member(C,ops) then C fi end,
           Cs,[op(rhs(F_eq))]);
        if " <> [] then op(1,") else op(1,Cs) fi
    else op(1,Cs)
    fi;
    " = cat(_,F,1)(op(subs(s_eq,map(rhs,_C_eqs))));
    F_eq := subs(",rhs(F_eq));
    if has(F_eq,_s) then RETURN(fail_5)
    else
        map(proc(c)
            options operator,arrow;
                if substring(c,1 .. 2) = _C then c fi
            end                                      ,indets(F_eq,'string'));
        if " = [] then RETURN((f = simplify(F_eq)) &Where {})
        else
            sort([op(")]);
            {seq("[j] = cat(''_C'',j),j = 1 .. nops("))};
            RETURN((f = simplify(subs(",F_eq))) &Where {})
        fi
    fi
end:
#####################################################################
`pdsolve/INTEGRATE` := 
proc(`ODE's`)
local ode,Sol,res,count;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    Sol := `ODE's`;
    count := 0;
    for ode in Sol do
        indets(ode,'Function') intersect _Env_S0;
        if 1 < nops(") then
            {op(1,sort([op(")],(a,b) -> lexorder(op(0,a),op(0,b))))}
        fi;
        res := traperror(dsolve(ode,"));
        if res <> NULL and res <> lasterror then
            count := count+1; Sol := subs(ode = {res},Sol)
        fi
    od;
    if 1 < count then `pdsolve/INTEGRATE/_C`(Sol) else Sol fi
end:
#####################################################################
`pdsolve/INTEGRATE/_C` :=
proc(Sol)
local i,j,jj,j_set,k,C_new,C_old,cop,guide,res,funcs;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    res := Sol;
    cop := select(type,Sol,'set');
    funcs := indets(cop,'Function');
    map(
     proc(u) if traperror(substring(op(0,u),1 .. 1)) = '_' then u fi end,funcs
     );
    sort([op(map(u -> op(0,u),"))]);
    sort([op(funcs minus {op("")})],
        proc(a,b) if type(a,'unknown') then 'true' else 'false' fi end);
    guide := [op(""),op(")];
    k := 0;
    for j in guide do
        jj := `pdsolve/select`(cop,j);
        if jj = {} then next fi;
        cop := cop minus jj;
        for j_set in jj do
            C_new := NULL;
            C_old := sort([op(indets(j_set,'string'))]);
            for i in C_old do
                if substring(i,1 .. 2) = '_C' then
                    k := k+1; C_new := C_new,i = cat('_C',k)
                fi
            od;
            res := subs(j_set = subs({C_new},j_set),res)
        od
    od
end:
#####################################################################
`pdsolve/first_order` :=
proc(A1,F,derivatives,diff_vars,not_diff_var1,not_diff_var2,Case_has_F)
local ee,j,uu,i,n,arb_func,a1,g,derivs,hint,go_ahead,tt,vars,not_var,u_x,
    frozenA1,frozenset,check,check1,dt;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    if has(A1,{_s,_p}) then subs({_p = i,_s = j},A1) else A1 fi;
    if not has(strip(",F),_p) then
        traperror(pdsolve(",op(0,F),'HINT' = 'strip'));
        if type(",'`&Where`'('anything','anything')) and not has(",'_s') then
            traperror(map(collect,",_Env_vars));
            if " <> lasterror then " else "" fi;
            RETURN(subs({j = _s,i = _p},"))
        fi
    fi;
    go_ahead := 'true';
    derivs := [op(usediff(derivatives))];
    if nops(derivs) = 2 and type(A1,linear({op(derivs)})) and
        frontend(expand,[subs({derivs[1] = 0,derivs[2] = 0},A1)]) = 0 then
        vars := [op(2,derivs[1]),op(2,derivs[2])];
        tt := proc(A1,deriv) local uu; diff(subs(deriv = uu,A1),uu) end;
        g[1] := int(tt(A1,derivs[1]),op(2,vars));
        g[2] := int(tt(A1,derivs[2]),op(1,vars));
        uu := simplify(g[1]+g[2]);
        `pdsolve/select`(indets(uu,'string'),{op(vars)});
        if uu = 0 then g[1]
        elif nops(") = 1 and member(op("),vars,'n') and
            has(g[map(proc(u) if u = 2 then 1 else 2 fi end,n)],uu) then
            g[map(proc(u) if u = 2 then 1 else 2 fi end,n)]
        else
            for i to 2 do
                dt := derivs[1],derivs[2],derivs[1];
                not_var := op(subsop(i = NULL,vars));
                hint := frontend(expand,[A1*h(op(i,vars))]);
                int(tt(hint,dt[i]),not_var)+gx(op(i,vars));
                int(tt(hint,dt[i+1]),vars[i])+gy(not_var);
                `pdsolve/select`(diff(""-",op(i,vars)),not_var,`+`);
                traperror(dsolve(",h(op(i,vars))));
                if " = lasterror or has(",not_var) then
                    if i = 1 then next else go_ahead := false; break fi
                else break
                fi
            od;
            if go_ahead then
                hint := expand(subs(",hint));
                g[1] := frontend(expand,[int(tt(hint,derivs[1]),op(2,vars))]);
                g[2] := frontend(expand,[int(tt(hint,derivs[2]),op(1,vars))]);
                g[1]-g[2];
                if type(",`+`) then {op(")} else {"} fi;
                sum(op(j,"),j = 1 .. nops("));
                if diff(",op(2,vars)) = tt(hint,derivs[1]) and
                    diff(",op(1,vars)) = -tt(hint,derivs[2]) then
                    "
                else go_ahead := false
                fi
            fi
        fi;
        if go_ahead then
            [op(args[5]),op(args[6])];
            cat(''_'',op(0,F),1),";
            RETURN((F = "[1](""",op("[2]))) &Where {})
        fi
    fi;
    uu := 'uu';
    go_ahead := 'true';
    u_x := {seq(uu[i] = diff_vars[i],i = 1 .. nops(diff_vars))};
    map(v -> rhs(v) = lhs(v),");
    select(proc(d,f) if op(op(0,d)) = f then 'true' else 'false' fi end,
        indets(useD(A1),'De'),op(0,F));
    frozenset := {seq("[i] = subs("","[i]),i = 1 .. nops("))},F = subs("",F);
    frozenA1 := subs(",useD(A1));
    if Case_has_F and 2 <= nops(diff_vars) then
        for i in diff_vars do
            diff(frozenA1,i);
            if not " = 0 then go_ahead := 'false'; break fi
        od;
        if not_diff_var1 <> [] then
            if has(subs(F = uu,A1),not_diff_var1) then go_ahead := false
            else arb_func := cat(''_'',op(0,F),1)(op(not_diff_var1))
            fi
        else arb_func := _C1
        fi;
        if go_ahead then
            hint :=
            phi(sum(_c[j]*diff_vars[j],j = 2 .. nops(diff_vars))+diff_vars[1])
            ;
            (eval @ subs)(F = hint,A1);
            subs(op(hint) = uu,");
            [traperror(dsolve(",phi(uu),'explicit'))];
            if " = [lasterror] or " = [] then
                [traperror(dsolve("",phi(uu)))];
                if " = [lasterror] or " = [] then RETURN(FAIL) fi
            fi;
            check := map(isolate,",phi(uu));
            check1 := [];
            for i in check do
                if lhs(i) = phi(uu) and not has(rhs(i),phi(uu)) and
                    diff(rhs(i),uu) <> 0 then
                    check1 := [op(check1),i]
                fi
            od;
            if check1 <> [] then
                F = subs({uu = op(hint),_C1 = arb_func},rhs(op(1,")));
                RETURN(" &Where {})
            fi
        fi
    fi;
    go_ahead := 'true';
    if Case_has_F then
        ee := {};
        a1 := useD(A1);
        for i in diff_vars do
            diff(frozenA1,i);
            traperror(sign("));
            if " = lasterror then go_ahead := 'false'; break
            else
                ee := {",op(ee)};
                if subs(u_x,""") <> sign(""")*useD(diff(F,i)) then
                    go_ahead := 'false'; break
                else a1 := a1-subs(u_x,""")*i
                fi
            fi
        od;
        if go_ahead and nops(ee) = 1 then
            if subs(uu = F,diff(subs(F = uu,a1),uu)) <> -op(ee) then
                go_ahead := 'false'
            else
                if not_diff_var1 <> [] then
                    arb_func := seq(cat(''_'',op(0,F),i)(op(not_diff_var1)),
                        i = 1 .. nops(diff_vars))
                else
                    arb_func :=
                        seq(cat(''_'','c')[i],i = 1 .. nops(diff_vars))
                fi;
                for j in diff_vars do
                    diff(subs(frozenset,a1),j);
                    if not " = 0 then go_ahead := 'false'; break
                    else next
                    fi
                od
            fi;
            if go_ahead then
                hint := usediff(A1);
                for i to nops(diff_vars) do
                    hint := subs(diff(F,op(i,diff_vars)) = arb_func[i],hint)
                od;
                hint := isolate(hint,F);
                RETURN(hint &Where {})
            fi
        fi
    fi;
    RETURN('FAIL')
end:
#####################################################################
`pdsolve/second_order` :=
proc(a1::{`=`,algebraic},F::function,derivatives,diff_vars,N)
local eq,aux,Coeff,res,x,y,a,b,c,Sol,nome,Case,elliptic,hyperbolic,parabolic;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    map(proc(u) if odiff(u) = 2 then u fi end,derivatives);
    if not type(a1,linear(")) then RETURN('FAIL') fi;
    eq := a1;
    x := op(1,diff_vars);
    y := op(2,diff_vars);
    nome := op(0,F);
    a := coeff(eq,useD(diff(F,x,x)));
    b := 1/2*coeff(eq,useD(diff(F,x,y)));
    c := coeff(eq,useD(diff(F,y,y)));
    Coeff := 1;
    map(proc(u)
        options operator,arrow;
            if not type(evalf(u),'numeric') then FAIL fi
        end                                             ,{a,c,b});
    if has(",FAIL) then
        subs(0 = NULL,[a,b,c]);
        if " = [] then RETURN('FAIL') else Coeff := op(1,") fi;
        aux :=
            map((u,v) -> factor(numer(u/v))/factor(denom(u/v)),[a,b,c],Coeff);
        map(proc(u)
            options operator,arrow;
                if not type(evalf(u),'numeric') then FAIL fi
            end                                             ,aux);
        if has(",FAIL) then RETURN('FAIL')
        else
            eq := normal(eq/Coeff);
            a := op(1,aux);
            b := op(2,aux);
            c := op(3,aux)
        fi
    fi;
    evalf(b^2-a*c);
    if is(0 < ") then
        Case := hyperbolic;
        if b = 0 or a = 0 and c = 0 then RETURN(''ok'') fi
    elif " = 0 then Case := parabolic; if b = 0 then RETURN(''ok'') fi
    elif is(" < 0) then Case := elliptic; if b = 0 then RETURN(''ok'') fi
    else RETURN('FAIL')
    fi;
    cat(`pdsolve/second_order/`,Case)(eq,[a,b,c],[x,y],N);
    if type(",'list') and nops(") = 3 then
        Sol := ";
        _Env_check_info := 'true';
        res := pdsolve(Sol[1]*Coeff,nome);
        if traperror(op(0,res)) = `&Where` then
            (F = rhs(op(1,res))) &Where {op(op(2,res)),`&and`(Sol[2])}
        else 'FAIL'
        fi
    else 'FAIL'
    fi
end:
#####################################################################
`pdsolve/second_order/hyperbolic` :=
proc(eqhyp::{`=`,algebraic},cof::list,vars::list,N)
local a,b,c,x,y,Jac,tr,itr;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    b := cof[2];
    if cof[1] <> 0 then a := cof[1]; c := cof[3]; x := vars[1]; y := vars[2]
    else a := cof[3]; c := cof[1]; x := vars[2]; y := vars[1]
    fi;
    itr := (b+sqrt(b^2-a*c))/a,(b-sqrt(b^2-a*c))/a;
    itr := [cat(_xi,N) = y-x*itr[1],cat(_xi,N+1) = y-x*itr[2]];
    Jac := (itr,x,y) -> diff(rhs(itr[1]),x)*diff(rhs(itr[2]),y)-
        diff(rhs(itr[1]),y)*diff(rhs(itr[2]),x);
    if Jac(itr,x,y) = 0 then
        itr := [cat(_xi,N) = y+x,cat(_xi,N+1) = x-y];
        if Jac(itr,x,y) = 0 then RETURN('FAIL') fi
    fi;
    tr := solve({op(itr)},{x,y});
    if " <> NULL then
        RETURN([dchange(
        tr,eqhyp,{op(itr)},[cat(_xi,N),cat(_xi,N+1)],u -> frontend(expand,[u])
        ),{op(itr)},tr])
    else RETURN('FAIL')
    fi
end:
#####################################################################
`pdsolve/second_order/parabolic` :=
proc(eqpar::{`=`,algebraic},cof::list,vars::list,N)
local a,b,x,y,tr,itr,Jac;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    x := vars[1];
    y := vars[2];
    a := cof[1];
    b := cof[2];
    y-b/a*x;
    itr := [cat(_xi,N) = 1/2*"+x,cat(_xi,N+1) = "];
    Jac := (itr,x,y) -> diff(rhs(itr[1]),x)*diff(rhs(itr[2]),y)-
        diff(rhs(itr[1]),y)*diff(rhs(itr[2]),x);
    if Jac(itr,x,y) = 0 then
        itr := [cat(_xi,N) = """+2*y,itr[2]];
        Jac(itr,x,y);
        if " = 0 then RETURN('FAIL') fi
    fi;
    tr := solve({op(itr)},{x,y});
    if " <> NULL then
        RETURN([dchange(
        tr,eqpar,{op(itr)},[cat(_xi,N),cat(_xi,N+1)],u -> frontend(expand,[u])
        ),{op(itr)},tr])
    else RETURN('FAIL')
    fi
end:
#####################################################################
`pdsolve/second_order/elliptic` :=
proc(equel::{`=`,algebraic},cof::list,vars::list,N)
local a,b,c,x,y,x1,y1,tr,itr;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    a := cof[1];
    b := cof[2];
    c := cof[3];
    x := vars[1];
    y := vars[2];
    map(assume,{y1,x1},'real');
    y1-(b+I*sqrt(a*c-b^2))/a*x1;
    [cat(_xi,N) = Re("),cat(_xi,N+1) = Im(")];
    itr := subs({x1 = x,y1 = y},");
    diff(rhs(itr[1]),x)*diff(rhs(itr[2]),y)-
        diff(rhs(itr[1]),y)*diff(rhs(itr[2]),x);
    if " = 0 then RETURN('FAIL') fi;
    tr := solve({op(itr)},{x,y});
    if tr <> NULL then
        RETURN([dchange(
        tr,equel,{op(itr)},[cat(_xi,N),cat(_xi,N+1)],u -> frontend(expand,[u])
        ),{op(itr)},tr])
    else RETURN('FAIL')
    fi
end:
#####################################################################
`pdsolve/sep` :=
proc(a1,derivatives,non_separated,not_diff_var1,not_diff_var2)
local `ODE's`,a,n,n_separated,candidate,ode,res,divisor,cop,Case_fail,
    checking,multivar,n_s_L;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    `ODE's` := {};
    res := a1;
    n_s_L := map(
        proc(x,res) options operator,arrow; if has(res,x) then x fi end,
        non_separated,a1);
    n_separated := {op(")};
    Case_fail := 'false';
    checking := NULL;
    for a in n_s_L do
        if member(a,not_diff_var2) then next
        elif has([checking],a) then next
        elif member(a,not_diff_var1) then a := {op(not_diff_var1)}
        else a := {a}
        fi;
        checking := checking,a;
        if has(res,n_separated minus a) then
            if hastype(res,`^`) then
                res := frontend(expand,[res],[{`+`,`*`,`^`},{}])
            fi;
            if type(res,`+`) then
                select(() -> not has(args),res,a);
                if " = 0 then multivar := 'true'
                else
                    `pdsolve/select`(",n_separated minus a,`+`);
                    multivar := 'false'
                fi;
                if "" = 0 then
                    `pdsolve/select`(res,a,`+`);
                    ",derivatives minus `pdsolve/select`(derivatives,a),
                        n_separated,a,multivar;
                    `pdsolve/rearrange`(");
                    if " = 'FAIL' then next
                    else
                        res := res-"""+"[1];
                        divisor := ""[2];
                        cop := map((u,divisor) -> u/divisor,res,divisor)
                    fi
                else cop := res
                fi
            else cop := res
            fi;
            `pdsolve/select`(cop,a,`+`);
            if has(",n_separated minus a) then
                factor("); candidate := `pdsolve/select`(",a)
            else candidate := "
            fi
        else cop := res; candidate := res
        fi;
        `pdsolve/select`(indets(candidate,'string'),{op(_Env_vars)});
        if " = a then
            if
             `pdsolve/trap`(candidate,n_separated minus {op(not_diff_var2)},a)
              then
                if n_separated minus {op(not_diff_var2)} = a then
                    Case_fail := 'true'; break
                else next
                fi
            fi;
            n_separated :=
                map(proc(u,cop) if has(cop,u) then u fi end,n_separated,cop)
                minus a;
            if nops(n_separated) = 0 then 0
            else member(op(1,a),_Env_vars,'n'); _c[n]
            fi;
            ode := candidate = ";
            res := cop
        else next
        fi;
        ode := `pdsolve/LHS_of_ode`(ode,op(1,a),derivatives);
        if not has(cop,lhs(")) and has(cop,1/lhs(")) then
            ode := map(u -> 1/u,ode)
        fi;
        if has(ode,{op(_Env_vars)} minus a) then ERROR(`Unexpected error`)
        fi;
        `ODE's` := {",op(`ODE's`)};
        if nops(n_separated) = 0 then res := 0; break fi;
        cop := res;
        res := frontend(expand,[subs(`ODE's`,res)]);
        if has(res,a) then
            lhs(ode);
            if type(",{`+`,`*`}) then
                indets(",`^`);
                [op(`pdsolve/select`(",[diff,a])),
                    op(`pdsolve/select`(",[op(a)])),
                    op(`pdsolve/select`(indets("",'function'),a))];
                isolate(ode,"[1])
            else ode
            fi;
            res := frontend(expand,[subs(",res)]);
            if has(res,a) then
                (combine @ expand)(res);
                res := factor(numer("))/factor(denom("))
            fi;
            if has(res,a) then
                indets(`ODE's`) intersect {op(_Env_vars)};
                select(has,indets(usediff(cop),'Function') intersect _Env_S0,a
                    );
                res := useD(pdtest(cop,
                 `pdsolve/res`(cop,(op(1,") = op(1,")) &Where {op(`ODE's`)},0)
                 ));
                if has(res,a) then
                    n_separated := n_separated union a;
                    res := cop;
                    `ODE's` := `ODE's` minus {ode}
                fi
            fi
        fi
    od;
    if n_separated = {} or n_separated = {op(n_s_L)} or Case_fail then
        RETURN(res,derivatives,[op(n_separated)],`ODE's`,Case_fail)
    elif n_separated minus {op(not_diff_var2)} = {} then
        RETURN(0,derivatives,[],`ODE's` union {res = 0},Case_fail)
    elif n_separated minus {op(not_diff_var1)} = {} then
        `pdsolve/trap`(res,n_separated,{op(not_diff_var1)});
        if " then RETURN(res,derivatives,[],`ODE's`,")
        else RETURN(0,derivatives,[],`ODE's` union {res = 0},")
        fi
    elif `pdsolve/re_enter`(map(op,[checking]),n_separated) then
        proc(u,n_separated)
            {op(u)}; if " intersect n_separated = " then u fi
        end;
        map(",derivatives,n_separated);
        `pdsolve/sep`(res,",[op(n_separated)],not_diff_var1,not_diff_var2);
        RETURN("[1 .. 3],{op("[4]),op(`ODE's`)},"[5]);
    else RETURN(res,derivatives,[op(n_separated)],`ODE's`,Case_fail)
    fi
end:
#####################################################################
`pdsolve/re_enter` := 
proc(checking,n_separated)
local i;
    for i to nops(checking)-1 do
        if has(n_separated,op(i,checking)) and
            not has(n_separated,op(i+1,checking)) then
            RETURN(true)
        fi
    od;
    false
end:
#####################################################################
`pdsolve/solve_c` := 
proc(ode,f,ODES)
local C,c,c_set,cs,arb_c,sol;
    if type(ode,`=`) then C := lhs(ode)-rhs(ode) else C := ode fi;
    cs := map(
       proc(c)
       options operator,arrow;
           if member(op(0,c),{'_k','_c'}) or traperror(searchtext('_C',c)) = 1
                then
               c
           fi
       end
       ,indets(C,'name'));
    if " = {} then RETURN('FAIL')
    else
        sol := [solve(C,cs)];
        if sol = [NULL] then RETURN(FAIL)
        elif not has(sol,{op(f)}) then
            map(s -> map(proc(eq)
                         options operator,arrow;
                             if lhs(eq) <> rhs(eq) then eq fi
                         end                                 ,s),sol);
            sort(",proc(a,b)
                   options operator,arrow;
                       if nops(a) <= nops(b) then 'true' else 'false' fi
                   end                                                  );
            RETURN(`pdsolve/choose_c`(",ODES))
        else
            for c_set in sol do
                if not has(c_set,{op(f)}) then
                    `pdsolve/choose_c`([c_set],ODES);
                    if " <> 'FAIL' then RETURN(") fi
                fi;
                map(proc(eq)
                    options operator,arrow;
                        if lhs(eq) = rhs(eq) then eq fi
                    end                                ,c_set);
                if " = {} then next fi;
                c_set := c_set minus ";
                arb_c := map(lhs,"");
                map(
                 proc(s) options operator,arrow; if 0 < nops(s) then s fi end,
                 combinat[powerset](arb_c));
                sort([op(")],
                    proc(a,b)
                    options operator,arrow;
                        if nops(a) <= nops(b) then 'true' else 'false' fi
                    end                                                  );
                for c in " do
                    map(u -> u = 0,c);
                    traperror(subs(",c_set));
                    if
                      " <> lasterror and not has(frontend(expand,["]),{op(f)})
                       then
                        `pdsolve/choose_c`([" union ""],ODES);
                        if " <> FAIL then RETURN(" union """) fi
                    fi
                od
            od
        fi;
        map(proc(s) options operator,arrow; if 0 < nops(s) then s fi end,
            combinat[powerset](cs));
        sort([op(")],proc(a,b)
                     options operator,arrow;
                         if nops(a) <= nops(b) then 'true' else 'false' fi
                     end                                                  );
        for c in " do
            map(u -> u = 0,c);
            if traperror(frontend(expand,[subs(",C)])) = 0 then
                `pdsolve/choose_c`(["],ODES);
                if " <> 'FAIL' then RETURN(" union "") fi
            fi
        od
    fi;
    FAIL
end:
#####################################################################
`pdsolve/choose_c` := 
proc(c_sol::list(set),ODES::set)
local i,badness;
    if ODES = {} then RETURN(op(1,c_sol)) fi;
    badness := [];
    for i to nops(c_sol) do
        traperror(subs(c_sol[i],ODES));
        if " <> lasterror and not has(",map(lhs,c_sol[i])) then
            if nops(c_sol) = 1 then RETURN(op(c_sol)) fi;
            map(ode -> [
             lhs(ode)-rhs(ode),map(op,indets(ode,'unknown') intersect _Env_S0)
             ],");
            map(ode_args -> `pdsolve/trap`(op(ode_args)),[op(")]);
            if {op(")} = {'false'} then RETURN(c_sol[i])
            else
                badness := [op(badness),[i,nops(map(
                 proc(u) options operator,arrow; if u = 'true' then u fi end,"
                 ))]]
            fi
        fi
    od;
    if badness <> [] then
        sort(badness,proc(a,b)
                     options operator,arrow;
                         if a[2] <= b[2] then 'true' else 'false' fi
                     end                                            );
        op(op(1,")[1],c_sol);
        RETURN(")
    fi;
    'FAIL'
end:
#####################################################################
`pdsolve/trap` := 
proc(de::algebraic,n_separated::set)
local derivatives,func,f,uu,U,candidate,a;
    if nargs = 2 then a := args[2] else a := args[3] fi;
    if a = n_separated then candidate := usediff(de) = 0
    else candidate := usediff(de) = _c[0]
    fi;
    if not assigned(_Env_funcs) then
        f := map(u -> op(0,u),`pdsolve/select`(_Env_S0,a))
    else
        ({op(_Env_funcs)} union _Env_fhint) union map(u -> op(0,u),_Env_S0);
        f := map(
          proc(u,can) options operator,arrow; if has(can,u) then u fi end,",de
          );
        _Env_S0 := select(has,indets(candidate,'unknown'),"") union _Env_S0
    fi;
    if not has(de,f) then RETURN('true') fi;
    derivatives := select(has,indets(useD(de),'De'),f);
    if derivatives <> {} then
        if rhs(candidate) <> 0 then RETURN('false')
        else
            map(proc(deriv)
                options operator,arrow;
                    if 1 < nops(deriv) then deriv fi
                end                                 ,derivatives);
            if " <> {} then RETURN('false') fi
        fi;
        derivatives := usediff(derivatives);
        map(odiff,derivatives);
        max(0,op("));
        if 1 < " then RETURN('false') fi
    fi;
    f := map(
       proc(func,de) options operator,arrow; if has(de,func) then func fi end,
       select(has,_Env_S0,f),lhs(candidate));
    candidate := lhs(candidate)-rhs(candidate);
    for func in f do
        select(has,derivatives,func);
        if " = {} then U := func
        elif nops(") = 1 then U := op(1,")
        else
            U := op(1,sort([op(")],
                proc(a,b)
                options operator,arrow;
                    if odiff(b) <= odiff(a) then 'true' else 'false' fi
                end                                                    ))
        fi;
        traperror(simplify(subs(U = 0,candidate)));
        if " = lasterror then
            traperror(simplify(subs(U = 0,normal(denom(candidate)*candidate)))
                )
        fi;
        if " = 0 then
            `pdsolve/solve_c`(subs(U = useD(U),candidate),func,{});
            if " = 'FAIL' then RETURN('true') else RETURN('false') fi
        elif U = func then
            {op(func)};
            if indets(normal(subs(func = uu,candidate))) intersect " = " then
                RETURN('false')
            fi
        else RETURN('false')
        fi
    od;
    'true'
end:
#####################################################################
`pdsolve/LHS_of_ode` :=
proc(ode,a)
local k,LHS;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    [op(`pdsolve/select`(indets(ode,'De'),a))];
    if " = [] then
        lhs(ode);
        if type(",'function') then ode
        elif type(",{`+`,`*`}) then
            if type(frontend(expand,["]),`*`) and rhs(ode) = 0 then
                RETURN(ode)
            fi;
            for k in op(") do
                if has(k,a) then
                    if type(k,function) then k
                    elif type(k,`^`) then op(2,k); op(1,k)^(sign(")*")
                    else next
                    fi;
                    traperror(isolate(ode,"));
                    if " = lasterror then next else break fi
                fi
            od
        elif type(",{`^`}) then
            op(2,");
            traperror(isolate(ode,op(1,"")^(sign(")*")));
            if " = lasterror then map(u -> 1/u,ode) else " fi
        else ode
        fi;
        if " = lasterror or not type(",`=`) then RETURN(ode)
        else RETURN(")
        fi
    elif has(",`$`) then LHS := `pdsolve/select`(",`$`)
    else
        LHS :=
          sort(",proc(a,b) if odiff(b) < odiff(a) then true else false fi end)
          [1]
    fi;
    `pdsolve/select`(indets(ode,`^`),LHS);
    for k in " do
        op(2,k);
        if not type(",'Numeric') then LHS := k; break
        elif type(LHS,`^`) then if op(2,LHS) < evalf(") then LHS := k fi
        elif 1 < evalf(") then LHS := k
        fi
    od;
    traperror(isolate(ode,LHS));
    if " = lasterror or " = (LHS = 0) then factor(ode)
    else
        collect(",`pdsolve/select`(indets(",'indexed'),_c),
            proc(u) local Sin; subs(Sin = sin,simplify(subs(sin = Sin,u))) end
            )
    fi
end:
#####################################################################
`pdsolve/den` :=
proc(a1,non_separated)
local res,irreducible_terms,ns,d,candidates,k,prd;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    res := frontend(expand,[a1]);
    if not type(res,`+`) then RETURN(a1) fi;
    irreducible_terms := {};
    for ns in non_separated do
        `pdsolve/select`(res,ns,`+`);
        d := denom(");
        if has(d,ns) then
            candidates := {};
            if type(d,`*`) then
                for k in subs(ns = NULL,non_separated) do
                    `pdsolve/select`(d,k);
                    if has(",ns) then
                        candidates := {op(candidates),`pdsolve/select`(",ns)}
                    fi
                od
            elif has(d,subs(ns = NULL,non_separated)) then
                candidates := {op(candidates),d}
            fi
        else next
        fi;
        irreducible_terms := {op(candidates),op(irreducible_terms)}
    od;
    if irreducible_terms <> {} then
        prd :=
            product(irreducible_terms['k'],'k' = 1 .. nops(irreducible_terms))
            ;
        res := map((u,prd) -> simplify(u*prd),res,prd);
        if denom(res) <> 1 then
            for k in indets(prd,'name') intersect {op(non_separated)} do
                traperror(convert(",'parfrac',k));
                if " = lasterror then RETURN(res) else res := " fi
            od
        else RETURN(res)
        fi
    else RETURN(res)
    fi;
    res
end:
#####################################################################
`pdsolve/rearrange` :=
proc(expr,derivatives,n_separated::set,var,multivar)
local A,new_expr,other_vars,term,divisor;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    other_vars := n_separated minus var;
    frontend(expand,[expr]);
    traperror(
        collect(",select(has,indets(",function),other_vars),'distributed'));
    if " = lasterror then A := "" else A := " fi;
    A := expr;
    _Env_D := derivatives;
    _Env_Dx :=
        `pdsolve/select`(indets(A,'De'),[var,map(u -> op(0,u),_Env_S0)]);
    if not type(A,`+`) then
        A := frontend(expand,[A]); if not type(A,`+`) then RETURN(A,1) fi
    fi;
    new_expr := A;
    map(proc(u,v) options operator,arrow; if not has(u,v) then u fi end,
        map(`pdsolve/select`,[op(A)],other_vars),var);
    if nops(") = nops(A) then
        {op(")}; if nops(") = 1 then RETURN(new_expr,1) fi
    fi;
    map(proc(u,v) options operator,arrow; if not has(u,v) then u fi end,
        map(`pdsolve/select`,[op(A)],var),other_vars);
    if nops(") = nops(A) then
        {op(")};
        if nops(") = 1 then RETURN(new_expr,1)
        elif nops(") = 2 then
            sort([op(")],`pdsolve/rearrange/sort`); RETURN(new_expr,op(1,"))
        fi
    fi;
    divisor := 1;
    `pdsolve/select`(A,other_vars);
    if " = 0 then RETURN(new_expr,1)
    elif nops(") = nops(A) then
        map(`pdsolve/select`,[op(A)],[other_vars,var]);
        {op(")};
        if nops(") = 1 and has(",_Env_vars) then
            op(");
            if multivar then divisor := "; A := map((u,d) -> u/d,A,divisor)
            else
                frontend(expand,[1/"]);
                if type(",`+`) and not has(`pdsolve/select`(",var),other_vars)
                     then
                    RETURN(new_expr,"")
                fi
            fi
        fi
    else A := "
    fi;
    if not has(A,other_vars) then RETURN(new_expr,divisor)
    elif type(A,`+`) then sort([op(A)],`pdsolve/rearrange/sort`)
    else [A]
    fi;
    for term in " do
        if type(term,`^`) then
            factor(frontend(expand,[term],[{`+`,`*`,`^`},{}]))
        else factor(term)
        fi;
        if type(",`*`) then
            `pdsolve/select`(",var);
            if has(",var) and not has(",other_vars) then
                RETURN(new_expr,"*divisor)
            else next
            fi
        else next
        fi
    od;
    FAIL
end:
#####################################################################
`pdsolve/rearrange/sort` := 
proc(a,b)
    if not has(a,_Env_Dx) then 'true'
    elif not has(b,_Env_Dx) then 'false'
    else
        if has(a,_Env_D) then 'true'
        elif has(b,_Env_D) then 'false'
        else
            if has(a,_Env_S0) then 'true'
            elif has(b,_Env_S0) then 'false'
            else
                if hastype(a,'unknown') then 'true'
                elif hastype(b,'unknown') then 'false'
                else 'true'
                fi
            fi
        fi
    fi
end:
#####################################################################
build :=
proc(
a::`=` &Where list({set({`=`,set(`=`)}),function({name,function}),`&and`(set)})
)
local rem_aux,rem_ODE,N,target,odes,ODE,and_func,func_names,solved_odes,F,
    mimic,case_remaining,remaining,eliminated,f,i,res;
    target := op(1,a);
    op(2,a);
    and_func := op(`pdsolve/select`(",`&and`));
    op(1,"");
    if type(",'set') then odes := " else odes := {} fi;
    if odes = {} then
        if and_func = NULL then RETURN(op(1,a))
        else
            'known' = map(
              proc(f,x)
              options operator,arrow;
                  if substring(op(0,f),1 .. 1) = '_' and has(f,x) then op(0,f)
                  fi
              end
              ,indets(target,'function'),map(lhs,op(and_func)));
            RETURN(dchange(op(and_func),target,"))
        fi
    else
        N := nops(odes);
        remaining := {};
        solved_odes := {};
        if and_func = NULL then {op(lhs(target))}
        else {op(lhs(target)),op(map(lhs,op(and_func)))}
        fi;
        _Env_S0 := select(has,indets(usediff(rhs(target)),'unknown'),");
        mimic := F(op(""));
        func_names := map(f -> op(0,f),_Env_S0);
        odes := map(proc(u)
                    options operator,arrow;
                        if type(u,'set') then op(1,u) else u fi
                    end                                        ,[op(odes)]);
        for i to nops(odes) do
            if nops(odes) < i then break fi;
            indets(odes[i],{'diff','De'});
            if not has(",func_names) then
                ODE := odes[i];
                odes := subs(ODE = NULL,odes);
                i := i-1;
                eliminated := 'false';
                case_remaining := 'false';
                map(proc(f,ode)
                    options operator,arrow;
                        if has(ode,f) then f fi
                    end                        ,_Env_S0,ODE);
                for f in " do
                    lhs(ODE)-rhs(ODE);
                    traperror(simplify(subs(f = 0,")));
                    if " = lasterror then
                        traperror(simplify(subs(f = 0,normal(denom("")*""))))
                    fi;
                    if " = lasterror then case_remaining := 'true'; next
                    elif " = 0 then
                        `pdsolve/solve_c`(
                            ODE,f,{op(odes),op(solved_odes),op(remaining)});
                        if " = FAIL then case_remaining := 'true'; next
                        else
                            [(eval @ subs)(",odes),
                                (eval @ subs)(",solved_odes),
                                (eval @ subs)(",remaining),
                                (eval @ subs)(",target)];
                            zip(assign,
                                ['odes','solved_odes','remaining','target'],")
                                ;
                            i := 0;
                            eliminated := 'true';
                            break
                        fi
                    fi
                od;
                if not eliminated then
                    if case_remaining then
                        remaining := remaining union {ODE}
                    else solved_odes := solved_odes union {ODE}
                    fi
                fi
            fi
        od;
        odes := {op(odes)} minus (remaining union solved_odes);
        rem_aux := {};
        if odes <> {} then
            _Env_S0 := map(proc(f,odes)
                           options operator,arrow;
                               if has(odes,op(0,f)) then f fi
                           end                               ,_Env_S0,odes);
            `pdsolve/INTEGRATE`(odes);
            remaining := remaining union (" intersect odes);
            solved_odes := solved_odes union ("" minus odes);
            for ODE in """ minus odes do
                rem_aux :=
                 rem_aux union {[ODE,indets(ODE,'unknown') intersect _Env_S0]}
            od
        fi;
        if solved_odes <> {} then
            target,(lhs(target) = mimic) &Where [solved_odes];
            res := Value((eval @ subs)(
                {'int' = `pdsolve/expand/Int`,'Int' = `pdsolve/expand/Int`},
                pdtest(")))
        else
            print(`Warning: unable to build the solution`);
            print('______________________________________________________');
            print(` `);
            RETURN(args)
        fi
    fi;
    func_names := indets(res,'unknown');
    for rem_ODE in rem_aux do
        op(2,rem_ODE);
        if func_names intersect " = " then
            remaining := remaining union {op(1,rem_ODE)}
        fi
    od;
    if and_func = NULL then lhs(target) = rhs(isolate(res,mimic))
    else
        'known' = map(
           proc(f,x)
           options operator,arrow;
               if substring(op(0,f),1 .. 1) = '_' and has(f,x) then op(0,f) fi
           end
           ,indets(target,'function'),map(lhs,op(and_func)));
        lhs(target) = dchange(
            op(and_func),rhs(isolate(res,mimic)),",u -> frontend(expand,[u]))
    fi;
    if has(",'RootOf') then
        traperror(convert(",'radical')); if " = lasterror then "" fi
    else "
    fi;
    if remaining <> {} then
        if nops(remaining) = N then
            print(`Warning: unable to build the solution`); op(1,a)
        else print(`Warning: the solution has been only partially built`)
        fi;
        print('______________________________________________________');
        print(` `);
        " &Where [remaining]
    else "
    fi
end:
#####################################################################
strip :=
proc(eq::{`=`,algebraic},g::function)
local f,S,res,j,derivs,cop;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    if not has(eq,{diff,Diff,'D'}) then
        ERROR(eq,`is not a differential equation`)
    elif type(eq,`=`) then res := usediff(lhs(eq)-rhs(eq))
    else res := usediff(eq)
    fi;
    indets(res,'De');
    if not " = {} then ERROR(`strip cannot handle derivatives such as`,")
    elif not has(res,g) then ERROR(`Your equation`,eq,`does not contain`,g)
    else f := op(0,g)
    fi;
    indets(res,specfunc(anything,f));
    if 1 < nops(") then
        ERROR(`strip expects an unique indeterminate function but received`,")
    else
        `pdsolve/select`(indets(res,'diff'),g);
        if " = {} then
            ERROR(eq,`is not a partial differential equation in`,g)
        elif map(odiff,") <> {1} then
            ERROR(
`strip cannot yet handle equations of differential order higher than one`
            )
        fi
    fi;
    derivs := {seq(diff(g,op(j,g)) = _p[j],j = 1 .. nops(g))};
    res := useD(subs(derivs,g = f,res));
    S := 0;
    for j to nops(g) do  S := S+useD(diff(res,_p[j]))*_p[j] od;
    traperror(simplify(S,{res},{seq(_p[j],j = 1 .. nops(g))}));
    if " = lasterror then S := {Diff(f,_s) = simplify(S)}
    else S := {Diff(f,_s) = frontend(expand,["])}
    fi;
    for j to nops(g) do
        S :=
         S union {Diff(op(j,g),_s) = frontend(expand,[useD(diff(res,_p[j]))])}
    od;
    cop := S;
    do
        for j to nops(g) do
            if has(S,_p[j]) then
                S := S union {Diff(_p[j],_s) = frontend(
                    expand,[-useD(diff(res,op(j,g)))-useD(diff(res,f))*_p[j]])
                    }
            fi
        od;
        if S = cop then break else cop := S fi
    od;
    seq(op(j,g) = op(j,g)(_s),j = 1 .. nops(g));
    seq(_p[j] = _p[j](_s),j = 1 .. nops(g));
    S := usediff(subs({Diff = diff,f = f(_s),"","},S));
    if has(S,_p) then
        derivs := map(proc(u,S)
                      options operator,arrow;
                          if has(S,rhs(u)) then rhs(u) = lhs(u) fi
                      end                                         ,derivs,S);
        RETURN(S &Where derivs)
    else RETURN(S)
    fi
end:
#####################################################################
splitstrip :=
proc(PDE,F)
local sys,q,subset,others,Sets,eq_vars,add;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    strip(PDE,F);
    if type(",'`&Where`'('anything','anything')) then
        sys := op(1,"); add := op(2,"")
    else sys := "
    fi;
    map(proc(u) if op(u) = _s then u fi end,indets(sys,'function'));
    [op(map((u,vars) -> indets(u,'function') intersect vars,sys,"))];
    eq_vars :=
        sort(",proc(a,b) if nops(b) <= nops(a) then true else false fi end);
    Sets := {};
    for q in eq_vars do
        do
            subset := `pdsolve/select`(sys,q);
            nops(");
            if " = nops(sys) then
                if assigned(add) then RETURN({op(Sets),subset} &Where add)
                else RETURN({op(Sets),subset})
                fi
            elif " = 0 then break
            fi;
            proc(u) if op(u) = _s then u fi end;
            q := map(",indets(subset,'function'));
            others := map("",indets(sys minus subset,'function')) intersect q;
            if others = {} then
                Sets := {op(Sets),subset};
                sys := sys minus subset;
                if nops(sys) = 1 then
                    if assigned(add) then RETURN({op(Sets),sys} &Where add)
                    else RETURN({op(Sets),sys})
                    fi
                else break
                fi
            else q := q union others; next
            fi
        od
    od;
    if assigned(add) then RETURN(Sets &Where add) else RETURN(Sets) fi
end:
#####################################################################
pdtest := 
proc(a::{`=`,algebraic},b::{
    function({list({set({`=`,set(`=`)}),function}),`=`}),
    list({set({`=`,set(`=`)}),`=`})})
local L_eq,u,vars,iso_list,S,Kill_eqs,Kill_eqs1,uu,a1,candidates,func,F,Strip,
    w,v,n,target,aux,alpha;
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    if not (type(b,'`&Where`'(`=`,'list')) or type(b,'list')) then
        ERROR(`pdtest accepts as second argument either a "&Where"`.
            ` function or a list`)
    elif not type(op(1,b),`=`) then
        ERROR(`pdtest accepts as second argument either a list or a`.
            ` "&Where" function with an equation as first argument inside`)
    fi;
    if type(b,'function') and has(op(2,b),'_s') and not has(a,'_s') then
        Kill_eqs := map(simplify,indets(op(2,b),`=`));
        func := map(
            proc(u) options operator,arrow; if op(u) = _s then u fi end,
            indets(Kill_eqs,'unknown'));
        for w in indets(op(1,b),'Function') do
            if has(func,op(0,w)) then w; break fi
        od;
        F := ";
        strip(op(1,b),F);
        if type(",'function') then Strip := op(1,") else Strip := " fi;
        if has(Kill_eqs,Strip) then
            Kill_eqs := Kill_eqs minus Strip; Strip := Strip minus Kill_eqs
        fi;
        target := map(u -> combine((expand @ normal)(lhs(u)-rhs(u)),'power'),
            subs(Kill_eqs,Strip)) minus {0};
        if " = {} then RETURN(0)
        else
            for n in target do
                indets(n,'Function') intersect func;
                op(`pdsolve/select`(Kill_eqs,"));
                if " = {} then
                    (expand @ simplify)(n,trig);
                    target := subs(n = ",target) minus {0}
                else target := subs(n = pdtest(n,["]),target) minus {0}
                fi;
                if target = {} then RETURN(0) fi
            od;
            RETURN(target)
        fi
    else
        L_eq := lhs(op(1,b));
        if not type(L_eq,'Function') then
            indets(L_eq,'Function');
            if nops(") <> 1 then
                ERROR(`Unable to determine the indeterminate function`)
            else L_eq := op(")
            fi
        fi;
        op(1,b);
        if L_eq <> rhs(") then
            traperror(isolate(op(1,b),L_eq));
            if " = lasterror then ERROR(`Unable to check this result`)
            elif lhs(") <> L_eq then
                `PDEtools/print`(`Not implemented`); RETURN(a)
            fi
        fi;
        S(op(L_eq)) := subs('Diff' = 'diff',rhs("));
        if has(",RootOf) then
            traperror(convert(",'radical')); if " = lasterror then "" fi
        fi;
        if type(a,`=`) then a1 := usediff(lhs(a)-rhs(a))
        else a1 := usediff(a)
        fi;
        uu := (pde,u,S) -> frontend(
        expand,[(eval @ subs)({'Diff' = 'diff',u = S},pde)],[{`+`,`*`,`^`},{}]
        );
        if has(b,`&and`) then
            map(proc(u)
                options operator,arrow;
                    if op(0,u) = `&and` then (op @ op)(u) fi
                end                                         ,
                indets(op(2,b),'function'));
            ",{op(L_eq)} intersect indets(map(rhs,"),'string');
            dchange("[1],[a1,L_eq],solve("[1],"[2]),sort([op(map(lhs,"[1]))]))
                ;
            op("),S(op(L_eq))
        else a1,op(0,L_eq),S
        fi;
        traperror(uu("));
        if " <> lasterror then target := "
        else target := uu(frontend(expand,[numer(""[1])]),""[2 .. 3])
        fi;
        if target = 0 then RETURN(0) fi;
        map(proc(u)
            options operator,arrow;
                if op(0,u) = `&and` then u = NULL fi
            end                                     ,indets(b,'function'));
        if type(b,'list') then indets(subs(",b[2 .. nops(b)]),`=`)
        else
            op(1,op(2,b));
            if type(",'set') then
                map(proc(s,x)
                    local eq;
                        if type(s,'set') then
                            if 1 < nops(s) then
                                for eq in s do
                                    if has(rhs(eq),x) then break fi
                                od;
                                eq
                            else op(1,s)
                            fi
                        else s
                        fi
                    end                                            ,",
                    {op(L_eq)})
            else {}
            fi
        fi;
        Kill_eqs := usediff(");
        Kill_eqs1 := map(
          proc(u)
              lhs(u);
              if type(",'diff') or type(",`^`) and type(op(1,"),'diff') then u
              fi
          end
          ,Kill_eqs);
        traperror((eval @ subs)(",target));
        if " <> lasterror then target := "
        else target := (eval @ subs)("",numer(target))
        fi;
        if target = 0 then RETURN(0) fi;
        Kill_eqs := map(u -> lhs(u)-rhs(u),Kill_eqs minus Kill_eqs1) minus {0}
            ;
        if " = {} then RETURN(simplify(expand(target))) fi;
        vars := indets(op(1,b),'name');
        iso_list := [];
        indets(Kill_eqs,{function^algebraic,indexed^algebraic,'function'});
        candidates := map(
            proc(f,vars) options operator,arrow; if has(f,vars) then f fi end,
            ",vars);
        map(proc(f,w,target)
            options operator,arrow;
                if has(target,f) and not has(w minus {f},f) then f fi
            end                                                      ,",map(
            proc(f,tar) options operator,arrow; if has(tar,f) then f fi end,
            candidates,target),target);
        iso_list := sort([op(")],
          proc(a,b)
          options operator,arrow;
              if type(a,'function') and substring(op(0,a),1 .. 1) = '_' then
                  'true'
              elif type(b,'function') and substring(op(0,b),1 .. 1) = '_' then
                  'false'
              elif type(b,'unknown') then 'false'
              else 'true'
              fi
          end
          );
        candidates minus "";
        iso_list := [op(iso_list),op(sort([op(")],has))];
        if not iso_list = [] then
            for u in iso_list do
                for v in Kill_eqs do
                    if has(v,u) then
                        if has(target,1/u) then aux := 1/u
                        elif has(target,u) then aux := u
                        else next
                        fi;
                        traperror(isolate(v,u));
                        if " <> lasterror then
                            if has(",RootOf) then
                                traperror(convert(",'radical'));
                                if " = lasterror then "" fi
                            fi;
                            if lhs(") <> u and type(u,'Function') then
                                select(has,indets(target,'diff'),u);
                                if " <> {} then
                                    sort([op(")],
                                       proc(a,b)
                                       options operator,arrow;
                                           if odiff(b) <= odiff(a) then 'true'
                                           else 'false'
                                           fi
                                       end
                                       );
                                    subs(u = v,op(1,"));
                                    Kill_eqs := subs(v = ",Kill_eqs);
                                    u := op(1,""");
                                    v := """;
                                    traperror(isolate(v,u));
                                    if " = lasterror then next fi
                                else alpha*u = rhs("")-lhs("")+alpha*u
                                fi
                            fi;
                            if aux = 1/u then {map(p -> 1/p,"),"} fi;
                            traperror(
                              simplify(subs(alpha = 0,expand(subs(",target))))
                              );
                            if " <> lasterror and not has(",u) then
                                target := "
                            else
                                frontend(expand,[numer(target)]);
                                target :=
                                 simplify(subs(alpha = 0,expand(subs(""","))))
                                 ;
                                if has(target,u) then
                                    member(u,iso_list,'n');
                                    traperror(
                                        {op(iso_list[n+1 .. nops(iso_list)])});
                                    if has(v,") then break fi
                                fi
                            fi
                        else next
                        fi;
                        if target = 0 then RETURN(0)
                        else Kill_eqs := Kill_eqs minus {v}; break
                        fi
                    fi
                od
            od
        fi;
        if target = 0 then 0
        elif iso_list = [] or Kill_eqs = {} then (expand @ normal)(target)
        else
            indets(Kill_eqs) intersect
                (indets(target) intersect {op(iso_list)});
            traperror(simplify(target,Kill_eqs,"));
            if " <> lasterror then " else target fi
        fi
    fi
end:
#####################################################################
`pdsolve/Assigned` :=
proc(a) traperror(assigned(a)); if " = lasterror then 'false' else " fi end:
#####################################################################
`PDEtools/print` :=
proc()
    if not assigned(_Env_PDEtools_print) or _Env_PDEtools_print then
        print(args)
    fi
end:
#####################################################################
`pdsolve/select` :=
proc(a,b)
local i;
    if type(b,list) and 1 < nops(b) then
        a; for i in b do  `pdsolve/select`(",i) od; RETURN(")
    fi;
    proc(x) if has(args[1 .. 2]) then x else _identity fi end;
    if type(a,{set,list}) then map(subs(_identity = NULL,"),args)
    elif type(a,`+`) then
        map(subs(_identity = 0,"),frontend(expand,[args[1]]),args[2])
    elif not has([args],`+`) and type(a,`*`) then
        map(subs(_identity = 1,"),args)
    elif type(a,{'algebraic'}) then subs(_identity = 0,")(args)
    else ERROR(`not implemented`)
    fi
end:
#####################################################################
`pdsolve/expand/Int` :=
proc(f,dx)
local c,y,x;
options remember,`Date: 02/10/94`;
    if has(f,{'Int','int'}) then
        (eval @ subs)({'Int' = `pdsolve/expand/Int`,'int' = `expand/int`},f)
    else f
    fi;
    frontend(expand,["]);
    if hastype(",1/'algebraic') then y := frontend(expand,[factor(")])
    else y := "
    fi;
    x := op(1,dx);
    if type(y,`+`) then map(procname,y,args[2 .. nargs])
    elif type(y,`*`) then
        c := map(proc(g,x) if not has(g,x) then g else 1 fi end,y,x);
        if not has(y/c,x) then c*int(y/c,args[2 .. nargs])
        else c*Int(y/c,args[2 .. nargs])
        fi
    elif not has(y,x) then y*int(1,args[2 .. nargs])
    else Int(args)
    fi
end:
#####################################################################
`type/known` :=
proc(a)
options remember,`Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    disassemble(addressof(a));
    if "[1] = FUNCTION and (`pdsolve/Assigned`(cat(`diff/`,pointto("[2]))) or
        traperror(readlib(cat(`diff/`,pointto("[2])))) <> lasterror) then
        'true'
    else 'false'
    fi
end:
#####################################################################
`type/unknown` :=
proc(a)
options remember,`Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    disassemble(addressof(a));
    if not "[1] = FUNCTION or `pdsolve/Assigned`(cat(`diff/`,pointto("[2]))) or
        traperror(readlib(cat(`diff/`,pointto("[2])))) <> lasterror then
        'false'
    else 'true'
    fi
end:
#####################################################################
`type/De` :=
proc(a)
options `Copyright 1993 by E. S. Cheb-Terrab`,remember;
    if not has(a,'D') then RETURN('false') fi;
    disassemble(addressof(a));
    do
        if "[1] = FUNCTION or "[1] = TABLEREF then
            if "[2] = addressof('D') then RETURN('true')
            elif "[2] = addressof(`@@`) then
                if disassemble("[3])[2] = addressof('D') then RETURN('true')
                else RETURN('false')
                fi
            else disassemble("[2]); next
            fi
        else RETURN('false')
        fi
    od
end:
#####################################################################
`type/Int` :=
proc(a)
options `Copyright 1993 by E. S. Cheb-Terrab`,remember;
    disassemble(addressof(a));
    if "[1] = FUNCTION and "[2] = addressof('Int') then 'true' else 'false' fi
end:
#####################################################################
`type/int`:= subs('Int'='int',eval(`type/Int`)):
#####################################################################
`type/diff`:= subs('Int'='diff',eval(`type/Int`)):
#####################################################################
`type/Diff`:= subs('Int'='Diff',eval(`type/Int`)):
#####################################################################
`type/sum`:= subs('Int'='sum',eval(`type/Int`)):
#####################################################################
`type/Sum`:= subs('Int'='Sum',eval(`type/Int`)):
#####################################################################
`type/limit`:= subs('Int'='limit',eval(`type/Int`)):
#####################################################################
`type/Limit`:= subs('Int'='Limit',eval(`type/Int`)):
#####################################################################
`type/product`:= subs('Int'='product',eval(`type/Int`)):
#####################################################################
`type/Product`:= subs('Int'='Product',eval(`type/Int`)):
#####################################################################
`type/Function` :=
proc(a)
options `Copyright 1993 by E. S. Cheb-Terrab`,remember;
    disassemble(addressof(a));
    if "[1] = FUNCTION then
        if not ( member("[2],{addressof('Int'),addressof('int'),
            addressof('diff'),addressof('Diff'),addressof('limit'),
            addressof('Limit'),addressof('sum'),addressof('Sum')}) or
            ( has(a,'D') and type(a,'De') ) ) then
            'true'
        else 'false'
        fi
    else 'false'
    fi
end:
#####################################################################
`type/Numeric` :=
proc(x)
if type(x,'numeric') or evalf(x)<>x then 'true' else 'false' fi
end:
#####################################################################
`type/HINT` :=
proc(x)
options `Copyright 1994 by E. S. Cheb-Terrab & Katherina von Bulow`;
    if type(x,`=`) and lhs(x) = 'HINT' then
        rhs(x);
        if " = 'strip' or type(",'algebraic') then 'true' else 'false' fi
    else 'false'
    fi
end:
#####################################################################
#                   Taken from the "partials" package
#####################################################################
odiff :=
proc(a::algebraic)
local u,v,aux,name0,name1;
options `Copyright 1993 by E. S. Cheb-Terrab`,remember;
    if not member(nargs,{1,2}) then ERROR(`Invalid number of arguments`)
    elif type(a,{'Diff','diff'}) then u := useD(args[1])
    elif type(a,'De') then u := a
    else
        aux := indets(useD(a),'De');
        if aux = {} then RETURN(0)
        elif nargs = 1 then RETURN(max(op(map(odiff,aux))))
        else
            proc(u,x) if has([op(u)],x) then odiff(u,x) else 0 fi end;
            RETURN(max(op(map(",aux,args[2]))))
        fi
    fi;
    name1 := op(0,u);
    if type(name1,{'indexed','function'}) then
        name0 := op(0,name1);
        if not type(name0,{anything @@ anything,'name'}) then
            ERROR(`Cannot handle expressions as`,a)
        fi
    fi;
    if has(u,`$`) then
        ERROR(`Not implemented for objects containing $ as`,u)
    elif nargs = 2 and not has([op(u)],args[2]) then RETURN(0)
    elif name1 = 'D' then RETURN(1)
    elif name0 = `@@` then RETURN(op(2,name1))
    elif name0 = 'D' then
        if type(name1,'indexed') then RETURN(nops(name1))
        elif nops(u) = 1 then RETURN(1)
        else ERROR(`Multivariate use of D`)
        fi
    elif op(0,name0) = `@@` then
        if nops(u) = 1 then RETURN(op(2,name0))
        else ERROR(`Multivariate use of D`)
        fi
    elif not op(map(type,{op(name0)},'posint')) then
        if nargs = 1 then RETURN(nops([op(name0)]))
        else ERROR(`Unable to determinate`)
        fi
    elif max(op(name0)) <= nops(u) then
        if nargs = 1 then RETURN(nops(name0))
        else
            member(args[2],[op(u)],v);
            RETURN(nops(name0)-nops(subs(v = NULL,[op(name0)])))
        fi
    else
        nops(u);
        ERROR(`Index out of range: function takes only `.".` arguments`)
    fi
end:
#####################################################################
parameters := 
proc()
local i;
global `parameters/PARAMETERS`;
options `Copyright 1993 by E. S. Cheb-Terrab`;
    if `parameters/PARAMETERS` = '`parameters/PARAMETERS`' then
        `parameters/PARAMETERS` := {}
    fi;
    if 1 <= nargs then
        for i to nargs do
            `parameters/PARAMETERS` := {op(`parameters/PARAMETERS`),args[i]};
            assign(
            args[i],proc() options `p a r a m e t e r`; RETURN('procname') end
            )
        od
    fi;
    for i in `parameters/PARAMETERS` do
        if not has(eval(i),`p a r a m e t e r`) then
            `parameters/PARAMETERS` := `parameters/PARAMETERS` minus {eval(i)}
        fi
    od;
    `parameters/PARAMETERS`
end:
#####################################################################
usediff :=
proc(a::{set,`=`,list,algebraic})
options `Copyright 1993 by E. S. Cheb-Terrab`;
    a;
    if type(",{`=`,'set','list'}) then RETURN(map(usediff,")) fi;
    if not has(",'D') then "
    else map(u -> u = `usediff/subD`(u),indets(",'De')); subs(","")
    fi
end:
#####################################################################
`usediff/subD` :=
proc(u)
options `Copyright 1993 by E. S. Cheb-Terrab`,remember;
    op(0,u);
    if " = 'D' or type(",'indexed') and op(0,") = 'D' or
        not map(type,{op(u)},'name') = {'true'} then
        RETURN(u)
    elif op(0,") = 'D' then
        if nops(u) = 1 then RETURN(diff(op(")(op(u)),op(u)))
        else ERROR(`Unable to handle non-sensical expression`,u)
        fi
    elif op(0,op(0,")) = `@@` then
        RETURN(diff(op(")(op(u)),op(u) $ op(2,op(0,"))))
    elif op(0,op(0,")) = 'D' then
        if has([op(op(0,"))],`$`) then
            if nops(op(0,")) = 1 and type(op(1,op(op(0,"))),'posint') then
                if op(1,op(op(0,"))) <= nops(u) then
                    RETURN(diff(op(")(op(u)),
                        op(op(1,op(op(0,"))),[op(u)]) $ op(2,op(op(0,")))))
                else
                    ERROR(`Cannot derivate the function`,op(")(op(u)),
                        `with respect to the argument number`,
                        op(1,op(op(0,"))),`as in`,u)
                fi
            else RETURN(u)
            fi
        fi;
        zip(
           (a,b) -> traperror(op(a,b)),[op(op(0,"))],[[op(u)] $ nops(op(0,"))]
           );
        if has(",lasterror) then
            ERROR(`Unable to handle non-sensical expression`,u)
        else RETURN(diff(op("")(op(u)),op(")))
        fi
    fi
end:
#####################################################################
useD :=
proc(a::{set,`=`,list,algebraic})
options `Copyright 1993 by E. S. Cheb-Terrab`;
    if type(a,{`=`,'set','list'}) then RETURN(map(useD,a)) fi;
    subs('Diff' = 'diff',a);
    subs('diff' = `useD/subdiff`,");
    "
end:
#####################################################################
`useD/subdiff` :=
proc(u,v)
local n;
options `Copyright 1993 by E. S. Cheb-Terrab`,remember;
    if 2 < nargs then
        ERROR(
`The diff command cannot handle an abstract derivation variable`.
` built with the ``$`` operator and another derivation variable`.
` at the same time as in`
        ,'diff'(args))
    fi;
    if nops(u) = 1 then
        if type(v,'`$`'(anything,anything)) then
            if has(op(u),op(1,v)) then ('D' @@ op(2,v))(op(0,u))(op(u))
            else 0
            fi
        else D(op(0,u))(op(u))
        fi
    else
        if type(v,'`$`'(anything,anything)) then
            if has([op(u)],op(1,v)) then
                member(op(1,v),[op(u)],'n'); D[n $ op(2,v)](op(0,u))(op(u))
            else 0
            fi
        elif member(v,[op(u)],'n') then D[n](op(0,u))(op(u))
        else ERROR(`Unable to handle, try convert(args,D)`)
        fi
    fi
end:
#####################################################################
Value :=
proc(f)
local g,nm;
options `Copyright 1993 by E. S. Cheb-Terrab`;
    if nargs <> 1 then ERROR(`incorrect number of arguments`) fi;
    g := x -> x;
    if type(f,'function') then
        nm := op(0,f);
        if type(nm,'name') then
            if type(`Value/`.nm,'procedure') then g := `Value/`.nm
            elif type(nm,'indexed') and
                has(eval(cat(`Value/`,op(0,nm))),`i n d e x e d`) then
                g := cat(`Value/`,op(0,nm))
            else g := traperror(`value/define`(`value/`.nm))
            fi;
            if g = lasterror then
                if hastype([op(f)],'function') then
                    map(Value,[op(f)]);
                    if not [op(f)] = " then RETURN(op(0,f)(op("))) fi
                fi;
                g := x -> x
            fi;
            RETURN(eval(g(f)))
        elif hastype(op(0,f),'function') then
            g := procname([op(f)]); RETURN(procname(op(0,f))(op(g)))
        fi
    elif hastype(f,'function') then
        if type(f,'indexed') then RETURN(Value(op(0,f))[Value(op(f))])
        else RETURN(map('procname',f))
        fi
    elif has(eval(f),`p a r a m e t e r`) then RETURN(f)
    fi;
    RETURN(eval(g(f)))
end:
#####################################################################
# To allow Value to work well while value has not been loaded

`value/define` := proc(x)
options `Copyright 1992 by the University of Waterloo`;
    if type(x,'procedure') then eval(x) else readlib(x) fi
end:
#####################################################################

`Value/Sum` := proc(x) sum(op(x)); Value(") end:
`Value/Normal` := proc(x) evala(x); Value(") end:
`Value/Product` := proc(x) product(op(x)); Value(") end:
`Value/Diff` := proc(x) Value([op(x)]); diff(op(")) end:
`Value/Int` := proc(x) Value([op(x)]); int(op(")) end:
#####################################################################
`Value/Limit` :=
proc(x)
local f,var;
options `Copyright 1993 by E. S. Cheb-Terrab`;
    f := Value(op(1,x));
    var := Value(op(2,x));
    indets(f,function);
    proc(u) if type(op(0,u),'indexed') then op(0,u) fi end;
    map(","") union indets(f,'indexed');
    (u,v) -> u = op(0,u)[op(map(limit,[op(u)],v))];
    map(","",var);
    f := subs(",f);
    limit(f,var)
end:
#####################################################################
Has := 
proc(f,x)
options `Copyright 1994 by E. S. Cheb-Terrab`;
    subs('int' = 'Int',f);
    map(`Has/definite_int`,indets(",'Int'),x);
    if has(subs(",""),x) then 'true' else 'false' fi
end:
#####################################################################
`Has/definite_int` := 
proc(U,x)
local uu;
options remember;
    op(2,U);
    if has(U,x) and type(",`=`) then
        op(1,U),op(1,"),op(2,");
        U = subsop(1 = subs(x = uu,"[1]),2 = (subs(x = uu,"[2]) = "[3]),U)
    fi
end:
#####################################################################
#save `pdetools.m`;
#quit

