#
## <SHAREFILE=numerics/findif/findif.mpl >
## <DESCRIBE>
##	A procedure which automates the generation of finite
##       	difference formulae for numerical work, and example.
##                AUTHOR: Robert M. Corless, rcorless@uwo.ca
## </DESCRIBE>
## <UPDATE=R4 >
interface(echo=0);
#
# Updates for Maple V Release 3, RMC March 1994
# Renamings of global variables, breakings and fixings, June 1994.
#
# Explicit declaration of `FINDIF/h` and `FINDIF/f` as global
#
# Removed extra copy of routines (??? why were they there????)
#
alias(f=`FINDIF/f`,h=`FINDIF/h`,p=`FINDIF/parameter`):

stencil_gen:=proc(k)
  local T; global `FINDIF/h`;
  T:=array(1..7,[
    [[0],[`FINDIF/h`],[-`FINDIF/h`]],
    [[0],[`FINDIF/h`],[-`FINDIF/h`],[2*`FINDIF/h`],[-2*`FINDIF/h`]],
    [[0],[`FINDIF/h`],[-`FINDIF/h`],[2*`FINDIF/h`],[-2*`FINDIF/h`],
         [3*`FINDIF/h`],[-3*`FINDIF/h`]],
    [[0],[`FINDIF/h`]],
    [[0],[`FINDIF/h`],[2*`FINDIF/h`]],
    [[0],[`FINDIF/h`],[2*`FINDIF/h`],[3*`FINDIF/h`]],
    [[0],[`FINDIF/h`],[2*`FINDIF/h`],[3*`FINDIF/h`],[4*`FINDIF/h`]]
  ]);
  T[k]
end:
#........................................................
#.......................................................
mask_gen:=proc(sten,nd)
  local npx,ma,msk,i;

# generates standard masks for a given stencil

  npx:= nops(sten);
  ma := [seq(i,i=0..nd)];
  msk:= [seq(ma, i=1..npx)];
  msk
end:
#.......................................................
#.......................................................
formal_taylor_ser:=proc(arg,k,idr,FF)
  local su,ik,iks;
  # generates formal taylor series of D[idr](fun)(arg)
  #  with respect to point zero
  iks:=1;
  su:=FF[idr];
  ik:='ik';
  for ik from 1 to k do
    iks:=iks*ik;
    su:=su+FF[ik+idr]*arg^ik/iks;
  od;
  su
end:
#.......................................................
#
FINDIF:=proc(stenx,maskx,difexpx,naccx)
  local AA,bb,FF,np,npt,ipow,ww,wt,icol,irow,findif_sum,er,ndir,nacc,id,
  ip,nma,ma,iq,pnt,nph,ndr,
  XX, dervid, difexp, drv, mask, ndirx, obj,
  set_FF_dif, set_FUN_dif, set_dif_FF,
  set_dif_FUN, sten, taydifexp, wwx,
  AAdiv,FUN,dir,hiq,ia,ichk,icnt,iph,ipq,iw,lam,
  lst,su,n_of_eq,pdeg;
  global `FINDIF/f`,`FINDIF/h`,`FINDIF/parameter`;
  #
  #   input verification
  #
  if nargs<>4 then
    ERROR(` FINDIF requires 4 arguments`);
  fi;
  if type(args[1],numeric) then
    if args[1]>0 and args[1]<7 then
      sten:=stencil_gen(args[1]);
    else
      ERROR(` stencil number too high or negative`,stenx);
    fi;
  else
    sten:=stenx;
  fi;
  if type(args[2],numeric) then
    if args[2]>=0 then
      mask:=mask_gen(sten,args[2]);
    else
      ERROR(` mask number negative `,maskx);
    fi;
  else
    mask:=maskx;
  fi;
  # third argument can be:
  #   positive integer
  #   expression containing `FINDIF/f` and its derivatives evaluated
  #   at point "0" or/and at other points depending on "`FINDIF/h`"
  if type(args[3],numeric) then
    if args[3]>=0 and frac(args[3])=0 then
      difexp:=(D@@difexpx)(`FINDIF/f`)(0);
      ndirx:=difexpx;
    else
      ERROR(` difexp fractional or negative `,difexpx);
    fi;
  else
    difexp:=difexpx;
  # looking for the lowest derivative
    taydifexp:=convert(taylor(difexp,`FINDIF/h`=0,10),polynom);
    id:='id';
    for id from 0 to 11 do
      ndirx:=id;
      drv:=(D@@id)(`FINDIF/f`)(0);
      dervid:=simplify(coeff(collect(taydifexp,drv),drv));
      if dervid<>0 then break fi;
    od;
    if ndirx>10 then ERROR(` lowest derivative in difexp is>10 `,taydifexp) fi;
  fi;
  userinfo(2,FINDIF,`stencil                 = `,sten);
  userinfo(2,FINDIF,`mask                    = `,mask);
  userinfo(2,FINDIF,`differential expression = `,difexp);
  #
  #   main algorithm
  #

  npt:=nops(mask);
  nph:=0;
  ip:='ip';
  for ip from 1 to npt do nph:=nph+nops(mask[ip]) od;
  ip:='ip';
  ipow:=array(1..nph,[0$ip=1..nph]);
  ww:=array(1..nph);
  wt:=array(1..nph);
  ip:='ip';
  iph:=0;
  for ip from 1 to npt do
    ma:=mask[ip];
    pnt:=sten[ip][1];
    nma:=nops(ma);
    iq:='iq';
    for iq from 1 to nma do
      iph:=iph+1;
      ipow[iph]:=ma[iq];
      ww[iph]:=pnt;
    od;
  od;
  np:=iph;
  ndir:=ndirx;
  nacc:=naccx;
  pdeg:=ndir+nacc+2;
  n_of_eq:=ndir+nacc-1;
  FF:=array(0..pdeg);
  AA:=array(0..pdeg,1..np);
  id:='id';
  bb:=array(0..pdeg,[0$id=0..pdeg]);
  set_dif_FUN:={};
  set_FUN_dif:={};
  set_dif_FF:={};
  set_FF_dif:={};
  ip:='ip';
  for ip from 1 to np do
    pnt:=ww[ip];
    ndr:=ipow[ip];
    dir:=(D@@ndr)(`FINDIF/f`)(pnt);
    set_FUN_dif:=set_FUN_dif union {FUN[ip]=dir};
    set_dif_FUN:=set_dif_FUN union {dir=FUN[ip]};
  od;
  ia:='ia';
  for ia from 0 to pdeg do
    dir:=(D@@ia)(`FINDIF/f`)(0);
    set_FF_dif:=set_FF_dif union {FF[ia]=dir};
    set_dif_FF:=set_dif_FF union {dir=FF[ia]};
  od;
  ip:='ip';
  #  for each point and the given function/derivative
  for ip from 1 to np do
    pnt:=ww[ip];
    ndr:=ipow[ip];
    obj:=(D@@ndr)(`FINDIF/f`)(pnt);
    wwx:=convert(taylor(obj,`FINDIF/h`=0,pdeg-ndr+1),polynom);
    wt[ip]:=subs(set_dif_FF,wwx);
  od;
  #
  # taylor expansion of the diffexp
  #
  taydifexp:=subs(set_dif_FF,convert(taylor(difexp,`FINDIF/h`=0,pdeg+1),polynom));
  #
  #  generates a matrix AA for the linear system and the right
  #  hand side vector bb
  ip:='ip';
  for ip from 1 to np do
    ndr:=ipow[ip];
    hiq:=`FINDIF/h`^ndr;
    id:='id';
    for id from 0 to pdeg do
      AA[id,ip]:=simplify(hiq*coeff(collect(wt[ip],FF[id]),FF[id]));
    od;
  od;
  id:='id';
  for id from 0 to pdeg do
    bb[id]:=simplify(coeff(collect(taydifexp,FF[id]),FF[id]));
  od;
  #  eliminate maximally the original matrix AA
  #  AA is possibly over/under determined
  ia:='ia';
  irow:=array(0..n_of_eq,[0$i=0..n_of_eq]);
  ip:='ip';
  icol:=array(1..np,[1$i=1..np]);
  ia:='ia';
  for ia from 0 to n_of_eq do
    ipq:=0;
    ip:='ip';
  #  what number (ipq) has the non-zero element in the row "ia"
    for ip from 1 to np do
      if AA[ia,ip]=0 or ipq>0 then
      else
        ipq:=ip;
      fi;
    od;
    if ipq=0 then
  #   if the row "ia" is full of zeros skip elimination
    else
  #     elimination will produce zeros in the column "ipq"
  #     (except for the row "ia" where 1 will appear")
      id:='id';
  #     elimination of ALL other rows by the row ia
  #  irow stores the column number in which "1" will appear
  #  icol=0 if a column is reduced
      irow[ia]:=ipq;
      icol[ipq]:=0;
      for id from 0 to n_of_eq do
        if id=ia then
  #         no elimination of the row "ia" by itself
  #         this row is divided by AA[id=ia,ipq]
  	ip:='ip';
  	AAdiv:=AA[id,ipq];
  	bb[id]:=simplify(bb[id]/AAdiv);
  	for ip from 1 to np do
     if ip=ipq then
       AA[id,ip]:=1;
     else
  	    AA[id,ip]:=simplify(AA[id,ip]/AAdiv);
     fi;
  	od;
        else
  	lam:=-AA[id,ipq]/AA[ia,ipq];
  	bb[id]:=simplify(bb[id]+lam*bb[ia]);
  	ip:='ip';
  #         elimination of the row "id"<>"ia" by the row "ia"
  	for ip from 1 to np do
  	  AA[id,ip]:=simplify(AA[id,ip]+lam*AA[ia,ip]);
  	od;
        fi;
      od;
    fi;
  od;
  icnt:=0;
  ip:='ip';
  for ip from 1 to np do
    if icol[ip]=0 then
    else
      ichk:=0;
      id:='id';
      for id from 0 to n_of_eq do
        if AA[id,ip]=0 then
        else
  	ichk:=1;
  	break;
        fi;
      od;
      if ichk>0 then
        icnt:=icnt+1;
  #  icol stores the free parameter number
        icol[ip]:=icnt;
      else
  #  icol is "0" if the column is full of "0" or if the
  #    column was succesfully reduced
        icol[ip]:=0;
      fi;
    fi;
  od;
  #  icnt stores the number of free parameters
  #....................................................................
  #
  #
  #  solves over/under-determined system AA*XX=bb
  #  findif_sum - represents the final findif formula
  #  er - denotes the calculated error
  if icnt>0 then
    userinfo(2,FINDIF,`NUMBER OF FREE PARAMETERS IN THE FORMULA icnt = `,icnt);
  fi;
  `FINDIF/parameter`:=array(1..max(1,icnt));
  FUN:=array(1..np);
  XX:=array(1..np);
  ia:='ia';
  for ia from 0 to n_of_eq do
    ipq:=irow[ia];
    if ipq=0 then
    else
      su:=0;
      ip:='ip';
      for ip from 1 to np do
        iw:=icol[ip];
        if iw=0 then
        else
  	su:=su+`FINDIF/parameter`[iw]*AA[ia,ip];
        fi;
      od;
      XX[ipq]:=(bb[ia]-su)*`FINDIF/h`^ipow[ipq];
    fi
  od;
  ip:='ip';
  for ip from 1 to np do
    iw:=icol[ip];
    if iw=0 then
    else
      XX[ip]:=`FINDIF/parameter`[iw];
    fi
  od;
  #  the solution vector is evaluated
  findif_sum:=0;
  er:=-taydifexp;
  ip:='ip';
  for ip from 1 to np do
    findif_sum:=findif_sum+XX[ip]*FUN[ip];
    er:=simplify(er+XX[ip]*wt[ip]);
  od;
  lst:=[op(convert(`FINDIF/parameter`,list)),`FINDIF/h`];
  findif_sum:=collect(findif_sum,lst);
  er:=collect(er,`FINDIF/h`);
  findif_sum:=subs(set_FUN_dif,findif_sum);
  er:=subs(set_FF_dif,er);
  # findif_sum - finite difference formula
  # er  - error term
  [findif_sum,er]
end:
#
interface(echo=2);
