with(share):readshare(ratsum, algebra):
#
#
#
# Test file for the package ratsum
#
#  R. Pirastu - RISC Linz - 1994
#
#

#read(`ratsum.m`);

# Some functions to extract the rational and
# non rational part of the solution

rat := proc(f)
map(proc(a) if has(a,Psi) or has(a,D_INV) or has(a,Sum) then 0 else a fi end, f)
end:

nonrat := proc(f)
map(proc(a) if  has(a,Sum) then
      op(1,a) else 0 fi end, f)
end:


#
# Examples from the help file
#
#


f:= 1/x/(x+4):
alg:=`paule`:
r:=ratsum(f,x,alg):
if simplify(subs(x=x+1,rat(r))-rat(r) + nonrat(r) -f)=0 then print(ok) else print(f) fi;

f:=1/x/(x+2)^2/(x+3):
alg:=`abramov`:
r:=ratsum(f,x,alg):
if simplify(subs(x=x+1,rat(r))-rat(r) + nonrat(r) -f)=0 then print(ok) else print(f) fi;

f:= 1/x/(x^2+1)/(x+3):
alg:=`newabramov`:
r:=ratsum(f,x,alg):
if simplify(subs(x=x+1,rat(r))-rat(r) + nonrat(r) -f)=0 then print(ok) else print(f) fi;

f:= 1/x/(x^2+1)/(x+3):
alg:=`moenck`:
r:=ratsum(f,x,alg):
if simplify(subs(x=x+1,rat(r))-rat(r) + nonrat(r) -f)=0 then print(ok) else print(f) fi;

f:= 1/x/(x^2+1)/(x+3):
r:=ratsum(f,x):
if simplify(subs(x=x+1,rat(r))-rat(r) + nonrat(r) -f)=0 then print(ok) else print(f) fi;


#
# Some few more examples
#
#

f:= x^3+1/x^2/x/(x^2+1)/(x+4):
alg:=`paule`:
r:=ratsum(f,x,alg):
if simplify(subs(x=x+1,rat(r))-rat(r) + nonrat(r) -f)=0 then print(ok) else print(f) fi;

f:= x/(x+1)/(x+3)^2/(x^3+1):
alg:=`abramov`:
r:=ratsum(f,x,alg):
if simplify(subs(x=x+1,rat(r))-rat(r) + nonrat(r) -f)=0 then print(ok) else print(f) fi;

f:= 6/(x-2/3)/(x+1/3)^7:
alg:=`newabramov`:
r:=ratsum(f,x,alg):
if simplify(subs(x=x+1,rat(r))-rat(r) + nonrat(r) -f)=0 then print(ok) else print(f) fi;

f:= 6/(x-2/3)/(x+1/3)^7:
alg:=`moenck`:
r:=ratsum(f,x,alg):
if simplify(subs(x=x+1,rat(r))-rat(r) + nonrat(r) -f)=0 then print(ok) else print(f) fi;

f:= (x^2+3)/x/(2*x^2+2)/(3*x+6):
alg:=`abramov`:
r:=ratsum(f,x,alg):
if simplify(subs(x=x+1,rat(r))-rat(r) + nonrat(r) -f)=0 then print(ok) else print(f) fi;

f:= (x^2+3)/x/(2*x^2+2)/(3*x+6):
alg:=`newabramov`:
r:=ratsum(f,x,alg):
if simplify(subs(x=x+1,rat(r))-rat(r) + nonrat(r) -f)=0 then print(ok) else print(f) fi;

f:= x^3/(x+1)^4/(x+2)^2/x:
alg:=`paule`:
r:=ratsum(f,x,alg):
if simplify(subs(x=x+1,rat(r))-rat(r) + nonrat(r) -f)=0 then print(ok) else print(f) fi;


#
# Examples where the sum function in Maple fails
#
#

#
# Error message by sum:
# Error, (in quo) arguments must be polynomial in, x
#

f:= 1/x^5/(x+2)/(x+3)^3:
alg:=`paule`:
r:=ratsum(f,x,alg):
if simplify(subs(x=x+1,rat(r))-rat(r) + nonrat(r) -f)=0 then print(ok) else print(f) fi;

f:= 1/x^5/(x+2)/(x+3)^3:
alg:=`newabramov`:
r:=ratsum(f,x,alg):
if simplify(subs(x=x+1,rat(r))-rat(r) + nonrat(r) -f)=0 then print(ok) else print(f) fi;

f:=2/x^5/(x+2)/(x+3)^4:
alg:=`abramov`:
r:=ratsum(f,x,alg):
if simplify(subs(x=x+1,rat(r))-rat(r) + nonrat(r) -f)=0 then print(ok) else print(f) fi;

#
# Error message by sum:
# Error, (in gcdex/diophant) wrong number (or type) of arguments
#

f:=1/x^5/(x+2)/(x+3)^4/(x^2+1):
alg:=`abramov`:
r:=ratsum(f,x,alg):
if simplify(subs(x=x+1,rat(r))-rat(r) + nonrat(r) -f)=0 then print(ok) else print(f) fi;

f:=1/x^5/(x+2)/(x+3)^4/(x^2+1):
alg:=`paule`:
r:=ratsum(f,x,alg):
if simplify(subs(x=x+1,rat(r))-rat(r) + nonrat(r) -f)=0 then print(ok) else print(f) fi;

#quit
