with(share): readshare(pdetools,analysis):
#####################################################################
#
# Edgardo S. Cheb-Terrab and Katherina von Bulow
# E-Mail: TERRAB@BRUERJ.BITNET
# Address:
#        Departamento de Fisica Teorica
#		 3o. andar, Instituto de Fisica
#        Universidade do Estado do Rio de Janeiro, UERJ
#        Rua Sao Francisco Xavier 524, RJ 20550-013
#        Brazil
#
# Test for the commands of the PDEtools package.
#
#####################################################################
#                        TEST procedure

TEST := proc(obtain,expect)
local example;
global Number,fail;

if type(expect,'set') then
	example := obtain minus expect;
elif type(expect,`=`) then
	normal(obtain-expect);
	example := lhs(") - rhs(");
else example := normal(obtain-expect);
fi;

Number := Number + 1:              # Number of example being tested.
print();                           # Separator.
if example=0 or example={}

# if any "example" <> 0 please turn on the following two lines:
#
# or member(frontend(expand,[simplify(example)]),{0,{}})

then
print(cat(`Example `,Number,`) :   OK`));

# Alternative output:
#
# print(okay);

else
   if nargs > 2 then RETURN(procname(obtain,args[3..nargs])) fi;
	print(cat(`Example `,Number,`) : FAIL`));
        lprint(obtain);
	fail[TOTNumber+Number] := `input `=_com_inp[Number],
		`output `=obtain,`expected output`=expect;
 print(
 cat(`The input, output and expected-output can be seen as fail[`,
 	TOTNumber+Number,`]`));
#
# print(`Please contact E.S.Cheb-Terrab or Katherina von Bulow`,
# `e-mail: TERRAB@BRUERJ.BITNET`):

fi:
NULL;
end:

#####################################################################
# Load the package

# with(PDEtools);
#read `pdetools.m`;
interface(labelling=false);
_Env_PDEtools_print := 'false';
print(
`Time consumed by a 486 DX-33 for processing this test:  around 8 minutes.`);
#####################################################################
# Initialize counters and timing

TOTNumber := 0:    # Total number of examples
TIME0 := time():

#####################################################################
# Here begins the TEST.
#
# 1) Command: pdsolve
#

print(_______________________________________________________________):
print(`Testing procedure pdsolve.`):
print(_______________________________________________________________):

Number := 0:		# Initialize the Number of the examples of this command.
_com_inp := eq:		# Indicates the name of the table/input for the command.
#
#Case one diff
#

#Example 1)
eq[1] :=f(x,y)^(1/2)*(diff(f(x,y),x,y)+g(x,y))=0:
res[1] := pdsolve("):
TEST(",`&Where`(f(x,y) = _f2(x)+_f1(y)-Int(Int(g(x,y),x),y)+_C1*y+_C2,
[``(_f1(y),_f2(x),` are arbitrary functions.`)]));

# Example 2)
eq[2] :=diff(f(x,y,z),x,y)+g(x)*z:
res[2] := pdsolve("):
TEST(",`&Where`(f(x,y,z) = _f2(x,z)+_f1(y,z)-z*Int(g(x),x)*y+_C1*y+_C2,
[``(_f1(y,z),_f2(x,z),` are arbitrary functions.`)]));

# Example 3)
eq[3] := cos(diff(f(x,y,z,t),x,y))^2=g(x,y,z,t):
res[3] := pdsolve("):
TEST(",`&Where`(f(x,y,z,t) = _f2(x,z,t)+_f1(y,z,t)+Int(Int(arccos(g(x,y,z,t)^
(1/2)),x),y)+_C1*y+_C2,[``(_f1(y,z,t),_f2(x,z,t),` are arbitrary functions.`)]));

# Example 4)
eq[4] := cos(diff(f(u,v),v,u))-sin(diff(f(u,v),u,v))=1:
res[4] := pdsolve("):
TEST(",`&Where`(f(u,v) = _f2(u)+_f1(v)+_C1*v+_C2,[``(_f1(v),_f2(u),
` are arbitrary functions.`)]));

# Example 5)
eq[5] := diff(f(t,x,y),x)*x+h(x)*y=0:
res[5] := pdsolve("):
TEST(",`&Where`(f(t,x,y) = _f1(t,y)-y*Int(h(x)/x,x)+_C1,[``(_f1(t,y),
` are arbitrary functions.`)]));

# Example 6)
eq[6] := diff(f(xi,eta,rho,alpha,beta),xi,eta,rho$2)=g(xi,eta,rho):
res[6] := pdsolve("):
TEST(",`&Where`(f(xi,eta,rho,alpha,beta) =
_f4(xi,eta,alpha,beta)+_f2(xi,rho,alpha,beta)+_f1(eta,rho,alpha,beta)+
Int(Int(Int(Int(g(xi,eta,rho),xi),eta),rho),rho)+_C2*Int(rho,rho)+_C4+
_C1*eta*Int(rho,rho)+(_f3(xi,eta,alpha,beta)+_C3)*rho,
[``(_f1(eta,rho,alpha,beta),_f2(xi,rho,alpha,beta),_f3(xi,eta,alpha,beta),
_f4(xi,eta,alpha,beta),` are arbitrary functions.`)]));

# Example 7)
eq[7] := diff(f(x,y),y)+g(x):
res[7] := pdsolve("):
TEST(",`&Where`(f(x,y) = _f1(x)-g(x)*y+_C1,
[``(_f1(x),` are arbitrary functions.`)]));

# Example 8)
eq[8] := x/diff(f(x,y),y,x)=y^2:
res[8] := pdsolve("):
TEST(",`&Where`(f(x,y) = _f2(x)+_f1(y)+Int(x,x)*Int(1/y^2,y)+_C1*y+_C2,
[``(_f1(y),_f2(x),` are arbitrary functions.`)]));

#
# Case of homogeneus product of derivatives
#

# Example 9)
eq[9] := diff(f(x,y),y)*diff(f(x,y),x,x)*x=0:
res[9] := pdsolve(",INTEGRATE):
TEST(",`&Where`(f(x,y) = _f1(x)+_f2(y),[{{_f2(y) = _c[2]*y+_C3},
{_f1(x) = _C1+_C2*x}}]));

#
# Case of non-homogeneous product of derivatives
#

# Example 10)
eq[10] := diff(f(x,y,z),x,y)^3*diff(f(x,y,z),y)^2=g(x)*g(y,z):
res[10] := pdsolve("):
TEST(",`&Where`(f(x,y,z) = _f1(x)*(__f41(z)+1/_c[1]*Int((g(y,z)*_c[1]^4)^
(1/5),y)+_C1),[{diff(_f1(x),x)^3 = _c[1]/_f1(x)^2*g(x)},``(__f41(z),
` are arbitrary functions.`)]));

# Example 11)
eq[11] := diff(f(x,y,z),x,y)*diff(f(x,y,z),z$5)=cos(x*y):
res[11] := pdsolve("):
TEST(",`&Where`(f(x,y,z) = _f3(z)+__f42(x)+__f41(y)+1/_c[3]*
Int(Int(cos(x*y),x),y)+_C1*y+_C2,
[{diff(diff(diff(diff(diff(_f3(z),z),z),z),z),z) =_c[3]},
``(__f41(y),__f42(x),` are arbitrary functions.`)]));

# Example 12)
eq[12] := diff(f(x,y,z),x,y)^2*diff(f(x,y,z),y)=g(x)*g(y,z):
res[12] := pdsolve("):

`&Where`(f(x,y,z) = _f1(x)*(__f41(z)+1/_c[1]*Int((g(y,z)*
_c[1]^2)^(1/3),y)+_C1),[{diff(
_f1(x),x)^2 = _c[1]/_f1(x)*g(x)}, ``(__f41(z),` are arbitrary functions.`)]):

if ""-"=0 then "","
else (res[12],`&Where`(f(x,y,z) = _f1(x)*(__f41(z)+
	Int((g(y,z)/_c[1])^(1/3),y)+_C1),[{diff(_f1(x),x)^2 = _c[1]/_f1(x)*g(x)},
	``(__f41(z),` are arbitrary functions.`)]))
fi:

TEST(");

# Example 13)
eq[13] := diff(f(x,y),x,y)*diff(f(x,y),x)=1:
res[13] := pdsolve("):
TEST(",`&Where`(f(x,y) = _f1(x)*_f2(y),[{diff(_f1(x),x) = _c[1],
diff(_f2(y),y) = 1/_c[1]^2/_f2(y)}]));

#
# Case of only mixed derivatives
#

# Example 14)
eq[14] := diff(f(x,y,z),x,y)+diff(f(x,y,z),x,z$5):
res[14] := pdsolve("):
TEST(",`&Where`(f(x,y,z) = _f1(x)+_f2(y,z),[``(_f1(x),_f2(y,z),
` are arbitrary functions.`)]));

# Example 15)
eq[15] := diff(f(x,y,z),x,y)*diff(f(x,y,z),x,z,y)*cos(x*y*z):
res[15] := pdsolve("):
TEST(",`&Where`(f(x,y,z) = _f1(x,z)+_f2(y,z),[``(_f1(x,z),_f2(y,z),
` are arbitrary functions.`)]));

# Example 16)
eq[16] := diff(f(x,y,z,t),x,y)+diff(f(x,y,z,t),x,z,y)*g(x,y):
res[16] := pdsolve("):
TEST(",`&Where`(f(x,y,z,t) = _f1(x,z,t)+_f2(y,z,t),[``(_f1(x,z,t),_f2(y,z,t),
` are arbitrary functions.`)]));

#
# Case linear in diff
#

# Example 17)
eq[17] := diff(f(x,y,z),y)^2+(diff(f(x,y,z),x,x)*x+y+z^(1/2)):
res[17] := pdsolve("):
TEST(",
`&Where`(f(x,y,z) = _f00(z)*_f1(x)+__f41(z)+Int((-y-_c[1]*
_f00(z)+z^(1/2))^(1/2),y)+_C1,
[{diff(diff(_f1(x),x),x) = _c[1]/x}, ``(__f41(z),
_f00(z),` are arbitrary functions.`)]) );

# Example 18)
eq[18] := diff(f(x,y,z),x,x)+diff(f(x,y,z),y,y)+diff(f(x,y,z),z,z):
res[18] := pdsolve(",INTEGRATE):
TEST(",`&Where`(f(x,y,z) = _f1(x)*_f2(y)*_f3(z),[{{_f1(x) = _C1*
exp(_c[1]^(1/2)*x)+_C2*exp(-_c[1]^(1/2)*x)}, {_f2(y) = _C3*exp(_c[2]^(1/2)*y)+
_C4*exp(-_c[2]^(1/2)*y)}, {_f3(z) = _C5*exp((-_c[1]-_c[2])^(1/2)*z)+_C6*exp(-(
-_c[1]-_c[2])^(1/2)*z)}}]));

# Example 19)
eq[19] := diff(f(x,y,z,t),t,t)=t:
res[19] := pdsolve("):
TEST(",`&Where`(f(x,y,z,t)=_f2(x,y,z)+Int(Int(t,t),t)+_C2+(_f1(x,y,z)+_C1)*t,
[``(_f1(x,y,z),_f2(x,y,z),` are arbitrary functions.`)]));

# Example 20)
eq[20] := diff(f(x,y,z),x,x) + diff(f(x,y,z),y,y) - f(x,y,z):
res[20] := pdsolve("):
TEST(",`&Where`(f(x,y,z) = _f1(x)*_f2(y)*_f00(z),[{diff(diff(_f2(y),y),y) =
_c[2]-_c[1]*_f2(y)+_f2(y), diff(diff(_f1(x),x),x) = _c[1]*_f1(x),
_f00(z)*_c[2] = 0}]));

# Example 21)
eq[21] := (diff(f(x,y),x)+g(x))/g(y)+diff(f(x,y),y)=cos(y):
res[21] := pdsolve("):
TEST(",`&Where`(f(x,y) = _f1(x)+_f2(y),[{diff(_f2(y),y)=-1/g(y)*_c[1]+cos(y),
diff(_f1(x),x) = _c[1]-g(x)}]));

# Example 22)
eq[22] := diff(f(x,y,z),y,y)+(diff(f(x,y,z),x,x)*x+z):
res[22] := pdsolve("):

`&Where`(f(x,y,z) = (1+_f1(x)+_f2(y))*_f00(z),
[{_c[2]*_f00(z)+_c[1]*_f00(z)+z = 0, diff(
diff(_f1(x),x),x) = _c[1]/x, diff(diff(_f2(y),y),y) = _c[2]}]):

if ""-"=0 then "","
else res[22],`&Where`(f(x,y,z) = _f00(z)*(__f41(x)+__f42(y)),
	[{_f00(z)=_c[3]*z, diff(diff(__f42(y),y),y) = _c[5], diff(diff(__f41(x),x),x)
	= -1/x*_c[5]-1/_c[3]/x}])
fi:
TEST(");

# Example 23)
eq[23] := diff(f(x,y,z,t),y,y)/y+diff(f(x,y,z,t),z)/z=diff(f(x,y,z,t),t,t):
res[23] := pdsolve("):

`&Where`(f(x,y,z,t) = _f2(y)*_f3(z)*_f4(t)*_f0(x),[{_f0(x)*_c[4] = 0,
diff(diff(_f2(y),y),y) = _c[2]*y*_f2(y), diff(_f3(z),z) = _c[3]*z*_f3(z),
diff(diff(_f4(t),t),t) = -_c[4]+_c[2]*_f4(t)+_c[3]*_f4(t)}]):

if ""-"=0 then "","
else res[23],`&Where`(f(x,y,z,t) = _f2(y)*_f3(z)*_f4(t)*_f0(x),
	[{diff(diff(_f2(y),y),y) = _c[2]*y*_f2(y), diff(_f3(z),z) = _c[3]*z*_f3(z),
	diff(diff(_f4(t),t),t) = _c[4]+_c[2]*_f4(t)+_c[3]*_f4(t), -_f0(x)*_c[4] = 0}])
fi:
TEST(");

# Example 24)
eq[24] := diff(f(x,y,z),y)+(diff(f(x,y,z),x)-f(x,y,z))/y^2:
res[24] := pdsolve("):
TEST(",&Where(f(x,y,z) = exp(-1/y)*_f1((x*y+1)/y,z),[``(_f1((x*y+1)/y,z),
` are arbitrary functions.`)]));

# Example 25)
eq[25] := diff(f(x,y),y)*sin(x)/(x*y)+diff(f(x,y),x)*sin(y)/(x*y):
res[25] := pdsolve("):
TEST(",`&Where`(f(x,y) = _f1(x)*_f2(y),[{diff(_f2(y),y) = -_c[1]*_f2(y)*sin(y),
diff(_f1(x),x) = _c[1]*_f1(x)*sin(x)}]));

# Example 26)
eq[26] := diff(f(x,y,z),x)+diff(f(x,y,z),x,z$5):
res[26] := pdsolve("):
TEST(",`&Where`(f(x,y,z) = _f1(x)*_f3(z)*_f0(y),[{diff(_f1(x),x) = _c[1],
_c[1]*_f0(y)*_c[3] = 0, diff(diff(diff(diff(diff(_f3(z),z),z),z),z),z) =
_c[3]-_f3(z)}]));

# Example 27)
eq[27] := diff(f(x,y),x,x) - diff(f(x,y),y,y) +lambda/x*diff(f(x,y),x):
res[27] := pdsolve("):
TEST(",`&Where`(f(x,y) = _f1(x)*_f2(y),[{diff(diff(_f2(y),y),y)=_c[1]*_f2(y),
diff(diff(_f1(x),x),x) = _c[1]*_f1(x)-lambda/x*diff(_f1(x),x)}]));

# Example 28)
eq[28] := diff(f(x,y,z1,z2),y$5)+diff(f(x,y,z1,z2),x$5)=f(x,y,z1,z2):
res[28] := pdsolve("):
TEST(",`&Where`(f(x,y,z1,z2)= _f1(x)*_f2(y)*_f00(z1,z2),[{_f00(z1,z2)*_c[2]=0,
diff(diff(diff(diff(diff(_f2(y),y),y),y),y),y) = _c[2]-_c[1]*_f2(y)+_f2(y),
diff(diff(diff(diff(diff(_f1(x),x),x),x),x),x) = _c[1]*_f1(x)}]));

# Example 29)
eq[29] := diff(f(x,y),x)+g(x)+g(y)+diff(f(x,y),y):
res[29] := pdsolve("):
TEST(",`&Where`(f(x,y) = _f1(x)+_f2(y),[{diff(_f1(x),x) = _c[1]-g(x),
diff(_f2(y),y) = -_c[1]-g(y)}]));

#
# Case first order (1st. hint)
#

# Example 30)
eq[30] := diff(f(x,y,z),y)*sin(x)/z+diff(f(x,y,z),x)*sin(y)*z=0:
res[30] := pdsolve("):
`&Where`(f(x,y,z) = _f1(-cos(y)*_C1*z+cos(x)*_C1/z,z),
[``(_f1(-cos(y)*_C1*z+cos(x)*_C1/z,z),` are arbitrary functions.`)]):

if ""-"=0 then "","
else res[30],`&Where`(f(x,y,z) = _f1(cos(y)*_C1*z-cos(x)*_C1/z,	z),
	[``(_f1(cos(y)*_C1*z-cos(x)*_C1/z,z),` are arbitrary functions.`)])
fi:
TEST(");

# Example 31)
eq[31] := diff(f(x,y),y)+diff(f(x,y),x)=0:
res[31] := pdsolve("):

TEST(",&Where(f(x,y)=_f1(y-x+_C1),[``(_f1(y-x+_C1),
` are arbitrary functions.`)]));

# Example 32)
eq[32] := diff(f(t,x,z,y,s),y)*sin(x)+diff(f(t,x,z,y,s),x)*sin(y*z)=0:
res[32] := pdsolve("):

`&Where`(f(t,x,z,y,s) = _f1(-cos(y*z)/z*_C1+cos(x)*_C1,z,t,s),
[``(_f1(-cos(y*z)/z*_C1+cos(x)*_C1,z,t,s),` are arbitrary functions.`)]):

if ""-"=0 then "","
else res[32],`&Where`(f(t,x,z,y,s) =
	_f1(cos(y*z)/z*_C1-cos(x)*_C1,z,t,s),
	[``(_f1(cos(y*z)/z*_C1-cos(x)*_C1,z,t,s),
	` are arbitrary functions.`)])
fi:
TEST(");

# Example 33)
eq[33] := diff(f(x,y,z),y)+diff(f(x,y,z),x)*y/x=0:
res[33] := pdsolve("):
TEST(",&Where(f(x,y,z) = _f1(1/2*x^2-1/2*y^2+1/2*_C1^2,z),
[``(_f1(1/2*x^2-1/2*y^2+1/2*_C1^2,z),
` are arbitrary functions.`)]));

# Example 34)
eq[34] := diff(u(x,y),x)*Diff(g(x,y)+f1(x),y)-diff(u(x,y),y)*Diff(g(x,y)+
f2(y),x):
res[34] := pdsolve(",u):

&Where(u(x,y) = _u1(g(x,y)),[``(_u1(g(x,y)),` are arbitrary functions.`)]):

if ""-"=0 then "","
else res[34],`&Where`(u(x,y) = _u1(-g(x,y)),[``(_u1(-g(x,y)),
	` are arbitrary functions.`)]):
fi:
TEST(");

# Example 35)
eq[35] := diff(f(x,y),y)*diff((x^(1/2)/exp(y*x)),x)-diff(f(x,y),x)*
diff((x^(1/2)/exp(y*x)),y)=0:
res[35] := map(simplify,pdsolve(")):

`&Where`(f(x,y) = _f1(-x^(1/2)*exp(-x*y)),[``(_f1(-x^(1/2)*exp(-x*y)),
` are arbitrary functions.`)]):

if ""-"=0 then "","
else res[35],`&Where`(f(x,y) = _f1(x^(1/2)*exp(-x*y)),
	[``(_f1(x^(1/2)*exp(-x*y)),` are arbitrary functions.`)])
fi:
TEST(");

# Example 36)
eq[36] :=  diff(f(x,y),y)*x^(1/2)+diff(f(x,y),x)*y=0:
res[36] := pdsolve("):

`&Where`(f(x,y) = _f1(1/2*_C1*y^2-2/3*x^(3/2)*_C1),[``(_f1(1/2*_C1*y^2
-2/3*x^(3/2)*_C1),` are arbitrary functions.`)]):

if ""-"=0 then "","
else res[36],`&Where`(f(x,y) = _f1(-1/2*_C1*y^2+2/3*x^(3/2)*_C1),
	[``(_f1(-1/2*_C1*y^2+2/3*x^(3/2)*_C1),` are arbitrary functions.`)])
fi:
TEST(");

# Example 37)
eq[37] := diff(u(x,y),x)/diff(u(x,y),y)=y/x:
res[37] := pdsolve("):

TEST(",&Where(u(x,y) = _u1(y*x/_C1),[``(_u1(y*x/_C1),
` are arbitrary functions.`)]));

#
# Case first order (2nd. hint)
# (Only has diff or f, not the coordinates)
#

# Example 38)
eq[38] := diff(f(x,y,z,t),x)*diff(f(x,y,z,t),y)/diff(f(x,y,z,t),z)=f(x,y,z,t):
res[38] := pdsolve("):

`&Where`(f(x,y,z,t) = _f1(t),[``(_f1(t),` are arbitrary functions.`)]):

if ""-"=0 then "","
else res[38],`&Where`(f(x,y,z,t) = exp(_c[3]/_c[2]*(_c[2]*y+
	_c[3]*z+x))*_f1(t),[``(_f1(t),` are arbitrary functions.`)])
fi:
TEST(");

# Example 39)
eq[39] := diff(f(x,y,z,t),x)*diff(f(x,y,z,t),y)=f(x,y,z,t):
res[39] := pdsolve("):
TEST(",
`&Where`(f(x,y,z,t) = 1/4*((_c[2]*y+x)^2+4*
(_c[2]*y+x)*_f1(z,t)*_c[2]+4*_f1(z,t)^2*_c[2]
^2)/_c[2],[``(_f1(z,t),` are arbitrary functions.`)]) );

# Example 40)
eq[40] := a*diff(f(x,y,z,t),x)+b*diff(f(x,y,z,t),y)+c*diff(f(x,y,z,t),z)+d*
diff(f(x,y,z,t),t) = f(x,y,z,t):
res[40] := pdsolve("):
TEST(",&Where(f(x,y,z,t) = exp((t-_C1)/d)*_f1(-(-x*d+a*t-a*_C1)/d,
-(-y*d+b*t-b*_C1)/d,(z*d-c*t+c*_C1)/d),
[``(_f1(-(-x*d+a*t-a*_C1)/d,-(-y*d+b*t-b*_C1)/d,(z*d-c*t+c*_C1)/d),
` are arbitrary functions.`)]));

# Example 41)
eq[41] := f(x,y)^2*(1+diff(f(x,y),x)^2+diff(f(x,y),y)^2)=1:
res[41] := pdsolve("):
`&Where`(f(x,y) = 1/(-1-_c[2]^2)*(-(1+_c[2]^2)*(-1-_c[2]^2+
(_c[2]*y+x-_C1)^2/(-1/(1+_c[2]^2)-1/(1+_c[2]^2)*_c[2]^2)^2))^(1/2),
[``(`There are no arbitrary functions`)]):

if (normal@expand)(""-")=0 then ""," else
"",`&Where`(f(x,y) = -1/(-1-_c[2]^2)*
	(-(1+_c[2]^2)*(-1-_c[2]^2+(_c[2]*y+x-_C1)^2/(-1/(1+_c[2]^2)-1/(1+_c[2]^2)
	*_c[2]^2)^2))^(1/2),[``(`There are no arbitrary functions`)]):
fi:
TEST(");

#
# Case first order (3rd. hint)
# (f=x1*p1+x2*p2+...+xn*pn+g(p1,p2,...,pn) )
#

# Example 42)
eq[42] :=f(x,y,z,t)=x*diff(f(x,y,z,t),x)+t*diff(f(x,y,z,t),t)+
ln(diff(f(x,y,z,t),x)-diff(f(x,y,z,t),t))*diff(f(x,y,z,t),x):
res[42] := pdsolve("):
TEST(",`&Where`(f(x,y,z,t) = x*_f1(y,z)+t*_f2(y,z)+ln(_f1(y,z)-_f2(y,z))*
_f1(y,z),[``(_f1(y,z),_f2(y,z),` are arbitrary functions.`)]));

# Example 43)
eq[43] :=f(x,y)=x*diff(f(x,y),x)+y*diff(f(x,y),y)+g(diff(f(x,y),x)):
res[43] := pdsolve("):
TEST(",`&Where`(f(x,y) = x*_c[1]+y*_c[2]+g(_c[1]),
[``(g(_c[1]),` are arbitrary functions.`)]));

# Example 44)
eq[44] :=x*diff(f(x,y,z),x)+y*diff(f(x,y,z),y)+G(diff(f(x,y,z),x)^(1/2))=
f(x,y,z):
res[44] := pdsolve("):
TEST(",`&Where`(f(x,y,z) = x*_f1(z)+y*_f2(z)+G(_f1(z)^(1/2)),
[``(G(_f1(z)^(1/2)),_f1(z),_f2(z),` are arbitrary functions.`)]));

# Example 45)
eq[45] :=x*diff(f(x,y,z),x)+y*diff(f(x,y,z),y)+exp(diff(f(x,y,z),x))*
diff(f(x,y,z),y)-f(x,y,z):
res[45] := pdsolve("):
TEST(", `&Where`(f(x,y,z) = x*_f1(z)+y*_f2(z)+exp(_f1(z))*_f2(z),
[``(_f1(z),_f2(z),` are arbitrary functions.`)]));

# Example 46)
eq[46] :=x*diff(f(x,y,z),x)+y*diff(f(x,y,z),y)+z*diff(f(x,y,z),z)-
sin(1/diff(f(x,y,z),x))*diff(f(x,y,z),z)-f(x,y,z):

res[46] := pdsolve("):

TEST(",`&Where`(f(x,y,z) = x*_c[1]+_c[2]*y+_c[3]*z-sin(1/_c[1])*_c[3],
[``(`There are no arbitrary functions`)]));

#
# Case second order (derivatives with constant coefficients)
#

# Example 47) Hyperbolic

eq[47] := f(x,y)+diff(f(x,y),x,x) + 2*diff(f(x,y),x,y) + diff(f(x,y),y,y):

res[47] := pdsolve("):

TEST(",&Where(f(x,y)=_f1(_xi1)*_f00(_xi2),[{diff(diff(_f1(_xi1),_xi1),_xi1)
=_c[1]-_f1(_xi1),_f00(_xi2)*_c[1]=0}, &and({_xi2=y-x,_xi1=1/2*y+1/2*x})]));

# Example 48) Hyperbolic
eq[48] := 2*diff(psi(x,y),x,x) + diff(psi(x,y),y,x)+x^2:

res[48] := pdsolve("):

TEST(",&Where(psi(x,y) = (_C1+8*Int(_xi1^2,_xi1))*_xi2+8*_xi1*Int(_xi2^2,
_xi2)-16*Int(_xi1,_xi1)*Int(_xi2,_xi2)+_psi2(_xi1)+_psi1(_xi2)+_C2,
[``(_psi1(_xi2),_psi2(_xi1),` are arbitrary functions.`),
&and({_xi1 = y-1/2*x, _xi2 = y})]));

# Example 49) Hyperbolic
eq[49] := 1/4*diff(f(x,y),x,y) +2*diff(f(x,y),y,y)-diff(f(x,y),x,x):

res[49] := pdsolve("):

TEST(",`&Where`(f(x,y) = _f1(_xi1)+_f2(_xi2),[``(_f1(_xi1),_f2(_xi2),
` are arbitrary functions.`),`&and`({_xi1 = y-x*(-1/8-1/8*129^(1/2)),
_xi2 = y-x*(-1/8+1/8*129^(1/2))})]));

# Example 50) 
eq[50] := diff(f(x,y,z),x,z) +diff(f(x,y,z),x,y) + g(x)**diff(f(x,y,z),y):
res[50] := pdsolve("):
TEST(",&Where(f(x,y,z) = _f1(x)+_f2(y)+_f3(z)+_f1(x)*_f3(z)+_f1(x)*_f2(y),
[{diff(_f1(x),x) = -g(x)^(_c[2]*(1+_f1(x)))/(_c[3]+_c[2]), diff(_f3(z),z)
 = _c[3], diff(_f2(y),y) = _c[2]}]));

# Example 51)
eq[51] := diff(f(x,y),x,x)-4*diff(f(x,y),y,y) + x*diff(f(x,y),x) +
y*diff(f(x,y),y):
res[51] := pdsolve("):
TEST(",&Where(f(x,y) = _f1(x)*_f2(y),[{diff(diff(_f1(x),x),x) = _c[1]*_f1(x)
-x*diff(_f1(x),x), diff(diff(_f2(y),y),y) = 1/4*_c[1]*_f2(y)+1/4*y*
diff(_f2(y),y)}]));

# Example 52)
eq[52] :=h(x)*diff(f(x,y),x,y) + 4*diff(f(x,y),x,x):
res[52] := pdsolve("):

&Where(f(x,y) = _f1(x)*_f2(y),[{diff(diff(_f1(x),x),x) = _c[1]*h(x)
*diff(_f1(x),x), diff(_f2(y),y) = -4*_c[1]*_f2(y)}]):

if "" =" then ""," else
"",&Where(f(x,y) = _f1(x)*_f2(y),[{diff(_f2(y),y) = -4*_f2(y)/_c[1],
 diff(diff(_f1(x),x),x) = h(x)*diff(_f1(x),x)/_c[1]}])
fi:
TEST(");

# Example 53) Elliptic
eq[53] :=diff(f(x,y),x,x) +1/4*diff(f(x,y),x,y) - diff(f(x,y),y,y):
res[53] := pdsolve("):
TEST(",&Where(f(x,y) = _f1(_xi1)+_f2(_xi2),[``(_f1(_xi1),_f2(_xi2),
` are arbitrary functions.`), &and({_xi2 = y-x*(1/8-1/8*65^(1/2)), _xi1 = y-x*(1
/8+1/8*65^(1/2))})]));

#
# No case (separation of variables)
#

# Example 54)
eq[54] := diff(f(x,y,z),y)*diff(f(x,y,z),x,x)*x+1+diff(f(x,y,z),z)=0:
res[54] := pdsolve("):
TEST(",`&Where`(f(x,y,z) = _f1(x)+_f2(y)+_f3(z),[{diff(_f2(y),y) =_c[2],
diff(diff(_f1(x),x),x) = -(1+_c[3])/_c[2]/x, diff(_f3(z),z) = _c[3]}]));

# Example 55)
eq[55] := diff(f(x,y),y)^2+diff(f(x,y),x)=0:
res[55] := pdsolve("):
TEST(",`&Where`(f(x,y) = _f1(x)+_f2(y),[{diff(_f2(y),y) = _c[2],
diff(_f1(x),x) = -_c[2]^2}]));

# Example 56)
eq[56] := diff(f(x,y,z),z,z)/(diff(f(x,y,z),x,y)+x^2)=0:
res[56] := pdsolve("):
TEST(",`&Where`(f(x,y,z) = _f2(x,y)+_C2+(_f1(x,y)+_C1)*z,
[``(_f1(x,y),_f2(x,y),` are arbitrary functions.`)]));

# Example 57)
eq[57] := exp(diff(f(x,y,z),x$5,z))+diff(f(x,y,z),y$4)+h(y,z):
res[57] := Value(pdsolve(")):
TEST(",`&Where`(f(x,y,z) = _f1(x)+_f3(z)*_f1(x)+__f44(z)-int(int(int(int(
h(y,z),y),y),y),y)+1/2*__f42(z)*y^2+1/6*__f41(z)*y^3-1/24*exp(diff(_f3(z),z)*
_c[1])*y^4+_C4+1/6*_C1*y^3+1/2*_C2*y^2+(_C3+__f43(z))*y,
[{diff(diff(diff(diff(diff(_f1(x),x),x),x),x),x) = _c[1]},``(__f41(z),
__f42(z),__f43(z),__f44(z),_f3(z),` are arbitrary functions.`)]));

# Example 58)
eq[58] := exp(diff(f(x,y),x$5)+y)+diff(f(x,y),y$4):
res[58] := pdsolve("):
TEST(",`&Where`(f(x,y)=_f1(x)+_f2(y),[{diff(diff(diff(diff(_f2(y),y),y),y),y)
= -exp(_c[1]+y), diff(diff(diff(diff(diff(_f1(x),x),x),x),x),x) = _c[1]}]));

# Example 59)
eq[59] := diff(f(x,y,z),y)*(diff(f(x,y,z),x,x)*x+1):
res[59] := pdsolve("):
TEST(",`&Where`(f(x,y,z) = _f1(x)+_f2(y)+_f0(z),[{diff(_f2(y),y) = _c[2],
diff(diff(_f1(x),x),x) = -1/x},``(_f0(z),` are arbitrary functions.`)]));

# Example 60)
eq[60] := diff(f(x,y),x,x) - diff(f(x,y),y,y)+lambda/x*diff(f(x,y),x):
res[60] := pdsolve("):
TEST(",`&Where`(f(x,y) = _f1(x)*_f2(y),[{diff(diff(_f1(x),x),x) =_f1(x)*_c[1]
-lambda*diff(_f1(x),x)/x, diff(diff(_f2(y),y),y) = _f2(y)*_c[1]}]));

# Example 61)
eq[61] := exp(diff(f(x,y),x$5))+diff(f(x,y),y$4)*g(x)*h(y):
res[61] := pdsolve("):
TEST(",`&Where`(f(x,y) = _f1(x)+_f2(y),
[{diff(diff(diff(diff(diff(_f1(x),x),x),x),x),x) = ln(_c
[1]*g(x)), diff(diff(diff(diff(_f2(y),y),y),y),y) = -_c[1]/h(y)}]) );

# Example 62)
#eq[62] := limit(diff(f(x,y),x)-1/diff(f(x,y),y)^n,n=infinity):
#res[62] := pdsolve(",INTEGRATE);
#TEST(",`&Where`(f(x,y) = _f1(x)+_f2(y),[{{_f2(y) = _c[2]*y+_C1},
#limit(diff(_f1(x),x)-_c[2]^(-n),n = infinity) = 0}]));

# Example 63)
eq[63] := x^2*diff(f(x,y),x)+y*diff(f(x,y),y)+(diff(f(x,y),y)^2+
diff(f(x,y),x))=0:
res[63] := pdsolve("):
TEST(",`&Where`(f(x,y) = _f1(x)+_f2(y),[{diff(_f1(x),x) = _c[1]/(x^2+1),
diff(_f2(y),y)^2 = -_c[1]-y*diff(_f2(y),y)}]));

# Example 64)
eq[64] := diff(f(x,y,z),z,z)/(diff(f(x,y,z),x,y)+x^2)=1:
res[64] := pdsolve("):
TEST(",`&Where`(f(x,y,z) = _f1(x)+_f2(y)+_f3(z)+_f1(x)*_f2(y),
[{diff(_f2(y),y) = _c[2], diff(diff(_f3(z),z),z) = _c[3], diff(_f1(x),x)
= -(-_c[3]+x^2)/_c[2]}]));

# Example 65)
eq[65] := exp(diff(f(x,y,z,t1,t2),x$5)*y)+diff(f(x,y,z,t1,t2)*z,y$4):
res[65] := pdsolve("):
TEST(",`&Where`(f(x,y,z,t1,t2) = _f00(z)*_f1(x)+__f64(z,t1,t2)+_C1*Int(Int(
y,y),y)+__f62(z,t1,t2)*Int(y,y)+__f61(z,t1,t2)*Int(Int(y,y),y)+_C4+_C2*
Int(y,y)+(__f63(z,t1,t2)+_C3)*y-1/z*Int(Int(Int(Int(exp(_c[1]*_f00(z)*
y),y),y),y),y),[{diff(diff(diff(diff(diff(_f1(x),x),x),x),x),x) = _c[1]},
``(__f61(z,t1,t2),__f62(z,t1,t2),__f63(z,t1,t2),__f64(z,t1,t2),_f00(z),
` are arbitrary functions.`)]));

#
# HINTS
#

# Example 66)
eq[66] := S(xi,eta)*diff(diff(S(xi,eta),eta),xi)+diff(S(xi,eta),xi)*
diff(S(xi,eta),eta)-1 = 0:
res[66] := pdsolve(",HINT=`+`):

`&Where`(S(xi,eta) = _S1(xi)+_S2(eta),[{diff(_S2(eta),eta) = _c[1],
diff(_S1(xi),xi) = 1/_c[1]}]):

if ""-"=0 then "","
else res[66],`&Where`(S(xi,eta) = _S1(xi)+_S2(eta),
	[{diff(_S2(eta),eta)= 1/_c[1], diff(_S1(xi),xi) = _c[1]}])
fi:
TEST(");

# Example 67)
eq[67] := diff(f(x,y,z),x,y)+diff(f(x,y,z),x,z$5):
res[67] := pdsolve(",HINT=f1(x)/f2(y)+f3(z)):
TEST(",
`&Where`(f(x,y,z) = f1(x)/f2(y)+f3(z),[{diff(f1(x),x) = _c[1], 
-_c[1]/f2(y)^2*diff(f2(y),y) = 0},
``(f3(z),` are arbitrary functions.`)]) );

# Example 68)#OK
eq[68] := -diff(f(x,y),x,x) +1/4*diff(f(x,y),x,y) - diff(f(x,y),y,y):
res[68] := pdsolve(",HINT=`+`):
TEST(",`&Where`(f(x,y) = _f1(x)+_f2(y),[{diff(diff(_f2(y),y),y) = _c[2],
diff(diff(_f1(x),x),x) = -_c[2]}]));

# Example 69)
eq[69] := x*diff(f(x,y),x)+y*diff(f(x,y),y)+G(diff(f(x,y),x)^(1/2))=f(x,y):
res[69] := pdsolve(",HINT=`+`):
TEST(",
`&Where`(f(x,y) = _f1(x)+_f2(y),[{diff(_f2(y),y) = 1/y*_c[2]+_f2(y)/y, diff(
_f1(x),x) = RootOf(x*_Z^2+_c[2]+G(_Z)-_f1(x))^2}]) );

# Example 70)
eq[70] := diff(f(x,y),x,x) + 2*diff(f(x,y),x,y) + 5*diff(f(x,y),y,y) +
3*diff(f(x,y),x) +f(x,y):
res[70] := pdsolve(",HINT=`+`):
TEST(",`&Where`(f(x,y) = _f1(x)+_f2(y),[{diff(diff(_f1(x),x),x) = _c[1]-3*
diff(_f1(x),x)-_f1(x), diff(diff(_f2(y),y),y) = -1/5*_c[1]-1/5*_f2(y)}]));

# Example 71)
eq[71] := diff(f(x,y),x,x) - diff(f(x,y),y,y) +lambda/x*diff(f(x,y),x):
res[71] := pdsolve(",HINT=`+`):
TEST(",`&Where`(f(x,y) = _f1(x)+_f2(y),[{diff(diff(_f1(x),x),x) = _c[2]-
lambda/x*diff(_f1(x),x), diff(diff(_f2(y),y),y) = _c[2]}]));

# Example 72)
eq[72] := cos(diff(f(u,v),v,u))-sin(diff(f(u,v),u,v))=1:
res[72] := pdsolve(",HINT=`*`):
TEST(",`&Where`(f(u,v) = _f1(u)*_f2(v),[{cos(diff(_f1(u),u)*_c[2])-
sin(diff(_f1(u),u)*_c[2])-1 = 0, diff(_f2(v),v) = _c[2]}]),
`&Where`(f(u,v) = _f1(u)*_f2(v),[{diff(_f1(u),u) = -1/2*Pi/_c[2], diff(_f2(v),v
) = _c[2]}]) );

# Example 73)
eq[73] := S(xi,eta)*diff(diff(S(xi,eta),xi),eta)+diff(S(xi,eta),xi)*
diff(S(xi,eta),eta)-1 = 0:
res[73] := pdsolve(",HINT=P(xi,eta)^(1/2)):
TEST(",`&Where`(S(xi,eta) = (_P2(xi)+_P1(eta)+2*xi*eta+_C1*eta+_C2)^(1/2),
[``(_P1(eta),_P2(xi),` are arbitrary functions.`)]));

# Example 74)
eq[74] := diff(f(x,y,z),y)^2+(diff(f(x,y,z),x,x)*x+y+z^(1/2)):
res[74] := pdsolve(",HINT=f1(x)*f3(z)+f2(y)+f3(z)):
TEST(",`&Where`(f(x,y,z) = f1(x)*f3(z)+f2(y)+f3(z),[{z^(1/2) = -_c[2]-
_c[1]*f3(z), diff(diff(f1(x),x),x) = _c[1]/x, diff(f2(y),y)^2 = _c[2]-y}]));

# Example 75)
eq[75] := diff(f(x,y,z),x,y)^2+diff(f(x,y,z),x,z)=g(z):
res[75] := pdsolve(",HINT=`*`):
TEST(",&Where(f(x,y,z) = _f1(x)*(__f41(y)+__f42(z)),[{diff(_f1(x),x) = _c[1], diff(
__f41(y),y) = _c[2], diff(__f42(z),z) = -_c[1]*_c[2]^2+g(z)/_c[1]}]));

#
# HINT = strip
#

# Example 76)
eq[76] := diff(f(x,y),x)+diff(f(x,y),y)+x*y=0:
res[76] := pdsolve(",HINT=strip):
TEST(",`&Where`(f(x,y) = 1/6*x^3-1/2*x*_C1^2+1/3*_C1^3-1/2*x^2*y+1/2*_C1^2*y+
_f1(y-x+_C1),[``(_f1(y-x+_C1),` are arbitrary functions.`)]));

# Example 77)
eq[77] := 2*diff(f(x,y,z),y)+diff(f(x,y,z),x)=x*y+f(x,y,z)*z:
res[77] := pdsolve(",HINT=strip):
TEST(",`&Where`(f(x,y,z) = -(2*z*x+4+z^2*x*y+z*y-exp(z*(x-_C1))*
_f1(y-2*x+2*_C1,z)*z^3)/z^3,[``(_f1(y-2*x+2*_C1,z),
` are arbitrary functions.`)]));

# Example 78)
eq[78] := diff(f(x,y,z),y)*cos(z)/y+diff(f(x,y,z),x)*exp(x)-t:
res[78] := pdsolve("):
TEST(",&Where(f(x,y,z) = -t*exp(-x)+_C1*t+_f1(y^2+2*cos(z)*exp(-x)-2*cos(z)*_C1,z),
[``(_f1(y^2+2*cos(z)*exp(-x)-2*cos(z)*_C1,z),` are arbitrary functions.`)]));

TOTNumber := TOTNumber + Number:
#####################################################################
#
# 2) Command: dchange
#

print(_______________________________________________________________):
print(`Testing procedure dchange.`):
print(_______________________________________________________________):

Number := 0:
_com_inp := _dc:		# The name of the table/input for the command.

# Example 1)
transf := {x=xi+eta,y=xi-eta}:
_dc[1] := transf,diff(f(x,y),x)+g(x,y)+diff(f(x,y),y),[xi,eta]:
TEST(dchange("),diff(f(xi,eta),xi)+g(xi,eta));

# Example 2)
_dc[2] := transf,diff(f(x,y),x)+g(x,y)+diff(f(x,y),y),[xi,eta],known=g:
TEST(dchange("),diff(f(xi,eta),xi)+g(xi+eta,xi-eta));

# Example 3)
_dc[3] := transf,diff(f(x,y),x,x)+2*diff(f(x,y),x,y)+diff(f(x,y),y,y)+
diff(f(x,y),x)-diff(f(x,y),y),[xi,eta]:
TEST(dchange("),diff(diff(f(xi,eta),xi),xi)+diff(f(xi,eta),eta));

# Example 4)
transf := {x=xi,y=xi-eta-kappa,z=kappa+xi}:
_dc[4] := transf,diff(f(x,y,z),x,z)*y+int(diff(f(x,y,z)*z,y),x),
[xi,eta,kappa],combine:
TEST(dchange("),
(-diff(diff(f(xi,eta,kappa),xi),eta)-2*diff(diff(f(xi,eta,kappa),
eta),eta)+3*diff(diff(f(xi,eta,kappa),kappa),eta)+diff(diff(f(xi,eta,kappa),
kappa),xi)-diff(diff(f(xi,eta,kappa),kappa),kappa))*(xi-eta-kappa)+
int((-kappa-xi)*diff(f(xi,eta,kappa),eta),xi));

# Example 5)
#Laplace := f -> diff(f,x,x)+diff(f,y,y)+diff(f,z,z):
#transf := {x=r*cos(phi),y=r*sin(phi),z=Z}:
#_dc[5] := (transf,Laplace,u -> simplify(u,trig)):
#TEST(dchange("),
#f -> (diff(diff(f,phi),phi)+diff(diff(f,Z),Z)*r^2+diff(diff(f,r),r)*
#r^2+diff(f,r)*r)/r^2);

transf := 'transf':
Laplace := 'Laplace':
TOTNumber := TOTNumber + Number:
#####################################################################
#
# 3) Command: pdtest
#

print(_______________________________________________________________):
print(`Testing procedure pdtest.`):
print(_______________________________________________________________):

Number := 0:
_com_inp := _pt:		# The name of the table/input for the command.

# Testing all the examples (above) of pdsolve
for i to nops([indices(eq)]) do
    if i = 62 then next fi; # unable to do this one
    if i <> 17 and i <> 69 then
	_pt[i] := eq[i],res[i]:
	TEST(pdtest(_pt[i]),0);
    fi;
od:

TOTNumber := TOTNumber + Number:
#####################################################################
#
# 4) Command: build
#

print(_______________________________________________________________):
print(`Testing procedure build.`):
print(_______________________________________________________________):

Number := 0:
_com_inp := _bu:		# The name of the table/input for the command.

_bu[1] := res[13]:
TEST(build("),f(x,y)=(2/_c[1]^2*y+_C2)^(1/2)*x*_c[1]
+(2/_c[1]^2*y+_C2)^(1/2)*_C1);

_bu[2] := res[14]:
TEST(build("),f(x,y,z)=_f1(x)+_f2(y,z));

_bu[3] := res[15]:
TEST(build("),f(x,y,z)=_f1(x,z)+_f2(y,z));

_bu[4] := res[16]:
TEST(build("),f(x,y,z,t)=_f1(x,z,t)+_f2(y,z,t));

_bu[5] := res[17]:
TEST(build("),
f(x,y,z) = -_f00(z)*x*_c[1]+_f00(z)*_c[1]*
ln(x)*x+_f00(z)*_C1+_f00(z)*_C2*x+
__f41(z)-2/3*(-y-_c[1]*_f00(z)+z^(1/2))^(3/2)+_C1 );

_bu[6] := res[18]:
TEST(build("),f(x,y,z)=exp(_c[2]^(1/2)*y)*exp((-_c[1]-_c[2])^(1/2)*z)*
_C3*_C5*_C1*exp(_c[1]^(1/2)*x)+exp(_c[2]^(1/2)*y)*exp((-_c[1]-_c[2])^
(1/2)*z)*_C3*_C5*_C2/exp(_c[1]^(1/2)*x)+exp(_c[2]^(1/2)*y)/exp(
(-_c[1]-_c[2])^(1/2)*z)*_C3*_C6*_C1*exp(_c[1]^(1/2)*x)+exp(_c[2]^(1/2)*y)/
exp((-_c[1]-_c[2])^(1/2)*z)*_C3*_C6*_C2/exp(_c[1]^(1/2)*x)+1/exp(_c[2]^
(1/2)*y)*exp((-_c[1]-_c[2])^(1/2)*z)*_C4*_C5*_C1*exp(_c[1]^(1/2)*x)+1/exp(
_c[2]^(1/2)*y)*exp((-_c[1]-_c[2])^(1/2)*z)*_C4*_C5*_C2/exp(_c[1]^(1/2)*x)+
1/exp(_c[2]^(1/2)*y)/exp((-_c[1]-_c[2])^(1/2)*z)*_C4*_C6*_C1*exp(_c[1]^
(1/2)*x)+1/exp(_c[2]^(1/2)*y)/exp((-_c[1]-_c[2])^(1/2)*z)*_C4*_C6*_C2/exp(
_c[1]^(1/2)*x));

_bu[7] := res[19]:
TEST(build("),f(x,y,z,t)= _f2(x,y,z)+Int(Int(t,t),t)+_C2+(_f1(x,y,z)+_C1)*t);

_bu[8] := res[20]:
TEST(build("),f(x,y,z)=exp((-_c[1]+1)^(1/2)*y)*_f00(z)*_C3*_C1*exp(
_c[1]^(1/2)*x)+exp((-_c[1]+1)^(1/2)*y)*_f00(z)*_C3*_C2/exp(_c[1]^(1/2)*x)+
1/exp((-_c[1]+1)^(1/2)*y)*_f00(z)*_C4*_C1*exp(_c[1]^(1/2)*x)+1/exp(
(-_c[1]+1)^(1/2)*y)*_f00(z)*_C4*_C2/exp(_c[1]^(1/2)*x));

_bu[9] := res[21]:
TEST(build("),f(x,y)=x*_c[1]-int(g(x),x)+_C1-
	_c[1]*int(1/g(y),y)+sin(y)+_C2);

_bu[10] := res[22]:

build("),
f(x,y,z) = (-z/(_c[1]+_c[2])+1/(_c[1]+_c[2])*z*
x*_c[1]-1/(_c[1]+_c[2])*z*_c[1]*
ln(x)*x-1/(_c[1]+_c[2])*_C1*z-1/(_c[1]+_c[2])*z*
_C2*x-1/2*z/(_c[1]+_c[2])*_c[2]
*y^2-z/(_c[1]+_c[2])*_C3-z/(_c[1]+_c[2])*_C4*y)/
(1/(_c[1]+_c[2])*_c[1]+1/(_c[1]+_c[2])*_c[2]):

if "[1]<>"[2] then "[1],
f(x,y,z) = _c[3]*z*x*_c[5]-_c[3]*z*x*_c[5]*ln(x)+z*x-z*x*ln(x)+_c[3]*z*_C1
+_c[3]*z*_C2*x+1/2*_c[3]*z*_c[5]*y^2+_c[3]*z*_C3+_c[3]*z*_C4*y:
fi:
TEST(");

_bu[11] := res[23]:
TEST(build(_bu[11]),
f(x,y,z,t) = exp(1/2*_c[3]*z^2)*_C3*_f0(x)*_C1*y^(1/2)*BesselJ(1/3,2/3*(-_c[2])
^(1/2)*y^(3/2))*_C4*exp((_c[3]+_c[2])^(1/2)*t)+exp(1/2*_c[3]*z^2)*_C3*_f0(x)*
_C1*y^(1/2)*BesselJ(1/3,2/3*(-_c[2])^(1/2)*y^(3/2))*_C5/exp((_c[3]+_c[2])^(1/2)
*t)+exp(1/2*_c[3]*z^2)*_C3*_f0(x)*_C2*y^(1/2)*BesselY(1/3,2/3*(-_c[2])^(1/2)*y^
(3/2))*_C4*exp((_c[3]+_c[2])^(1/2)*t)+exp(1/2*_c[3]*z^2)*_C3*_f0(x)*_C2*y^(1/2)
*BesselY(1/3,2/3*(-_c[2])^(1/2)*y^(3/2))*_C5/exp((_c[3]+_c[2])^(1/2)*t),
f(x,y,z,t) = exp(1/2*_c[3]*z^2)*_C3*_f0(x)*_C1*y^(1/2)*BesselY(1/3,2/3*(-_c[2])
^(1/2)*y^(3/2))*_C4*exp((_c[3]+_c[2])^(1/2)*t)+exp(1/2*_c[3]*z^2)*_C3*_f0(x)*
_C1*y^(1/2)*BesselY(1/3,2/3*(-_c[2])^(1/2)*y^(3/2))*_C5/exp((_c[3]+_c[2])^(1/2)
*t)+exp(1/2*_c[3]*z^2)*_C3*_f0(x)*_C2*y^(1/2)*BesselJ(1/3,2/3*(-_c[2])^(1/2)*y^
(3/2))*_C4*exp((_c[3]+_c[2])^(1/2)*t)+exp(1/2*_c[3]*z^2)*_C3*_f0(x)*_C2*y^(1/2)
*BesselJ(1/3,2/3*(-_c[2])^(1/2)*y^(3/2))*_C5/exp((_c[3]+_c[2])^(1/2)*t),
f(x,y,z,t) = exp(1/2*_c[3]*z^2)*_C3*_f0(x)*_C1*y^(1/2)*BesselY(1/3,2/3*(-_c[2])
^(1/2)*y^(3/2))*_C4*exp((_c[3]+_c[2])^(1/2)*t)+exp(1/2*_c[3]*z^2)*_C3*_f0(x)*
_C1*y^(1/2)*BesselY(1/3,2/3*(-_c[2])^(1/2)*y^(3/2))*_C5/exp((_c[3]+_c[2])^(1/2)
*t)+exp(1/2*_c[3]*z^2)*_C3*_f0(x)*_C2*y^(1/2)*BesselJ(1/3,2/3*(-_c[2])^(1/2)*y^
(3/2))*_C4*exp((_c[3]+_c[2])^(1/2)*t)+exp(1/2*_c[3]*z^2)*_C3*_f0(x)*_C2*y^(1/2)
*BesselJ(1/3,2/3*(-_c[2])^(1/2)*y^(3/2))*_C5/exp((_c[3]+_c[2])^(1/2)*t) );

_bu[12] := res[24]:
TEST(build("),f(x,y,z) = exp(-1/y)*_f1((x*y+1)/y,z));

_bu[13] := res[25]:
TEST(build("),f(x,y)=exp(cos(y)*_c[1])*_C2/exp(cos(x)*_c[1])*_C1);

_bu[14] := res[26]:
TEST(build(_bu[14]),
f(x,y,z) = 1/exp(z)*_f0(y)*_C2*x*_c[1]+1/exp(z)*_f0(y)*_C2*_C1+1/exp(z)*_f0(y)*
_C3*exp(-1/4*z*5^(1/2))*exp(5/4*z)*exp(-1/4*I*z*2^(1/2)*(5+5^(1/2))^(1/2))*x*_c
[1]+1/exp(z)*_f0(y)*_C3*exp(-1/4*z*5^(1/2))*exp(5/4*z)*exp(-1/4*I*z*2^(1/2)*(5+
5^(1/2))^(1/2))*_C1+1/exp(z)*_f0(y)*_C4*exp(1/4*z*5^(1/2))*exp(5/4*z)*exp(1/4*I
*z*2^(1/2)*(5-5^(1/2))^(1/2))*x*_c[1]+1/exp(z)*_f0(y)*_C4*exp(1/4*z*5^(1/2))*
exp(5/4*z)*exp(1/4*I*z*2^(1/2)*(5-5^(1/2))^(1/2))*_C1+1/exp(z)*_f0(y)*_C5*exp(1
/4*z*5^(1/2))*exp(5/4*z)*exp(-1/4*I*z*2^(1/2)*(5-5^(1/2))^(1/2))*x*_c[1]+1/exp(
z)*_f0(y)*_C5*exp(1/4*z*5^(1/2))*exp(5/4*z)*exp(-1/4*I*z*2^(1/2)*(5-5^(1/2))^(1
/2))*_C1+1/exp(z)*_f0(y)*_C6*exp(-1/4*z*5^(1/2))*exp(5/4*z)*exp(1/4*I*z*2^(1/2)
*(5+5^(1/2))^(1/2))*x*_c[1]+1/exp(z)*_f0(y)*_C6*exp(-1/4*z*5^(1/2))*exp(5/4*z)*
exp(1/4*I*z*2^(1/2)*(5+5^(1/2))^(1/2))*_C1,
f(x,y,z) = 1/exp(z)*_f0(y)*_C2*x*_c[1]+1/exp(z)*_f0(y)*_C2*_C1+_f0(y)*_C3*exp(-\
1/4*z*5^(1/2))*exp(1/4*z)*exp(1/4*I*z*2^(1/2)*(5+5^(1/2))^(1/2))*x*_c[1]+_f0(y)
*_C3*exp(-1/4*z*5^(1/2))*exp(1/4*z)*exp(1/4*I*z*2^(1/2)*(5+5^(1/2))^(1/2))*_C1+
_f0(y)*_C4*exp(-1/4*z*5^(1/2))*exp(1/4*z)*exp(-1/4*I*z*2^(1/2)*(5+5^(1/2))^(1/2
))*x*_c[1]+_f0(y)*_C4*exp(-1/4*z*5^(1/2))*exp(1/4*z)*exp(-1/4*I*z*2^(1/2)*(5+5^
(1/2))^(1/2))*_C1+_f0(y)*_C5*exp(1/4*z*5^(1/2))*exp(1/4*z)*exp(-1/4*I*z*2^(1/2)
*(5-5^(1/2))^(1/2))*x*_c[1]+_f0(y)*_C5*exp(1/4*z*5^(1/2))*exp(1/4*z)*exp(-1/4*I
*z*2^(1/2)*(5-5^(1/2))^(1/2))*_C1+_f0(y)*_C6*exp(1/4*z*5^(1/2))*exp(1/4*z)*exp(
1/4*I*z*2^(1/2)*(5-5^(1/2))^(1/2))*x*_c[1]+_f0(y)*_C6*exp(1/4*z*5^(1/2))*exp(1/
4*z)*exp(1/4*I*z*2^(1/2)*(5-5^(1/2))^(1/2))*_C1,
f(x,y,z) = 1/exp(z)*_f0(y)*_C2*x*_c[1]+1/exp(z)*_f0(y)*_C2*_C1+_f0(y)*_C3*exp(-\
1/4*z*5^(1/2))*exp(1/4*z)*exp(-1/4*I*z*2^(1/2)*(5+5^(1/2))^(1/2))*x*_c[1]+_f0(y
)*_C3*exp(-1/4*z*5^(1/2))*exp(1/4*z)*exp(-1/4*I*z*2^(1/2)*(5+5^(1/2))^(1/2))*
_C1+_f0(y)*_C4*exp(1/4*z*5^(1/2))*exp(1/4*z)*exp(1/4*I*z*2^(1/2)*(5-5^(1/2))^(1
/2))*x*_c[1]+_f0(y)*_C4*exp(1/4*z*5^(1/2))*exp(1/4*z)*exp(1/4*I*z*2^(1/2)*(5-5^
(1/2))^(1/2))*_C1+_f0(y)*_C5*exp(-1/4*z*5^(1/2))*exp(1/4*z)*exp(1/4*I*z*2^(1/2)
*(5+5^(1/2))^(1/2))*x*_c[1]+_f0(y)*_C5*exp(-1/4*z*5^(1/2))*exp(1/4*z)*exp(1/4*I
*z*2^(1/2)*(5+5^(1/2))^(1/2))*_C1+_f0(y)*_C6*exp(1/4*z*5^(1/2))*exp(1/4*z)*exp(
-1/4*I*z*2^(1/2)*(5-5^(1/2))^(1/2))*x*_c[1]+_f0(y)*_C6*exp(1/4*z*5^(1/2))*exp(1
/4*z)*exp(-1/4*I*z*2^(1/2)*(5-5^(1/2))^(1/2))*_C1,
f(x,y,z) = 1/exp(z)*_f0(y)*_C2*x*_c[1]+1/exp(z)*_f0(y)*_C2*_C1+1/exp(z)*_f0(y)*
_C3*exp(-1/4*z*5^(1/2))*exp(5/4*z)*exp(1/4*I*z*2^(1/2)*(5+5^(1/2))^(1/2))*x*_c[
1]+1/exp(z)*_f0(y)*_C3*exp(-1/4*z*5^(1/2))*exp(5/4*z)*exp(1/4*I*z*2^(1/2)*(5+5^
(1/2))^(1/2))*_C1+1/exp(z)*_f0(y)*_C4*exp(1/4*z*5^(1/2))*exp(5/4*z)*exp(-1/4*I*
z*2^(1/2)*(5-5^(1/2))^(1/2))*x*_c[1]+1/exp(z)*_f0(y)*_C4*exp(1/4*z*5^(1/2))*exp
(5/4*z)*exp(-1/4*I*z*2^(1/2)*(5-5^(1/2))^(1/2))*_C1+1/exp(z)*_f0(y)*_C5*exp(-1/
4*z*5^(1/2))*exp(5/4*z)*exp(-1/4*I*z*2^(1/2)*(5+5^(1/2))^(1/2))*x*_c[1]+1/exp(z
)*_f0(y)*_C5*exp(-1/4*z*5^(1/2))*exp(5/4*z)*exp(-1/4*I*z*2^(1/2)*(5+5^(1/2))^(1
/2))*_C1+1/exp(z)*_f0(y)*_C6*exp(1/4*z*5^(1/2))*exp(5/4*z)*exp(1/4*I*z*2^(1/2)*
(5-5^(1/2))^(1/2))*x*_c[1]+1/exp(z)*_f0(y)*_C6*exp(1/4*z*5^(1/2))*exp(5/4*z)*
exp(1/4*I*z*2^(1/2)*(5-5^(1/2))^(1/2))*_C1,
f(x,y,z) = 1/exp(z)*_f0(y)*_C2*x*_c[1]+1/exp(z)*_f0(y)*_C2*_C1+1/exp(z)*_f0(y)*
_C3*exp(1/4*z*5^(1/2))*exp(5/4*z)*exp(1/4*I*z*2^(1/2)*(5-5^(1/2))^(1/2))*x*_c[1
]+1/exp(z)*_f0(y)*_C3*exp(1/4*z*5^(1/2))*exp(5/4*z)*exp(1/4*I*z*2^(1/2)*(5-5^(1
/2))^(1/2))*_C1+1/exp(z)*_f0(y)*_C4*exp(-1/4*z*5^(1/2))*exp(5/4*z)*exp(-1/4*I*z
*2^(1/2)*(5+5^(1/2))^(1/2))*x*_c[1]+1/exp(z)*_f0(y)*_C4*exp(-1/4*z*5^(1/2))*exp
(5/4*z)*exp(-1/4*I*z*2^(1/2)*(5+5^(1/2))^(1/2))*_C1+1/exp(z)*_f0(y)*_C5*exp(-1/
4*z*5^(1/2))*exp(5/4*z)*exp(1/4*I*z*2^(1/2)*(5+5^(1/2))^(1/2))*x*_c[1]+1/exp(z)
*_f0(y)*_C5*exp(-1/4*z*5^(1/2))*exp(5/4*z)*exp(1/4*I*z*2^(1/2)*(5+5^(1/2))^(1/2
))*_C1+1/exp(z)*_f0(y)*_C6*exp(1/4*z*5^(1/2))*exp(5/4*z)*exp(-1/4*I*z*2^(1/2)*(
5-5^(1/2))^(1/2))*x*_c[1]+1/exp(z)*_f0(y)*_C6*exp(1/4*z*5^(1/2))*exp(5/4*z)*exp
(-1/4*I*z*2^(1/2)*(5-5^(1/2))^(1/2))*_C1,
f(x,y,z) = 1/exp(z)*_f0(y)*_C2*x*_c[1]+1/exp(z)*_f0(y)*_C3*exp(-1/4*z*5^(1/2))*
exp(5/4*z)*exp(-1/4*I*z*2^(1/2)*(5+5^(1/2))^(1/2))*x*_c[1]+1/exp(z)*_f0(y)*_C4*
exp(1/4*z*5^(1/2))*exp(5/4*z)*exp(1/4*I*z*2^(1/2)*(5-5^(1/2))^(1/2))*x*_c[1]+1/
exp(z)*_f0(y)*_C5*exp(-1/4*z*5^(1/2))*exp(5/4*z)*exp(1/4*I*z*2^(1/2)*(5+5^(1/2)
)^(1/2))*x*_c[1]+1/exp(z)*_f0(y)*_C6*exp(1/4*z*5^(1/2))*exp(5/4*z)*exp(-1/4*I*z
*2^(1/2)*(5-5^(1/2))^(1/2))*x*_c[1]+1/exp(z)*_f0(y)*_C2*_C1+1/exp(z)*_f0(y)*_C3
*exp(-1/4*z*5^(1/2))*exp(5/4*z)*exp(-1/4*I*z*2^(1/2)*(5+5^(1/2))^(1/2))*_C1+1/
exp(z)*_f0(y)*_C4*exp(1/4*z*5^(1/2))*exp(5/4*z)*exp(1/4*I*z*2^(1/2)*(5-5^(1/2))
^(1/2))*_C1+1/exp(z)*_f0(y)*_C5*exp(-1/4*z*5^(1/2))*exp(5/4*z)*exp(1/4*I*z*2^(1
/2)*(5+5^(1/2))^(1/2))*_C1+1/exp(z)*_f0(y)*_C6*exp(1/4*z*5^(1/2))*exp(5/4*z)*
exp(-1/4*I*z*2^(1/2)*(5-5^(1/2))^(1/2))*_C1);

_bu[15] := res[27]:
TEST(build(_bu[15]),
f(x,y) = 1/(x^lambda)^(1/2)*_C1*x^(1/2)*BesselJ(1/2*lambda-1/2,(-_c[1])^(1/2)*x
)*_C3*exp(_c[1]^(1/2)*y)+1/(x^lambda)^(1/2)*_C1*x^(1/2)*BesselJ(1/2*lambda-1/2,
(-_c[1])^(1/2)*x)*_C4/exp(_c[1]^(1/2)*y)+1/(x^lambda)^(1/2)*_C2*x^(1/2)*BesselY
(1/2*lambda-1/2,(-_c[1])^(1/2)*x)*_C3*exp(_c[1]^(1/2)*y)+1/(x^lambda)^(1/2)*_C2
*x^(1/2)*BesselY(1/2*lambda-1/2,(-_c[1])^(1/2)*x)*_C4/exp(_c[1]^(1/2)*y),
f(x,y) = exp(_c[1]^(1/2)*y)*_C3*_C1/(x^lambda)^(1/2)*x^(1/2)*BesselY(1/2*lambda
-1/2,(-_c[1])^(1/2)*x)+exp(_c[1]^(1/2)*y)*_C3*_C2/(x^lambda)^(1/2)*x^(1/2)*
BesselJ(1/2*lambda-1/2,(-_c[1])^(1/2)*x)+1/exp(_c[1]^(1/2)*y)*_C4*_C1/(x^lambda
)^(1/2)*x^(1/2)*BesselY(1/2*lambda-1/2,(-_c[1])^(1/2)*x)+1/exp(_c[1]^(1/2)*y)*
_C4*_C2/(x^lambda)^(1/2)*x^(1/2)*BesselJ(1/2*lambda-1/2,(-_c[1])^(1/2)*x),
f(x,y) = exp(_c[1]^(1/2)*y)*_C3*_C1*x^(-1/2*lambda)*x^(1/2)*BesselJ(1/2*lambda-\
1/2,(-_c[1])^(1/2)*x)+exp(_c[1]^(1/2)*y)*_C3*_C2*x^(-1/2*lambda)*x^(1/2)*
BesselY(1/2*lambda-1/2,(-_c[1])^(1/2)*x)+1/exp(_c[1]^(1/2)*y)*_C4*_C1*x^(-1/2*
lambda)*x^(1/2)*BesselJ(1/2*lambda-1/2,(-_c[1])^(1/2)*x)+1/exp(_c[1]^(1/2)*y)*
_C4*_C2*x^(-1/2*lambda)*x^(1/2)*BesselY(1/2*lambda-1/2,(-_c[1])^(1/2)*x) );

#_bu[16] := res[28]:
#TEST(build(_bu[16]),

_bu[17] := res[29]:
TEST(build("),f(x,y)=x*_c[1]-int(g(x),x)+_C1-_c[1]*y-int(g(y),y)+_C2);

_bu[18] := res[30]:
build("),f(x,y,z) = _f1(-cos(y)*_C1*z+cos(x)*_C1/z,z):
if "[1]<>"[2] then "[1],f(x,y,z) = _f1(cos(y)*_C1*z-cos(x)*_C1/z,z) fi:
TEST(");

_bu[19] := res[31]:
TEST(build("),f(x,y) = _f1(y-x+_C1));

_bu[20] := res[32]:
build("),f(t,x,z,y,s) = _f1(-cos(x)*_C1+cos(y*z)/z*_C1,z,t,s):
if "[1]<>"[2] then "[1],f(t,x,z,y,s)=_f1(cos(x)*_C1-cos(y*z)/z*_C1,z,t,s) fi:
TEST(");

_bu[21] := res[33]:
TEST(build("),f(x,y,z) = _f1(1/2*x^2-1/2*y^2+1/2*_C1^2,z));

_bu[22] := res[34]:
build("),u(x,y) = _u1(g(x,y)):
if "[1] <> "[2] then "[1],u(x,y) = _u1(-g(x,y)) fi:
TEST(");

_bu[23] := res[35]:
build("),f(x,y)=_f1(-x^(1/2)*exp(-x*y)):
if "[1] <> "[2] then "[1],f(x,y)=_f1(x^(1/2)*exp(-x*y)) fi:
TEST(");

_bu[24] := res[36]:
build("),f(x,y)=_f1(1/2*_C1*y^2-2/3*x^(3/2)*_C1):
if "[1] <> "[2] then "[1],f(x,y)=_f1(2/3*x^(3/2)*_C1-1/2*_C1*y^2) fi:
TEST(");

_bu[25] := res[37]:
build("),u(x,y) = _u1(y*x/_C1):
if "[1] <> "[2] then "[1],u(x,y)=_u1(-y*x/_C1) fi:
TEST(");

_bu[26] := res[38]:
TEST(build("),f(x,y,z,t)=exp(_c[3]/_c[2]*(_c[2]*y+_c[3]*z+x))*_f1(t));

_bu[27] := res[39]:
TEST(build("),f(x,y,z,t)=(-1/2/_c[2]*(_c[2]*y+x)-_f1(z,t))^2*_c[2]);

_bu[28] := res[40]:
TEST(build("),
f(x,y,z,t) = exp((t-_C1)/d)*_f1(-(-x*d+a*t-a*_C1)/d,-(-y*d+b*t-b*_C1)/d,
-(-z*d+c*t-c*_C1)/d));

_bu[29] := res[41]:
map(u -> u^2,build(")),
f(x,y)^2 =(-1/(-1-_c[2]^2)*((1+_c[2]^2)*(1+_c[2]^2
-(_c[2]*y+x-_C1)^2/(-1/(1+_c[2]^2)-1/(1+_c[2]^2)*_c[2]^2)^2))^(1/2))^2:
TEST(");

_bu[30] := res[42]:
TEST(build("),f(x,y,z,t)=x*_f1(y,z)+t*_f2(y,z)+ln(_f1(y,z)-
	_f2(y,z))*_f1(y,z));

_bu[31] := res[43]:
TEST(build("),f(x,y)=x*_c[1]+_c[2]*y+g(_c[1]));

_bu[32] := res[44]:
TEST(build("),f(x,y,z)=x*_f1(z)+y*_f2(z)+G(_f1(z)^(1/2)));

_bu[33] := res[45]:
TEST(build("),f(x,y,z)=x*_f1(z)+y*_f2(z)+exp(_f1(z))*_f2(z));

_bu[34] := res[46]:
TEST(build("),f(x,y,z)=x*_c[1]+_c[2]*y+_c[3]*z-sin(1/_c[1])*_c[3]);

_bu[35] := res[47]:
TEST(build(_bu[35]),f(x,y)=_f00(y-x)*_C1*cos(1/2*y+1/2*x)+_f00(y-x)*_C2*
sin(1/2*y+1/2*x),
f(x,y) = _f00(y-x)*_C1*sin(1/2*y+1/2*x)+_f00(y-x)*_C2*cos(1/2*y+1/2*x) );

_bu[36] := res[49]:
TEST(build("),f(x,y)=_f1(y-x*(-1/8-1/8*129^(1/2)))+_f2(y-x*(-
	1/8+1/8*129^(1/2))));

_bu[37] := res[51]:
TEST(build("),f(x,y)=DESol({diff(diff(_Y(x),x),x)
+x*diff(_Y(x),x)-_c[1]*_Y(x)},{_Y(x)})*
DESol({4*diff(diff(_Y(y),y),y)-y*diff(_Y(y),y)-_c[1]*_Y(y)},{_Y(y)}));

_bu[38] := res[53]:
TEST(build("),f(x,y)=_f1(y-x*(1/8+1/8*65^(1/2)))+_f2(y-x
*(1/8-1/8*65^(1/2))));

TOTNumber := TOTNumber + Number:
#####################################################################
#
# 4) Command: strip
#

print(_______________________________________________________________):
print(`Testing procedure strip.`):
print(_______________________________________________________________):

Number := 0:
_com_inp := _st:		# The name of the table/input for the command.

# Example 1)
_st[1] := (diff(f(x,y,z),z)+diff(f(x,y,z),y)-f(x,y,z)*x,f(x,y,z)):
TEST(strip("),
{diff(y(_s),_s) = 1,diff(f(_s),_s)=f(_s)*x(_s),
diff(z(_s),_s)=1,diff(x(_s),_s) = 0});

# Example 2)
_st[2] := (f(alpha,beta,sigma)-x*diff(f(alpha,beta,sigma),sigma)-
diff(f(alpha,beta,sigma),alpha)=1/alpha,f(alpha,beta,sigma)):

strip("),{diff(f(_s),_s) = -1/alpha(_s)+f(_s), diff(alpha(_s),_s) = 1,
diff(beta(_s),_s) = 0, diff(sigma(_s),_s) = x}:

if "[1] minus "[2] <> {} then
	"[1],{diff(f(_s),_s) = -f(_s)+1/alpha(_s),
	diff(alpha(_s),_s) = -1, diff(beta(_s),_s) = 0, diff(sigma(_s),_s)=-x}
fi:
TEST(");

# Example 3)
_st[3] := (diff(f(x,y),x)/diff(f(x,y),y)+f(x,y)-x*f(x,y)^2=g(f(x,y)),f(x,y)):
TEST(strip("),`&Where`({diff((_p[2])(_s),_s) = -(_p[2])(_s)+2*(_p[2])(_s)*x(_s)*
f(_s)+(_p[2])(_s)*(D(g))(f(_s)), diff(x(_s),_s) = 1/(_p[2])(_s),
diff(f(_s),_s) = 0, diff(y(_s),_s) = -(_p[1])(_s)/(_p[2])(_s)^2,
diff((_p[1])(_s),_s) = f(_s)^2-(_p[1])(_s)+2*(_p[1])(_s)*x(_s)*f(_s)+
(_p[1])(_s)*(D(g))(f(_s))},{_p[1] = diff(f(x,y),x), _p[2] = diff(f(x,y),y)}));

# Example 4)
_st[4] := (x*diff(f(x,y),y)-diff(f(x,y),x)=f(x,y)/y,f(x,y)):
TEST(strip(") , {diff(f(_s),_s) = f(_s)/y(_s), diff(x(_s),_s) = -1,
diff(y(_s),_s) = x(_s)});

# Example 5)
_st[5] := (diff(f(x,y),x)+y*diff(f(x,y),y)+(diff(f(x,y),y)*diff(f(x,y),x))=0,
f(x,y)):
TEST(strip("), `&Where`({diff(f(_s),_s) = -(_p[1])(_s)-(_p[2])(_s)*y(_s),
diff(x(_s),_s) = 1+(_p[2])(_s), diff((_p[1])(_s),_s) = 0, diff((_p[2])(_s),_s)
= -(_p[2])(_s), diff(y(_s),_s) = y(_s)+(_p[1])(_s)},{_p[1] = diff(f(x,y),x),
_p[2] = diff(f(x,y),y)}));

TOTNumber := TOTNumber + Number:
#####################################################################
#
# 5) Command: splitstrip
#

print(_______________________________________________________________):
print(`Testing procedure splitstrip.`):
print(_______________________________________________________________):

Number := 0:
_com_inp := _sp:		# The name of the table/input for the command.

# Example 1)
_sp[1] := (x*diff(f(x,y),x)+y*diff(f(x,y),y)+(diff(f(x,y),y)^2+
diff(f(x,y),x))=0,f(x,y)):
splitstrip("),
`&Where`({{diff(f(_s),_s) = -x(_s)*(_p[1])(_s)-(_p[1])(_s)-y(_s)*
(_p[2])(_s), diff((_p[2])(_s),_s) = -(_p[2])(_s), diff((_p[1])(_s),_s) =
-(_p[1])(_s), diff(y(_s),_s) = y(_s)+2*(_p[2])(_s), diff(x(_s),_s) =
x(_s)+1}},{_p[2] = diff(f(x,y),y), _p[1] = diff(f(x,y),x)}):

if "[1] minus "[2] <> {} then
	"[1],`&Where`({{diff((_p[2])(_s),_s) =
	(_p[2])(_s),diff(y(_s),_s)=-y(_s)-2*(_p[2])(_s),diff(f(_s),_s)=y(_s)*
	(_p[2])(_s)+x(_s)*(_p[1])(_s)+(_p[1])(_s),diff((_p[1])(_s),_s)=(_p[1])(_s),
	diff(x(_s),_s)=-x(_s)-1}},{_p[2]=diff(f(x,y),y),_p[1]=diff(f(x,y),x)});
fi:
TEST(");

# Example 2)
_sp[2] := (diff(f(x,y,z,t),t)+diff(f(x,y,z,t),x)+f(x,y,z,t)=t,f(x,y,z,t)):
splitstrip("),
{{diff(t(_s),_s) = -1, diff(f(_s),_s) = -t(_s)+f(_s)},
{diff(z(_s),_s) = 0},{diff(x(_s),_s) = -1},{diff(y(_s),_s) = 0}}:

if "[1] minus "[2] <> {} then
	"[1],{{diff(y(_s),_s) = 0},
	{diff(z(_s),_s) = 0}, {diff(f(_s),_s)=-f(_s)+t(_s), diff(t(_s),_s) = 1},
	{diff(x(_s),_s) = 1}}
fi:
TEST(");

# Example 3)
_sp[3] := (diff(f(xi,eta,phi),phi)-(xi+eta)*diff(f(xi,eta,phi),eta)=g(xi+eta),
f(xi,eta,phi)):
splitstrip("),
{{diff(xi(_s),_s) = 0, diff(f(_s),_s) = -g(xi(_s)+eta(_s)),
diff(eta(_s),_s) = xi(_s)+eta(_s)},{diff(phi(_s),_s) = -1}}:

if "[1] minus "[2] <> {} then
	"[1],{{diff(phi(_s),_s) = 1},
	{diff(f(_s),_s) = g(xi(_s)+eta(_s)), diff(eta(_s),_s) = -xi(_s)-eta(_s),
	diff(xi(_s),_s) = 0}}
fi:
TEST(");

# Example 4)
_sp[4] := (x*diff(f(x,y),y)-diff(f(x,y),x)=f(x,y),f(x,y)):
TEST(splitstrip(") ,{{diff(x(_s),_s) = -1, diff(y(_s),_s) = x(_s)},
{diff(f(_s),_s) = f(_s)}});

# Example 5)
_sp[5] := (diff(f(x,y),x)+diff(f(x,y),y)^2,f(x,y)):
TEST(splitstrip("),
 `&Where`({{diff(y(_s),_s) = 2*(_p[2])(_s), diff((_p[2])(_s),_s) = 0},
{diff(x(_s),_s) = 1}, {diff(f(_s),_s) = -(_p[1])(_s), diff((_p[1])(_s),_s) =
0}},{_p[1] = diff(f(x,y),x), _p[2] = diff(f(x,y),y)}));

TOTNumber := TOTNumber + Number:
#####################################################################
# Timing:

print(_______________________________________________________________):
print(cat(`Total number of examples: `,TOTNumber));

# print(cat(`Time consumed: `,time()-TIME0));
TOTNumber := 'TOTNumber':
Number := 'Number':
TIME0 := 'TIME0':
#####################################################################
#quit
