#
## <SHAREFILE=engineer/thyristr/harmonal.mpl >
## <DESCRIBE>
##           Harmonal calculates the harmonic content of a 3 phase,
##           thyristor bridge for a firing angle y (degrees) and a notional
##           frequency 1 Hz and plot the results. 
##                AUTHOR: Alastair Rough, adrough@maplesoft.on.ca
## </DESCRIBE>


#  Maple Procedures for Analysis of 3 Phase Thyristor Bridge.
#  The code is described in the Maple Technical Newsletter Issue 9.
#  Title of article: Harmonic Analysis of Phase Controlled Waveforms
#  Authors: A. D. Rough, rough@manadon.ac.uk, and J. Richardson

#  These procedures calculate the harmonic content of a 3 phase full 
#  wave thyristor bridge rectifier and plot the results for up to
#  24 harmonics and a maximum firing angle of 150 deg.
#  To generate the matrix of harmonic magnitudes enter:
#  makearray():

#  To plot the elements of matrix Darray against its rows (firing angle) and 
#  columns (harmonic number) enter:
#  with(plots,matrixplot):   matrixplot(D);

#  To plot the reconstructed signal against the original using 24 
#  harmonics for firing angle 70 deg and plot the comparison, enter:
#  drawit(24,70);
#
#  Global (major) Variables
#  ------------------------
#  
#  X,Y                         Variable for integration remember table,
#  Darray                      Matrix elements for matrix plot,
#  Clistlist                   `List of lists' for surface plot.
                               
# Define the phase voltages.
v1:=t->sin(t):
v2:=t->sin(t-2*Pi/3):
v3:=t->sin(t-4*Pi/3):


#  Procedure to construct array of harmonic values ax
makearray:=proc()
local i,j,x,y;
global Darray;
Darray:=array(1..25,1..16):
for j from 0 to 15 do;
        y:= evalf(10*j*Pi/180):
        Darray[1,j+1]:=a0(y);
        for i from 1 to 24 do;
          x:=i:
          Darray[i+1,j+1]:=evalf(sqrt((a(x,y))^2 + (b(x,y))^2)):
        od;
od;
end:


#  MapleV procedure to create and plot a listlist of adjacent points
#  from matrix for use by the share library procedure surfdata.
makelist:= proc()
local i,j;
global Clistlist;
        Clistlist:=[seq( [seq([i, j*10, Darray[i+1,j+1]] ,i=0..24)] , j=0..15)]:
end:

#  Plot the original waveform and recomposed Fourier harmonics
drawit := proc(maxharm,y_degree)
local t,y,vline,signal;
              y := evalf(1/180*y_degree*Pi);
              vline(t):=line(y,t);
              signal(t):=checksig(maxharm,y,t);
              plot({vline(t),signal(t)},t = 0 .. 2*Pi,-1 .. 2,style = LINE)
          end:

#  Reconstruct signal to check harmonics for p harmonics at
#  firing angle q.
checksig :=  proc(p,q,t)
local u,signal;
       signal := 1/2*a0(q);
       for u to p do  signal := signal+a(u,q)*cos(u*t)+b(u,q)*sin(u*t) od;
signal;
   end:


r01 := proc(y)
local t;
       1/Pi*(int(v3(t)-v2(t),t = 0 .. 1/6*Pi+y)+
             int(v1(t)-v2(t),t = 1/6*Pi+y .. 1/2*Pi+y)+
             int(v1(t)-v3(t),t = 1/2*Pi+y .. 5/6*Pi+y)+
             int(v2(t)-v3(t),t = 5/6*Pi+y .. 7/6*Pi+y)+
             int(v2(t)-v1(t),t = 7/6*Pi+y .. 3/2*Pi+y)+
             int(v3(t)-v1(t),t = 3/2*Pi+y .. 11/6*Pi+y));
end:
r02 := proc(y)
local t;
       1/Pi*(int(v3(t)-v1(t),t = 0 .. -1/6*Pi+y)+
             int(v3(t)-v2(t),t = -1/6*Pi+y .. 1/6*Pi+y)+
             int(v1(t)-v2(t),t = 1/6*Pi+y .. 1/2*Pi+y)+
             int(v1(t)-v3(t),t = 1/2*Pi+y .. 5/6*Pi+y)+
             int(v2(t)-v3(t),t = 5/6*Pi+y .. 7/6*Pi+y)+
             int(v2(t)-v1(t),t = 7/6*Pi+y .. 3/2*Pi+y)+
             int(v3(t)-v1(t),t = 3/2*Pi+y .. 2*Pi));
end:
r03 := proc(y)
local t:
       1/Pi*(int(v3(t)-v1(t),t = 0 .. 1/6*Pi)+
             int(v3(t)-v2(t),t = -1/6*Pi+y .. 1/2*Pi)+
             int(v1(t)-v2(t),t = 1/6*Pi+y .. 5/6*Pi)+
             int(v1(t)-v3(t),t = 1/2*Pi+y .. 7/6*Pi)+
             int(v2(t)-v3(t),t = 5/6*Pi+y .. 3/2*Pi)+
             int(v2(t)-v1(t),t = 7/6*Pi+y .. 11/6*Pi)+
             int(v3(t)-v1(t),t = 3/2*Pi+y .. 2*Pi));
end:

r04 := proc(y)
local t;
  1/Pi*(int(v3(t)-v1(t),t = -1/2*Pi+y .. 1/6*Pi)+
        int(v3(t)-v2(t),t = -1/6*Pi+y .. 1/2*Pi)+
        int(v1(t)-v2(t),t = 1/6*Pi+y .. 5/6*Pi)+
        int(v1(t)-v3(t),t = 1/2*Pi+y .. 7/6*Pi)+
        int(v2(t)-v3(t),t = 5/6*Pi+y .. 3/2*Pi)+
        int(v2(t)-v1(t),t = 7/6*Pi+y .. 11/6*Pi));
end:
#
ax1 := proc(x,y)
local t;
option remember;

  1/Pi*(int((v3(t)-v2(t))*cos(x*t),t = 0 .. 1/6*Pi+y)+
       int((v1(t)-v2(t))*cos(x*t),t = 1/6*Pi+y .. 1/2*Pi+y)+
       int((v1(t)-v3(t))*cos(x*t),t = 1/2*Pi+y .. 5/6*Pi+y)+
       int((v2(t)-v3(t))*cos(x*t),t = 5/6*Pi+y .. 7/6*Pi+y)+
       int((v2(t)-v1(t))*cos(x*t),t = 7/6*Pi+y .. 3/2*Pi+y)+
       int((v3(t)-v1(t))*cos(x*t),t = 3/2*Pi+y .. 11/6*Pi+y)):
end:

ax2 := proc(x,y)
local t;
option remember;
 1/Pi*(int((v3(t)-v1(t))*cos(x*t),t = 0 .. -1/6*Pi+y)+
       int((v3(t)-v2(t))*cos(x*t),t = -1/6*Pi+y .. 1/6*Pi+y)+
       int((v1(t)-v2(t))*cos(x*t),t = 1/6*Pi+y .. 1/2*Pi+y)+
       int((v1(t)-v3(t))*cos(x*t),t = 1/2*Pi+y .. 5/6*Pi+y)+
       int((v2(t)-v3(t))*cos(x*t),t = 5/6*Pi+y .. 7/6*Pi+y)+
       int((v2(t)-v1(t))*cos(x*t),t = 7/6*Pi+y .. 3/2*Pi+y)+
       int((v3(t)-v1(t))*cos(x*t),t = 3/2*Pi+y .. 2*Pi)):
end:

ax3 := proc(x,y)
local t;
option remember;
 1/Pi*(int((v3(t)-v1(t))*cos(x*t),t = 0 .. 1/6*Pi)+
       int((v3(t)-v2(t))*cos(x*t),t = -1/6*Pi+y .. 1/2*Pi)+
       int((v1(t)-v2(t))*cos(x*t),t = 1/6*Pi+y .. 5/6*Pi)+
       int((v1(t)-v3(t))*cos(x*t),t = 1/2*Pi+y .. 7/6*Pi)+
       int((v2(t)-v3(t))*cos(x*t),t = 5/6*Pi+y .. 3/2*Pi)+
       int((v2(t)-v1(t))*cos(x*t),t = 7/6*Pi+y .. 11/6*Pi)+
       int((v3(t)-v1(t))*cos(x*t),t = 3/2*Pi+y .. 2*Pi)):
end:

ax4 := proc(x,y)
local t;
option remember;
 1/Pi*(int((v3(t)-v1(t))*cos(x*t),t = -1/2*Pi+y .. 1/6*Pi)+
       int((v3(t)-v2(t))*cos(x*t),t = -1/6*Pi+y .. 1/2*Pi)+
       int((v1(t)-v2(t))*cos(x*t),t = 1/6*Pi+y .. 5/6*Pi)+
       int((v1(t)-v3(t))*cos(x*t),t = 1/2*Pi+y .. 7/6*Pi)+
       int((v2(t)-v3(t))*cos(x*t),t = 5/6*Pi+y .. 3/2*Pi)+
       int((v2(t)-v1(t))*cos(x*t),t = 7/6*Pi+y .. 11/6*Pi)):
end:
#
bx1 := proc(x,y)
local t;
option remember;
 1/Pi*(int((v3(t)-v2(t))*sin(x*t),t = 0 .. 1/6*Pi+y)+
       int((v1(t)-v2(t))*sin(x*t),t = 1/6*Pi+y .. 1/2*Pi+y)+
       int((v1(t)-v3(t))*sin(x*t),t = 1/2*Pi+y .. 5/6*Pi+y)+
       int((v2(t)-v3(t))*sin(x*t),t = 5/6*Pi+y .. 7/6*Pi+y)+
       int((v2(t)-v1(t))*sin(x*t),t = 7/6*Pi+y .. 3/2*Pi+y)+
       int((v3(t)-v1(t))*sin(x*t),t = 3/2*Pi+y .. 11/6*Pi+y)):
end:

bx2 := proc(x,y)
local t;
option remember;
 1/Pi*(int((v3(t)-v1(t))*sin(x*t),t = 0 .. -1/6*Pi+y)+
       int((v3(t)-v2(t))*sin(x*t),t = -1/6*Pi+y .. 1/6*Pi+y)+
       int((v1(t)-v2(t))*sin(x*t),t = 1/6*Pi+y .. 1/2*Pi+y)+
       int((v1(t)-v3(t))*sin(x*t),t = 1/2*Pi+y .. 5/6*Pi+y)+
       int((v2(t)-v3(t))*sin(x*t),t = 5/6*Pi+y .. 7/6*Pi+y)+
       int((v2(t)-v1(t))*sin(x*t),t = 7/6*Pi+y .. 3/2*Pi+y)+
       int((v3(t)-v1(t))*sin(x*t),t = 3/2*Pi+y .. 2*Pi)):
end:

bx3 := proc(x,y)
local t;
option remember;
 1/Pi*(int((v3(t)-v1(t))*sin(x*t),t = 0 .. 1/6*Pi)+
       int((v3(t)-v2(t))*sin(x*t),t = -1/6*Pi+y .. 1/2*Pi)+
       int((v1(t)-v2(t))*sin(x*t),t = 1/6*Pi+y .. 5/6*Pi)+
       int((v1(t)-v3(t))*sin(x*t),t = 1/2*Pi+y .. 7/6*Pi)+
       int((v2(t)-v3(t))*sin(x*t),t = 5/6*Pi+y .. 3/2*Pi)+
       int((v2(t)-v1(t))*sin(x*t),t = 7/6*Pi+y .. 11/6*Pi)+
       int((v3(t)-v1(t))*sin(x*t),t = 3/2*Pi+y .. 2*Pi)):
end:

bx4 := proc(x,y)
local t;
option remember;
 1/Pi*(int((v3(t)-v1(t))*sin(x*t),t = -1/2*Pi+y .. 1/6*Pi)+
       int((v3(t)-v2(t))*sin(x*t),t = -1/6*Pi+y .. 1/2*Pi)+
       int((v1(t)-v2(t))*sin(x*t),t = 1/6*Pi+y .. 5/6*Pi)+
       int((v1(t)-v3(t))*sin(x*t),t = 1/2*Pi+y .. 7/6*Pi)+
       int((v2(t)-v3(t))*sin(x*t),t = 5/6*Pi+y .. 3/2*Pi)+
       int((v2(t)-v1(t))*sin(x*t),t = 7/6*Pi+y .. 11/6*Pi)):
end:



a0 := proc(y0)
local r0;
if y0 < evalf(1/6*Pi) then
    r0 := subs(Y=y0,r01(Y));
elif y0 < evalf(1/3*Pi) then
    r0 := subs(Y=y0,r02(Y));
elif y0 < evalf(1/2*Pi) then
    r0 := subs(Y=y0,r03(Y));
else
    r0 := subs(Y=y0,r04(Y));
fi;
evalf(r0);
      end:

a := proc(x0,y0)
local ax;
        if y0 < evalf(1/6*Pi) then
          if x0<>0 and x0<>1 and y0<>0 then
               ax:=subs(X=x0,Y=y0,ax1(X,Y));
          elif (x0=0 or x0=1) and y0=0 then
               ax:=ax1(x0,0);
          elif x0<>0 and y0=0 then
               ax:=subs(X=x0,ax1(X,0));
          elif (x0=0 or x0=1) and y0<>0 then
               ax:=subs(Y=y0,ax1(x0,Y));
          fi;
         elif y0 < evalf(1/3*Pi) then
          if x0<>0 and x0<>1 and y0<>0 then
               ax:=subs(X=x0,Y=y0,ax2(X,Y));
          elif (x0=0 or x0=1) and y0=0 then
               ax:=ax2(x0,0);
          elif x0<>0 and y0=0 then
               ax:=subs(X=x0,ax2(X,0));
          elif (x0=0 or x0=1) and y0<>0 then
               ax:=subs(Y=y0,ax2(x0,Y));
          fi;
         elif y0 < evalf(1/2*Pi) then
          if x0<>0 and x0<>1 and y0<>0 then
               ax:=subs(X=x0,Y=y0,ax3(X,Y));
          elif (x0=0 or x0=1) and y0=0 then
               ax:=ax3(x0,0);
          elif x0<>0 and y0=0 then
               ax:=subs(X=x0,ax3(X,0));
          elif (x0=0 or x0=1) and y0<>0 then
               ax:=subs(Y=y0,ax3(x0,Y));
          fi;
         else
          if x0<>0 and x0<>1 and y0<>0 then
               ax:=subs(X=x0,Y=y0,ax4(X,Y));
          elif (x0=0 or x0=1) and y0=0 then
               ax:=ax4(x0,0);
          elif x0<>0 and y0=0 then
               ax:=subs(X=x0,ax4(X,0));
          elif (x0=0 or x0=1) and y0<>0 then
               ax:=subs(Y=y0,ax4(x0,Y));
          fi;
         fi;
evalf(ax);
end:

b := proc(x0,y0)
local bx;
     if y0 < evalf(1/6*Pi) then
          if x0<>0 and x0<>1 and y0<>0 then
               bx:=subs(X=x0,Y=y0,bx1(X,Y));
          elif (x0=0 or x0=1) and y0=0 then
               bx:=bx1(x0,0);
          elif x0<>0 and y0=0 then
               bx:=subs(X=x0,bx1(X,0));
          elif (x0=0 or x0=1) and y0<>0 then
               bx:=subs(Y=y0,bx1(x0,Y));
          fi;
         elif y0 < evalf(1/3*Pi) then
          if x0<>0 and x0<>1 and y0<>0 then
               bx:=subs(X=x0,Y=y0,bx2(X,Y));
          elif (x0=0 or x0=1) and y0=0 then
               bx:=bx2(x0,0);
          elif x0<>0 and y0=0 then
               bx:=subs(X=x0,bx2(X,0));
          elif (x0=0 or x0=1) and y0<>0 then
               bx:=subs(Y=y0,bx2(x0,Y));
          fi;
         elif y0 < evalf(1/2*Pi) then
          if x0<>0 and x0<>1 and y0<>0 then
               bx:=subs(X=x0,Y=y0,bx3(X,Y));
          elif (x0=0 or x0=1) and y0=0 then
               bx:=bx3(x0,0);
          elif x0<>0 and y0=0 then
               bx:=subs(X=x0,bx3(X,0));
          elif (x0=0 or x0=1) and y0<>0 then
               bx:=subs(Y=y0,bx3(x0,Y));
          fi;
         else
          if x0<>0 and x0<>1 and y0<>0 then
               bx:=subs(X=x0,Y=y0,bx4(X,Y));
          elif (x0=0 or x0=1) and y0=0 then
               bx:=bx4(x0,0);
          elif x0<>0 and y0=0 then
               bx:=subs(X=x0,bx4(X,0));
          elif (x0=0 or x0=1) and y0<>0 then
               bx:=subs(Y=y0,bx4(x0,Y));
          fi;
         fi;
evalf(bx);
end:

# Define the phase controlled line voltage
line := proc(y,t)
local a,b,d,m,n,vline;
     m := signum(t-a);
     n := signum(t-b);
     d(t,a,b) := 1/2*m-1/2*n;
     if y < evalf(1/6*Pi) then
         vline := 
   evalf(subs({a = 0,b = 1/6*Pi+y},d(t,a,b))*(v3(t)-v2(t)))+
   evalf(subs({a = 1/6*Pi+y,b = 1/2*Pi+y},d(t,a,b))*(v1(t)-v2(t)))+
   evalf(subs({a = 1/2*Pi+y,b = 5/6*Pi+y},d(t,a,b))*(v1(t)-v3(t)))+
   evalf(subs({a = 5/6*Pi+y,b = 7/6*Pi+y},d(t,a,b))*(v2(t)-v3(t)))+
   evalf(subs({a = 7/6*Pi+y,b = 3/2*Pi+y},d(t,a,b))*(v2(t)-v1(t)))+
   evalf(subs({a = 3/2*Pi+y,b = 11/6*Pi+y},d(t,a,b))*(v3(t)-v1(t)));
     elif y < evalf(1/3*Pi) then
         vline := 
   evalf(subs({a = 0,b = -1/6*Pi+y},d(t,a,b))*(v3(t)-v1(t)))+
   evalf(subs({b = 1/6*Pi+y,a = -1/6*Pi+y},d(t,a,b))*(v3(t)-v2(t)))+
   evalf(subs({a = 1/6*Pi+y,b = 1/2*Pi+y},d(t,a,b))*(v1(t)-v2(t)))+
   evalf(subs({a = 1/2*Pi+y,b = 5/6*Pi+y},d(t,a,b))*(v1(t)-v3(t)))+
   evalf(subs({a = 5/6*Pi+y,b = 7/6*Pi+y},d(t,a,b))*(v2(t)-v3(t)))+
   evalf(subs({a = 7/6*Pi+y,b = 3/2*Pi+y},d(t,a,b))*(v2(t)-v1(t)))+
   evalf(subs({a = 3/2*Pi+y,b = 2*Pi},d(t,a,b))*(v3(t)-v1(t)));
     elif y < evalf(1/2*Pi) then
         vline := evalf(subs({a = 0,b = 1/6*Pi},d(t,a,b))*(v3(t)-v1(t)))+
   evalf(subs({a = -1/6*Pi+y,b = 1/2*Pi},d(t,a,b))*(v3(t)-v2(t)))+
   evalf(subs({a = 1/6*Pi+y,b = 5/6*Pi},d(t,a,b))*(v1(t)-v2(t)))+
   evalf(subs({a = 1/2*Pi+y,b = 7/6*Pi},d(t,a,b))*(v1(t)-v3(t)))+
   evalf(subs({a = 5/6*Pi+y,b = 3/2*Pi},d(t,a,b))*(v2(t)-v3(t)))+
   evalf(subs({a = 7/6*Pi+y,b = 11/6*Pi},d(t,a,b))*(v2(t)-v1(t)))+
   evalf(subs({a = 3/2*Pi+y,b = 2*Pi},d(t,a,b))*(v3(t)-v1(t)));
     else
         vline := 
   evalf(subs({b = 1/6*Pi,a = -1/2*Pi+y},d(t,a,b))*(v3(t)-v1(t)))+
   evalf(subs({a = -1/6*Pi+y,b = 1/2*Pi},d(t,a,b))*(v3(t)-v2(t)))+
   evalf(subs({a = 1/6*Pi+y,b = 5/6*Pi},d(t,a,b))*(v1(t)-v2(t)))+
   evalf(subs({a = 1/2*Pi+y,b = 7/6*Pi},d(t,a,b))*(v1(t)-v3(t)))+
   evalf(subs({a = 5/6*Pi+y,b = 3/2*Pi},d(t,a,b))*(v2(t)-v3(t)))+
   evalf(subs({a = 7/6*Pi+y,b = 11/6*Pi},d(t,a,b))*(v2(t)-v1(t)));
     fi;
vline;
end:


#save `harmonal.m`;
#quit
