# Test File for CharSets Version 1.2 (in Maple V)
# Copyright (C) 1990-1994 by Dongming Wang 

with(share): readshare(charsets,algebra): # read `charsets.m`;

# the test function for CharSets 
charsets[test]:=`charsets/test`():
`charsets/test` :=

proc()
local aa,ps,ord,ordb,as,f,test_in,test_out,rr;
    ps := [
     x4^2+x4^2*x1-x4*x2-x1*x2*x4+x1*x2+3*x2,x1*x4+x3-x1*x2,x4*x3-2*x2^2-x1*x2-1
     ];
    ord := [x1,x2,x3,x4];
    ordb := [b,c2];
    as := [-1+b+6*b^2+12*b^3];
    f := -6156+29484*b+23328*c2+11664*c2^3-17712*c2^2+67392*c2^2*b^2+58320*
        c2^2*b-58320*b*c2-50544*b^2*c2+17496*b^2;
    test_in := [[`charsets/charset`,[ps,ord]],
        [`charsets/charset`,[ps,ord,'basset']],
        [`charsets/charset`,[ps,ord,'wbasset']],
        [`charsets/charset`,[ps,ord,'qbasset']],
        [`charsets/charset`,[ps,ord,'charsetn']],
        [`charsets/charset`,[ps,ord,'wcharsetn']],
        [`charsets/charset`,[ps,ord,'qcharsetn']],
        [`charsets/charset`,[ps,ord,'triset']],
        [`charsets/charset`,[ps,ord,'trisetc']],[`charsets/mcharset`,[ps,ord]],
        [`charsets/mcharset`,[ps,ord,'basset']],
        [`charsets/mcharset`,[ps,ord,'wbasset']],
        [`charsets/mcharset`,[ps,ord,'qbasset']],
        [`charsets/mcharset`,[ps,ord,'charsetn']],
        [`charsets/mcharset`,[ps,ord,'wcharsetn']],
        [`charsets/mcharset`,[ps,ord,'qcharsetn']],
        [`charsets/mcharset`,[ps,ord,'triset']],
        [`charsets/mcharset`,[ps,ord,'trisetc']],
        [`charsets/iniset`,[[as[1],(4*b^2-1)*f-11],ordb]],
        [`charsets/remset`,[[as[1]-f,f^2,2*f-b^2],[as[1],f],ordb]],
        [`charsets/charser`,[ps,ord]],[`charsets/charser`,[ps,ord,'basset']],
        [`charsets/charser`,[ps,ord,'wbasset']],
        [`charsets/charser`,[ps,ord,'charsetn']],
        [`charsets/charser`,[ps,ord,'wcharsetn']],
        [`charsets/charser`,[ps,ord,'trisetc']],[`charsets/mcs`,[ps,ord]],
        [`charsets/mcs`,[ps,ord,'basset']],[`charsets/mcs`,[ps,ord,'wbasset']],
        [`charsets/mcs`,[ps,ord,'charsetn']],
        [`charsets/mcs`,[ps,ord,'wcharsetn']],
        [`charsets/mcs`,[ps,ord,'trisetc']],[`charsets/ecs`,[ps,ord]],
        [`charsets/ecs`,[ps,ord,'basset']],[`charsets/ecs`,[ps,ord,'wbasset']],
        [`charsets/ecs`,[[ps,x2-x3],ord,'charsetn']],
        [`charsets/ecs`,[ps,ord,'wcharsetn']],
    	[`charsets/ecs`,[ps,ord,'trisetc']],
        [`charsets/mecs`,[ps,ord]],[`charsets/mecs`,[ps,ord,'basset']],
        [`charsets/mecs`,[ps,ord,'wbasset']],
        [`charsets/mecs`,[[ps,x2],ord,'charsetn']],
        [`charsets/mecs`,[ps,ord,'wcharsetn']],
    	[`charsets/mecs`,[ps,ord,'trisetc']],
        [`charsets/triser`,[ps,ord]],
        [`charsets/csolve`,[subs(x1 = 3,ps),{x4,x2,x3}]],
        [`charsets/ics`,[ps,ord]],[`charsets/ics`,[ps,ord,'basset']],
        [`charsets/ics`,[ps,ord,'charsetn']],
	    [`charsets/ics`,[ps,ord,'trisetc']],
        [`charsets/cfactor`,[f,as,ordb]],[`charsets/qics`,[ps,ord]],
        [`charsets/qics`,[ps,ord,'basset']],
	    [`charsets/qics`,[ps,ord,'wbasset']],
        [`charsets/qics`,[ps,ord,'charsetn']],
        [`charsets/qics`,[ps,ord,'wcharsetn']],
	    [`charsets/qics`,[ps,ord,'trisetc']],
        [`charsets/eics`,[ps,ord]],[`charsets/eics`,[ps,ord,'basset']],
        [`charsets/eics`,[[ps,x3],ord,'charsetn']],
        [`charsets/eics`,[ps,ord,'trisetc']],[`charsets/ivd`,[ps,ord]],
        [`charsets/ivd`,[ps,ord,'basset']],[`charsets/ivd`,[ps,ord,'charsetn']],
        [`charsets/ivd`,[ps,ord,'trisetc']]];
    test_out := [{{[x1*(-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1),
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2]}},{{[
    x1*(-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1),
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2]}},{{[
    x1*(-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1),2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,
    x1*x4+x3-x1*x2]}},{{[x1*(-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1),
    2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,x1*x4+x3-x1*x2]}},{{[
    x1*(-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1),
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2]}},{{[
    x1*(-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1),2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,
    x1*x4+x3-x1*x2]}},{{[x1*(-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1),
    2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,x1*x4+x3-x1*x2]}},{{[
    x1*(-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1),2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,
    x1*x4+x3-x1*x2]}},{{[x1*(-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1),
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2]}},{{
    `factors removed` = {x1},[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2]}},{{
    `factors removed` = {x1},[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2]}},{{
    `factors removed` = {x1},[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,x1*x4+x3-x1*x2]}},{{
    `factors removed` = {x1},[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,x1*x4+x3-x1*x2]}},{{
    `factors removed` = {x1},[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2]}},{{
    `factors removed` = {x1},[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,x1*x4+x3-x1*x2]}},{{
    `factors removed` = {x1},[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,x1*x4+x3-x1*x2]}},{{
    `factors removed` = {x1},[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,x1*x4+x3-x1*x2]}},{{
    `factors removed` = {x1},[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2]}},
    {{{2*b+1,2*b-1}}},{{{b^2}}},{{[x1*(-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1),
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2],
    [1+x1,x2,-1+x3^2,-x3+x4],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2]}},{{[
    x1*(-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1),
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2],
    [1+x1,x2,-1+x3^2,-x3+x4],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2]}},{{[
    x1*(-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1),2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,
    x1*x4+x3-x1*x2],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],
    [x1,4*x2^4+4*x2^2+1,-2*x2^3*x3+4*x2^4+4*x2^2-x2*x3+1,x4^2-x4*x2+3*x2],
    [1+x1,x2,-x3^2+2*x2^2+1-x2*x3-x2,x4*x3-2*x2^2-x1*x2-1]}},{{[
    x1*(-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1),
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2],
    [1+x1,x2,-1+x3^2,-x3+x4],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2]}},{{[
    x1*(-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1),2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,
    x1*x4+x3-x1*x2],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],
    [x1,4*x2^4+4*x2^2+1,-2*x2^3*x3+4*x2^4+4*x2^2-x2*x3+1,x4^2-x4*x2+3*x2],
    [1+x1,x2,-1+x3^2,x4*x3-2*x2^2-x1*x2-1]}},{{[
    x1*(-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1),
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2],
    [1+x1,x2,-1+x3^2,-x3+x4],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2]}},{{[
    -2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2],
    [1+x1,x2,-1+x3^2,-x3+x4],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2]}},{{[
    -2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2],
    [1+x1,x2,-1+x3^2,-x3+x4],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2]}},{{[
    -2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,
    x1*x4+x3-x1*x2],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],
    [1+x1,x2,x3^2-2*x2^2-1+x2*x3+x2,x4*x3-2*x2^2-x1*x2-1]},{[
    -2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,
    x1*x4+x3-x1*x2],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],
    [1+x1,x2,-1+x3^2,x4*x3-2*x2^2-x1*x2-1]}},{{[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2],
    [1+x1,x2,-1+x3^2,-x3+x4],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2]}},{{[
    -2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,
    x1*x4+x3-x1*x2],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],
    [1+x1,x2,x3^2-2*x2^2-1+x2*x3+x2,x4*x3-2*x2^2-x1*x2-1]},{[
    -2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,
    x1*x4+x3-x1*x2],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],
    [1+x1,x2,-1+x3^2,x4*x3-2*x2^2-x1*x2-1]}},{{[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2],
    [1+x1,x2,-1+x3^2,-x3+x4],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2]}},{{
    [1+x1,x2,-1+x3^2,-x3+x4],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],[[
    x1*(-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1),
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2],
    x1*(1+x1)]}},{{[1+x1,x2,-1+x3^2,-x3+x4],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],[[
    x1*(-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1),
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2],
    x1*(1+x1)]}},{{[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],
    [[1+x1,x2,-x3^2+2*x2^2+1-x2*x3-x2,x4*x3-2*x2^2-x1*x2-1],x3],[[
    x1*(-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1),2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,
    x1*x4+x3-x1*x2],x1*(1+x1)],[
    [x1,4*x2^4+4*x2^2+1,-2*x2^3*x3+4*x2^4+4*x2^2-x2*x3+1,x4^2-x4*x2+3*x2],
    2*x2^2+1]}},{{[1+x1,x2,-1+x3^2,-x3+x4],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],[[
    x1*(-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1),
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2],
    x1*(x2-x3)*(1+x1)]}},{{[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],
    [1+x1,x2,-1+x3^2,x4*x3-2*x2^2-x1*x2-1],[[
    x1*(-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1),2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,
    x1*x4+x3-x1*x2],x1*(1+x1)],[
    [x1,4*x2^4+4*x2^2+1,-2*x2^3*x3+4*x2^4+4*x2^2-x2*x3+1,x4^2-x4*x2+3*x2],
    2*x2^2+1]}},{{[1+x1,x2,-1+x3^2,-x3+x4],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],[[
    x1*(-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1),
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2],
    x1*(1+x1)]}},{{[1+x1,x2,-1+x3^2,-x3+x4],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],[[
    -2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2],
    x1*(1+x1)]}},{{[1+x1,x2,-1+x3^2,-x3+x4],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],[[
    -2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2],
    x1*(1+x1)]}},{{[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],
    [[1+x1,x2,-x3^2+2*x2^2+1-x2*x3-x2,x4*x3-2*x2^2-x1*x2-1],x3],[[
    -2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,
    x1*x4+x3-x1*x2],x1*(1+x1)],
    [[x1,4*x2^4+4*x2^2+1,2*x2^2+1-x2*x3,x4^2-x4*x2+3*x2],2*x2^2+1]}},{{
    [x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],[[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2],
    x1*x2*(1+x1)]}},{{[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],
    [1+x1,x2,-1+x3^2,x4*x3-2*x2^2-x1*x2-1],[[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,x1*x4+x3-x1*x2],x1*(1+x1)],
    [[x1,4*x2^4+4*x2^2+1,2*x2^2+1-x2*x3,x4^2-x4*x2+3*x2],2*x2^2+1]}},{{
    [1+x1,x2,-1+x3^2,-x3+x4],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],[[
    -2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2],
    x1*(1+x1)]}},{{[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,x1*x4+x3-x1*x2],
    [x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],
    [1+x1,x2,x3^2-2*x2^2-1+x2*x3+x2,x4*x3-2*x2^2-x1*x2-1]},{[
    -2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,
    x1*x4+x3-x1*x2],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],
    [1+x1,x2,-1+x3^2,x4*x3-2*x2^2-x1*x2-1]}},{{{x3 = (-3)/4+3/4*I*23^(1/2),
    x2 = 3/8+1/8*I*23^(1/2),
    x4 = 3/16+1/16*I*23^(1/2)+1/16*2^(1/2)*(-79-21*I*23^(1/2))^(1/2)},{
    x4 = 3/16-1/16*I*23^(1/2)+1/16*2^(1/2)*(-79+21*I*23^(1/2))^(1/2),
    x3 = (-3)/4-3/4*I*23^(1/2),x2 = 3/8-1/8*I*23^(1/2)},{
    x2 = 3/8-1/8*I*23^(1/2),
    x4 = 3/16-1/16*I*23^(1/2)-1/16*2^(1/2)*(-79+21*I*23^(1/2))^(1/2),
    x3 = 15/8+3/8*I*23^(1/2)},{x2 = 3/8+1/8*I*23^(1/2),x3 = 15/8-3/8*I*23^(1/2)
    ,x4 = 3/16+1/16*I*23^(1/2)-1/16*2^(1/2)*(-79-21*I*23^(1/2))^(1/2)}}, {{
    x3 = 15/8+3/8*I*23**(1/2),x4 = -1/4-1/4*I*23**(1/2), 
    x2 = -1/2*(-11+I*23**(1/2))/(7+I*23**(1/2))}, {
    x3 = -3/4+3/4*I*23**(1/2),x4 = 5/8-1/8*I*23**(1/2), 
    x2 = 1/4*(-1+5*I*23**(1/2))/(7+I*23**(1/2))}, {
    x3 = 15/8-3/8*I*23**(1/2), x2 = -1/2*(11+I*23**(1/2))/(-7+I*23**(1/2)), 
    x4 = -1/4+1/4*I*23**(1/2)}, {x3 = -3/4-3/4*I*23**(1/2), 
    x4 = 5/8+1/8*I*23**(1/2), 
    x2 = 1/4*(1+5*I*23**(1/2))/(-7+I*23**(1/2))}}},{{
    [1+x1,x2,x3-1,x4-1],[1+x1,x2,1+x3,1+x4],
    [-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,x3-x1+x1*x2,x4+1-2*x2],
    [-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,-x3-x1+2*x1*x2,x4+x2-1]}},{{
    [1+x1,x2,x3-1,x4-1],[1+x1,x2,1+x3,1+x4],
    [-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,x3-x1+x1*x2,x4+1-2*x2],
    [-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,-x3-x1+2*x1*x2,x4+x2-1]}},{{
    [1+x1,x2,x3-1,x4-1],[1+x1,x2,1+x3,1+x4],
    [-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,x3-x1+x1*x2,x4+1-2*x2],
    [-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,-x3-x1+2*x1*x2,x4+x2-1]}},{{
    [1+x1,x2,x3-1,x4-1],[1+x1,x2,1+x3,1+x4],
    [-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,x3-x1+x1*x2,x4+1-2*x2],
    [-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,-x3-x1+2*x1*x2,x4+x2-1]}},{
    {144*(-27*b-32*c2+48*b^2*c2+27*b^2+27*c2^2+72*b*c2+18)*(12*b^2+7*b+3*c2-1)}
    },{{[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2],
    [x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],[1+x1,x2,x3-1,x4-1],[1+x1,x2,1+x3,1+x4]}},
    {{[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2],
    [x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],[1+x1,x2,x3-1,x4-1],[1+x1,x2,1+x3,1+x4]}},
    {{[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,
    x1*x4+x3-x1*x2],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],
    [1+x1,x2,x3^2-2*x2^2-1+x2*x3+x2,x4*x3-2*x2^2-x1*x2-1]},{[
    -2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,
    x1*x4+x3-x1*x2],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],[1+x1,x2,x3-1,x4-1],
    [1+x1,x2,1+x3,1+x4]}},{{[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2],
    [x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],[1+x1,x2,x3-1,x4-1],[1+x1,x2,1+x3,1+x4]}},
    {{[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,
    x1*x4+x3-x1*x2],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],
    [1+x1,x2,x3^2-2*x2^2-1+x2*x3+x2,x4*x3-2*x2^2-x1*x2-1]},{[
    -2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,2*x1*x2^2+x1^2*x2+x1+x3^2-x1*x2*x3,
    x1*x4+x3-x1*x2],[x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],[1+x1,x2,x3-1,x4-1],
    [1+x1,x2,1+x3,1+x4]}},{{[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,
    x1^3*x2+3*x1^2*x2+x3^2+x3^2*x1-x1*x2*x3-x1^2*x2*x3,x1*x4+x3-x1*x2],
    [x1,2*x2^2+1,x3,x4^2-x4*x2+3*x2],[1+x1,x2,x3-1,x4-1],[1+x1,x2,1+x3,1+x4]}},
    {{[1+x1,x2,x3-1,x4-1],[1+x1,x2,1+x3,1+x4],
    [[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,-x3-x1+2*x1*x2,x4+x2-1],x1*(1+x1)],
    [x1,2*x2^2+1,x3,x4+x2-1],
    [[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,x3-x1+x1*x2,x4+1-2*x2],x1*(1+x1)],
    [x1,2*x2^2+1,x3,x4+1-2*x2]}},{{[1+x1,x2,x3-1,x4-1],[1+x1,x2,1+x3,1+x4],
    [[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,-x3-x1+2*x1*x2,x4+x2-1],x1*(1+x1)],
    [x1,2*x2^2+1,x3,x4+x2-1],
    [[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,x3-x1+x1*x2,x4+1-2*x2],x1*(1+x1)],
    [x1,2*x2^2+1,x3,x4+1-2*x2]}},{{[1+x1,x2,x3-1,x4-1],[1+x1,x2,1+x3,1+x4],
    [[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,-x3-x1+2*x1*x2,x4+x2-1],x1*x3*(1+x1)],
    [[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,x3-x1+x1*x2,x4+1-2*x2],x1*x3*(1+x1)]}},{{
    [1+x1,x2,x3-1,x4-1],[1+x1,x2,1+x3,1+x4],
    [[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,-x3-x1+2*x1*x2,x4+x2-1],x1*(1+x1)],
    [x1,2*x2^2+1,x3,x4+x2-1],
    [[-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,x3-x1+x1*x2,x4+1-2*x2],x1*(1+x1)],
    [x1,2*x2^2+1,x3,x4+1-2*x2]}},{{
    [-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,x3-x1+x1*x2,x4+1-2*x2],
    [-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,x3+x1-2*x1*x2,x4+x2-1]}},{{
    [-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,x3-x1+x1*x2,x4+1-2*x2],
    [-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,x3+x1-2*x1*x2,x4+x2-1]}},{{
    [-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,x3-x1+x1*x2,x4+1-2*x2],
    [-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,x3+x1-2*x1*x2,x4+x2-1]}},{{
    [-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,x3-x1+x1*x2,x4+1-2*x2],
    [-2*x1*x2+2*x2^2+2*x1*x2^2+1+x1,x3+x1-2*x1*x2,x4+x2-1]}}];
    for i to nops(test_in) do
        aa := traperror(test_in[i][2][3]);
        if aa = lasterror or not type(aa,string) then aa := test_in[i][1]-` `
        else aa := test_in[i][1]-aa
        fi;
        rr := normal({test_in[i][1](op(test_in[i][2]))});
        if `charsets/testsub`(rr,test_out[i]) then
            lprint(`CharSets/Test:`,aa,'Good')
        else lprint(`CharSets/Test:`,aa,'Bad',rr)
        fi
    od
end:

# subroutine for test
`charsets/testsub` :=

    proc(rr,ss)
    local i;
        if member(rr,ss) then true
        else
            for i in ss do
                if `charsets/equal`(rr minus i,i minus rr) then RETURN(true) fi
            od;
            false
        fi
    end:

# subroutine for testsub
`charsets/equal` :=

    proc(a,b)
    local i,j,ind;
        if type(a,list) then
            if nops(a) <> nops(b) then RETURN(false) fi;
            for i to nops(a) do
                if not `charsets/equal`(a[i],b[i]) then RETURN(false) fi
            od;
            true
        elif type(a,set) then
            if nops(a) <> nops(b) then RETURN(false) fi;
            for i in a do
                ind := true;
                for j in b do  if `charsets/equal`(i,j) then ind := false fi od;
                if ind then RETURN(false) fi
            od;
            true
        elif type(b,{set,list}) then false
        elif type(a,`polynom`) then
            if divide(a,b) and divide(b,a) then true else false fi
        elif evalc(a)=evalc(b) then true
        else false
        fi
    end:  

#read `charsets`;
`charsets/test`();
#quit
