#read(`FPS`):
with(share):readshare(FPS,analysis):
# infolevel[FormalPowerSeries] := 1:
interface(echo=1):
TestNr := 0:
kernelopts(printbytes=false):

test := proc(f,x) local S, i, j, s, s1, s2, ord, a, result, V, equal, ind; global TestNr;
   if assigned(TestNr) then TestNr := TestNr + 1 fi;
   equal := proc(S1,S2) local k1,k2;
      k1 := indets(S1,name) minus indets(S2,name);
      k2 := indets(S2,name) minus indets(S1,name);
      evalb(nops(k1)=1 and nops(k2)=1 and subs(op(k1)=op(k2),S1=S2))
   end;
   ord := 10; assume(V>0):
   a := nargs; if type(args[a], list) then result := args[a]; a := a-1 fi;
   S := traperror(`FPS/FPS`(f, x, args[3..a]));
   if type(result, list) and [S]=result then
      RETURN('ok')
   elif type(result, list) and equal([S],result) then
      if assigned(infolevel[FormalPowerSeries]) and infolevel[FormalPowerSeries] > 0 then
         print(f = S);
      fi;
      RETURN('ok')
   elif S = lasterror then
      ERROR(TestNr,`: `,'procname'(args) = S)
   elif assigned(infolevel[FormalPowerSeries]) and infolevel[FormalPowerSeries] > 0 then
      print(f = S);
   fi;

   if has(S, Sum) then
      ind := select((t,x) -> type(t,`^`) and has(op(1,t),x), indets(S), x);
      if ind <> {} then
         ord := iquo(ord, max(op(map(t -> denom(normal(op(2,t))), ind))));
      fi;
      s1 := expand(eval(subs({Product=product, Sum=sum, infinity=ord}, S)));
      ord := max(ord, op(map(t->floor(op(2,t)), indets(s1, identical(x)^rational))));
      s1 := map(simplify, series(s1, x, ord));
      if nargs>2 and args[3] = right then
         s2 := traperror(subs(V=x,series(subs(x=V,f), V, ord)));
         if s2=lasterror then
            s2 := traperror(subs(V=x,series(subs(x=V,normal(f)), V, ord)))
         fi;
         if s2=lasterror then # try asympt
            s2 := traperror(series(subs(x=1/x,asympt(subs(x=1/x,f),x,ord+1)),x,ord));
         fi;
      else
         s2 := traperror(series(f, x, ord));
         if s2=lasterror then s2 := traperror(series(normal(f), x, ord)) fi;
      fi;
      if s2=lasterror then
         ERROR(TestNr,`: problems in series computation for f=`,f) fi;
      s2 := map(simplify, s2);
      if s1 <> s2 then
         if type(s1,series) and type(s2, series) then
            i := 1; j := 1;
            while i < nops(s1) and j < nops(s2) do
               if   testeq(op(i,s1)) then i := i+2
               elif testeq(op(j,s2)) then j := j+2
               elif op(i,s1) = O(1) then break
               elif op(j,s2) = O(1) then break
               elif not (testeq(op(i,s1), op(i,s2)) and op(i+1,s1)=op(j+1,s2)) then
                  ERROR(TestNr,`: coeff `,i,`differs.`,op(i,s1),op(i,s2));
               else i := i+2; j := j+2;
               fi
            od;
         else s1 := convert(s1, polynom); s2 := convert(s2, polynom);
             s := expand(s1-s2); s := series(s, x, ord); s := eval(subs(O=0, s));
             if s <> 0 then 
                if 1+min(op(map(t->op(2,t), indets(s, identical(x)^rational))))<ord then;
                   ERROR(TestNr,`: s1-s2 = `,s) fi
             fi
         fi;
      fi;
      'ok';
   elif testeq(f, S) or testeq(convert(f,exp),S) or testeq(expand(f), S) then 'ok'
   elif nargs>2 and testeq(limit(f, x=0, args[3]), S) then 'ok'
   elif nargs>2 and args[3] = right and
        subs(V=x, series(subs(x=V,f),V,ord)) = series(S+x^ord,x,ord) then 'ok'
   elif convert(series(f+x^ord,x,ord),polynom) = convert(series(S+x^ord,x,ord),polynom) then 'ok'
   else ERROR(TestNr,`: `,'procname'(args), `could not compare`)
   fi;
end: # test

test(x^2*exp(x),x);
test(exp(x^2),x);
test(exp(x)*sinh(x)/x,x);
test(exp(x^2)*erf(x)/x^2,x);
test(exp(x*y),x);
test(x^2*sin(x),x);
test(sin(x)^2,x);
test(sin(x*y),x);
test(sin(x^2),x);
test((sinh(x)/x)^2,x);
test(arctan(x)/x,x);
test(exp(arcsinh(x)),x);
#test(exp(arccosh(x)),x);
# see below for this one; the result of limit() has changed (correctly)
# between R3 and R4
test(x^100*sin(x),x);
test(sin(x^2-y),x);
test(cos(x^3-y),x);
test(tan(arccot(x)),x);
test(exp(x)^2*cos(x),x);
test(Si(x),x);
test(cos(2*arccos(x)),x);
test(cos(4*arccos(x)),x);
test(cos(x)+x*sin(x) - exp(I*x),x); 
test(exp(x)*sin(x)/x,x);
test(x*exp(x)*sin(2*x),x);
test(exp(y*arcsin(x)),x);
test(cos(2*arccos(x)),x);
test(cos(4*arccos(x)),x);
test((1+sqrt(1-x))^2,x);
test(exp(x^(1/3)),x);
test(Int(int(arcsinh(x),x)*x,x)/x,x);
test(cosh(y*arcsin(x)),x);
test(1/(1-A*x-B*x^2),x);
test(x^a*sin(x)^2+x^a*cos(x)^2,x);
test(arccot(1/x),x,right);
test(exp(1/x^2)*(erf(1/x)-1),x,right);
test(exp(1/x),x,left,	[0]);
test(erf(1/x)-1,x,left,	[-2]);
test(erf(1/x)-1,x,right,	[0]);
#done;

# test for exp(arccosh(x)):
res:= traperror(`FPS/FPS`(exp(arccosh(x)),x)):
if res = `no initialisation found` then 'ok'; else res; fi;
# this special result is due to an improvment in limit()'s handling of the
# following complex limit:
# limit(1/(z^2-1)^(1/2),z=0,complex);
# which used to return -I in R3, but now returns undefined (the limit depends
# on direction: consider z = x*(1-2*I), for real x.  In the direction given
# by x --> 0 from the right, the limit is +I (not -I).

# Also, we can test that it does work if we assume the limit is approached
# along the real axis, in which case it should return the result that it
# was returning:
ans:=I*(1-x^2)^(1/2)+x:
a:=`FPS/FPS`(exp(arccosh(x)),x,right):
if value(a) = ans then
   ok;
else
   a;
fi;
a:=`FPS/FPS`(exp(arccosh(x)),x,left):
if value(a) = ans then
   ok;
else
   a;
fi;
a:=`FPS/FPS`(exp(arccosh(x)),x,real):
if value(a) = ans then
   ok;
else
   a;
fi;
#
# Note from Dominik:
# Date: Tue, 10 Oct 1995 17:37:18 +0100
# To: cfarell@maplesoft.com
# Subject: Re: FPS (share) problem
# 
# Mathematically, with our definition of the sqrt function (principal
# value), the limit does not exist.
# 
# Instead of testing whether the error appears, you could also compute
# the one-sided or real valued power series expansion which should be
# what you got in Release 3, as both the limit from left and from right
# is -I for this particular limit. If I remember right, the direction
# can be specified as an additional argument, i.e. FPS(<expr>, x=0, real).
