#
## <SHAREFILE=analysis/sdiff/sdiff.mplu>
## <DESCRIBE>
##           Maple procedure for differentiating expressions containing
##                sums with indexed variables.
##                AUTHOR: A Pindor, pindor@breeze.utirc.utoronto.ca
## </DESCRIBE>
## <UPDATE=R4 >

#--> sdiff(p:expression,x:name)
#
# sdiff(p,x) ==> derivative of p w.r.t. x, where x can be an indexed variable
#                x[j] and p can contain a sum of x[k]'s .
#                Index 'j' and limits of the sums have to be 'assume'd integer.
#                The procedure exits with an error message if there is not
#                enough information about 'j' w.r.t. limits of sums in p
#                to perform the diferentiation.
#
#  Author: Andrzej J. Pindor, University of Toronto, Instructional and
#                            Research Computing, 1994

sdiff:= proc(p,t) local ss,si,sf,dd,ds,ind,tmp,dm,of;
        if op(0,p) <> 'sum' then
           if  type(p,name) or type(p,constant) then
               RETURN(diff(p,t)) fi;
           if type(p,function) then 
               of:=op(1,p);
               RETURN(D(op(0,p))(of)*sdiff(of,t))
           fi;
           if type(p,`*`) then
               dd:=op(1,p); ind:=nops(p);
               ds:=product(op('i',p),'i'=2..ind);
               RETURN(sdiff(dd,t)*ds + dd*sdiff(ds,t)); 
           fi;
           if type(p,`+`) then
               ind:=nops(p);
               ds:=sum(op('i',p),'i'=2..ind);
               RETURN(sdiff(op(1,p),t) + sdiff(ds,t));
           fi;
           if type(p,`^`) then
               dd:=op(1,p); ds:=op(2,p);
               RETURN(p*(sdiff(ds,t)*ln(dd) + ds*sdiff(dd,t)/dd));
           else ERROR(`Wrong argument in sdiff`)
           fi;
        fi;
        if type(t,indexed) then
           si:= op(1,op(2,op(2,p)));
           sf:= op(2,op(2,op(2,p)));
           ss:= op(1,t);
           if is(ss,integer) then
             if is(si,integer) and is(sf,integer) then
              if is(si<=ss) and is(ss<=sf) then        
                 ind:=op(1,op(2,p));
                 ds:=subs(ind=ss,op(1,p));
                 dd:=diff(ds,t);
                 RETURN(dd);
               elif
                 is(si>ss) or is(sf<ss) then
                 RETURN(0) 
               else
                 ERROR(`Not enough information about index `,ss);
               fi;
             else
              ERROR(`Limits of the sum `,si, `and `,sf,` have to be assumed integer`)
             fi;
           else
              ERROR(`Index has to be integer`) 
           fi;
        else
           RETURN(diff(p,t)) 
        fi;
end:


#save `sdiff.m`;
#quit
