#### Test file for orbitals #######
#2345678901234567890123456789012345678901234567890123456789012345678901234567890
#
# author and copyright:  Herbert H. H. Homeier, 1994
# email: na.hhomeier@na-net.ornl.gov
# date: May 20, 1994
# 
# description: test file for orbitals package
#              (procedures to compute real and complex spherical harmonics)
#
macro(
 testofcomplex = `orbitals/testHarmonics`['`test_of_complex_for_lm_equal_to`'],
 conj = `orbitals/testHarmonics`['`complex_conjugate`'],
 testofortho=
`orbitals/testHarmonics`['`test_of_orthonormality_for_lm_equal_to`'],
 testofreal = `orbitals/testHarmonics`['`test_of_real_for_lm_equal_to`']);
#
#
with(share):readshare(orbitals, science):
#read `orbitals.m`:
with(orbitals);
#
#
#2345678901234567890123456789012345678901234567890123456789012345678901234567890
testofcomplex :=
proc(l::nonnegint,m::integer)
    local theta,phi,err;
    option `Copyright 1994 by Herbert H. H. Homeier`;
    ComplexSolidHarmonic(
        l,m,cos(phi)*sin(theta),sin(phi)*sin(theta),cos(theta));
    evalc(expand("));
    expand(
    evalc(ComplexSurfaceHarmonic(l,m,theta,phi))
    );
    err := simplify("-"");
    if err = 0 then RETURN(okay) else RETURN(err) fi;
end:
#2345678901234567890123456789012345678901234567890123456789012345678901234567890
testofreal :=
proc(l::nonnegint,m::integer)
    local theta,phi,err;
    option `Copyright 1994 by Herbert H. H. Homeier`;
    expand(RealSurfaceHarmonic(l,m,theta,phi));
    if m<0 then
      expand(evalc(Im(ComplexSurfaceHarmonic(l,abs(m),theta,phi))));
    else
      expand(evalc(Re(ComplexSurfaceHarmonic(l,abs(m),theta,phi))));
    fi;
    err := simplify("-"");
    if err = 0 then RETURN(okay) else RETURN(err) fi;
end:
#2345678901234567890123456789012345678901234567890123456789012345678901234567890
conj := proc(u::algebraic) subs(I = -I,u) end:
#2345678901234567890123456789012345678901234567890123456789012345678901234567890
testofortho:=proc(l1::nonnegint,m1::integer,l2::nonnegint,m2::integer)
  local result;
  option `Copyright 1994 by Herbert H. H. Homeier`;
  result:=int(sin(theta)*
              int(conj(ComplexSurfaceHarmonic(l1,m1,theta,phi))*
              ComplexSurfaceHarmonic(l2,m2,theta,phi),phi=0..2*Pi)
             ,theta=0..Pi);
  if (l1=l2 and m1=m2 and result=1) or
     (l1<>l2 and result=0) or
     (m1<>m2 and result=0) then
          RETURN(`okay`)
  else
          RETURN(result)
  fi;
end:
#2345678901234567890123456789012345678901234567890123456789012345678901234567890
expr:= ComplexSurfaceHarmonic(3,3,theta,phi):
truev:=-1/8*sin(theta)^3*exp(3*I*phi)*7^(1/2)*5^(1/2)/Pi^(1/2):
if simplify(expr-truev,sqrt)=0 then print(okay); else print(expr); fi;
#
expr:=factor(expr*sqrt(4*Pi/7)):
truev:=-1/4*sin(theta)^3*exp(3*I*phi)*5^(1/2):
if simplify(expr-truev,sqrt)=0 then print(okay); else print(expr); fi;
#
expr:=RealSurfaceHarmonic(5,2,theta,phi):
truev:=1/3225600*sin(theta)^2*(604800*cos(theta)^3-201600*cos(theta))*
cos(2*phi)*11^(1/2)*210^(1/2)/Pi^(1/2):
if simplify(expr-truev,sqrt)=0 then print(okay); else print(expr); fi;
#
expr:=ComplexSolidHarmonic(17,-12,a,b,c):
truev:=78460462080000*1508087^(1/2)/Pi^(1/2)*(1/235438866432000*(a-I*b)^12*c^5
+1/612141052723200*(-a-I*b)*(a-I*b)^13*c^3+1/11426632984166400*
(-a-I*b)^2*(a-I*b)^14*c):
if simplify(expr-truev,sqrt)=0 then print(okay); else print(expr); fi;
#
testofcomplex(3,-1);
testofcomplex(12,7);
testofreal(6,3);
testofreal(17,-4);
testofortho(3,2,3,2);
testofortho(30,1,31,1);
testofortho(1,0,200,17);  
for l from 4 to 5 do
  for m from l-2 to l do
    print(testofcomplex(l,m));
    print(testofreal(l,m));
    for ll from l to 5 do
        print(testofortho(l,m,ll,-ll));
    od;
  od;
od;
#quit
