#
# Produce a list of dimensions of irreducible representations of a
# semisimple Lie algebra.
#
#   dim_table(R,m);    (R = root system of the Lie algebra)  
#
#   R = root system of the Lie algebra
#   m = upper bound on the dimension
# The output is sorted into increasing order, with duplications removed.
#
with(weyl):
dim_table:=proc(R,m) local Wt,wts,sat,v0,v,w,d,res;
  Wt:=weyl['weights'](R); weyl['store'](R);
  wts:=[0]; sat:=0; res:={1};
  while sat<nops(wts) do;
    v0:=wts[sat+1];
    for w in Wt do;
      v:=v0+w; if member(v,wts) then next fi;
      d:=weyl['weyl_dim'](v,R);
      if d>m then next fi;
      wts:=[op(wts),v]; res:={op(res),d};
    od;
    sat:=sat+1;
  od;
  sort([op(res)]);
end;
#
# Example:
#  dim_table(C4,10000);
#
