# file maple3

# Hill Section 3.3 Example 9 p156.
# Sums and scalar multiples of continuous real-valued functions
#
f:= x->x:              # This is the function whose rule is  f(x) = x
twosin:= 2*sin:                                     SUM:= f + sin:
#
# If your computer terminal has graphics capabilities, you should plot these:
plot( {f(x),sin(x),twosin(x),SUM(x)},-Pi..Pi ):
# If your computer terminal does not have graphics capabilities,
#  the following may help you visualise them:
f(0),sin(0),twosin(0),SUM(0);
f(Pi/2),sin(Pi/2),twosin(Pi/2),SUM(Pi/2);
f(Pi/3),sin(Pi/3),twosin(Pi/3),SUM(Pi/3);
# Hill Section 3.3 Example 10 p157 will be done in chapter 4.
quit

# Hill Section 3.4 Example 6 p167.
with(linalg):
v1:= vector( [2,1] ):                         v2:= vector( [-4,-2] ):
b:= vector( [b1,b2] ):
#
# b is a linear combination of v1,v2 if there are scalars a1, a2 such that
evalm(a1*v1 + a2*v2) = b;
# As in    Example 9 of Hill Section 1.3,    this can be done as follows
A:= augment(v1,v2):                       x:= vector( [a1,a2] ):
evalm(A&*x);
# Since this is the same as  a1*v1 + a2*v2,  solve the equation    A*x = b
U:= gausselim( augment(A,b) );
# (a)  b:= vector( [6,3] ):
subs (b1=6, b2=3, evalm(U) );
# Since these equations are consistent, [6,3] is in span {v1,v2}.
# i.e. [6,3] = a1*v1 + a2*v2, where [a1,a2] is given by (for any value of t2):
backsub(");
# (b)  b:= vector( [3,5] ):
subs (b1=3, b2=5, evalm(U) );
# The last row shows the equations are inconsistent.     So [3,5] is not
#  in span {v1,v2}.     i.e. [3,5] is not a linear combination of v1,v2.
quit

# Hill Section 3.5 Example 7 p178.
with(linalg):
v1:= vector([2,-3]):       v2:= vector([4,-2]):        v3:= vector([-4,3]):
# These are linearly dependent if there are numbers c1, c2, c3, not all zero,
# such that                      0 = c1*v1 + c2*v2 + c3*v3
# These can be found as follows
A:= augment( v1,v2,v3 ):
U:= gausselim( augment(A,vector([0,0])) );
x:= backsub(");
# This shows that the  v1,v2,v3  above are linearly dependent. For example
evalm( 2*v1 + 3*v2 + 4*v3 );
# In particular    number of pivot columns in U  <=  rowdim(U)  =  rowdim(A)
# So the equations must always have a solution for any vectors  v1, v2, v3
quit

# Hill Section 3.6 Example 2 p182.
with(linalg):
# Show that the vectors v1,v2,v3 form a basis for R^3, where
v1:=vector([2,1,0]):        v2:=vector([-3,-3,1]):        v3:=vector([-2,1,-1]):
#
# We need to show that v1, v2, v3 span R^3 and are linearly independent
# To show they span R^3, consider an arbitrary vector in R^3
x:=vector([x1,x2,x2]):
# and solve the equation    Ac = x  where
A:= augment( v1,v2,v3 );
gausselim( augment(A,x) );
# Since the pivots on the diagonal of this matrix are all non-zero, the
#    equation    Ac = x  has a solution for any x1,x2,x2, and so they span R^3.
# In fact the solutions are unique and so, setting x1 = x2 = x3 = 0,
#    we can see that the equation    Ac = 0  has only one solution.
# Thus v1, v2, v3 are linearly independent.
quit

# Hill Section 3.6 Example 13 p188.
with(linalg):
c1:= vector([-2,4]):        c2:= vector([1,-2]):        c3:= vector([3,5]):
A:= augment( c1,c2,c3 );
# The three columns c1,c2,c3 of A are in R^2 and are linearly dependent (WHY?)
#
gausselim(A);
# The pivots in columns 1 and 3 of this Echelon form show that
#  c1,c3  are linearly independent and so form a basis for R^2.
#
# The two rows  r1,r2  of A are in R^3 but do not span R^3 (WHY?).  However,
#   if {e1,e2,e3} is the standard basis for R^3, then 
#      {r1,r2,e1,e2,e3} must span R^3.  They are the columns of the matrix
augment( transpose(A),diag(1,1,1) );
gausselim(");
# Since the first three columns are pivots,  {r1,r2,e1} is a basis for R^3.
#    Note that  {r1,r2,e3} is NOT a basis for R^3    (CHECK this).
quit

with(linalg):
I3:= diag(1,1,1):                                  nullspace(I3);
# Output like  {}  indicates that the answer is the zero subspace.
#
# Hill Section 3.6 Example 15 p189.
# Find the null space of the matrix
A:= matrix( [[0, 0, 1, -4],  
             [2,-4,-1, -2],  
             [4,-8, 0,-12]] ):
nullspace(A);
# The displayed vectors are a basis for the null space NS(A), or kernel, of A.
#
# Alternatively, solve the equation  Ax = 0  by reducing A to Echelon form
U:= gausselim(A):                                        nullspace(U);
# Thus  NS(U) = NS(A),  illustrating equation 3.65 of Hill (p 190).
quit

with(linalg):
A:= matrix( [[a11,a12,a12],  
             [a21,a22,a22]] ):
nullspace(A);
rowspace(A);
colspace(A);
rank(A);
quit

# Hill Section 3.7 Examples 3-8 pp 196-201
with(linalg):
# Examples 3 and 4:    Find a basis for the vector space spanned by
v1:= vector( [2,-3,  4, 1, 2] ):       v2:= vector( [  4,-6,  5, 3,-4] ):
v3:= vector( [-10,15,-14, 3, 7] ):     v4:= vector( [ -8,12,-10, 4, 9] ):
#
# This can be done by finding a basis for the row space of the matrix
A:= matrix( [v1, v2, v3, v4] );
rowspace(A);
# Note that this is different from the answer in Hill, who gives
u1:= v1:    u2:= vector( [0,0,-3,1,-8] ):    u3:= vector( [0,0,0,10,1] ):
#
# This illustrates the fact that a basis for a vector space is not unique.
# In fact, Maple's answers are linear combinations of  u1, u2, u3:
evalm( u1/2 + 2*u2/3 - 7*u3/60 ),  evalm( u3/30 - u2/3 ),  evalm( u3/10 );
#    (Exercise: express u1, u2, u3 as linear combinations of Hill's basis)
#
# Now consider the rowspace of the Echelon form U of A.
U:= gausselim(A);
rowspace(U);
#    which shows that    RS(A) = RS(U).

# Examples 5 and 6:    Find bases for the column spaces CS(U) and CS(A):
basis([ col(U,1..5) ]); 
# These are just the pivot columns of U (i.e. the columns of U with pivots)
# An alternative basis for CS(U) may be found by
colspace(U); 
colspace(A);                                     # A basis for CS(A)
# Because of the 1 in the last place of some of these vectors, CS(A) <> CS(U)
#
# Examples 7 and 8:
# These two bases have the same number of vectors as the number of pivots of U.
#            Thus  dim CS(A)  =  dim CS(U)  =  dim RS(U)  =  dim RS(A).
quit

# Hill Section 3.8 Example 7 p215.  (cf. Example 6, p213.)
with(linalg):
# Find the coordinates of the vector x  relative to the basis  u1,u2,u3  where
x:= vector([x1,x2,x3]):
u1:=vector([2,3,-1]):        u2:=vector([2,1,2]):        u3:=vector([4,3,1]):
B:= augment( u1,u2,u3 );
# First check that this is a basis for R^3 using the  rank  function:
rank(B);
# Thus  dim( CS(B) ) = 3  and so the columns are a basis for  R^3.
#
# The coordinates of  x  relative to  {u1,u2,u3}  are given by
xB:= linsolve(B,x);

# Find the coordinates of  x  relative to the basis  v1,v2,v3  where
v1:=vector([1,1,1]):         v2:=vector([0,1,1]):        v3:=vector([0,0,1]):
C:= augment( v1,v2,v3 ):                                xC:= linsolve(C,x);
# Alternatively:
P:= evalm( inverse(C)&*B );
equal( evalm(P&*xB), xC );

# P can also be found by reducing  (C:B)  to row reduced form:
gaussjord( augment(C,B) );
equal( submatrix(",1..3,4..6), P );
quit

# Z2 looks like  {0,1}  except that
modp( 1+1,2 );

# Hill Section 3.9 Examples 3 and 4, pp 225,226.
with(linalg):
u1:= vector( [1,0,0,0,0,1,1] ):              u2:= vector( [0,1,0,0,1,0,1] ):
u3:= vector( [0,0,1,0,1,1,0] ):              u4:= vector( [0,0,0,1,1,1,1] ):
#
H:= matrix([ [0,0,0,1,1,1,1],
             [0,1,1,0,0,1,1],
             [1,0,1,0,1,0,1] ]):
map( modp, evalm(H&*u1), 2 );              # Checking that  u1  is in  NS(H)
# Exercise:  Check that  u2, u3, u4  are also in  NS(H)
#
# Example 4 (p226): Correct (if necessary) the following messages,
#   given that there is at most one error in each.
x:= vector( [0,1,1,0,0,1,1] ):
y:= vector( [0,1,1,1,0,0,1] ):
#
map( modp, evalm(H&*x), 2 );
# So  x  is correct
#
map( modp, evalm(H&*y), 2 );
# Since this is the second column of H, change the second entry in  y:
y[2]:= 0:                                    map( modp, evalm(H&*y), 2 );
quit

