
with(share): readshare(normform,linalg): # read `normform.m`;

A:=array([[-9,21,-15,4,2,0],[-10,21,-14,4,2,0],[-8,16,-11,4,2,0],
          [-6,12,-9,3,3,0],[-4,8,-6,0,5,0],[-2,4,-3,0,1,3]]):
F:=array([[3,0,0,0,0,0],[0,0,0,0,0,15],[0,1,0,0,0,-47],
          [0,0,1,0,0,56],[0,0,0,1,0,-32],[0,0,0,0,1,9]]):
FF:=frobenius(A,'P','Pinv'):
if linalg[iszero](evalm(FF-F)) and
   linalg[iszero](evalm(Pinv-P^(-1))) and
   linalg[iszero](evalm(Pinv&*A&*P-FF)) then
  print('OK')
else
  print(FF,P,Pinv)
fi:

A:=array([[3+I,1-6*I,2+3*I,I],
          [5+2*I,5-I,4+2*I,3-I],
          [2-I,2-I,3+2*I,5],
          [6,7-2*I,3*I,8-4*I]]):
F:=array([[0,0,0,299-1029*I],
          [1,0,0,181+267*I],
          [0,1,0,-83-6*I],
          [0,0,1,19-2*I]]):
FF:=frobenius(A,{I},'P','Pinv'):
if linalg[iszero](map(SIMPLIFY,evalm(FF-F))) and
   linalg[iszero](map(SIMPLIFY,evalm(Pinv-P^(-1)))) and
   linalg[iszero](map(SIMPLIFY,evalm(Pinv&*A&*P-FF))) then
  print('OK')
else
  print(FF,P,Pinv)
fi:

alias(ss=RootOf(x^2-2)):
A:=array([[4*ss-6,-4*ss+7,-3*ss+6],
          [3*ss-6,-3*ss+7,-3*ss+6],
          [3*ss,1-3*ss,-2*ss]]):
F:=array([[ss,0,0],[0,0,2*(4*ss-7)/(ss-2)],[0,1,(5*ss-6)/(ss-2)]]):
FF:=frobenius(A,{ss},'P','Pinv'):
if linalg[iszero](map(SIMPLIFY,evalm(FF-F))) and
   linalg[iszero](map(SIMPLIFY,evalm(Pinv-P^(-1)))) and
   linalg[iszero](map(SIMPLIFY,evalm(Pinv&*A&*P-FF))) then
  print('OK')
else
  print(FF,P,Pinv)
fi:

alias(aa=RootOf(X^3-2*X+X-5)):
A:=array([[11+6*aa^2+2*aa,6*aa^2+10,-6*aa^2-2*aa-10],
          [1+3*aa+aa^2,aa+aa^2,-3*aa-aa^2],
          [4*aa+6*aa^2+10,6*aa^2+10,-9-4*aa-6*aa^2]]):
F:=array([[1-2*aa,0,0],[0,0,10+5*aa^2-aa],[0,1,1+aa+aa^2]]):
FF:=frobenius(A,{aa},'P','Pinv'):
if linalg[iszero](map(SIMPLIFY,evalm(FF-F))) and
   linalg[iszero](map(SIMPLIFY,evalm(Pinv-P^(-1)))) and
   linalg[iszero](map(SIMPLIFY,evalm(Pinv&*A&*P-FF))) then
  print('OK')
else
  print(FF,P,Pinv)
fi:

A:=array([[(y+y^2-x^2)/y,(x-x^2-y+y^2)/y,(x^2-y^2)/y],
          [1+x+y,(x-y+y^2+x*y)/y,-x-y],
          [(y-x+y^2-x^2)/y,(x-y+y^2-x^2)/y,(x+x^2-y^2)/y]]):
F:=array([[x/y,0,0],[0,0,-x*(x+y)/y],[0,1,(x+x*y+y^2)/y]]):
FF:=frobenius(A,'P','Pinv'):
if linalg[iszero](map(SIMPLIFY,evalm(FF-F))) and
   linalg[iszero](map(SIMPLIFY,evalm(Pinv-P^(-1)))) and
   linalg[iszero](map(SIMPLIFY,evalm(Pinv&*A&*P-FF))) then
  print('OK')
else
  print(FF,P,Pinv)
fi:

print(`End of test of frobenius`);

A:=array([[-9,21,-15,4,2,0],[-10,21,-14,4,2,0],[-8,16,-11,4,2,0],
          [-6,12,-9,3,3,0],[-4,8,-6,0,5,0],[-2,4,-3,0,1,3]]):
R1:=array([[3,0,0,0,0,0],[0,3,0,0,0,0],[0,0,1,1,0,0],
          [0,0,0,1,0,0],[0,0,0,0,0,-5],[0,0,0,0,1,4]]):
R2:=array([[1,1,0,0,0,0],[0,1,0,0,0,0],[0,0,3,0,0,0],
           [0,0,0,3,0,0],[0,0,0,0,0,-5],[0,0,0,0,1,4]]):
RR:=ratjordan(A,'P','Pinv'):
if (linalg[iszero](evalm(RR-R1)) or linalg[iszero](evalm(RR-R2))) and
   linalg[iszero](evalm(Pinv-P^(-1))) and
   linalg[iszero](evalm(Pinv&*A&*P-RR)) then
  print('OK')
else
  print(RR,P,Pinv)
fi:

A:=array([[-3-I,1,2+I,7-9*I],
          [-2,1,1,5-I],
          [-2-2*I,1,2+2*I,4-2*I],
          [2,0,-1,-2+8*I]]):
R:=array([[1+I,0,0,0],[0,1+I,0,0],[0,0,0,-2-5*I],[0,0,1,-4+7*I]]):
RR:=ratjordan(A,{I},'P','Pinv'):
if linalg[iszero](map(SIMPLIFY,evalm(RR-R))) and
   linalg[iszero](map(SIMPLIFY,evalm(Pinv-P^(-1)))) and
   linalg[iszero](map(SIMPLIFY,evalm(Pinv&*A&*P-RR))) then
  print('OK')
else
  print(RR,P,Pinv)
fi:

alias(ss=RootOf(x^2-2)):
A:=array([[4*ss-6,-4*ss+7,-3*ss+6],
          [3*ss-6,-3*ss+7,-3*ss+6],
          [3*ss,1-3*ss,-2*ss]]):
R1:=array([[1-3*ss,0,0],[0,ss,0],[0,0,ss]]):
R2:=array([[ss,0,0],[0,ss,0],[0,0,1-3*ss]]):
RR:=ratjordan(A,{ss},'P','Pinv'):
if (linalg[iszero](map(SIMPLIFY,evalm(RR-R1))) or linalg[iszero](map(SIMPLIFY,evalm(RR-R2)))) and
   linalg[iszero](map(SIMPLIFY,evalm(Pinv-P^(-1)))) and
   linalg[iszero](map(SIMPLIFY,evalm(Pinv&*A&*P-RR))) then
  print('OK')
else
  print(RR,P,Pinv)
fi:

alias(aa=RootOf(X^3-2*X+X-5)):
A:=array([[11+6*aa^2+2*aa,6*aa^2+10,-6*aa^2-2*aa-10],
          [1+3*aa+aa^2,aa+aa^2,-3*aa-aa^2],
          [4*aa+6*aa^2+10,6*aa^2+10,-9-4*aa-6*aa^2]]):
R1:=array([[1-2*aa,0,0],[0,1-2*aa,0],[0,0,3*aa+aa^2]]):
R2:=array([[3*aa+aa^2,0,0],[0,1-2*aa,0],[0,0,1-2*aa]]):
RR:=ratjordan(A,{aa},'P','Pinv'):
if (linalg[iszero](map(SIMPLIFY,evalm(RR-R1))) or linalg[iszero](map(SIMPLIFY,evalm(RR-R2)))) and
   linalg[iszero](map(SIMPLIFY,evalm(Pinv-P^(-1)))) and
   linalg[iszero](map(SIMPLIFY,evalm(Pinv&*A&*P-RR))) then
  print('OK')
else
  print(RR,P,Pinv)
fi:

A:=array([[(y+y^2-x^2)/y,(x-x^2-y+y^2)/y,(x^2-y^2)/y],
          [1+x+y,(x-y+y^2+x*y)/y,-x-y],
          [(y-x+y^2-x^2)/y,(x-y+y^2-x^2)/y,(x+x^2-y^2)/y]]):
R1:=array([[x+y,0,0],[0,x/y,0],[0,0,x/y]]):
R2:=array([[x/y,0,0],[0,x/y,0],[0,0,x+y]]):
RR:=ratjordan(A,'P','Pinv'):
if (linalg[iszero](map(SIMPLIFY,evalm(RR-R1))) or linalg[iszero](map(SIMPLIFY,evalm(RR-R2)))) and
   linalg[iszero](map(SIMPLIFY,evalm(Pinv-P^(-1)))) and
   linalg[iszero](map(SIMPLIFY,evalm(Pinv&*A&*P-RR))) then
  print('OK')
else
  print(RR,P,Pinv)
fi:

print(`End of test of ratjordan`);

A:=array([[-9,21,-15,4,2,0],[-10,21,-14,4,2,0],[-8,16,-11,4,2,0],
          [-6,12,-9,3,3,0],[-4,8,-6,0,5,0],[-2,4,-3,0,1,3]]):
J1:=array([[3,0,0,0,0,0],[0,3,0,0,0,0],[0,0,1,1,0,0],
          [0,0,0,1,0,0],[0,0,0,0,x31,0],[0,0,0,0,0,x32]]):
J2:=array([[1,1,0,0,0,0],[0,1,0,0,0,0],[0,0,3,0,0,0],
           [0,0,0,3,0,0],[0,0,0,0,x31,0],[0,0,0,0,0,x32]]):
JJ:=jordansymbolic(A,'P','Pinv'):
if linalg[iszero](evalm(JJ[1]-J1)) or linalg[iszero](evalm(JJ[1]-J2)) then
  print('OK')
else
  print(JJ,P,Pinv)
fi:

A:=array([[-3-I,1,2+I,7-9*I],
          [-2,1,1,5-I],
          [-2-2*I,1,2+2*I,4-2*I],
          [2,0,-1,-2+8*I]]):
J:=array([[1+I,0,0,0],[0,1+I,0,0],[0,0,x21,0],[0,0,0,x22]]):
JJ:=jordansymbolic(A,{I},'P','Pinv'):
if linalg[iszero](map(SIMPLIFY,evalm(JJ[1]-J))) then
  print('OK')
else
  print(JJ,P,Pinv)
fi:

alias(ss=RootOf(x^2-2)):
A:=array([[ss,1-3*ss],[3,1/ss]]):
J:=array([[x11,0],[0,x12]]):
JJ:=jordansymbolic(A,{ss},'P','Pinv'):
if linalg[iszero](map(SIMPLIFY,evalm(JJ[1]-J))) then
  print('OK')
else
  print(JJ,P,Pinv)
fi:

alias(aa=RootOf(X^3-2*X+X-5)):
A:=array([[1-aa,2+aa^2],[3+aa-2*aa^2,3]]):
J:=array([[x11,0],[0,x12]]):
JJ:=jordansymbolic(A,{aa},'P','Pinv'):
if linalg[iszero](map(SIMPLIFY,evalm(JJ[1]-J))) then
  print('OK')
else
  print(JJ,P,Pinv)
fi:

A:=array([[-1,-1/y],[y^2+y+1,y+1]]):
J:=array([[x11,0],[0,x12]]):
JJ:=jordansymbolic(A,'P','Pinv'):
if linalg[iszero](map(SIMPLIFY,evalm(JJ[1]-J))) then
  print('OK')
else
  print(JJ,P,Pinv)
fi:

print(`End of test of jordansymbolic`);

A:=array([[-9,21,-15,4,2,0],[-10,21,-14,4,2,0],[-8,16,-11,4,2,0],
          [-6,12,-9,3,3,0],[-4,8,-6,0,5,0],[-2,4,-3,0,1,3]]):
J1:=array([[3,0,0,0,0,0],[0,3,0,0,0,0],[0,0,1,1,0,0],
          [0,0,0,1,0,0],[0,0,0,0,2+I,0],[0,0,0,0,0,2-I]]):
J2:=array([[3,0,0,0,0,0],[0,3,0,0,0,0],[0,0,1,1,0,0],
          [0,0,0,1,0,0],[0,0,0,0,2-I,0],[0,0,0,0,0,2+I]]):
J3:=array([[1,1,0,0,0,0],[0,1,0,0,0,0],[0,0,3,0,0,0],
           [0,0,0,3,0,0],[0,0,0,0,2+I,0],[0,0,0,0,0,2-I]]):
J4:=array([[1,1,0,0,0,0],[0,1,0,0,0,0],[0,0,3,0,0,0],
           [0,0,0,3,0,0],[0,0,0,0,2-I,0],[0,0,0,0,0,2+I]]):
JJ:=jordan(A,'P','Pinv'):
if (linalg[iszero](evalm(JJ-J1)) or linalg[iszero](evalm(JJ-J2)) or
   linalg[iszero](evalm(JJ-J3)) or linalg[iszero](evalm(JJ-J4))) and
   linalg[iszero](map(evalc,evalm(Pinv-P^(-1)))) and
   linalg[iszero](map(evalc,evalm(Pinv&*A&*P-JJ))) then
  print('OK')
else
  print(JJ,P,Pinv)
fi:

A:=array([[-3-I,1,2+I,7-9*I],
          [-2,1,1,5-I],
          [-2-2*I,1,2+2*I,4-2*I],
          [2,0,-1,-2+8*I]]):
J1:=array([[1+I,0,0,0],[0,1+I,0,0],[0,0,-2+7/2*I+1/2*(-41-76*I)^(1/2),0],[0,0,0,-2+7/2*I-1/2*(-41-76*I)^(1/2)]]):
J2:=array([[1+I,0,0,0],[0,1+I,0,0],[0,0,-2+7/2*I-1/2*(-41-76*I)^(1/2),0],[0,0,0,-2+7/2*I+1/2*(-41-76*I)^(1/2)]]):
JJ:=jordan(A,{I},'P','Pinv'):
if linalg[iszero](map(SIMPLIFY,evalm(JJ-J1))) or linalg[iszero](map(SIMPLIFY,evalm(JJ-J2))) then
  print('OK')
else
  print(JJ,P,Pinv)
fi:

print(`End of test of jordan`);

testsmithex:=proc(A,S,L,R)
local SS,LL,RR;
  SS:=smithex(A,x,'LL','RR');
  if linalg[equal](SS,S) and linalg[equal](LL,L) and linalg[equal](RR,R) then
    print('OK')
  else
    print(SS,LL,RR)
  fi
end:

A:=array([[3*x,x^2+x],[0,x^2]]):
S:=array([[x,0],[0,x^2]]):
L:=array([[1,0],[x,1]]):
R:=array([[3,x+1],[-3,-x]]):
testsmithex(A,S,L,R):

A:=array([[y^2*x,x^2-(1+y)*x],[x,x^2*(y-2)]]):
S:=array([[x,0],[0,x*(y^3*x-2*y^2*x-x+1+y)/(y^3-2*y^2-1)]]):
L:=array([[-(-y^5+2*y^4+y^2+1+y+x*y^3-2*x*y^2-x)/(y^3-2*y^2-1),-1],[1,0]]):
R:=array([[1,x*(y-2)],[-1,-y*x+2*x+y^3-2*y^2-1]]):
testsmithex(A,S,L,R):

print(`End of test of smithex`);

testismithex:=proc(A,S,L,R)
local SS,LL,RR;
  SS:=ismithex(A,'LL','RR');
  if linalg[equal](SS,S) and linalg[equal](LL,L) and linalg[equal](RR,R) then
    print('OK')
  else
    print(SS,LL,RR)
  fi
end:

A:=array([[9,-36,30],[-36,192,-180],[30,-180,180]]):
S:=array([[3,0,0],[0,12,0],[0,0,60]]):
L:=array([[-17,-5,-4],[64,19,15],[-50,-15,-12]]):
R:=array([[1,-24,30],[-1,25,-30],[0,-1,1]]):
testismithex(A,S,L,R):

print(`End of test of ismithex`);
#quit
