#
## <SHAREFILE=numerics/fit/fit.mpl >
## <DESCRIBE>
##                A (linear) least squares fit of a curve to a set of data.
##                fit(X, Y, B, v) fits the linear basis functions B in v
##                to the X Y data points.
##                AUTHOR: Dominik Gruntz, gruntz@inf.ethz.ch
## </DESCRIBE>

fit := proc(x, y, f, v) local X,Y,V,i,k,m,n,A,b,result,FF,F,p,c,r,z;
#
# FUNCTION: fit - least-squares fit to data
# 
# CALLING SEQUENCE:
#    fit(x, y, f, v);
# 
# PARAMETERS:
#    x    - list or vector of numerical values (data points) or
#         - list of lists, vector of vectors, matrix of numerical values
#    y    - list or vector of numerical values (function values at the points x)
#    f    - list or set or vector of expressions in v (linear basis) or
# 	        expression in v (containing free parameters)
#    v    - name or list of names
# 
#                                    DWG October 1991
#
    V := v;
    if type(V,name) then V := [V] fi;
    if not type(V,list(name)) then
        ERROR(`4th argument must be a name or list of names`) fi;

    if nops(V) = 0 then
        ERROR(`4th argument must be a name or a non empty list of names!`)
    elif type(v,name) then
        if type(x,'list(algebraic)') then
            X := x;
            if not type(y,'list(algebraic)') then 
                ERROR(`1st and 2nd argument must be of same type`) fi;
            Y := y;
        elif type(x,'vector(algebraic)') then
            X := convert(x,list);
            if not type(y,'vector(algebraic)') then 
                ERROR(`1st and 2nd argument must be of same type`) fi;
            Y := convert(y,list);
        else ERROR(`1st argument must be either a list or vector of numerical values`)
        fi
    else
        if type(x,list(list(algebraic))) then
            X := x;
            if not type(y,'list(algebraic)') then 
                ERROR(`2nd argument should be a list`) fi;
            Y := y;
        elif type(x,matrix(algebraic)) then
            X := convert(x,listlist);
            if not type(y,'vector(algebraic)') then 
                ERROR(`if 1st argument is a matrix, then 2nd argument must be a vector`) fi;
            Y := convert(y,list);
        else ERROR(`1st argument is invalid, must be either a list of lists or a matrix`)
      fi
    fi;
    if nops(X) <> nops(Y) then ERROR(`length of 1st and 2nd argument are not equal`) fi;

    if type(f, {list, set, vector}) then
        F := sum(z[i]*f[i], i=1..nops(convert(f,list)) )
    elif type(f, {algebraic}) then
        F := f
    else
        ERROR(`3rd argument must be an expression`) fi;

    c := indets(indets(F),name) minus {V[]};
    m := nops(X);
    n := nops(c);
    p := nops(V);
    FF:= unapply(F, V[]);
    r := linalg[vector](m);
    if type(X,listlist) then
        for i to m do
            if nops(X[i]) <> p then
                ERROR(`data must be of dimenstion`,p) fi;
            r[i] := evalf(FF(X[i][])-Y[i])
        od;
    else
        for i to m do
             r[i] := evalf(FF(X[i])-Y[i])
        od;
    fi;
    map(type,convert(r,set),'linear'(c));
    if has(",false) then     # nonlinear case!
#        F := linalg['dotprod'](r,r);
#        g := linalg['grad'](F,convert(c,list));
#        g := fsolve(convert(g,'set'), c );
#        if g = NULL then ERROR(`could not solve ...`) fi;
#        subs(g,f)
       ERROR(`non linear case not yet implemented`);
    else            # linear case!
        A := linalg[matrix](m,n);
        b := linalg[vector](m);
        for i to m do
            r[i] := collect(r[i],c,'distributed');
            for k to n do
                A[i,k] := coeff(r[i], c[k], 1);
                r[i] := r[i] - c[k] * ";
            od;
            b[i] := -expand(r[i])
        od;
        result := linalg['leastsqrs'](A,b);
        if assigned(result) then
            subs({seq(c[i]=result[i], i=1..n)}, F)
        fi;
fi;
end:


#save `fit.m`;
#quit;
